/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.TopLogging;
import org.netbeans.modules.autoupdate.services.DependencyAggregator;
import org.netbeans.modules.autoupdate.services.DependencyChecker;
import org.netbeans.modules.autoupdate.services.FeatureUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.InstallManager;
import org.netbeans.modules.autoupdate.services.InstallSupportImpl;
import org.netbeans.modules.autoupdate.services.ModuleUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateElementImpl;
import org.netbeans.modules.autoupdate.services.UpdateManagerImpl;
import org.netbeans.modules.autoupdate.updateprovider.InstalledModuleProvider;
import org.netbeans.modules.autoupdate.updateprovider.UpdateItemImpl;
import org.netbeans.spi.autoupdate.KeyStoreProvider;
import org.netbeans.spi.autoupdate.UpdateItem;
import org.netbeans.updater.ModuleDeactivator;
import org.netbeans.updater.UpdateTracking;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.modules.Dependency;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    public static final String UPDATE_DIR = "update";
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String DOWNLOAD_DIR = "update" + FILE_SEPARATOR + "download";
    public static final String NBM_EXTENTSION = ".nbm";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd");
    public static final String ATTR_VISIBLE = "AutoUpdate-Show-In-Client";
    public static final String ATTR_ESSENTIAL = "AutoUpdate-Essential-Module";
    private static final String USER_KS_KEY = "userKS";
    private static final String USER_KS_FILE_NAME = "user.ks";
    private static final String KS_USER_PASSWORD = "open4user";
    private static Lookup.Result<KeyStoreProvider> result;
    private static Logger err;
    private static ModuleManager mgr;
    private static final String ATTR_NAME = "name";
    private static final String ATTR_SPEC_VERSION = "specification_version";
    private static final String ATTR_SIZE = "size";
    private static final String ATTR_NBM_NAME = "nbm_name";
    private static String productVersion;

    private Utilities() {
    }

    public static Collection<KeyStore> getKeyStore() {
        Collection collection;
        if (result == null) {
            result = Lookup.getDefault().lookup(new Lookup.Template(KeyStoreProvider.class));
            result.addLookupListener((LookupListener)new KeyStoreProviderListener());
        }
        if ((collection = result.allInstances()) == null || collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<KeyStore> arrayList = new ArrayList<KeyStore>();
        for (KeyStoreProvider keyStoreProvider : collection) {
            KeyStore keyStore = keyStoreProvider.getKeyStore();
            if (keyStore == null) continue;
            arrayList.add(keyStore);
        }
        return arrayList;
    }

    private static File getInstallLater(File file) {
        File file2 = new File(file.getPath() + FILE_SEPARATOR + DOWNLOAD_DIR + FILE_SEPARATOR + "install_later.xml");
        return file2;
    }

    public static void deleteAllDoLater() {
        List<File> list = UpdateTracking.clusters(true);
        assert (list != null) : "Clusters cannot be empty.";
        for (File file : list) {
            for (File file2 : Utilities.findDoLater(file)) {
                file2.delete();
            }
        }
    }

    private static Collection<File> findDoLater(File file) {
        if (!file.exists()) {
            return Collections.emptySet();
        }
        HashSet<File> hashSet = new HashSet<File>();
        if (Utilities.getInstallLater(file).exists()) {
            hashSet.add(Utilities.getInstallLater(file));
        }
        if (ModuleDeactivator.getDeactivateLater(file).exists()) {
            hashSet.add(ModuleDeactivator.getDeactivateLater(file));
        }
        return hashSet;
    }

    public static void writeInstallLater(Map<UpdateElementImpl, File> map) {
        List<File> list = UpdateTracking.clusters(true);
        assert (list != null) : "Clusters cannot be empty.";
        for (File file : list) {
            Utilities.writeInstallLaterToCluster(file, map);
        }
    }

    private static void writeInstallLaterToCluster(File file, Map<UpdateElementImpl, File> map) {
        Document document = XMLUtil.createDocument((String)"installed_modules", null, null, null);
        Element element = document.getDocumentElement();
        if (map.isEmpty()) {
            return;
        }
        boolean bl = true;
        for (UpdateElementImpl updateElementImpl : map.keySet()) {
            File file2 = map.get(updateElementImpl);
            if (!file.equals(file2)) continue;
            Element element2 = document.createElement("module");
            element2.setAttribute("codename", updateElementImpl.getCodeName());
            element2.setAttribute(ATTR_NAME, updateElementImpl.getDisplayName());
            element2.setAttribute(ATTR_SPEC_VERSION, updateElementImpl.getSpecificationVersion().toString());
            element2.setAttribute(ATTR_SIZE, Long.toString(updateElementImpl.getDownloadSize()));
            element2.setAttribute(ATTR_NBM_NAME, InstallSupportImpl.getDestination(file, updateElementImpl.getCodeName(), true).getName());
            element.appendChild(element2);
            bl = false;
        }
        if (bl) {
            return;
        }
        Utilities.writeXMLDocumentToFile(document, Utilities.getInstallLater(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeXMLDocumentToFile(Document document, File file) {
        document.getDocumentElement().normalize();
        file.getParentFile().mkdirs();
        InputStream inputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStream outputStream = null;
        try {
            try {
                XMLUtil.write((Document)document, (OutputStream)byteArrayOutputStream, (String)"UTF-8");
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
                outputStream = new FileOutputStream(file);
                inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Exceptions.printStackTrace((Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        finally {
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    public static void writeDeactivateLater(Collection<File> collection) {
        File file = InstallManager.getUserDir();
        assert (file != null && file.exists()) : "Userdir " + file + " found and exists.";
        Utilities.writeMarkedFilesToFile(collection, ModuleDeactivator.getDeactivateLater(file));
    }

    public static void writeFileMarkedForDelete(Collection<File> collection) {
        Utilities.writeMarkedFilesToFile(collection, ModuleDeactivator.getControlFileForMarkedForDelete(InstallManager.getUserDir()));
    }

    public static void writeFileMarkedForDisable(Collection<File> collection) {
        Utilities.writeMarkedFilesToFile(collection, ModuleDeactivator.getControlFileForMarkedForDisable(InstallManager.getUserDir()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeMarkedFilesToFile(Collection<File> collection, File file) {
        String string = "";
        if (file.exists()) {
            string = string + ModuleDeactivator.readStringFromFile(file);
        }
        for (File object2 : collection) {
            string = string + object2.getAbsolutePath() + UpdateTracking.PATH_SEPARATOR;
        }
        if (string == null || string.length() == 0) {
            return;
        }
        file.getParentFile().mkdirs();
        assert (file.getParentFile().exists() && file.getParentFile().isDirectory()) : "Parent of " + file + " exists and is directory.";
        Object object3 = null;
        OutputStream outputStream = null;
        try {
            FileOutputStream fileOutputStream;
            block12: {
                try {
                    fileOutputStream = new FileOutputStream(file);
                    object3 = new ByteArrayInputStream(string.getBytes());
                    FileUtil.copy((InputStream)object3, (OutputStream)fileOutputStream);
                    if (object3 == null) break block12;
                }
                catch (Throwable iOException) {
                    if (object3 != null) {
                        ((InputStream)object3).close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    throw iOException;
                }
                ((InputStream)object3).close();
            }
            if (fileOutputStream != null) {
                ((OutputStream)fileOutputStream).close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Exceptions.printStackTrace((Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public static void writeAdditionalInformation(Map<UpdateElementImpl, File> map) {
        List<File> list = UpdateTracking.clusters(true);
        assert (list != null) : "Clusters cannot be empty.";
        for (File file : list) {
            Utilities.writeAdditionalInformationToCluster(file, map);
        }
    }

    public static File locateUpdateTracking(ModuleInfo moduleInfo) {
        String string = "update_tracking/" + moduleInfo.getCodeNameBase().replace('.', '-') + ".xml";
        return InstalledFileLocator.getDefault().locate(string, moduleInfo.getCodeNameBase(), false);
    }

    public static String readSourceFromUpdateTracking(ModuleInfo moduleInfo) {
        Node node;
        String string = null;
        File file = Utilities.locateUpdateTracking(moduleInfo);
        if (file != null && (node = Utilities.getModuleConfiguration(file)) != null) {
            Node node2 = node.getAttributes().getNamedItem("origin");
            assert (node2 != null) : "ELEMENT_VERSION must contain ATTR_ORIGIN attribute.";
            if (!"updater".equals(node2.getNodeValue()) && !"installer".equals(node2.getNodeValue())) {
                string = node2.getNodeValue();
            }
        }
        return string;
    }

    public static Date readInstallTimeFromUpdateTracking(ModuleInfo moduleInfo) {
        Node node;
        Date date = null;
        String string = null;
        File file = Utilities.locateUpdateTracking(moduleInfo);
        if (file != null && (node = Utilities.getModuleConfiguration(file)) != null) {
            Node node2 = node.getAttributes().getNamedItem("install_time");
            assert (node2 != null) : "ELEMENT_VERSION must contain ATTR_INSTALL attribute.";
            string = node2.getNodeValue();
        }
        if (string != null) {
            try {
                long l = Long.parseLong(string);
                date = new Date(l);
            }
            catch (NumberFormatException numberFormatException) {
                Utilities.getLogger().log(Level.INFO, numberFormatException.getMessage(), numberFormatException);
            }
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeUpdateOfUpdaterJar(JarEntry jarEntry, JarFile jarFile, File file) {
        File file2 = new File(file, UPDATE_DIR + UpdateTracking.FILE_SEPARATOR + "new_updater" + UpdateTracking.FILE_SEPARATOR + "updater.jar");
        file2.getParentFile().mkdirs();
        assert (file2.getParentFile().exists() && file2.getParentFile().isDirectory()) : "Parent of " + file2 + " exists and is directory.";
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(file2);
                inputStream = jarFile.getInputStream(jarEntry);
                FileUtil.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Utilities.getLogger().log(Level.INFO, fileNotFoundException.getLocalizedMessage(), fileNotFoundException);
        }
        catch (IOException iOException) {
            Utilities.getLogger().log(Level.INFO, iOException.getLocalizedMessage(), iOException);
        }
    }

    static void cleanUpdateOfUpdaterJar() {
        List<File> list = UpdateTracking.clusters(true);
        assert (list != null) : "Clusters cannot be empty.";
        for (File file : list) {
            File file2 = new File(file, UPDATE_DIR + UpdateTracking.FILE_SEPARATOR + "new_updater");
            if (!file2.exists() || !file2.isDirectory()) continue;
            for (File file3 : file2.listFiles()) {
                file3.delete();
            }
            file2.delete();
        }
    }

    static Module toModule(UpdateUnit updateUnit) {
        return Utilities.getModuleInstance(updateUnit.getCodeName(), null);
    }

    public static Module toModule(String string, SpecificationVersion specificationVersion) {
        return Utilities.getModuleInstance(string, specificationVersion);
    }

    public static Module toModule(ModuleInfo moduleInfo) {
        return Utilities.getModuleInstance(moduleInfo.getCodeNameBase(), moduleInfo.getSpecificationVersion());
    }

    public static boolean isFixed(ModuleInfo moduleInfo) {
        Module module = Utilities.toModule(moduleInfo);
        assert (!moduleInfo.isEnabled() || module != null) : "Module found for enabled " + moduleInfo;
        return module == null ? false : module.isFixed();
    }

    public static boolean isValid(ModuleInfo moduleInfo) {
        Module module = Utilities.toModule(moduleInfo);
        assert (!moduleInfo.isEnabled() || module != null) : "Module found for enabled " + moduleInfo;
        return module == null ? false : module.isValid();
    }

    static UpdateUnit toUpdateUnit(Module module) {
        return UpdateManagerImpl.getInstance().getUpdateUnit(module.getCodeNameBase());
    }

    static UpdateUnit toUpdateUnit(String string) {
        return UpdateManagerImpl.getInstance().getUpdateUnit(string);
    }

    public static Set<UpdateElement> findRequiredUpdateElements(UpdateElement updateElement, Collection<ModuleInfo> collection, Set<Dependency> set) {
        UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
        HashSet<UpdateElement> hashSet = new HashSet<UpdateElement>();
        switch (updateElementImpl.getType()) {
            case KIT_MODULE: 
            case MODULE: {
                Set<UpdateElement> set2;
                Set<Dependency> set3;
                Set<Dependency> set4 = new HashSet<Dependency>(((ModuleUpdateElementImpl)updateElementImpl).getModuleInfo().getDependencies());
                HashSet<ModuleInfo> hashSet2 = new HashSet<ModuleInfo>(collection);
                while (!(set3 = Utilities.processDependencies(set4, hashSet, hashSet2, set)).isEmpty()) {
                    set4 = set3;
                }
                HashSet<Dependency> hashSet3 = new HashSet<Dependency>();
                HashSet<Object> hashSet4 = new HashSet<ModuleInfo>(hashSet2);
                while (hashSet.addAll(set2 = Utilities.handleBackwardCompatability(hashSet4, hashSet3))) {
                    if (!hashSet3.isEmpty()) {
                        set.addAll(hashSet3);
                        break;
                    }
                    hashSet4 = new HashSet();
                    for (UpdateElement updateElement2 : set2) {
                        hashSet4.add(((ModuleUpdateElementImpl)Trampoline.API.impl(updateElement2)).getModuleInfo());
                    }
                }
                if (hashSet3.isEmpty()) break;
                set.addAll(hashSet3);
                break;
            }
            case STANDALONE_MODULE: 
            case FEATURE: {
                FeatureUpdateElementImpl featureUpdateElementImpl = (FeatureUpdateElementImpl)updateElementImpl;
                for (ModuleUpdateElementImpl moduleUpdateElementImpl : featureUpdateElementImpl.getContainedModuleElements()) {
                    hashSet.addAll(Utilities.findRequiredUpdateElements(moduleUpdateElementImpl.getUpdateElement(), collection, set));
                }
                break;
            }
            case CUSTOM_HANDLED_COMPONENT: {
                Utilities.getLogger().log(Level.INFO, "CUSTOM_HANDLED_COMPONENT doesn't care about required elements.");
                break;
            }
            default: {
                assert (false) : "Not implement for type " + (Object)((Object)updateElementImpl.getType()) + " of UpdateElement " + updateElementImpl;
                break;
            }
        }
        return hashSet;
    }

    public static Set<UpdateElement> handleBackwardCompatability(Set<ModuleInfo> set, Set<Dependency> set2) {
        HashSet<UpdateElement> hashSet = new HashSet<UpdateElement>();
        for (ModuleInfo moduleInfo : set) {
            ModuleInfo moduleInfo2;
            UpdateElement updateElement;
            Object object;
            Object object3;
            Object object422;
            UpdateElement updateElement2;
            UpdateUnit updateUnit = UpdateManagerImpl.getInstance().getUpdateUnit(moduleInfo.getCodeNameBase());
            if (updateUnit == null || (updateElement2 = updateUnit.getInstalled()) == null) continue;
            for (Object object422 : Dependency.create((int)1, (String)moduleInfo.getCodeName())) {
                object3 = DependencyAggregator.getAggregator((Dependency)object422);
                if (object3 == null) continue;
                for (ModuleInfo moduleInfo3 : ((DependencyAggregator)object3).getDependening()) {
                    Module module = Utilities.toModule(moduleInfo3);
                    if (module == null || module.getProblems() != null && !module.getProblems().isEmpty()) continue;
                    for (Object object2 : module.getDependencies()) {
                        Set<Dependency> set3;
                        if (!object3.equals(DependencyAggregator.getAggregator((Dependency)object2)) || DependencyChecker.checkDependencyModule((Dependency)object2, moduleInfo) || ((UpdateUnit)(object = UpdateManagerImpl.getInstance().getUpdateUnit(module.getCodeNameBase()))).getAvailableUpdates().isEmpty()) continue;
                        updateElement = ((UpdateUnit)object).getAvailableUpdates().get(0);
                        moduleInfo2 = ((ModuleUpdateElementImpl)Trampoline.API.impl(updateElement)).getModuleInfo();
                        Set<Dependency> set4 = new HashSet<Dependency>(moduleInfo2.getDependencies());
                        Dependency dependency2 = new HashSet(set);
                        while (!(set3 = Utilities.processDependencies(set4, hashSet, dependency2, set2)).isEmpty()) {
                            set4 = set3;
                        }
                        hashSet.add(updateElement);
                    }
                }
            }
            TreeSet<String> treeSet = new TreeSet<String>(Arrays.asList(moduleInfo.getProvides()));
            object422 = new TreeSet<String>(Arrays.asList(((ModuleUpdateElementImpl)Trampoline.API.impl(updateElement2)).getModuleInfo().getProvides()));
            object422.removeAll(treeSet);
            object3 = object422.iterator();
            while (object3.hasNext()) {
                String string = (String)object3.next();
                if (string.startsWith("org.openide.modules.os")) continue;
                HashSet hashSet2 = new HashSet(Dependency.create((int)5, (String)string));
                hashSet2.addAll(Dependency.create((int)6, (String)string));
                for (Dependency dependency : hashSet2) {
                    Object object2;
                    object2 = DependencyAggregator.getAggregator(dependency);
                    if (object2 == null) continue;
                    object = ((DependencyAggregator)object2).getDependening().iterator();
                    while (object.hasNext()) {
                        updateElement = (ModuleInfo)object.next();
                        moduleInfo2 = Utilities.toModule((ModuleInfo)updateElement);
                        if (moduleInfo2 == null || moduleInfo2.getProblems() != null && !moduleInfo2.getProblems().isEmpty()) continue;
                        for (Dependency dependency2 : moduleInfo2.getDependencies()) {
                            if (!object2.equals(DependencyAggregator.getAggregator(dependency2))) continue;
                            set2.add(dependency2);
                        }
                    }
                }
            }
        }
        return hashSet;
    }

    private static Set<Dependency> processDependencies(Set<Dependency> set, Set<UpdateElement> set2, Set<ModuleInfo> set3, Set<Dependency> set4) {
        HashSet<Dependency> hashSet = new HashSet<Dependency>();
        for (Dependency dependency : set) {
            UpdateElement updateElement = Utilities.handleDependency(dependency, set3, set4);
            if (updateElement == null) continue;
            ModuleUpdateElementImpl moduleUpdateElementImpl = (ModuleUpdateElementImpl)Trampoline.API.impl(updateElement);
            set3.add(moduleUpdateElementImpl.getModuleInfo());
            set2.add(updateElement);
            hashSet.addAll(moduleUpdateElementImpl.getModuleInfo().getDependencies());
        }
        hashSet.removeAll(set);
        return hashSet;
    }

    /*
     * Unable to fully structure code
     */
    public static UpdateElement handleDependency(Dependency var0, Collection<ModuleInfo> var1_1, Set<Dependency> var2_2) {
        var3_3 = null;
        switch (var0.getType()) {
            case 3: {
                if (DependencyChecker.matchDependencyJava(var0)) break;
                var2_2.add(var0);
                break;
            }
            case 2: {
                if (DependencyChecker.matchPackageDependency(var0)) break;
                var2_2.add(var0);
                break;
            }
            case 1: {
                var4_4 = DependencyAggregator.getRequested(var0);
                var5_5 = false;
                if (var4_4 == null) {
                    for (ModuleInfo var7_9 : var1_1) {
                        if (!DependencyChecker.checkDependencyModule(var0, var7_9)) continue;
                        var5_5 = true;
                        break;
                    }
                    if (var5_5) break;
                    var2_2.add(var0);
                    break;
                }
                if (var4_4.getInstalled() != null) {
                    var6_7 = Trampoline.API.impl(var4_4.getInstalled());
                    var5_5 = DependencyChecker.checkDependencyModule(var0, ((ModuleUpdateElementImpl)var6_7).getModuleInfo());
                }
                if (var5_5) break;
                var6_7 = var1_1.iterator();
                while (var6_7.hasNext()) {
                    var7_10 = (ModuleInfo)var6_7.next();
                    if (!DependencyChecker.checkDependencyModule(var0, (ModuleInfo)var7_10)) continue;
                    var5_5 = true;
                    break;
                }
                if (var5_5) break;
                v0 = var6_7 = var4_4.getAvailableUpdates().isEmpty() != false ? null : var4_4.getAvailableUpdates().get(0);
                if (var6_7 == null) {
                    for (ModuleInfo var8_12 : var1_1) {
                        if (!DependencyChecker.checkDependencyModule(var0, var8_12)) continue;
                        var5_5 = true;
                        break;
                    }
                    if (var5_5) break;
                    var2_2.add(var0);
                    break;
                }
                var7_10 = Trampoline.API.impl((UpdateElement)var6_7);
                var8_13 = (ModuleUpdateElementImpl)var7_10;
                var9_15 = var8_13.getModuleInfo();
                if (DependencyChecker.checkDependencyModule(var0, var9_15)) {
                    if (var1_1.contains(var9_15)) break;
                    var3_3 = var6_7;
                    break;
                }
                var2_2.add(var0);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                if ("org.openide.modules.ModuleFormat1".equals(var0.getName()) || "org.openide.modules.ModuleFormat2".equals(var0.getName())) break;
                var6_8 = DependencyAggregator.getRequested(var0);
                var7_11 = false;
                if (var6_8 != null) ** GOTO lbl66
                for (ModuleInfo var9_16 : var1_1) {
                    if (!Arrays.asList(var9_16.getProvides()).contains(var0.getName())) continue;
                    var7_11 = true;
                    ** GOTO lbl69
                }
                ** GOTO lbl69
lbl66:
                // 1 sources

                var7_11 = true;
                if (!var6_8.getAvailableUpdates().isEmpty()) {
                    var3_3 = var6_8.getAvailableUpdates().get(0);
                }
lbl69:
                // 5 sources

                if (var7_11 || 7 == var0.getType()) break;
                var2_2.add(var0);
            }
        }
        return var3_3;
    }

    static Set<String> getBrokenDependencies(UpdateElement updateElement, List<ModuleInfo> list) {
        assert (updateElement != null) : "UpdateElement cannot be null";
        HashSet<Dependency> hashSet = new HashSet<Dependency>();
        Utilities.findRequiredUpdateElements(updateElement, list, hashSet);
        for (ModuleInfo object : list) {
            Object object2;
            TreeSet<String> treeSet;
            Object object32;
            UpdateElement updateElement2;
            UpdateUnit updateUnit = UpdateManagerImpl.getInstance().getUpdateUnit(object.getCodeNameBase());
            if (updateUnit == null || (updateElement2 = updateUnit.getInstalled()) == null || !updateUnit.getAvailableUpdates().isEmpty() && list.contains(object32 = ((ModuleUpdateElementImpl)Trampoline.API.impl((UpdateElement)((Object)(treeSet = updateUnit.getAvailableUpdates().get(0))))).getModuleInfo())) continue;
            for (Object object32 : Dependency.create((int)1, (String)object.getCodeName())) {
                object2 = DependencyAggregator.getAggregator((Dependency)object32);
                if (object2 == null) continue;
                for (ModuleInfo moduleInfo : ((DependencyAggregator)object2).getDependening()) {
                    Module module = Utilities.toModule(moduleInfo);
                    if (module == null || module.getProblems() != null && !module.getProblems().isEmpty()) continue;
                    for (Object object4 : module.getDependencies()) {
                        if (!object2.equals(DependencyAggregator.getAggregator((Dependency)object4)) || DependencyChecker.checkDependencyModule((Dependency)object4, object)) continue;
                        hashSet.add((Dependency)object4);
                    }
                }
            }
            treeSet = new TreeSet<String>(Arrays.asList(object.getProvides()));
            object32 = new TreeSet<String>(Arrays.asList(((ModuleUpdateElementImpl)Trampoline.API.impl(updateElement2)).getModuleInfo().getProvides()));
            object32.removeAll(treeSet);
            object2 = object32.iterator();
            while (object2.hasNext()) {
                String string = (String)object2.next();
                HashSet hashSet2 = new HashSet(Dependency.create((int)5, (String)string));
                hashSet2.addAll(Dependency.create((int)6, (String)string));
                for (Dependency dependency : hashSet2) {
                    Object object4;
                    object4 = DependencyAggregator.getAggregator(dependency);
                    if (object4 == null) continue;
                    for (ModuleInfo moduleInfo : ((DependencyAggregator)object4).getDependening()) {
                        Module module = Utilities.toModule(moduleInfo);
                        if (module == null || module.getProblems() != null && !module.getProblems().isEmpty()) continue;
                        for (Dependency dependency2 : module.getDependencies()) {
                            if (!object4.equals(DependencyAggregator.getAggregator(dependency2))) continue;
                            hashSet.add(dependency2);
                        }
                    }
                }
            }
        }
        HashSet hashSet2 = new HashSet(hashSet.size());
        for (Dependency dependency : hashSet) {
            hashSet2.add(dependency.toString());
        }
        return hashSet2;
    }

    static Set<String> getBrokenDependenciesInInstalledModules(UpdateElement updateElement) {
        assert (updateElement != null) : "UpdateElement cannot be null";
        HashSet<Dependency> hashSet = new HashSet<Dependency>();
        for (ModuleInfo object : Utilities.getModuleInfos(Collections.singleton(updateElement))) {
            hashSet.addAll(DependencyChecker.findBrokenDependenciesTransitive(object, InstalledModuleProvider.getInstalledModules().values(), new HashSet<ModuleInfo>()));
        }
        HashSet hashSet2 = new HashSet();
        for (Dependency dependency : hashSet) {
            hashSet2.add(dependency.toString());
        }
        return hashSet2;
    }

    private static List<ModuleInfo> getModuleInfos(Collection<UpdateElement> collection) {
        ArrayList<ModuleInfo> arrayList = new ArrayList<ModuleInfo>(collection.size());
        for (UpdateElement updateElement : collection) {
            if (updateElement.getUpdateUnit() != null && updateElement.getUpdateUnit().isPending()) continue;
            UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
            arrayList.addAll(updateElementImpl.getModuleInfos());
        }
        return arrayList;
    }

    private static Module getModuleInstance(String string, SpecificationVersion specificationVersion) {
        if (mgr == null) {
            mgr = Main.getModuleSystem().getManager();
        }
        assert (mgr != null);
        if (mgr == null || specificationVersion == null) {
            return mgr != null ? mgr.get(string) : null;
        }
        Module module = mgr.get(string);
        if (module == null) {
            return null;
        }
        if (module.getSpecificationVersion() == null) {
            return null;
        }
        return module.getSpecificationVersion().compareTo((Object)specificationVersion) >= 0 ? module : null;
    }

    public static boolean isAutomaticallyEnabled(String string) {
        Module module = Utilities.getModuleInstance(string, null);
        return module != null ? module.isAutoload() || module.isEager() || module.isFixed() : false;
    }

    public static ModuleInfo takeModuleInfo(UpdateElement updateElement) {
        UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
        assert (updateElementImpl instanceof ModuleUpdateElementImpl);
        return ((ModuleUpdateElementImpl)updateElementImpl).getModuleInfo();
    }

    public static String getProductVersion() {
        if (productVersion == null) {
            String string = System.getProperty("netbeans.buildnumber");
            productVersion = NbBundle.getMessage(TopLogging.class, (String)"currentVersion", (Object)string);
        }
        return productVersion;
    }

    private static Node getModuleConfiguration(File file) {
        Document document = null;
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            InputSource inputSource = new InputSource(bufferedInputStream);
            document = XMLUtil.parse((InputSource)inputSource, (boolean)false, (boolean)false, null, (EntityResolver)EntityCatalog.getDefault());
            if (bufferedInputStream != null) {
                ((InputStream)bufferedInputStream).close();
            }
        }
        catch (SAXException sAXException) {
            Utilities.getLogger().log(Level.INFO, "SAXException when reading " + file, sAXException);
            return null;
        }
        catch (IOException iOException) {
            Utilities.getLogger().log(Level.INFO, "IOException when reading " + file, iOException);
            return null;
        }
        assert (document.getDocumentElement() != null) : "File " + file + " must contain <module> element.";
        if (document.getDocumentElement() == null) {
            return null;
        }
        return Utilities.getModuleElement(document.getDocumentElement());
    }

    private static Node getModuleElement(Element element) {
        Node node = null;
        assert ("module".equals(element.getTagName())) : "The root element is: module but was: " + element.getTagName();
        NodeList nodeList = element.getElementsByTagName("module_version");
        for (int i = 0; i < nodeList.getLength() && (node = Utilities.getModuleLastVersion(nodeList.item(i))) == null; ++i) {
        }
        return node;
    }

    private static Node getModuleLastVersion(Node node) {
        Node node2 = node.getAttributes().getNamedItem("last");
        assert (node2 != null) : "ELEMENT_VERSION must contain ATTR_LAST attribute.";
        if (Boolean.valueOf(node2.getNodeValue()).booleanValue()) {
            return node;
        }
        return null;
    }

    private static File getAdditionalInformation(File file) {
        File file2 = new File(file.getPath() + FILE_SEPARATOR + DOWNLOAD_DIR + FILE_SEPARATOR + "additional_information.xml");
        return file2;
    }

    private static void writeAdditionalInformationToCluster(File file, Map<UpdateElementImpl, File> map) {
        if (map.isEmpty()) {
            return;
        }
        Document document = XMLUtil.createDocument((String)"module_additional", null, null, null);
        Element element = document.getDocumentElement();
        boolean bl = true;
        for (UpdateElementImpl updateElementImpl : map.keySet()) {
            File file2 = map.get(updateElementImpl);
            if (!file.equals(file2)) continue;
            Element element2 = document.createElement("module");
            element2.setAttribute(ATTR_NBM_NAME, InstallSupportImpl.getDestination(file, updateElementImpl.getCodeName(), true).getName());
            element2.setAttribute("source-display-name", updateElementImpl.getSource());
            element.appendChild(element2);
            bl = false;
        }
        if (bl) {
            return;
        }
        Utilities.writeXMLDocumentToFile(document, Utilities.getAdditionalInformation(file));
    }

    public static UpdateItem createUpdateItem(UpdateItemImpl updateItemImpl) {
        assert (Trampoline.SPI != null);
        return Trampoline.SPI.createUpdateItem(updateItemImpl);
    }

    public static UpdateItemImpl getUpdateItemImpl(UpdateItem updateItem) {
        assert (Trampoline.SPI != null);
        return Trampoline.SPI.impl(updateItem);
    }

    public static boolean canDisable(Module module) {
        return module != null && module.isEnabled() && !Utilities.isEssentialModule((ModuleInfo)module) && !module.isAutoload() && !module.isEager();
    }

    public static boolean canEnable(Module module) {
        return module != null && !module.isEnabled() && !module.isAutoload() && !module.isEager();
    }

    public static boolean isElementInstalled(UpdateElement updateElement) {
        assert (updateElement != null) : "Invalid call isElementInstalled with null parameter.";
        if (updateElement == null) {
            return false;
        }
        return updateElement.equals(updateElement.getUpdateUnit().getInstalled());
    }

    public static boolean isKitModule(ModuleInfo moduleInfo) {
        Object object = moduleInfo.getAttribute(ATTR_VISIBLE);
        return object == null || Boolean.parseBoolean(object.toString());
    }

    public static boolean isEssentialModule(ModuleInfo moduleInfo) {
        Object object = moduleInfo.getAttribute(ATTR_ESSENTIAL);
        return Utilities.isFixed(moduleInfo) || object != null && Boolean.parseBoolean(object.toString());
    }

    private static Logger getLogger() {
        if (err == null) {
            err = Logger.getLogger(Utilities.class.getName());
        }
        return err;
    }

    public static Set<Module> findRequiredModules(Module module, ModuleManager moduleManager, Map<Module, Set<Module>> map) {
        Set set = null;
        if (map != null) {
            set = map.get(module);
            if (set == null) {
                set = moduleManager.getModuleInterdependencies(module, false, false);
                map.put(module, set);
            }
        } else {
            set = moduleManager.getModuleInterdependencies(module, false, false);
        }
        return set;
    }

    public static Set<Module> findDependingModules(Module module, ModuleManager moduleManager, Map<Module, Set<Module>> map) {
        Set set = null;
        if (map != null) {
            set = map.get(module);
            if (set == null) {
                set = moduleManager.getModuleInterdependencies(module, true, false);
                map.put(module, set);
            }
        } else {
            set = moduleManager.getModuleInterdependencies(module, true, false);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDate(Date date) {
        SimpleDateFormat simpleDateFormat = DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return DATE_FORMAT.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDate(String string) throws ParseException {
        SimpleDateFormat simpleDateFormat = DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return DATE_FORMAT.parse(string);
        }
    }

    public static boolean canWriteInCluster(File file) {
        assert (file != null) : "dir cannot be null";
        if (file == null) {
            return false;
        }
        if (file.exists() && file.isDirectory()) {
            File file2 = null;
            File file3 = new File(file, UPDATE_DIR);
            File file4 = new File(file, DOWNLOAD_DIR);
            file2 = file4.exists() ? file4 : (file3.exists() ? file3 : file);
            if (file2.canWrite() && file2.canRead()) {
                boolean bl = Utilities.canWrite(file2);
                Utilities.getLogger().log(Level.FINE, "Can write into " + file2 + "? " + bl);
                return bl;
            }
            Utilities.getLogger().log(Level.FINE, "Can write into " + file2 + "? " + file2.canWrite());
            return file2.canWrite();
        }
        file.mkdirs();
        Utilities.getLogger().log(Level.FINE, "Can write into new cluster " + file + "? " + file.canWrite());
        return file.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canWrite(File file) {
        if (org.openide.util.Utilities.isWindows()) {
            if (file.isFile()) {
                FileWriter fileWriter = null;
                try {
                    fileWriter = new FileWriter(file, true);
                    Utilities.getLogger().log(Level.FINE, file + " has write permission");
                }
                catch (IOException iOException) {
                    Utilities.getLogger().log(Level.FINE, file + " has no write permission", iOException);
                    boolean bl = false;
                    return bl;
                }
                finally {
                    try {
                        if (fileWriter != null) {
                            fileWriter.close();
                        }
                    }
                    catch (IOException iOException) {
                        Utilities.getLogger().log(Level.INFO, iOException.getLocalizedMessage(), iOException);
                    }
                }
                return true;
            }
            try {
                File file2 = File.createTempFile("dummy", null, file);
                file2.delete();
                Utilities.getLogger().log(Level.FINE, file + " has write permission");
            }
            catch (IOException iOException) {
                Utilities.getLogger().log(Level.FINE, file + " has no write permission", iOException);
                return false;
            }
            return true;
        }
        return file.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore loadKeyStore() {
        String string = Utilities.getPreferences().get(USER_KS_KEY, null);
        if (string == null) {
            return null;
        }
        InputStream inputStream = null;
        KeyStore keyStore = null;
        try {
            File file = new File(Utilities.getCacheDirectory(), string);
            if (!file.exists()) {
                KeyStore keyStore2 = null;
                return keyStore2;
            }
            inputStream = new BufferedInputStream(new FileInputStream(file));
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(inputStream, KS_USER_PASSWORD.toCharArray());
        }
        catch (IOException iOException) {
            Utilities.getLogger().log(Level.INFO, iOException.getLocalizedMessage(), iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Utilities.getLogger().log(Level.INFO, noSuchAlgorithmException.getLocalizedMessage(), noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            Utilities.getLogger().log(Level.INFO, certificateException.getLocalizedMessage(), certificateException);
        }
        catch (KeyStoreException keyStoreException) {
            Utilities.getLogger().log(Level.INFO, keyStoreException.getLocalizedMessage(), keyStoreException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                Utilities.getLogger().log(Level.INFO, iOException.getLocalizedMessage(), iOException);
            }
        }
        return keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeKeyStore(KeyStore keyStore) {
        OutputStream outputStream = null;
        try {
            File file = new File(Utilities.getCacheDirectory(), USER_KS_FILE_NAME);
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            keyStore.store(outputStream, KS_USER_PASSWORD.toCharArray());
            Utilities.getPreferences().put(USER_KS_KEY, USER_KS_FILE_NAME);
        }
        catch (KeyStoreException keyStoreException) {
            Utilities.getLogger().log(Level.INFO, keyStoreException.getLocalizedMessage(), keyStoreException);
        }
        catch (IOException iOException) {
            Utilities.getLogger().log(Level.INFO, iOException.getLocalizedMessage(), iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Utilities.getLogger().log(Level.INFO, noSuchAlgorithmException.getLocalizedMessage(), noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            Utilities.getLogger().log(Level.INFO, certificateException.getLocalizedMessage(), certificateException);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                Utilities.getLogger().log(Level.INFO, iOException.getLocalizedMessage(), iOException);
            }
        }
    }

    public static void addCertificates(Collection<Certificate> collection) {
        KeyStore keyStore = Utilities.loadKeyStore();
        if (keyStore == null) {
            try {
                keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(null, KS_USER_PASSWORD.toCharArray());
            }
            catch (IOException iOException) {
                Utilities.getLogger().log(Level.INFO, iOException.getLocalizedMessage(), iOException);
                return;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Utilities.getLogger().log(Level.INFO, noSuchAlgorithmException.getLocalizedMessage(), noSuchAlgorithmException);
                return;
            }
            catch (CertificateException certificateException) {
                Utilities.getLogger().log(Level.INFO, certificateException.getLocalizedMessage(), certificateException);
                return;
            }
            catch (KeyStoreException keyStoreException) {
                Utilities.getLogger().log(Level.INFO, keyStoreException.getLocalizedMessage(), keyStoreException);
                return;
            }
        }
        for (Certificate certificate : collection) {
            try {
                if (keyStore.getCertificateAlias(certificate) != null) continue;
                String string = null;
                for (int i = 0; i < 9999 && keyStore.containsAlias(string = "genAlias" + i); ++i) {
                }
                if (string == null) {
                    Utilities.getLogger().log(Level.INFO, "Too many certificates with " + certificate);
                }
                keyStore.setCertificateEntry(string, certificate);
            }
            catch (KeyStoreException keyStoreException) {
                Utilities.getLogger().log(Level.INFO, keyStoreException.getLocalizedMessage(), keyStoreException);
            }
        }
        Utilities.storeKeyStore(keyStore);
    }

    private static File getCacheDirectory() {
        File file = null;
        String string = System.getProperty("netbeans.user");
        if (string != null) {
            file = new File(new File(new File(string, "var"), "cache"), "catalogcache");
        } else {
            File file2 = FileUtil.toFile((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot());
            file = new File(file2, "catalogcache");
        }
        file.mkdirs();
        return file;
    }

    private static Preferences getPreferences() {
        return NbPreferences.root().node("/org/netbeans/modules/autoupdate");
    }

    static {
        err = null;
        mgr = null;
        productVersion = null;
    }

    private static class KeyStoreProviderListener
    implements LookupListener {
        private KeyStoreProviderListener() {
        }

        public void resultChanged(LookupEvent lookupEvent) {
            Utilities.result = null;
        }
    }
}

