/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public enum EsniDnsKeyRecordVersion {
    NULL(null),
    VERSION_FF01(new byte[]{-1, 1}),
    VERSION_FF02(new byte[]{-1, 2}),
    VERSION_FF03(new byte[]{-1, 3});

    private static final Map<BigInteger, EsniDnsKeyRecordVersion> MAP;
    private final byte[] byteValue;

    private EsniDnsKeyRecordVersion(byte[] byteValue) {
        this.byteValue = byteValue;
    }

    public byte[] getByteValue() {
        return this.byteValue;
    }

    public static EsniDnsKeyRecordVersion getEnumByByte(byte[] versionBytes) {
        if (versionBytes == null) {
            return NULL;
        }
        BigInteger hashMapKey = new BigInteger(versionBytes);
        return MAP.get(hashMapKey);
    }

    static {
        MAP = new HashMap<BigInteger, EsniDnsKeyRecordVersion>();
        for (EsniDnsKeyRecordVersion version : EsniDnsKeyRecordVersion.values()) {
            byte[] versionBytes = version.getByteValue();
            if (versionBytes == null) continue;
            BigInteger hashMapKey = new BigInteger(versionBytes);
            MAP.put(hashMapKey, version);
        }
    }
}

