/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.helper.model;

import org.traccar.config.ConfigKey;
import org.traccar.config.KeyType;
import org.traccar.config.Keys;
import org.traccar.model.Device;
import org.traccar.model.Group;
import org.traccar.session.cache.CacheManager;

public final class AttributeUtil {
    private AttributeUtil() {
    }

    public static <T> T lookup(CacheManager cacheManager, ConfigKey<T> key, long deviceId) {
        Device device = cacheManager.getObject(Device.class, deviceId);
        Object result = device.getAttributes().get(key.getKey());
        long groupId = device.getGroupId();
        while (result == null && groupId > 0L) {
            Group group = cacheManager.getObject(Group.class, groupId);
            if (group != null) {
                result = group.getAttributes().get(key.getKey());
                groupId = group.getGroupId();
                continue;
            }
            groupId = 0L;
        }
        if (result == null && key.hasType(KeyType.SERVER)) {
            result = cacheManager.getServer().getAttributes().get(key.getKey());
        }
        if (result == null && key.hasType(KeyType.CONFIG)) {
            result = cacheManager.getConfig().getString(key.getKey());
        }
        if (result != null) {
            Class<T> valueClass = key.getValueClass();
            if (valueClass.equals(Boolean.class)) {
                return (T)(result instanceof String ? Boolean.valueOf(Boolean.parseBoolean((String)result)) : result);
            }
            if (valueClass.equals(Integer.class)) {
                return (T)Integer.valueOf(result instanceof String ? Integer.parseInt((String)result) : ((Number)result).intValue());
            }
            if (valueClass.equals(Long.class)) {
                return (T)Long.valueOf(result instanceof String ? Long.parseLong((String)result) : ((Number)result).longValue());
            }
            if (valueClass.equals(Double.class)) {
                return (T)Double.valueOf(result instanceof String ? Double.parseDouble((String)result) : ((Number)result).doubleValue());
            }
            return (T)result;
        }
        return key.getDefaultValue();
    }

    public static String getDevicePassword(CacheManager cacheManager, long deviceId, String protocol, String defaultPassword) {
        String password = AttributeUtil.lookup(cacheManager, Keys.DEVICE_PASSWORD, deviceId);
        if (password != null) {
            return password;
        }
        if (protocol != null && (password = cacheManager.getConfig().getString(Keys.PROTOCOL_DEVICE_PASSWORD.withPrefix(protocol))) != null) {
            return password;
        }
        return defaultPassword;
    }
}

