/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import ca.sqlpower.sql.DBConnectionSpec;
import ca.sqlpower.sql.XMLFileDBCSSource;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;

public class CheckConnection {
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("CheckConnection: A small utility to test a databases.xml connection");
            System.out.println("Usage: ");
            System.out.println("  java -cp sqlpower.jar:/path/to/jdbc/driver.jar ca.sqlpower.sql.CheckConnection /path/to/databases.xml");
            return;
        }
        String databasesXMLPath = args[0];
        System.out.println("Reading connection specs from " + databasesXMLPath);
        System.out.println("");
        XMLFileDBCSSource dbcss = new XMLFileDBCSSource(databasesXMLPath);
        List dbcsList = dbcss.getDBCSList();
        Iterator it = dbcsList.iterator();
        int i = 0;
        while (it.hasNext()) {
            DBConnectionSpec dbcs = (DBConnectionSpec)it.next();
            System.out.println("[" + i + "] " + dbcs.getDisplayName() + " <" + dbcs.getUrl() + ">");
            ++i;
        }
        System.out.print("Test which connection? ");
        String conNum = CheckConnection.readLine();
        DBConnectionSpec dbcs = (DBConnectionSpec)dbcsList.get(Integer.parseInt(conNum.toString()));
        if (dbcs.getUser() == null || dbcs.getPass() == null) {
            System.out.print("Username? ");
            dbcs.setUser(CheckConnection.readLine());
            System.out.print("Password? ");
            dbcs.setPass(CheckConnection.readLine());
        }
        System.out.println("Making connection...");
        System.out.println("Connection Name:   " + dbcs.getDisplayName());
        System.out.println("JDBC Driver Class: " + dbcs.getDriverClass());
        Class.forName(dbcs.getDriverClass(), true, CheckConnection.class.getClassLoader()).newInstance();
        System.out.println("JDBC URL:          " + dbcs.getUrl());
        System.out.println("Username:          " + dbcs.getUser());
        System.out.println("Password:          " + dbcs.getPass());
        long connStartTime = System.currentTimeMillis();
        Connection con = DriverManager.getConnection(dbcs.getUrl(), dbcs.getUser(), dbcs.getPass());
        long connEndTime = System.currentTimeMillis();
        System.out.println("Got connection in " + (connEndTime - connStartTime) + "ms.");
        System.out.println("Database version:  " + con.getMetaData().getDatabaseProductVersion());
        System.out.println("Driver version:    " + con.getMetaData().getDriverVersion());
        String sql = "SELECT schema_version FROM def_param";
        System.out.println("\nExecuting query:   " + sql);
        Statement stmt = con.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        System.out.print("Result: ");
        while (rs.next()) {
            System.out.println(rs.getString(1));
        }
        rs.close();
        stmt.close();
        con.close();
        System.out.println("\nDone.  Test Successful!");
    }

    private static String readLine() throws IOException {
        int ch;
        StringBuffer line = new StringBuffer();
        while ((ch = System.in.read()) != -1 && ch != 13 && ch != 10) {
            if (ch == 127 || ch == 8) {
                if (line.length() <= 0) continue;
                line.deleteCharAt(line.length() - 1);
                System.out.print('\b');
                continue;
            }
            line.append((char)ch);
        }
        System.out.println("");
        return line.toString();
    }
}

