/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal.modifiers;

import java.util.ArrayList;
import java.util.List;
import org.gradle.buildinit.plugins.internal.modifiers.Names;
import org.gradle.buildinit.plugins.internal.modifiers.WithIdentifier;

public enum ModularizationOption implements WithIdentifier
{
    SINGLE_PROJECT("no - only one application project"),
    WITH_LIBRARY_PROJECTS("yes - application and library projects");

    private final String displayName;

    public static ModularizationOption byId(String id) {
        for (ModularizationOption option : ModularizationOption.values()) {
            if (!option.getId().equals(id)) continue;
            return option;
        }
        return SINGLE_PROJECT;
    }

    public static List<String> listSupported() {
        ArrayList<String> result = new ArrayList<String>();
        for (ModularizationOption option : ModularizationOption.values()) {
            result.add(option.getId());
        }
        return result;
    }

    private ModularizationOption(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getId() {
        return Names.idFor(this);
    }

    public String toString() {
        return this.displayName;
    }
}

