/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.totp.user;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.totp.conf.ConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CodeUsageTrackingService {
    private static final int INVALID_INTERVAL = 2;
    private final Logger logger = LoggerFactory.getLogger(CodeUsageTrackingService.class);
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
    @Inject
    private ConfigurationService confService;
    private final ConcurrentMap<UsedCode, Long> invalidCodes = new ConcurrentHashMap<UsedCode, Long>();

    public CodeUsageTrackingService() {
        this.executor.scheduleAtFixedRate(new CodeEvictionTask(), 1L, 1L, TimeUnit.MINUTES);
    }

    public boolean useCode(String username, String code) throws GuacamoleException {
        UsedCode usedCode = new UsedCode(username, code);
        long current;
        long invalidUntil;
        Long expires;
        while ((expires = this.invalidCodes.putIfAbsent(usedCode, invalidUntil = (current = System.currentTimeMillis()) + (long)(this.confService.getPeriod() * 1000 * 2))) != null) {
            if (expires > current) {
                return false;
            }
            this.invalidCodes.remove(usedCode, expires);
        }
        return true;
    }

    public void shutdown() {
        this.executor.shutdownNow();
    }

    private class UsedCode {
        private final String username;
        private final String code;

        public UsedCode(String username, String code) {
            this.username = username;
            this.code = code;
        }

        public String getUsername() {
            return this.username;
        }

        public String getCode() {
            return this.code;
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + this.username.hashCode();
            hash = 79 * hash + this.code.hashCode();
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UsedCode other = (UsedCode)obj;
            return this.username.equals(other.username) && this.code.equals(other.code);
        }
    }

    private class CodeEvictionTask
    implements Runnable {
        private CodeEvictionTask() {
        }

        @Override
        public void run() {
            long checkStart = System.currentTimeMillis();
            Iterator entries = CodeUsageTrackingService.this.invalidCodes.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                long invalidUntil = (Long)entry.getValue();
                if (checkStart < invalidUntil) continue;
                entries.remove();
            }
            CodeUsageTrackingService.this.logger.debug("TOTP tracking cleanup check completed in {} ms.", (Object)(System.currentTimeMillis() - checkStart));
        }
    }
}

