/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security.cert.extensions;

import com.ca.commons.security.asn1.ASN1Object;
import com.ca.commons.security.asn1.ASN1Type;
import com.ca.commons.security.cert.extensions.V3Extension;

public class BasicConstraints
implements V3Extension {
    String value = null;
    public int pathLenConstraint = -1;

    public void init(ASN1Object asn1object) throws Exception {
        if (!asn1object.isASN1Type(ASN1Type.SEQUENCE)) {
            throw new Exception("Wrong ASN.1 type for BasicConstraints");
        }
        if (asn1object.size() == 0) {
            this.value = "CA: False\nPath Length Constraint: None";
            return;
        }
        if (asn1object.size() >= 1) {
            Object ca = asn1object.getComponent(0).getValue();
            if (!(ca instanceof Boolean)) {
                throw new Exception("Wrong ASN.1 type for BasicConstraints.cA");
            }
            this.value = "CA: " + ca;
        }
        if (asn1object.size() >= 2) {
            Object pathLen = asn1object.getComponent(1).getValue();
            this.value = this.value + "\nPath Length Constraint: " + pathLen;
            try {
                int len = Integer.parseInt(pathLen.toString());
                if (len >= 0) {
                    this.pathLenConstraint = len;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            this.value = this.value + "\nPath Length Constraint: None";
        }
    }

    public String toString() {
        return this.value;
    }
}

