/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule;

import java.io.StringWriter;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.binding.Bindings;
import org.jboss.byteman.rule.compiler.CompileContext;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;
import org.jboss.byteman.rule.type.TypeGroup;

public abstract class RuleElement {
    protected Rule rule;

    protected RuleElement(Rule rule) {
        this.rule = rule;
    }

    protected TypeGroup getTypeGroup() {
        return this.rule.getTypeGroup();
    }

    protected Bindings getBindings() {
        return this.rule.getBindings();
    }

    public abstract Type typeCheck(Type var1) throws TypeException;

    public abstract Object interpret(HelperAdapter var1) throws ExecuteException;

    public abstract void compile(MethodVisitor var1, CompileContext var2) throws CompileException;

    protected Object rebox(Type fromType, Type toType, Object value) {
        if (!fromType.isNumeric()) {
            return value;
        }
        if (!toType.isNumeric()) {
            return value;
        }
        if (fromType.isPrimitive()) {
            fromType = Type.boxType(fromType);
        }
        if (toType.isPrimitive()) {
            toType = Type.boxType(toType);
        }
        if (fromType.equals(toType)) {
            return value;
        }
        if (fromType == Type.CHARACTER) {
            char ival = ((Character)value).charValue();
            if (toType == Type.BYTE) {
                return (byte)ival;
            }
            if (toType == Type.SHORT) {
                return (short)ival;
            }
            if (toType == Type.INTEGER) {
                return (int)ival;
            }
            if (toType == Type.LONG) {
                return (long)ival;
            }
            if (toType == Type.FLOAT) {
                return Float.valueOf(ival);
            }
            if (toType == Type.DOUBLE) {
                return (double)ival;
            }
            return value;
        }
        Number num = (Number)value;
        if (toType == Type.BYTE) {
            return num.byteValue();
        }
        if (toType == Type.CHARACTER) {
            return Character.valueOf((char)num.intValue());
        }
        if (toType == Type.SHORT) {
            return num.shortValue();
        }
        if (toType == Type.INTEGER) {
            return num.intValue();
        }
        if (toType == Type.LONG) {
            return num.longValue();
        }
        if (toType == Type.FLOAT) {
            return Float.valueOf(num.floatValue());
        }
        if (toType == Type.DOUBLE) {
            return num.doubleValue();
        }
        return value;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        this.writeTo(stringWriter);
        return stringWriter.toString();
    }

    public abstract void writeTo(StringWriter var1);
}

