/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.browser;

import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.authentication.authenticators.browser.SpnegoAuthenticator;
import org.keycloak.authentication.authenticators.browser.SpnegoAuthenticatorFactory;
import org.keycloak.common.Profile;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;

public class SpnegoDisabledAuthenticatorFactory
extends SpnegoAuthenticatorFactory
implements AuthenticatorFactory {
    @Override
    public Authenticator create(KeycloakSession session) {
        return new SpnegoDisabledAuthenticator();
    }

    @Override
    public String getHelpText() {
        return "DISABLED. Please enable Kerberos feature and make sure Kerberos available in your platform. Initiates the SPNEGO protocol. Most often used with Kerberos.";
    }

    @Override
    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.DISABLED};
    }

    @Override
    public boolean isSupported() {
        return !Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.KERBEROS);
    }

    public static class SpnegoDisabledAuthenticator
    extends SpnegoAuthenticator {
        @Override
        public void authenticate(AuthenticationFlowContext context) {
            throw new IllegalStateException("Not possible to authenticate as Kerberos feature is disabled");
        }
    }
}

