/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.processor.generation.exceptionmappers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.resteasy.reactive.common.model.ResourceClass;
import org.jboss.resteasy.reactive.common.model.ResourceExceptionMapper;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.server.processor.ScannedApplication;
import org.jboss.resteasy.reactive.server.processor.generation.exceptionmappers.ServerExceptionMapperGenerator;
import org.jboss.resteasy.reactive.server.processor.scanning.FeatureScanner;
import org.jboss.resteasy.reactive.server.processor.util.GeneratedClassOutput;

public class ServerExceptionMappingFeature
implements FeatureScanner {
    final Set<DotName> unwrappableTypes;
    final Set<String> additionalBeanAnnotations;

    public ServerExceptionMappingFeature(Set<DotName> unwrappableTypes, Set<String> additionalBeanAnnotations) {
        this.unwrappableTypes = unwrappableTypes;
        this.additionalBeanAnnotations = additionalBeanAnnotations;
    }

    @Override
    public FeatureScanner.FeatureScanResult integrate(IndexView index, ScannedApplication scannedApplication) {
        List methodExceptionMapper = scannedApplication.getResourceScanningResult().getClassLevelExceptionMappers();
        GeneratedClassOutput classOutput = new GeneratedClassOutput();
        HashMap resultingMappers = new HashMap(methodExceptionMapper.size());
        for (MethodInfo methodInfo : methodExceptionMapper) {
            Map<String, String> classMappers;
            Map<String, String> generationResult = ServerExceptionMapperGenerator.generatePerClassMapper(methodInfo, classOutput, this.unwrappableTypes, this.additionalBeanAnnotations);
            DotName classDotName = methodInfo.declaringClass().name();
            String name = classDotName.toString();
            if (resultingMappers.containsKey(name)) {
                classMappers = (Map)resultingMappers.get(name);
            } else {
                classMappers = new HashMap();
                resultingMappers.put(name, classMappers);
            }
            classMappers.putAll(generationResult);
        }
        for (ResourceClass entry : scannedApplication.getResourceClasses()) {
            if (!resultingMappers.containsKey(entry.getClassName())) continue;
            entry.setClassLevelExceptionMappers((Map)resultingMappers.get(entry.getClassName()));
        }
        for (ResourceClass entry : scannedApplication.getSubResourceClasses()) {
            if (!resultingMappers.containsKey(entry.getClassName())) continue;
            entry.setClassLevelExceptionMappers((Map)resultingMappers.get(entry.getClassName()));
        }
        for (AnnotationInstance instance : index.getAnnotations(ResteasyReactiveDotNames.SERVER_EXCEPTION_MAPPER)) {
            MethodInfo methodInfo;
            if (instance.target().kind() != AnnotationTarget.Kind.METHOD || methodExceptionMapper.contains(methodInfo = instance.target().asMethod())) continue;
            Map<String, String> generatedClassNames = ServerExceptionMapperGenerator.generateGlobalMapper(methodInfo, classOutput, this.unwrappableTypes, this.additionalBeanAnnotations);
            for (Map.Entry<String, String> entry : generatedClassNames.entrySet()) {
                ResourceExceptionMapper mapper = new ResourceExceptionMapper().setClassName(entry.getValue());
                scannedApplication.getExceptionMappers().addExceptionMapper(entry.getKey(), mapper);
                AnnotationValue priorityValue = instance.value("priority");
                if (priorityValue == null) continue;
                mapper.setPriority(priorityValue.asInt());
            }
        }
        return new FeatureScanner.FeatureScanResult(classOutput.getOutput());
    }
}

