/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.utility;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeFormatter;

public class DockerStatus {
    static final String DOCKER_TIMESTAMP_ZERO = "0001-01-01T00:00:00Z";

    public static boolean isContainerRunning(InspectContainerResponse.ContainerState state, Duration minimumRunningDuration, Instant now) {
        if (state.getRunning().booleanValue()) {
            if (minimumRunningDuration == null) {
                return true;
            }
            Instant startedAt = DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)state.getStartedAt(), Instant::from);
            if (startedAt.isBefore(now.minus(minimumRunningDuration))) {
                return true;
            }
        }
        return false;
    }

    public static boolean isContainerStopped(InspectContainerResponse.ContainerState state) {
        if (state.getRunning().booleanValue() || state.getPaused().booleanValue()) {
            return false;
        }
        boolean hasStarted = DockerStatus.isDockerTimestampNonEmpty(state.getStartedAt());
        boolean hasFinished = DockerStatus.isDockerTimestampNonEmpty(state.getFinishedAt());
        return hasStarted && hasFinished;
    }

    public static boolean isDockerTimestampNonEmpty(String dockerTimestamp) {
        return dockerTimestamp != null && !dockerTimestamp.isEmpty() && !dockerTimestamp.equals(DOCKER_TIMESTAMP_ZERO) && DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)dockerTimestamp, Instant::from).getEpochSecond() >= 0L;
    }

    public static boolean isContainerExitCodeSuccess(InspectContainerResponse.ContainerState state) {
        int exitCode = state.getExitCode();
        return exitCode == 0;
    }
}

