import React, { HTMLAttributes, ReactNode, ReactNodeArray } from "react";
export interface Props extends HTMLAttributes<HTMLDivElement & HTMLInputElement> {
    shortCut: string[];
    children: ReactNode | ReactNodeArray;
    isVisible?: boolean;
    onClose: () => void;
    onChangeFilter: (value: string) => void;
}
interface State {
    selectedItemIndex: number;
}
export declare class CommandPalette extends React.PureComponent<Props, State> {
    state: State;
    items: React.RefObject<HTMLDivElement>;
    handleKeys: (event: KeyboardEvent) => void;
    componentDidMount(): void;
    componentWillUnmount(): void;
    handleChangeFilter: (e: React.ChangeEvent<HTMLInputElement>) => void;
    handleInputFocus: () => void;
    componentDidUpdate(): void;
    render(): JSX.Element;
}
export {};
