/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec2(38, 35) / 12) => ivec2(3, 2)
 * (ivec2(38, 35) / -6) => ivec2(-6, -5)
 * (ivec2(38, 35) / 76) => ivec2(0, 0)
 * (ivec2(38, 35) / -32) => ivec2(-1, -1)
 * (ivec2(64, -9) / 12) => ivec2(5, 0)
 * (ivec2(64, -9) / -6) => ivec2(-10, 1)
 * (ivec2(64, -9) / 76) => ivec2(0, 0)
 * (ivec2(64, -9) / -32) => ivec2(-2, 0)
 * (ivec2(64, 9) / 12) => ivec2(5, 0)
 * (ivec2(64, 9) / -6) => ivec2(-10, -1)
 * (ivec2(64, 9) / 76) => ivec2(0, 0)
 * (ivec2(64, 9) / -32) => ivec2(-2, 0)
 */
#version 120

void main()
{
  float[all(equal((ivec2(38, 35) / 12), ivec2(3, 2))) ? 1 : -1] array0;
  float[all(equal((ivec2(38, 35) / -6), ivec2(-6, -5))) ? 1 : -1] array1;
  float[all(equal((ivec2(38, 35) / 76), ivec2(0, 0))) ? 1 : -1] array2;
  float[all(equal((ivec2(38, 35) / -32), ivec2(-1, -1))) ? 1 : -1] array3;
  float[all(equal((ivec2(64, -9) / 12), ivec2(5, 0))) ? 1 : -1] array4;
  float[all(equal((ivec2(64, -9) / -6), ivec2(-10, 1))) ? 1 : -1] array5;
  float[all(equal((ivec2(64, -9) / 76), ivec2(0, 0))) ? 1 : -1] array6;
  float[all(equal((ivec2(64, -9) / -32), ivec2(-2, 0))) ? 1 : -1] array7;
  float[all(equal((ivec2(64, 9) / 12), ivec2(5, 0))) ? 1 : -1] array8;
  float[all(equal((ivec2(64, 9) / -6), ivec2(-10, -1))) ? 1 : -1] array9;
  float[all(equal((ivec2(64, 9) / 76), ivec2(0, 0))) ? 1 : -1] array10;
  float[all(equal((ivec2(64, 9) / -32), ivec2(-2, 0))) ? 1 : -1] array11;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length());
}
