#-------------------------------------------------------------------------------
# elftools: dwarf/enums.py
#
# Mappings of enum names to values
#
# Eli Bendersky (eliben@gmail.com)
# This code is in the public domain
#-------------------------------------------------------------------------------
from ..construct import Pass
from ..common.py3compat import iteritems


ENUM_DW_TAG = dict(
    DW_TAG_null                        = 0x00,
    DW_TAG_array_type                  = 0x01,
    DW_TAG_class_type                  = 0x02,
    DW_TAG_entry_point                 = 0x03,
    DW_TAG_enumeration_type            = 0x04,
    DW_TAG_formal_parameter            = 0x05,
    DW_TAG_global_subroutine           = 0x06,
    DW_TAG_global_variable             = 0x07,
    DW_TAG_imported_declaration        = 0x08,
    DW_TAG_label                       = 0x0a,
    DW_TAG_lexical_block               = 0x0b,
    DW_TAG_local_variable              = 0x0c,
    DW_TAG_member                      = 0x0d,
    DW_TAG_pointer_type                = 0x0f,
    DW_TAG_reference_type              = 0x10,
    DW_TAG_compile_unit                = 0x11,
    DW_TAG_string_type                 = 0x12,
    DW_TAG_structure_type              = 0x13,
    DW_TAG_subroutine                  = 0x14,
    DW_TAG_subroutine_type             = 0x15,
    DW_TAG_typedef                     = 0x16,
    DW_TAG_union_type                  = 0x17,
    DW_TAG_unspecified_parameters      = 0x18,
    DW_TAG_variant                     = 0x19,
    DW_TAG_common_block                = 0x1a,
    DW_TAG_common_inclusion            = 0x1b,
    DW_TAG_inheritance                 = 0x1c,
    DW_TAG_inlined_subroutine          = 0x1d,
    DW_TAG_module                      = 0x1e,
    DW_TAG_ptr_to_member_type          = 0x1f,
    DW_TAG_set_type                    = 0x20,
    DW_TAG_subrange_type               = 0x21,
    DW_TAG_with_stmt                   = 0x22,
    DW_TAG_access_declaration          = 0x23,
    DW_TAG_base_type                   = 0x24,
    DW_TAG_catch_block                 = 0x25,
    DW_TAG_const_type                  = 0x26,
    DW_TAG_constant                    = 0x27,
    DW_TAG_enumerator                  = 0x28,
    DW_TAG_file_type                   = 0x29,
    DW_TAG_friend                      = 0x2a,
    DW_TAG_namelist                    = 0x2b,
    DW_TAG_namelist_item               = 0x2c,
    DW_TAG_namelist_items              = 0x2c,
    DW_TAG_packed_type                 = 0x2d,
    DW_TAG_subprogram                  = 0x2e,

    # The DWARF standard defines these as _parameter, not _param, but we
    # maintain compatibility with readelf.
    DW_TAG_template_type_param         = 0x2f,
    DW_TAG_template_value_param        = 0x30,

    DW_TAG_thrown_type                 = 0x31,
    DW_TAG_try_block                   = 0x32,
    DW_TAG_variant_part                = 0x33,
    DW_TAG_variable                    = 0x34,
    DW_TAG_volatile_type               = 0x35,
    DW_TAG_dwarf_procedure             = 0x36,
    DW_TAG_restrict_type               = 0x37,
    DW_TAG_interface_type              = 0x38,
    DW_TAG_namespace                   = 0x39,
    DW_TAG_imported_module             = 0x3a,
    DW_TAG_unspecified_type            = 0x3b,
    DW_TAG_partial_unit                = 0x3c,
    DW_TAG_imported_unit               = 0x3d,
    DW_TAG_mutable_type                = 0x3e,
    DW_TAG_condition                   = 0x3f,
    DW_TAG_shared_type                 = 0x40,
    DW_TAG_type_unit                   = 0x41,
    DW_TAG_rvalue_reference_type       = 0x42,
    DW_TAG_atomic_type                 = 0x47,
    DW_TAG_call_site                   = 0x48,
    DW_TAG_call_site_parameter         = 0x49,
    DW_TAG_skeleton_unit               = 0x4a,
    DW_TAG_immutable_type              = 0x4b,



    DW_TAG_lo_user                     = 0x4080,
    DW_TAG_GNU_template_template_param = 0x4106,
    DW_TAG_GNU_template_parameter_pack = 0x4107,
    DW_TAG_GNU_formal_parameter_pack   = 0x4108,
    DW_TAG_GNU_call_site               = 0x4109,
    DW_TAG_GNU_call_site_parameter     = 0x410a,

    DW_TAG_APPLE_property              = 0x4200,

    DW_TAG_hi_user                     = 0xffff,

    _default_                          = Pass,
)


ENUM_DW_CHILDREN = dict(
    DW_CHILDREN_no  = 0x00,
    DW_CHILDREN_yes = 0x01,
)


ENUM_DW_AT = dict(
    DW_AT_null                      = 0x00,
    DW_AT_sibling                   = 0x01,
    DW_AT_location                  = 0x02,
    DW_AT_name                      = 0x03,
    DW_AT_fund_type                 = 0x05,
    DW_AT_mod_fund_type             = 0x06,
    DW_AT_user_def_type             = 0x07,
    DW_AT_mod_u_d_type              = 0x08,
    DW_AT_ordering                  = 0x09,
    DW_AT_subscr_data               = 0x0a,
    DW_AT_byte_size                 = 0x0b,
    DW_AT_bit_offset                = 0x0c,
    DW_AT_bit_size                  = 0x0d,
    DW_AT_element_list              = 0x0f,
    DW_AT_stmt_list                 = 0x10,
    DW_AT_low_pc                    = 0x11,
    DW_AT_high_pc                   = 0x12,
    DW_AT_language                  = 0x13,
    DW_AT_member                    = 0x14,
    DW_AT_discr                     = 0x15,
    DW_AT_discr_value               = 0x16,
    DW_AT_visibility                = 0x17,
    DW_AT_import                    = 0x18,
    DW_AT_string_length             = 0x19,
    DW_AT_common_reference          = 0x1a,
    DW_AT_comp_dir                  = 0x1b,
    DW_AT_const_value               = 0x1c,
    DW_AT_containing_type           = 0x1d,
    DW_AT_default_value             = 0x1e,
    DW_AT_inline                    = 0x20,
    DW_AT_is_optional               = 0x21,
    DW_AT_lower_bound               = 0x22,
    DW_AT_program                   = 0x23,
    DW_AT_private                   = 0x24,
    DW_AT_producer                  = 0x25,
    DW_AT_protected                 = 0x26,
    DW_AT_prototyped                = 0x27,
    DW_AT_public                    = 0x28,
    DW_AT_return_addr               = 0x2a,
    DW_AT_start_scope               = 0x2c,
    DW_AT_bit_stride                = 0x2e,
    DW_AT_stride_size               = 0x2e,
    DW_AT_upper_bound               = 0x2f,
    DW_AT_virtual                   = 0x30,
    DW_AT_abstract_origin           = 0x31,
    DW_AT_accessibility             = 0x32,
    DW_AT_address_class             = 0x33,
    DW_AT_artificial                = 0x34,
    DW_AT_base_types                = 0x35,
    DW_AT_calling_convention        = 0x36,
    DW_AT_count                     = 0x37,
    DW_AT_data_member_location      = 0x38,
    DW_AT_decl_column               = 0x39,
    DW_AT_decl_file                 = 0x3a,
    DW_AT_decl_line                 = 0x3b,
    DW_AT_declaration               = 0x3c,
    DW_AT_discr_list                = 0x3d,
    DW_AT_encoding                  = 0x3e,
    DW_AT_external                  = 0x3f,
    DW_AT_frame_base                = 0x40,
    DW_AT_friend                    = 0x41,
    DW_AT_identifier_case           = 0x42,
    DW_AT_macro_info                = 0x43,
    DW_AT_namelist_item             = 0x44,
    DW_AT_priority                  = 0x45,
    DW_AT_segment                   = 0x46,
    DW_AT_specification             = 0x47,
    DW_AT_static_link               = 0x48,
    DW_AT_type                      = 0x49,
    DW_AT_use_location              = 0x4a,
    DW_AT_variable_parameter        = 0x4b,
    DW_AT_virtuality                = 0x4c,
    DW_AT_vtable_elem_location      = 0x4d,
    DW_AT_allocated                 = 0x4e,
    DW_AT_associated                = 0x4f,
    DW_AT_data_location             = 0x50,
    DW_AT_byte_stride               = 0x51,
    DW_AT_stride                    = 0x51,
    DW_AT_entry_pc                  = 0x52,
    DW_AT_use_UTF8                  = 0x53,
    DW_AT_extension                 = 0x54,
    DW_AT_ranges                    = 0x55,
    DW_AT_trampoline                = 0x56,
    DW_AT_call_column               = 0x57,
    DW_AT_call_file                 = 0x58,
    DW_AT_call_line                 = 0x59,
    DW_AT_description               = 0x5a,
    DW_AT_binary_scale              = 0x5b,
    DW_AT_decimal_scale             = 0x5c,
    DW_AT_small                     = 0x5d,
    DW_AT_decimal_sign              = 0x5e,
    DW_AT_digit_count               = 0x5f,
    DW_AT_picture_string            = 0x60,
    DW_AT_mutable                   = 0x61,
    DW_AT_threads_scaled            = 0x62,
    DW_AT_explicit                  = 0x63,
    DW_AT_object_pointer            = 0x64,
    DW_AT_endianity                 = 0x65,
    DW_AT_elemental                 = 0x66,
    DW_AT_pure                      = 0x67,
    DW_AT_recursive                 = 0x68,
    DW_AT_signature                 = 0x69,
    DW_AT_main_subprogram           = 0x6a,
    DW_AT_data_bit_offset           = 0x6b,
    DW_AT_const_expr                = 0x6c,
    DW_AT_enum_class                = 0x6d,
    DW_AT_linkage_name              = 0x6e,
    DW_AT_string_length_bit_size    = 0x6f,
    DW_AT_string_length_byte_size   = 0x70,
    DW_AT_rank                      = 0x71,
    DW_AT_str_offsets_base          = 0x72,
    DW_AT_addr_base                 = 0x73,
    DW_AT_rnglists_base             = 0x74,
    DW_AT_dwo_name                  = 0x76,
    DW_AT_reference                 = 0x77,
    DW_AT_rvalue_reference          = 0x78,
    DW_AT_macros                    = 0x79,
    DW_AT_call_all_calls            = 0x7a,
    DW_AT_call_all_source_calls     = 0x7b,
    DW_AT_call_all_tail_calls       = 0x7c,
    DW_AT_call_return_pc            = 0x7d,
    DW_AT_call_value                = 0x7e,
    DW_AT_call_origin               = 0x7f,
    DW_AT_call_parameter            = 0x80,
    DW_AT_call_pc                   = 0x81,
    DW_AT_call_tail_call            = 0x82,
    DW_AT_call_target               = 0x83,
    DW_AT_call_target_clobbered     = 0x84,
    DW_AT_call_data_location        = 0x85,
    DW_AT_call_data_value           = 0x86,
    DW_AT_noreturn                  = 0x87,
    DW_AT_alignment                 = 0x88,
    DW_AT_export_symbols            = 0x89,
    DW_AT_deleted                   = 0x8a,
    DW_AT_defaulted                 = 0x8b,
    DW_AT_loclists_base             = 0x8c,

    DW_AT_MIPS_fde                      = 0x2001,
    DW_AT_MIPS_loop_begin               = 0x2002,
    DW_AT_MIPS_tail_loop_begin          = 0x2003,
    DW_AT_MIPS_epilog_begin             = 0x2004,
    DW_AT_MIPS_loop_unroll_factor       = 0x2005,
    DW_AT_MIPS_software_pipeline_depth  = 0x2006,
    DW_AT_MIPS_linkage_name             = 0x2007,
    DW_AT_MIPS_stride                   = 0x2008,
    DW_AT_MIPS_abstract_name            = 0x2009,
    DW_AT_MIPS_clone_origin             = 0x200a,
    DW_AT_MIPS_has_inlines              = 0x200b,
    DW_AT_MIPS_stride_byte              = 0x200c,
    DW_AT_MIPS_stride_elem              = 0x200d,
    DW_AT_MIPS_ptr_dopetype             = 0x200e,
    DW_AT_MIPS_allocatable_dopetype     = 0x200f,
    DW_AT_MIPS_assumed_shape_dopetype   = 0x2010,
    DW_AT_MIPS_assumed_size             = 0x2011,

    DW_AT_sf_names                      = 0x2101,
    DW_AT_src_info                      = 0x2102,
    DW_AT_mac_info                      = 0x2103,
    DW_AT_src_coords                    = 0x2104,
    DW_AT_body_begin                    = 0x2105,
    DW_AT_body_end                      = 0x2106,
    DW_AT_GNU_vector                    = 0x2107,
    DW_AT_GNU_template_name             = 0x2110,
    DW_AT_GNU_odr_signature             = 0x210f,

    DW_AT_GNU_call_site_value               = 0x2111,
    DW_AT_GNU_call_site_data_value          = 0x2112,
    DW_AT_GNU_call_site_target              = 0x2113,
    DW_AT_GNU_call_site_target_clobbered    = 0x2114,
    DW_AT_GNU_tail_call                     = 0x2115,
    DW_AT_GNU_all_tail_call_sites           = 0x2116,
    DW_AT_GNU_all_call_sites                = 0x2117,
    DW_AT_GNU_all_source_call_sites         = 0x2118,
    DW_AT_GNU_macros                        = 0x2119,
    DW_AT_GNU_deleted                       = 0x211a,
    DW_AT_GNU_dwo_id                        = 0x2131,
    DW_AT_GNU_pubnames                      = 0x2134,
    DW_AT_GNU_pubtypes                      = 0x2135,
    DW_AT_GNU_discriminator                 = 0x2136,
    DW_AT_GNU_locviews                      = 0x2137,
    DW_AT_GNU_entry_view                    = 0x2138,

    DW_AT_LLVM_include_path  = 0x3e00,
    DW_AT_LLVM_config_macros = 0x3e01,
    DW_AT_LLVM_isysroot      = 0x3e02,
    DW_AT_LLVM_tag_offset    = 0x3e03,

    DW_AT_APPLE_optimized               = 0x3fe1,
    DW_AT_APPLE_flags                   = 0x3fe2,
    DW_AT_APPLE_isa                     = 0x3fe3,
    DW_AT_APPLE_block                   = 0x3fe4,
    DW_AT_APPLE_major_runtime_vers      = 0x3fe5,
    DW_AT_APPLE_runtime_class           = 0x3fe6,
    DW_AT_APPLE_omit_frame_ptr          = 0x3fe7,
    DW_AT_APPLE_property_name           = 0x3fe8,
    DW_AT_APPLE_property_getter         = 0x3fe9,
    DW_AT_APPLE_property_setter         = 0x3fea,
    DW_AT_APPLE_property_attribute      = 0x3feb,
    DW_AT_APPLE_objc_complete_type      = 0x3fec,
    DW_AT_APPLE_property                = 0x3fed,

    _default_ = Pass,
)


ENUM_DW_FORM = dict(
    DW_FORM_null                = 0x00,
    DW_FORM_addr                = 0x01,
    DW_FORM_ref                 = 0x02,
    DW_FORM_block2              = 0x03,
    DW_FORM_block4              = 0x04,
    DW_FORM_data2               = 0x05,
    DW_FORM_data4               = 0x06,
    DW_FORM_data8               = 0x07,
    DW_FORM_string              = 0x08,
    DW_FORM_block               = 0x09,
    DW_FORM_block1              = 0x0a,
    DW_FORM_data1               = 0x0b,
    DW_FORM_flag                = 0x0c,
    DW_FORM_sdata               = 0x0d,
    DW_FORM_strp                = 0x0e,
    DW_FORM_udata               = 0x0f,
    DW_FORM_ref_addr            = 0x10,
    DW_FORM_ref1                = 0x11,
    DW_FORM_ref2                = 0x12,
    DW_FORM_ref4                = 0x13,
    DW_FORM_ref8                = 0x14,
    DW_FORM_ref_udata           = 0x15,
    DW_FORM_indirect            = 0x16,
    DW_FORM_sec_offset          = 0x17,
    DW_FORM_exprloc             = 0x18,
    DW_FORM_flag_present        = 0x19,
    DW_FORM_strx                = 0x1a,
    DW_FORM_addrx               = 0x1b,
    DW_FORM_ref_sup4            = 0x1c,
    DW_FORM_strp_sup            = 0x1d,
    DW_FORM_data16              = 0x1e,
    DW_FORM_line_strp           = 0x1f,
    DW_FORM_ref_sig8            = 0x20,
    DW_FORM_implicit_const      = 0x21,
    DW_FORM_loclistx            = 0x22,
    DW_FORM_rnglistx            = 0x23,
    DW_FORM_ref_sup8            = 0x24,
    DW_FORM_strx1               = 0x25,
    DW_FORM_strx2               = 0x26,
    DW_FORM_strx3               = 0x27,
    DW_FORM_strx4               = 0x28,
    DW_FORM_addrx1              = 0x29,
    DW_FORM_addrx2              = 0x2a,
    DW_FORM_addrx3              = 0x2b,
    DW_FORM_addrx4              = 0x2c,

    DW_FORM_GNU_addr_index      = 0x1f01,
    DW_FORM_GNU_str_index       = 0x1f02,
    DW_FORM_GNU_ref_alt         = 0x1f20,
    DW_FORM_GNU_strp_alt        = 0x1f21,
    _default_                   = Pass,
)

# Inverse mapping for ENUM_DW_FORM
DW_FORM_raw2name = dict((v, k) for k, v in iteritems(ENUM_DW_FORM))

# See http://www.airs.com/blog/archives/460
DW_EH_encoding_flags = dict(
    DW_EH_PE_absptr   = 0x00,
    DW_EH_PE_uleb128  = 0x01,
    DW_EH_PE_udata2   = 0x02,
    DW_EH_PE_udata4   = 0x03,
    DW_EH_PE_udata8   = 0x04,

    DW_EH_PE_signed   = 0x08,
    DW_EH_PE_sleb128  = 0x09,
    DW_EH_PE_sdata2   = 0x0a,
    DW_EH_PE_sdata4   = 0x0b,
    DW_EH_PE_sdata8   = 0x0c,

    DW_EH_PE_pcrel    = 0x10,
    DW_EH_PE_textrel  = 0x20,
    DW_EH_PE_datarel  = 0x30,
    DW_EH_PE_funcrel  = 0x40,
    DW_EH_PE_aligned  = 0x50,
    DW_EH_PE_indirect = 0x80,

    DW_EH_PE_omit     = 0xff,
)

ENUM_DW_LNCT = dict(
    DW_LNCT_path             = 0x1,
    DW_LNCT_directory_index  = 0x2,
    DW_LNCT_timestamp        = 0x3,
    DW_LNCT_size             = 0x4,
    DW_LNCT_MD5              = 0x5,
    DW_LNCT_lo_user          = 0x2000,
    DW_LNCT_hi_user          = 0x3fff
)

ENUM_DW_UT = dict(
    DW_UT_compile       = 0x01,
    DW_UT_type          = 0x02,
    DW_UT_partial       = 0x03,
    DW_UT_skeleton      = 0x04,
    DW_UT_split_compile = 0x05,
    DW_UT_split_type    = 0x06,
    DW_UT_lo_user       = 0x80,
    DW_UT_hi_user       = 0xff
)

ENUM_DW_LLE = dict(
    DW_LLE_end_of_list      = 0x00,
    DW_LLE_base_addressx    = 0x01,
    DW_LLE_startx_endx      = 0x02,
    DW_LLE_startx_length    = 0x03,
    DW_LLE_offset_pair      = 0x04,
    DW_LLE_default_location = 0x05,
    DW_LLE_base_address     = 0x06,
    DW_LLE_start_end        = 0x07,
    DW_LLE_start_length     = 0x08
)

ENUM_DW_RLE = dict(
    DW_RLE_end_of_list   = 0x00,
    DW_RLE_base_addressx = 0x01,
    DW_RLE_startx_endx   = 0x02,
    DW_RLE_startx_length = 0x03,
    DW_RLE_offset_pair   = 0x04,
    DW_RLE_base_address  = 0x05,
    DW_RLE_start_end     = 0x06,
    DW_RLE_start_length  = 0x07
)

ENUM_DW_LANG = dict(
    DW_LANG_C89            = 0x0001,
    DW_LANG_C              = 0x0002,
    DW_LANG_Ada83          = 0x0003,
    DW_LANG_C_plus_plus    = 0x0004,
    DW_LANG_Cobol74        = 0x0005,
    DW_LANG_Cobol85        = 0x0006,
    DW_LANG_Fortran77      = 0x0007,
    DW_LANG_Fortran90      = 0x0008,
    DW_LANG_Pascal83       = 0x0009,
    DW_LANG_Modula2        = 0x000a,
    DW_LANG_Java           = 0x000b,
    DW_LANG_C99            = 0x000c,
    DW_LANG_Ada95          = 0x000d,
    DW_LANG_Fortran95      = 0x000e,
    DW_LANG_PLI            = 0x000f,
    DW_LANG_ObjC           = 0x0010,
    DW_LANG_ObjC_plus_plus = 0x0011,
    DW_LANG_UPC            = 0x0012,
    DW_LANG_D              = 0x0013,
    DW_LANG_Python         = 0x0014,
    DW_LANG_OpenCL         = 0x0015,
    DW_LANG_Go             = 0x0016,
    DW_LANG_Modula3        = 0x0017,
    DW_LANG_Haskell        = 0x0018,
    DW_LANG_C_plus_plus_03 = 0x0019,
    DW_LANG_C_plus_plus_11 = 0x001a,
    DW_LANG_OCaml          = 0x001b,
    DW_LANG_Rust           = 0x001c,
    DW_LANG_C11            = 0x001d,
    DW_LANG_Swift          = 0x001e,
    DW_LANG_Julia          = 0x001f,
    DW_LANG_Dylan          = 0x0020,
    DW_LANG_C_plus_plus_14 = 0x0021,
    DW_LANG_Fortran03      = 0x0022,
    DW_LANG_Fortran08      = 0x0023,
    DW_LANG_RenderScript   = 0x0024,
    DW_LANG_BLISS          = 0x0025,
    DW_LANG_lo_user        = 0x8000,
    DW_LANG_hi_user        = 0xffff
)

ENUM_DW_ATE = dict(
    DW_ATE_address         = 0x01,
    DW_ATE_boolean         = 0x02,
    DW_ATE_complex_float   = 0x03,
    DW_ATE_float           = 0x04,
    DW_ATE_signed          = 0x05,
    DW_ATE_signed_char     = 0x06,
    DW_ATE_unsigned        = 0x07,
    DW_ATE_unsigned_char   = 0x08,
    DW_ATE_imaginary_float = 0x09,
    DW_ATE_packed_decimal  = 0x0a,
    DW_ATE_numeric_string  = 0x0b,
    DW_ATE_edited          = 0x0c,
    DW_ATE_signed_fixed    = 0x0d,
    DW_ATE_unsigned_fixed  = 0x0e,
    DW_ATE_decimal_float   = 0x0f,
    DW_ATE_UTF             = 0x10,
    DW_ATE_UCS             = 0x11,
    DW_ATE_ASCII           = 0x12,
    DW_ATE_lo_user         = 0x80,
    DW_ATE_hi_user         = 0xff
)

ENUM_DW_ACCESS = dict(
    DW_ACCESS_public    = 0x01,
    DW_ACCESS_protected = 0x02,
    DW_ACCESS_private   = 0x03
)

ENUM_DW_INL = dict(
    DW_INL_not_inlined          = 0x00,
    DW_INL_inlined              = 0x01,
    DW_INL_declared_not_inlined = 0x02,
    DW_INL_declared_inlined     = 0x03
)

ENUM_DW_CC = dict(
    DW_CC_normal            = 0x01,
    DW_CC_program           = 0x02,
    DW_CC_nocall            = 0x03,
    DW_CC_pass_by_reference = 0x04,
    DW_CC_pass_by_value     = 0x05,
    DW_CC_lo_user           = 0x40,
    DW_CC_hi_user           = 0xff
)
