/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.prometheus.scraper;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.prometheus.collector.MetricSamples;
import org.apache.solr.prometheus.exporter.MetricsQuery;
import org.apache.solr.prometheus.scraper.SolrScraper;

public class SolrStandaloneScraper
extends SolrScraper {
    private final Http2SolrClient solrClient;

    public SolrStandaloneScraper(Http2SolrClient solrClient, ExecutorService executor, String clusterId) {
        super(executor, clusterId);
        this.solrClient = solrClient;
    }

    @Override
    public Map<String, MetricSamples> pingAllCores(MetricsQuery query) throws IOException {
        return this.sendRequestsInParallel(this.getCores(), core -> {
            try {
                return this.request((SolrClient)this.solrClient, query.withCore((String)core));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public Map<String, MetricSamples> pingAllCollections(MetricsQuery query) throws IOException {
        return Collections.emptyMap();
    }

    @Override
    public Map<String, MetricSamples> metricsForAllHosts(MetricsQuery query) throws IOException {
        HashMap<String, MetricSamples> samples = new HashMap<String, MetricSamples>();
        samples.put(this.solrClient.getBaseURL(), this.request((SolrClient)this.solrClient, query));
        return samples;
    }

    @Override
    public MetricSamples search(MetricsQuery query) throws IOException {
        return this.request((SolrClient)this.solrClient, query);
    }

    @Override
    public MetricSamples collections(MetricsQuery metricsQuery) {
        return new MetricSamples();
    }

    private Set<String> getCores() throws IOException {
        NamedList coreAdminResponse;
        HashSet<String> cores = new HashSet<String>();
        CoreAdminRequest coreAdminRequest = new CoreAdminRequest();
        coreAdminRequest.setAction(CoreAdminParams.CoreAdminAction.STATUS);
        coreAdminRequest.setIndexInfoNeeded(false);
        try {
            coreAdminResponse = this.solrClient.request((SolrRequest)coreAdminRequest);
        }
        catch (SolrServerException e) {
            throw new IOException("Failed to get cores", e);
        }
        JsonNode statusJsonNode = OBJECT_MAPPER.readTree((String)coreAdminResponse.get("response")).get("status");
        for (JsonNode jsonNode : statusJsonNode) {
            cores.add(jsonNode.get("name").textValue());
        }
        return cores;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.solrClient);
    }
}

