/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.solr.api.Command;
import org.apache.solr.api.EndPoint;
import org.apache.solr.api.PayloadObj;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.beans.BackupCollectionPayload;
import org.apache.solr.client.solrj.request.beans.CreateAliasPayload;
import org.apache.solr.client.solrj.request.beans.CreatePayload;
import org.apache.solr.client.solrj.request.beans.DeleteAliasPayload;
import org.apache.solr.client.solrj.request.beans.RestoreCollectionPayload;
import org.apache.solr.client.solrj.request.beans.SetAliasPropertyPayload;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.handler.ClusterAPI;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class CollectionsAPI {
    public static final String V2_CREATE_COLLECTION_CMD = "create";
    public static final String V2_BACKUP_CMD = "backup-collection";
    public static final String V2_RESTORE_CMD = "restore-collection";
    public static final String V2_CREATE_ALIAS_CMD = "create-alias";
    public static final String V2_SET_ALIAS_PROP_CMD = "set-alias-property";
    public static final String V2_DELETE_ALIAS_CMD = "delete-alias";
    private final CollectionsHandler collectionsHandler;
    public final CollectionsCommands collectionsCommands = new CollectionsCommands();

    public CollectionsAPI(CollectionsHandler collectionsHandler) {
        this.collectionsHandler = collectionsHandler;
    }

    @EndPoint(path={"/c", "/collections"}, method={SolrRequest.METHOD.GET}, permission=PermissionNameProvider.Name.COLL_READ_PERM)
    public void getCollections(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        HashMap v1Params = Maps.newHashMap();
        v1Params.put("action", CollectionParams.CollectionAction.LIST.toLower());
        this.collectionsHandler.handleRequestBody(ClusterAPI.wrapParams(req, v1Params), rsp);
    }

    @EndPoint(path={"/c", "/collections"}, method={SolrRequest.METHOD.POST}, permission=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public class CollectionsCommands {
        @Command(name="backup-collection")
        public void backupCollection(PayloadObj<BackupCollectionPayload> obj) throws Exception {
            Map v1Params = obj.get().toMap(new HashMap());
            v1Params.put("action", CollectionParams.CollectionAction.BACKUP.toLower());
            CollectionsAPI.this.collectionsHandler.handleRequestBody(ClusterAPI.wrapParams(obj.getRequest(), v1Params), obj.getResponse());
        }

        @Command(name="restore-collection")
        public void restoreBackup(PayloadObj<RestoreCollectionPayload> obj) throws Exception {
            RestoreCollectionPayload v2Body = obj.get();
            Map v1Params = v2Body.toMap(new HashMap());
            v1Params.put("action", CollectionParams.CollectionAction.RESTORE.toLower());
            if (v2Body.createCollectionParams != null && !v2Body.createCollectionParams.isEmpty()) {
                Map createCollParams = (Map)v1Params.remove("create-collection");
                this.convertV2CreateCollectionMapToV1ParamMap(createCollParams);
                v1Params.putAll(createCollParams);
            }
            CollectionsAPI.this.collectionsHandler.handleRequestBody(ClusterAPI.wrapParams(obj.getRequest(), v1Params), obj.getResponse());
        }

        @Command(name="create-alias")
        public void createAlias(PayloadObj<CreateAliasPayload> obj) throws Exception {
            CreateAliasPayload v2Body = obj.get();
            Map v1Params = v2Body.toMap(new HashMap());
            v1Params.put("action", CollectionParams.CollectionAction.CREATEALIAS.toLower());
            if (!CollectionUtils.isEmpty((Collection)v2Body.collections)) {
                String collectionsStr = String.join((CharSequence)",", v2Body.collections);
                v1Params.remove("collections");
                v1Params.put("collections", collectionsStr);
            }
            if (v2Body.router != null) {
                Map routerProperties = (Map)v1Params.remove("router");
                V2ApiUtils.flattenMapWithPrefix(routerProperties, v1Params, "router.");
            }
            if (v2Body.createCollectionParams != null && !v2Body.createCollectionParams.isEmpty()) {
                Map createCollectionMap = (Map)v1Params.remove("create-collection");
                this.convertV2CreateCollectionMapToV1ParamMap(createCollectionMap);
                V2ApiUtils.flattenMapWithPrefix(createCollectionMap, v1Params, "create-collection.");
            }
            CollectionsAPI.this.collectionsHandler.handleRequestBody(ClusterAPI.wrapParams(obj.getRequest(), v1Params), obj.getResponse());
        }

        @Command(name="set-alias-property")
        public void setAliasProperty(PayloadObj<SetAliasPropertyPayload> obj) throws Exception {
            SetAliasPropertyPayload v2Body = obj.get();
            Map v1Params = v2Body.toMap(new HashMap());
            v1Params.put("action", CollectionParams.CollectionAction.ALIASPROP.toLower());
            Map propertiesMap = (Map)v1Params.remove("properties");
            V2ApiUtils.flattenMapWithPrefix(propertiesMap, v1Params, "property.");
            CollectionsAPI.this.collectionsHandler.handleRequestBody(ClusterAPI.wrapParams(obj.getRequest(), v1Params), obj.getResponse());
        }

        @Command(name="delete-alias")
        public void deleteAlias(PayloadObj<DeleteAliasPayload> obj) throws Exception {
            DeleteAliasPayload v2Body = obj.get();
            Map v1Params = v2Body.toMap(new HashMap());
            v1Params.put("action", CollectionParams.CollectionAction.DELETEALIAS.toLower());
            CollectionsAPI.this.collectionsHandler.handleRequestBody(ClusterAPI.wrapParams(obj.getRequest(), v1Params), obj.getResponse());
        }

        @Command(name="create")
        public void create(PayloadObj<CreatePayload> obj) throws Exception {
            CreatePayload v2Body = obj.get();
            Map v1Params = v2Body.toMap(new HashMap());
            v1Params.put("action", CollectionParams.CollectionAction.CREATE.toLower());
            this.convertV2CreateCollectionMapToV1ParamMap(v1Params);
            CollectionsAPI.this.collectionsHandler.handleRequestBody(ClusterAPI.wrapParams(obj.getRequest(), v1Params), obj.getResponse());
        }

        private void convertV2CreateCollectionMapToV1ParamMap(Map<String, Object> v2MapVals) {
            Set v2Keys = v2MapVals.keySet().stream().collect(Collectors.toSet());
            Iterator iterator = v2Keys.iterator();
            while (iterator.hasNext()) {
                String key;
                switch (key = (String)iterator.next()) {
                    case "properties": {
                        Map propertiesMap = (Map)v2MapVals.remove("properties");
                        V2ApiUtils.flattenMapWithPrefix(propertiesMap, v2MapVals, "property.");
                        break;
                    }
                    case "router": {
                        Map routerProperties = (Map)v2MapVals.remove("router");
                        V2ApiUtils.flattenMapWithPrefix(routerProperties, v2MapVals, "router.");
                        break;
                    }
                    case "config": {
                        v2MapVals.put("collection.configName", v2MapVals.remove("config"));
                        break;
                    }
                    case "shuffleNodes": {
                        v2MapVals.put("createNodeSet.shuffle", v2MapVals.remove("shuffleNodes"));
                        break;
                    }
                    case "nodeSet": {
                        Object nodeSetValUncast = v2MapVals.remove("nodeSet");
                        if (nodeSetValUncast instanceof String) {
                            v2MapVals.put("createNodeSet", nodeSetValUncast);
                            break;
                        }
                        List nodeSetList = (List)nodeSetValUncast;
                        String nodeSetStr = String.join((CharSequence)",", nodeSetList);
                        v2MapVals.put("createNodeSet", nodeSetStr);
                        break;
                    }
                }
            }
        }
    }
}

