/*
 * Decompiled with CFR 0.152.
 */
package tr.view.criteria;

import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openide.util.NbBundle;
import tr.model.IDGenerator;
import tr.model.criteria.Criterion;
import tr.model.criteria.Value;
import tr.util.Observer;
import tr.view.criteria.CriterionTableModel;

public class PriorityTableModel
extends CriterionTableModel
implements Observer {
    public static final String[] HEADINGS = new String[]{NbBundle.getMessage(PriorityTableModel.class, (String)"value"), NbBundle.getMessage(PriorityTableModel.class, (String)"mapping")};
    public static final Class[] CLASSES = new Class[]{String.class, Integer.class};
    public static final TableCellRenderer[] RENDERERS = new TableCellRenderer[]{null, null};
    public static final TableCellEditor[] EDITORS = new TableCellEditor[]{null, null};
    public static final int[] MAX_WIDTHS = new int[]{200, 100};
    public static final int[] MIN_WIDTHS = new int[]{200, 100};
    public static final int[] PREF_WIDTHS = new int[]{200, 100};

    public PriorityTableModel(Criterion criterion, IDGenerator idGenerator) {
        super(criterion, idGenerator);
    }

    public int getColumnCount() {
        return CLASSES.length;
    }

    public Class getColumnClass(int column) {
        return CLASSES[column];
    }

    public String getColumnName(int column) {
        return HEADINGS[column];
    }

    public int getRowCount() {
        return this.criterion.values.size();
    }

    public Value getValueAt(int row) {
        return (Value)this.criterion.values.get(row);
    }

    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return this.getValueAt(row).getName();
            }
            case 1: {
                return this.getValueAt(row).getMappedValue();
            }
        }
        return "";
    }

    public boolean isCellEditable(int row, int column) {
        return true;
    }

    public void setValueAt(Object value, int row, int column) {
        if (row < this.criterion.values.size()) {
            if (column == 0 && value instanceof String) {
                ((Value)this.criterion.values.get(row)).setName((String)value);
                return;
            }
            if (column == 1) {
                if (value instanceof Integer) {
                    Integer iValue = (Integer)value;
                    if (iValue < 0) {
                        iValue = 0;
                    } else if (iValue > 9) {
                        iValue = 9;
                    }
                    ((Value)this.criterion.values.get(row)).setMappedValue(iValue);
                } else {
                    ((Value)this.criterion.values.get(row)).setMappedValue(null);
                }
            }
        }
    }

    public int[] getMaxWidths() {
        return MAX_WIDTHS;
    }

    public int[] getMinWidths() {
        return MIN_WIDTHS;
    }

    public int[] getPrefWidths() {
        return PREF_WIDTHS;
    }
}

