/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler;

import io.netty.channel.ChannelHandler;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.traccar.BaseDataHandler;
import org.traccar.model.Position;
import org.traccar.session.cache.CacheManager;

@Singleton
@ChannelHandler.Sharable
public class EngineHoursHandler
extends BaseDataHandler {
    private final CacheManager cacheManager;

    @Inject
    public EngineHoursHandler(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    protected Position handlePosition(Position position) {
        Position last;
        if (!position.hasAttribute("hours") && (last = this.cacheManager.getPosition(position.getDeviceId())) != null) {
            long hours = last.getLong("hours");
            if (last.getBoolean("ignition") && position.getBoolean("ignition")) {
                hours += position.getFixTime().getTime() - last.getFixTime().getTime();
            }
            if (hours != 0L) {
                position.set("hours", hours);
            }
        }
        return position;
    }
}

