/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class Mta6ProtocolDecoder
extends BaseProtocolDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(Mta6ProtocolDecoder.class);
    private final boolean simple;

    public Mta6ProtocolDecoder(Protocol protocol, boolean simple) {
        super(protocol);
        this.simple = simple;
    }

    private void sendContinue(Channel channel) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE);
        channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
    }

    private void sendResponse(Channel channel, short packetId, short packetCount) {
        ByteBuf begin = Unpooled.copiedBuffer((CharSequence)"#ACK#", (Charset)StandardCharsets.US_ASCII);
        ByteBuf end = Unpooled.buffer((int)3);
        end.writeByte((int)packetId);
        end.writeByte((int)packetCount);
        end.writeByte(0);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{begin, end}));
        channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
    }

    private List<Position> parseFormatA(DeviceSession deviceSession, ByteBuf buf) {
        LinkedList<Position> positions = new LinkedList<Position>();
        FloatReader latitudeReader = new FloatReader();
        FloatReader longitudeReader = new FloatReader();
        TimeReader timeReader = new TimeReader();
        try {
            while (buf.isReadable()) {
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                short flags = buf.readUnsignedByte();
                short event = buf.readUnsignedByte();
                if (BitUtil.check(event, 7)) {
                    if (BitUtil.check(event, 6)) {
                        buf.skipBytes(8);
                    } else {
                        while (BitUtil.check(event, 7)) {
                            event = buf.readUnsignedByte();
                        }
                    }
                }
                position.setLatitude((double)latitudeReader.readFloat(buf) / Math.PI * 180.0);
                position.setLongitude((double)longitudeReader.readFloat(buf) / Math.PI * 180.0);
                position.setTime(timeReader.readTime(buf));
                if (BitUtil.check(flags, 0)) {
                    buf.readUnsignedByte();
                }
                if (BitUtil.check(flags, 1)) {
                    position.setAltitude(buf.readUnsignedShort());
                }
                if (BitUtil.check(flags, 2)) {
                    position.setSpeed(buf.readUnsignedShort() & 0x3FF);
                    position.setCourse(buf.readUnsignedByte());
                }
                if (BitUtil.check(flags, 3)) {
                    position.set("odometer", buf.readUnsignedShort() * 1000);
                }
                if (BitUtil.check(flags, 4)) {
                    position.set("fuelConsumptionAccumulator1", buf.readUnsignedInt());
                    position.set("fuelConsumptionAccumulator2", buf.readUnsignedInt());
                    position.set("hours1", buf.readUnsignedShort());
                    position.set("hours2", buf.readUnsignedShort());
                }
                if (BitUtil.check(flags, 5)) {
                    position.set("adc1", buf.readUnsignedShort() & 0x3FF);
                    position.set("adc2", buf.readUnsignedShort() & 0x3FF);
                    position.set("adc3", buf.readUnsignedShort() & 0x3FF);
                    position.set("adc4", buf.readUnsignedShort() & 0x3FF);
                }
                if (BitUtil.check(flags, 6)) {
                    position.set("temp1", buf.readByte());
                    buf.getUnsignedByte(buf.readerIndex());
                    position.set("input", buf.readUnsignedShort() & 0xFFF);
                    buf.readUnsignedShort();
                }
                if (BitUtil.check(flags, 7)) {
                    position.set("battery", buf.getUnsignedByte(buf.readerIndex()) >> 2);
                    position.set("power", buf.readUnsignedShort() & 0x3FF);
                    position.set("deviceTemp", buf.readByte());
                    position.set("rssi", buf.getUnsignedByte(buf.readerIndex()) >> 4 & 7);
                    int satellites = buf.readUnsignedByte() & 0xF;
                    position.setValid(satellites >= 3);
                    position.set("sat", satellites);
                }
                positions.add(position);
            }
        }
        catch (IndexOutOfBoundsException error) {
            LOGGER.warn("MTA6 parsing error", (Throwable)error);
        }
        return positions;
    }

    private Position parseFormatA1(DeviceSession deviceSession, ByteBuf buf) {
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        short flags = buf.readUnsignedByte();
        short event = buf.readUnsignedByte();
        if (BitUtil.check(event, 7)) {
            if (BitUtil.check(event, 6)) {
                buf.skipBytes(8);
            } else {
                while (BitUtil.check(event, 7)) {
                    event = buf.readUnsignedByte();
                }
            }
        }
        position.setLatitude((double)new FloatReader().readFloat(buf) / Math.PI * 180.0);
        position.setLongitude((double)new FloatReader().readFloat(buf) / Math.PI * 180.0);
        position.setTime(new TimeReader().readTime(buf));
        position.set("status", buf.readUnsignedByte());
        if (BitUtil.check(flags, 0)) {
            position.setAltitude(buf.readUnsignedShort());
            position.setSpeed(buf.readUnsignedByte());
            position.setCourse(buf.readByte());
            position.set("odometer", Float.valueOf(new FloatReader().readFloat(buf)));
        }
        if (BitUtil.check(flags, 1)) {
            position.set("fuelConsumption", Float.valueOf(new FloatReader().readFloat(buf)));
            position.set("hours", UnitsConverter.msFromHours(new FloatReader().readFloat(buf)));
            position.set("tank", (double)buf.readUnsignedByte() * 0.4);
        }
        if (BitUtil.check(flags, 2)) {
            position.set("engine", (double)buf.readUnsignedShort() * 0.125);
            position.set("pedals", buf.readUnsignedByte());
            position.set("temp1", buf.readUnsignedByte() - 40);
            position.set("serviceOdometer", buf.readUnsignedShort());
        }
        if (BitUtil.check(flags, 3)) {
            position.set("fuel", buf.readUnsignedShort());
            position.set("adc2", buf.readUnsignedShort());
            position.set("adc3", buf.readUnsignedShort());
            position.set("adc4", buf.readUnsignedShort());
        }
        if (BitUtil.check(flags, 4)) {
            position.set("temp1", buf.readByte());
            buf.getUnsignedByte(buf.readerIndex());
            position.set("input", buf.readUnsignedShort() & 0xFFF);
            buf.readUnsignedShort();
        }
        if (BitUtil.check(flags, 5)) {
            position.set("battery", buf.getUnsignedByte(buf.readerIndex()) >> 2);
            position.set("power", buf.readUnsignedShort() & 0x3FF);
            position.set("deviceTemp", buf.readByte());
            position.set("rssi", buf.getUnsignedByte(buf.readerIndex()) >> 5);
            int satellites = buf.readUnsignedByte() & 0x1F;
            position.setValid(satellites >= 3);
            position.set("sat", satellites);
        }
        return position;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        FullHttpRequest request = (FullHttpRequest)msg;
        ByteBuf buf = request.content();
        buf.skipBytes("id=".length());
        int index = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)38);
        String uniqueId = buf.toString(buf.readerIndex(), index - buf.readerIndex(), StandardCharsets.US_ASCII);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, uniqueId);
        if (deviceSession == null) {
            return null;
        }
        buf.skipBytes(uniqueId.length());
        buf.skipBytes("&bin=".length());
        short packetId = buf.readUnsignedByte();
        short offset = buf.readUnsignedByte();
        short packetCount = buf.readUnsignedByte();
        buf.readUnsignedByte();
        buf.readUnsignedByte();
        buf.skipBytes(offset - 5);
        if (channel != null) {
            this.sendContinue(channel);
            this.sendResponse(channel, packetId, packetCount);
        }
        if (packetId == 49 || packetId == 50 || packetId == 54) {
            if (this.simple) {
                return this.parseFormatA1(deviceSession, buf);
            }
            return this.parseFormatA(deviceSession, buf);
        }
        return null;
    }

    private static class FloatReader {
        private int previousFloat;

        private FloatReader() {
        }

        public float readFloat(ByteBuf buf) {
            switch (buf.getUnsignedByte(buf.readerIndex()) >> 6) {
                case 0: {
                    this.previousFloat = buf.readInt() << 2;
                    break;
                }
                case 1: {
                    this.previousFloat = (this.previousFloat & 0xFFFFFF00) + ((buf.readUnsignedByte() & 0x3F) << 2);
                    break;
                }
                case 2: {
                    this.previousFloat = (this.previousFloat & 0xFFFF0000) + ((buf.readUnsignedShort() & 0x3FFF) << 2);
                    break;
                }
                case 3: {
                    this.previousFloat = (this.previousFloat & 0xFF000000) + ((buf.readUnsignedMedium() & 0x3FFFFF) << 2);
                    break;
                }
                default: {
                    LOGGER.warn("MTA6 float decoding error", (Throwable)new IllegalArgumentException());
                }
            }
            return Float.intBitsToFloat(this.previousFloat);
        }
    }

    private static class TimeReader
    extends FloatReader {
        private long weekNumber;

        private TimeReader() {
        }

        public Date readTime(ByteBuf buf) {
            long weekTime = (long)(this.readFloat(buf) * 1000.0f);
            if (this.weekNumber == 0L) {
                this.weekNumber = buf.readUnsignedShort();
            }
            DateBuilder dateBuilder = new DateBuilder().setDate(1980, 1, 6);
            dateBuilder.addMillis(this.weekNumber * 7L * 24L * 60L * 60L * 1000L + weekTime);
            return dateBuilder.getDate();
        }
    }
}

