/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Color;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.zaproxy.zap.extension.search.SearchMatch;
import org.zaproxy.zap.view.HighlightSearchEntry;

public class HighlighterManager {
    static HighlighterManager hilighterManager = null;
    private LinkedList<HighlightSearchEntry> highlights = new LinkedList();
    private List<SoftReference<HighlighterManagerListener>> eventListeners = Collections.synchronizedList(new ArrayList());

    public static HighlighterManager getInstance() {
        if (hilighterManager == null) {
            hilighterManager = new HighlighterManager();
        }
        return hilighterManager;
    }

    public void reinitHighlights(LinkedList<HighlightSearchEntry> list) {
        this.highlights = (LinkedList)list.clone();
        this.fireHighlighterChanged(new HighlighterManagerEvent(this, HighlighterManagerEvent.Type.HIGHLIGHTS_SET));
    }

    public void addHighlightEntry(String token, SearchMatch.Location type, boolean isActive) {
        HighlightSearchEntry entry = new HighlightSearchEntry(token, type, Color.red, isActive);
        this.addHighlightEntry(entry);
    }

    public void addHighlightEntry(HighlightSearchEntry entry) {
        this.highlights.add(entry);
        this.fireHighlighterChanged(new HighlighterManagerEvent(this, HighlighterManagerEvent.Type.HIGHLIGHT_ADDED, entry));
    }

    public void removeHighlightEntry(int id) {
        HighlightSearchEntry entry = this.highlights.remove(id);
        if (entry != null) {
            this.fireHighlighterChanged(new HighlighterManagerEvent(this, HighlighterManagerEvent.Type.HIGHLIGHT_REMOVED, entry));
        }
    }

    public LinkedList<HighlightSearchEntry> getHighlights() {
        return (LinkedList)this.highlights.clone();
    }

    public void addHighlighterManagerListener(HighlighterManagerListener listener) {
        this.eventListeners.add(new SoftReference<HighlighterManagerListener>(listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHighlighterManagerListener(HighlighterManagerListener listener) {
        List<SoftReference<HighlighterManagerListener>> list = this.eventListeners;
        synchronized (list) {
            Iterator<SoftReference<HighlighterManagerListener>> it = this.eventListeners.iterator();
            while (it.hasNext()) {
                HighlighterManagerListener currentListener = it.next().get();
                if (currentListener == null) {
                    it.remove();
                    continue;
                }
                if (!listener.equals(currentListener)) continue;
                it.remove();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireHighlighterChanged(HighlighterManagerEvent e) {
        List<SoftReference<HighlighterManagerListener>> list = this.eventListeners;
        synchronized (list) {
            Iterator<SoftReference<HighlighterManagerListener>> it = this.eventListeners.iterator();
            while (it.hasNext()) {
                HighlighterManagerListener listener = it.next().get();
                if (listener == null) {
                    it.remove();
                    continue;
                }
                listener.highlighterChanged(e);
            }
        }
    }

    public static final class HighlighterManagerEvent
    extends EventObject {
        private static final long serialVersionUID = 1L;
        private Type type;
        private HighlightSearchEntry highlight;

        private HighlighterManagerEvent(HighlighterManager source, Type type) {
            this(source, type, (HighlightSearchEntry)null);
        }

        private HighlighterManagerEvent(HighlighterManager source, Type type, HighlightSearchEntry highlight) {
            super(source);
            this.type = type;
            this.highlight = highlight;
        }

        public Type getType() {
            return this.type;
        }

        public HighlightSearchEntry getHighlight() {
            return this.highlight;
        }

        public static enum Type {
            HIGHLIGHTS_SET,
            HIGHLIGHT_ADDED,
            HIGHLIGHT_REMOVED;

        }
    }

    @FunctionalInterface
    public static interface HighlighterManagerListener
    extends EventListener {
        public void highlighterChanged(HighlighterManagerEvent var1);
    }
}

