/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.json.connection;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleResourceNotFoundException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.auth.json.user.UserData;
import org.apache.guacamole.environment.Environment;
import org.apache.guacamole.io.GuacamoleReader;
import org.apache.guacamole.io.GuacamoleWriter;
import org.apache.guacamole.net.GuacamoleSocket;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.net.InetGuacamoleSocket;
import org.apache.guacamole.net.SSLGuacamoleSocket;
import org.apache.guacamole.net.SimpleGuacamoleTunnel;
import org.apache.guacamole.net.auth.GuacamoleProxyConfiguration;
import org.apache.guacamole.protocol.ConfiguredGuacamoleSocket;
import org.apache.guacamole.protocol.GuacamoleClientInformation;
import org.apache.guacamole.protocol.GuacamoleConfiguration;
import org.apache.guacamole.token.TokenFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ConnectionService {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionService.class);
    @Inject
    private Environment environment;
    private final ConcurrentHashMap<String, String> activeConnections = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Collection<GuacamoleTunnel>> shadowers = new ConcurrentHashMap();

    public GuacamoleConfiguration getConfiguration(UserData.Connection connection) {
        GuacamoleConfiguration config = new GuacamoleConfiguration();
        String primaryConnection = connection.getPrimaryConnection();
        if (primaryConnection != null) {
            String id = this.activeConnections.get(primaryConnection);
            if (id == null) {
                return null;
            }
            config.setConnectionID(id);
        } else {
            config.setProtocol(connection.getProtocol());
        }
        Map<String, String> parameters = connection.getParameters();
        if (parameters != null) {
            config.setParameters(parameters);
        }
        return config;
    }

    private void closeAll(Collection<GuacamoleTunnel> tunnels) {
        for (GuacamoleTunnel tunnel : tunnels) {
            try {
                tunnel.close();
            }
            catch (GuacamoleException e) {
                logger.debug("Failure to close tunnel masked by closeAll().", (Throwable)e);
            }
        }
    }

    public GuacamoleTunnel connect(UserData.Connection connection, GuacamoleClientInformation info, Map<String, String> tokens) throws GuacamoleException {
        SimpleGuacamoleTunnel tunnel;
        ConfiguredGuacamoleSocket socket;
        GuacamoleProxyConfiguration proxyConfig = this.environment.getDefaultGuacamoleProxyConfiguration();
        String hostname = proxyConfig.getHostname();
        int port = proxyConfig.getPort();
        GuacamoleConfiguration filteredConfig = this.getConfiguration(connection);
        if (filteredConfig == null) {
            logger.debug("Configuration for connection could not be generated. Perhaps the connection being joined is not active?");
            throw new GuacamoleResourceNotFoundException("No such connection");
        }
        new TokenFilter(tokens).filterValues(filteredConfig.getParameters());
        switch (proxyConfig.getEncryptionMethod()) {
            case SSL: {
                socket = new ConfiguredGuacamoleSocket((GuacamoleSocket)new SSLGuacamoleSocket(hostname, port), filteredConfig, info);
                break;
            }
            case NONE: {
                socket = new ConfiguredGuacamoleSocket((GuacamoleSocket)new InetGuacamoleSocket(hostname, port), filteredConfig, info);
                break;
            }
            default: {
                throw new GuacamoleServerException("Unimplemented encryption method.");
            }
        }
        final String id = connection.getId();
        if (id == null) {
            tunnel = new SimpleGuacamoleTunnel((GuacamoleSocket)socket);
        } else {
            final String connectionID = socket.getConnectionID();
            Collection existingTunnels = this.shadowers.putIfAbsent(connectionID, Collections.synchronizedList(new ArrayList()));
            assert (existingTunnels == null);
            String activeConnection = this.activeConnections.put(id, connectionID);
            if (activeConnection != null) {
                logger.warn("A connection with ID \"{}\" is already in progress, but another attempt to use this ID has been made. The original connection will no longer be joinable.", (Object)id);
            }
            tunnel = new SimpleGuacamoleTunnel(new GuacamoleSocket(){

                public GuacamoleReader getReader() {
                    return socket.getReader();
                }

                public GuacamoleWriter getWriter() {
                    return socket.getWriter();
                }

                public void close() throws GuacamoleException {
                    ConnectionService.this.activeConnections.remove(id, connectionID);
                    Collection tunnels = (Collection)ConnectionService.this.shadowers.remove(connectionID);
                    if (tunnels != null) {
                        ConnectionService.this.closeAll(tunnels);
                    }
                    socket.close();
                }

                public boolean isOpen() {
                    return socket.isOpen();
                }
            });
        }
        String joinedConnection = filteredConfig.getConnectionID();
        if (joinedConnection != null) {
            Collection<GuacamoleTunnel> tunnels = this.shadowers.get(joinedConnection);
            if (tunnels != null) {
                tunnels.add((GuacamoleTunnel)tunnel);
            }
            if (!this.shadowers.containsKey(joinedConnection)) {
                tunnel.close();
            }
        }
        return tunnel;
    }
}

