// ----------------------------------------------------------------------------
//
//     ***     AUTO GENERATED CODE    ***    Type: MMv1     ***
//
// ----------------------------------------------------------------------------
//
//     This file is automatically generated by Magic Modules and manual
//     changes will be clobbered when the file is regenerated.
//
//     Please read more about how to change this file in
//     .github/CONTRIBUTING.md.
//
// ----------------------------------------------------------------------------

package google

import (
	"fmt"
	"log"
	"reflect"
	"strings"
	"time"

	"github.com/hashicorp/terraform-plugin-sdk/v2/helper/schema"
)

func resourceCloudfunctions2function() *schema.Resource {
	return &schema.Resource{
		Create: resourceCloudfunctions2functionCreate,
		Read:   resourceCloudfunctions2functionRead,
		Update: resourceCloudfunctions2functionUpdate,
		Delete: resourceCloudfunctions2functionDelete,

		Importer: &schema.ResourceImporter{
			State: resourceCloudfunctions2functionImport,
		},

		Timeouts: &schema.ResourceTimeout{
			Create: schema.DefaultTimeout(60 * time.Minute),
			Update: schema.DefaultTimeout(60 * time.Minute),
			Delete: schema.DefaultTimeout(60 * time.Minute),
		},

		Schema: map[string]*schema.Schema{
			"name": {
				Type:     schema.TypeString,
				Required: true,
				ForceNew: true,
				Description: `A user-defined name of the function. Function names must
be unique globally and match pattern 'projects/*/locations/*/functions/*'.`,
			},
			"build_config": {
				Type:     schema.TypeList,
				Optional: true,
				Description: `Describes the Build step of the function that builds a container
from the given source.`,
				MaxItems: 1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"docker_repository": {
							Type:        schema.TypeString,
							Optional:    true,
							Description: `User managed repository created in Artifact Registry optionally with a customer managed encryption key.`,
						},
						"entry_point": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `The name of the function (as defined in source code) that will be executed.
Defaults to the resource name suffix, if not specified. For backward
compatibility, if function with given name is not found, then the system
will try to use function named "function". For Node.js this is name of a
function exported by the module specified in source_location.`,
						},
						"environment_variables": {
							Type:        schema.TypeMap,
							Computed:    true,
							Optional:    true,
							Description: `User-provided build-time environment variables for the function.`,
							Elem:        &schema.Schema{Type: schema.TypeString},
						},
						"runtime": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `The runtime in which to run the function. Required when deploying a new
function, optional when updating an existing function.`,
						},
						"source": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `The location of the function source code.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"repo_source": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `If provided, get the source from this location in a Cloud Source Repository.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"branch_name": {
													Type:         schema.TypeString,
													Optional:     true,
													Description:  `Regex matching branches to build.`,
													ExactlyOneOf: []string{},
												},
												"commit_sha": {
													Type:         schema.TypeString,
													Optional:     true,
													Description:  `Regex matching tags to build.`,
													ExactlyOneOf: []string{},
												},
												"dir": {
													Type:        schema.TypeString,
													Optional:    true,
													Description: `Directory, relative to the source root, in which to run the build.`,
												},
												"invert_regex": {
													Type:     schema.TypeBool,
													Optional: true,
													Description: `Only trigger a build if the revision regex does 
NOT match the revision regex.`,
												},
												"project_id": {
													Type:     schema.TypeString,
													Optional: true,
													ForceNew: true,
													Description: `ID of the project that owns the Cloud Source Repository. If omitted, the 
project ID requesting the build is assumed.`,
												},
												"repo_name": {
													Type:        schema.TypeString,
													Optional:    true,
													Description: `Name of the Cloud Source Repository.`,
												},
												"tag_name": {
													Type:         schema.TypeString,
													Optional:     true,
													Description:  `Regex matching tags to build.`,
													ExactlyOneOf: []string{},
												},
											},
										},
										ExactlyOneOf: []string{},
									},
									"storage_source": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `If provided, get the source from this location in Google Cloud Storage.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"bucket": {
													Type:        schema.TypeString,
													Optional:    true,
													Description: `Google Cloud Storage bucket containing the source`,
												},
												"generation": {
													Type:     schema.TypeInt,
													Optional: true,
													Description: `Google Cloud Storage generation for the object. If the generation 
is omitted, the latest generation will be used.`,
												},
												"object": {
													Type:        schema.TypeString,
													Optional:    true,
													Description: `Google Cloud Storage object containing the source.`,
												},
											},
										},
										ExactlyOneOf: []string{},
									},
								},
							},
						},
						"worker_pool": {
							Type:        schema.TypeString,
							Optional:    true,
							Description: `Name of the Cloud Build Custom Worker Pool that should be used to build the function.`,
						},
						"build": {
							Type:     schema.TypeString,
							Computed: true,
							Description: `The Cloud Build name of the latest successful
deployment of the function.`,
						},
					},
				},
			},
			"description": {
				Type:        schema.TypeString,
				Optional:    true,
				Description: `User-provided description of a function.`,
			},
			"event_trigger": {
				Type:     schema.TypeList,
				Optional: true,
				Description: `An Eventarc trigger managed by Google Cloud Functions that fires events in
response to a condition in another service.`,
				MaxItems: 1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"event_filters": {
							Type:        schema.TypeSet,
							Optional:    true,
							Description: `Criteria used to filter events.`,
							Elem:        cloudfunctions2functionEventTriggerEventFiltersSchema(),
							// Default schema.HashSchema is used.
						},
						"event_type": {
							Type:        schema.TypeString,
							Optional:    true,
							Description: `Required. The type of event to observe.`,
						},
						"pubsub_topic": {
							Type:     schema.TypeString,
							Computed: true,
							Optional: true,
							Description: `The name of a Pub/Sub topic in the same project that will be used
as the transport topic for the event delivery.`,
						},
						"retry_policy": {
							Type:         schema.TypeString,
							Optional:     true,
							ValidateFunc: validateEnum([]string{"RETRY_POLICY_UNSPECIFIED", "RETRY_POLICY_DO_NOT_RETRY", "RETRY_POLICY_RETRY", ""}),
							Description: `Describes the retry policy in case of function's execution failure.
Retried execution is charged as any other execution. Possible values: ["RETRY_POLICY_UNSPECIFIED", "RETRY_POLICY_DO_NOT_RETRY", "RETRY_POLICY_RETRY"]`,
						},
						"service_account_email": {
							Type:        schema.TypeString,
							Computed:    true,
							Optional:    true,
							Description: `The email of the service account for this function.`,
						},
						"trigger_region": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `The region that the trigger will be in. The trigger will only receive
events originating in this region. It can be the same
region as the function, a different region or multi-region, or the global
region. If not provided, defaults to the same region as the function.`,
						},
						"trigger": {
							Type:        schema.TypeString,
							Computed:    true,
							Description: `The resource name of the Eventarc trigger.`,
						},
					},
				},
			},
			"labels": {
				Type:        schema.TypeMap,
				Optional:    true,
				Description: `A set of key/value label pairs associated with this Cloud Function.`,
				Elem:        &schema.Schema{Type: schema.TypeString},
			},
			"location": {
				Type:        schema.TypeString,
				Optional:    true,
				ForceNew:    true,
				Description: `The location of this cloud function.`,
			},
			"service_config": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `Describes the Service being deployed.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"all_traffic_on_latest_revision": {
							Type:        schema.TypeBool,
							Optional:    true,
							Description: `Whether 100% of traffic is routed to the latest revision. Defaults to true.`,
							Default:     true,
						},
						"available_memory": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `The amount of memory available for a function.
Defaults to 256M. Supported units are k, M, G, Mi, Gi. If no unit is
supplied the value is interpreted as bytes.`,
						},
						"environment_variables": {
							Type:        schema.TypeMap,
							Optional:    true,
							Description: `Environment variables that shall be available during function execution.`,
							Elem:        &schema.Schema{Type: schema.TypeString},
						},
						"ingress_settings": {
							Type:         schema.TypeString,
							Optional:     true,
							ValidateFunc: validateEnum([]string{"ALLOW_ALL", "ALLOW_INTERNAL_ONLY", "ALLOW_INTERNAL_AND_GCLB", ""}),
							Description:  `Available ingress settings. Defaults to "ALLOW_ALL" if unspecified. Default value: "ALLOW_ALL" Possible values: ["ALLOW_ALL", "ALLOW_INTERNAL_ONLY", "ALLOW_INTERNAL_AND_GCLB"]`,
							Default:      "ALLOW_ALL",
						},
						"max_instance_count": {
							Type:     schema.TypeInt,
							Optional: true,
							Description: `The limit on the maximum number of function instances that may coexist at a
given time.`,
						},
						"min_instance_count": {
							Type:     schema.TypeInt,
							Optional: true,
							Description: `The limit on the minimum number of function instances that may coexist at a
given time.`,
						},
						"secret_environment_variables": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `Secret environment variables configuration.`,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"key": {
										Type:        schema.TypeString,
										Required:    true,
										Description: `Name of the environment variable.`,
									},
									"project_id": {
										Type:        schema.TypeString,
										Required:    true,
										Description: `Project identifier (preferrably project number but can also be the project ID) of the project that contains the secret. If not set, it will be populated with the function's project assuming that the secret exists in the same project as of the function.`,
									},
									"secret": {
										Type:        schema.TypeString,
										Required:    true,
										Description: `Name of the secret in secret manager (not the full resource name).`,
									},
									"version": {
										Type:        schema.TypeString,
										Required:    true,
										Description: `Version of the secret (version number or the string 'latest'). It is recommended to use a numeric version for secret environment variables as any updates to the secret value is not reflected until new instances start.`,
									},
								},
							},
						},
						"secret_volumes": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `Secret volumes configuration.`,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"mount_path": {
										Type:        schema.TypeString,
										Required:    true,
										Description: `The path within the container to mount the secret volume. For example, setting the mountPath as /etc/secrets would mount the secret value files under the /etc/secrets directory. This directory will also be completely shadowed and unavailable to mount any other secrets. Recommended mount path: /etc/secrets`,
									},
									"project_id": {
										Type:        schema.TypeString,
										Required:    true,
										Description: `Project identifier (preferrably project number but can also be the project ID) of the project that contains the secret. If not set, it will be populated with the function's project assuming that the secret exists in the same project as of the function.`,
									},
									"secret": {
										Type:        schema.TypeString,
										Required:    true,
										Description: `Name of the secret in secret manager (not the full resource name).`,
									},
									"versions": {
										Type:        schema.TypeList,
										Computed:    true,
										Optional:    true,
										Description: `List of secret versions to mount for this secret. If empty, the latest version of the secret will be made available in a file named after the secret under the mount point.'`,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"path": {
													Type:        schema.TypeString,
													Required:    true,
													Description: `Relative path of the file under the mount path where the secret value for this version will be fetched and made available. For example, setting the mountPath as '/etc/secrets' and path as secret_foo would mount the secret value file at /etc/secrets/secret_foo.`,
												},
												"version": {
													Type:        schema.TypeString,
													Required:    true,
													Description: `Version of the secret (version number or the string 'latest'). It is preferable to use latest version with secret volumes as secret value changes are reflected immediately.`,
												},
											},
										},
									},
								},
							},
						},
						"service": {
							Type:        schema.TypeString,
							Computed:    true,
							Optional:    true,
							Description: `Name of the service associated with a Function.`,
						},
						"service_account_email": {
							Type:        schema.TypeString,
							Computed:    true,
							Optional:    true,
							Description: `The email of the service account for this function.`,
						},
						"timeout_seconds": {
							Type:     schema.TypeInt,
							Optional: true,
							Description: `The function execution timeout. Execution is considered failed and
can be terminated if the function is not completed at the end of the
timeout period. Defaults to 60 seconds.`,
						},
						"vpc_connector": {
							Type:        schema.TypeString,
							Optional:    true,
							Description: `The Serverless VPC Access connector that this cloud function can connect to.`,
						},
						"vpc_connector_egress_settings": {
							Type:         schema.TypeString,
							Optional:     true,
							ValidateFunc: validateEnum([]string{"VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED", "PRIVATE_RANGES_ONLY", "ALL_TRAFFIC", ""}),
							Description:  `Available egress settings. Possible values: ["VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED", "PRIVATE_RANGES_ONLY", "ALL_TRAFFIC"]`,
						},
						"gcf_uri": {
							Type:        schema.TypeString,
							Computed:    true,
							Description: `URIs of the Service deployed`,
						},
						"uri": {
							Type:        schema.TypeString,
							Computed:    true,
							Description: `URI of the Service deployed.`,
						},
					},
				},
			},
			"environment": {
				Type:        schema.TypeString,
				Computed:    true,
				Description: `The environment the function is hosted on.`,
			},
			"state": {
				Type:        schema.TypeString,
				Computed:    true,
				Description: `Describes the current state of the function.`,
			},
			"update_time": {
				Type:        schema.TypeString,
				Computed:    true,
				Description: `The last update timestamp of a Cloud Function.`,
			},
			"project": {
				Type:     schema.TypeString,
				Optional: true,
				Computed: true,
				ForceNew: true,
			},
		},
		UseJSONNumber: true,
	}
}

func cloudfunctions2functionEventTriggerEventFiltersSchema() *schema.Resource {
	return &schema.Resource{
		Schema: map[string]*schema.Schema{
			"attribute": {
				Type:     schema.TypeString,
				Required: true,
				Description: `'Required. The name of a CloudEvents attribute.
Currently, only a subset of attributes are supported for filtering. Use the 'gcloud eventarc providers describe' command to learn more about events and their attributes.
Do not filter for the 'type' attribute here, as this is already achieved by the resource's 'event_type' attribute.`,
			},
			"value": {
				Type:     schema.TypeString,
				Required: true,
				Description: `Required. The value for the attribute.
If the operator field is set as 'match-path-pattern', this value can be a path pattern instead of an exact value.`,
			},
			"operator": {
				Type:     schema.TypeString,
				Optional: true,
				Description: `Optional. The operator used for matching the events with the value of
the filter. If not specified, only events that have an exact key-value
pair specified in the filter are matched.
The only allowed value is 'match-path-pattern'.
[See documentation on path patterns here](https://cloud.google.com/eventarc/docs/path-patterns)'`,
			},
		},
	}
}

func resourceCloudfunctions2functionCreate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	obj := make(map[string]interface{})
	nameProp, err := expandCloudfunctions2functionName(d.Get("name"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("name"); !isEmptyValue(reflect.ValueOf(nameProp)) && (ok || !reflect.DeepEqual(v, nameProp)) {
		obj["name"] = nameProp
	}
	descriptionProp, err := expandCloudfunctions2functionDescription(d.Get("description"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("description"); !isEmptyValue(reflect.ValueOf(descriptionProp)) && (ok || !reflect.DeepEqual(v, descriptionProp)) {
		obj["description"] = descriptionProp
	}
	buildConfigProp, err := expandCloudfunctions2functionBuildConfig(d.Get("build_config"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("build_config"); !isEmptyValue(reflect.ValueOf(buildConfigProp)) && (ok || !reflect.DeepEqual(v, buildConfigProp)) {
		obj["buildConfig"] = buildConfigProp
	}
	serviceConfigProp, err := expandCloudfunctions2functionServiceConfig(d.Get("service_config"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("service_config"); !isEmptyValue(reflect.ValueOf(serviceConfigProp)) && (ok || !reflect.DeepEqual(v, serviceConfigProp)) {
		obj["serviceConfig"] = serviceConfigProp
	}
	eventTriggerProp, err := expandCloudfunctions2functionEventTrigger(d.Get("event_trigger"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("event_trigger"); !isEmptyValue(reflect.ValueOf(eventTriggerProp)) && (ok || !reflect.DeepEqual(v, eventTriggerProp)) {
		obj["eventTrigger"] = eventTriggerProp
	}
	labelsProp, err := expandCloudfunctions2functionLabels(d.Get("labels"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("labels"); !isEmptyValue(reflect.ValueOf(labelsProp)) && (ok || !reflect.DeepEqual(v, labelsProp)) {
		obj["labels"] = labelsProp
	}

	url, err := replaceVars(d, config, "{{Cloudfunctions2BasePath}}projects/{{project}}/locations/{{location}}/functions?functionId={{name}}")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Creating new function: %#v", obj)
	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for function: %s", err)
	}
	billingProject = project

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "POST", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutCreate))
	if err != nil {
		return fmt.Errorf("Error creating function: %s", err)
	}

	// Store the ID now
	id, err := replaceVars(d, config, "projects/{{project}}/locations/{{location}}/functions/{{name}}")
	if err != nil {
		return fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	// Use the resource in the operation response to populate
	// identity fields and d.Id() before read
	var opRes map[string]interface{}
	err = cloudfunctions2OperationWaitTimeWithResponse(
		config, res, &opRes, project, "Creating function", userAgent,
		d.Timeout(schema.TimeoutCreate))
	if err != nil {
		// The resource didn't actually create
		d.SetId("")
		return fmt.Errorf("Error waiting to create function: %s", err)
	}

	if err := d.Set("name", flattenCloudfunctions2functionName(opRes["name"], d, config)); err != nil {
		return err
	}

	// This may have caused the ID to update - update it if so.
	id, err = replaceVars(d, config, "projects/{{project}}/locations/{{location}}/functions/{{name}}")
	if err != nil {
		return fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	log.Printf("[DEBUG] Finished creating function %q: %#v", d.Id(), res)

	return resourceCloudfunctions2functionRead(d, meta)
}

func resourceCloudfunctions2functionRead(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	url, err := replaceVars(d, config, "{{Cloudfunctions2BasePath}}projects/{{project}}/locations/{{location}}/functions/{{name}}")
	if err != nil {
		return err
	}

	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for function: %s", err)
	}
	billingProject = project

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequest(config, "GET", billingProject, url, userAgent, nil)
	if err != nil {
		return handleNotFoundError(err, d, fmt.Sprintf("Cloudfunctions2function %q", d.Id()))
	}

	if err := d.Set("project", project); err != nil {
		return fmt.Errorf("Error reading function: %s", err)
	}

	if err := d.Set("name", flattenCloudfunctions2functionName(res["name"], d, config)); err != nil {
		return fmt.Errorf("Error reading function: %s", err)
	}
	if err := d.Set("description", flattenCloudfunctions2functionDescription(res["description"], d, config)); err != nil {
		return fmt.Errorf("Error reading function: %s", err)
	}
	if err := d.Set("environment", flattenCloudfunctions2functionEnvironment(res["environment"], d, config)); err != nil {
		return fmt.Errorf("Error reading function: %s", err)
	}
	if err := d.Set("state", flattenCloudfunctions2functionState(res["state"], d, config)); err != nil {
		return fmt.Errorf("Error reading function: %s", err)
	}
	if err := d.Set("build_config", flattenCloudfunctions2functionBuildConfig(res["buildConfig"], d, config)); err != nil {
		return fmt.Errorf("Error reading function: %s", err)
	}
	if err := d.Set("service_config", flattenCloudfunctions2functionServiceConfig(res["serviceConfig"], d, config)); err != nil {
		return fmt.Errorf("Error reading function: %s", err)
	}
	if err := d.Set("event_trigger", flattenCloudfunctions2functionEventTrigger(res["eventTrigger"], d, config)); err != nil {
		return fmt.Errorf("Error reading function: %s", err)
	}
	if err := d.Set("update_time", flattenCloudfunctions2functionUpdateTime(res["updateTime"], d, config)); err != nil {
		return fmt.Errorf("Error reading function: %s", err)
	}
	if err := d.Set("labels", flattenCloudfunctions2functionLabels(res["labels"], d, config)); err != nil {
		return fmt.Errorf("Error reading function: %s", err)
	}

	return nil
}

func resourceCloudfunctions2functionUpdate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for function: %s", err)
	}
	billingProject = project

	obj := make(map[string]interface{})
	descriptionProp, err := expandCloudfunctions2functionDescription(d.Get("description"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("description"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, descriptionProp)) {
		obj["description"] = descriptionProp
	}
	buildConfigProp, err := expandCloudfunctions2functionBuildConfig(d.Get("build_config"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("build_config"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, buildConfigProp)) {
		obj["buildConfig"] = buildConfigProp
	}
	serviceConfigProp, err := expandCloudfunctions2functionServiceConfig(d.Get("service_config"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("service_config"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, serviceConfigProp)) {
		obj["serviceConfig"] = serviceConfigProp
	}
	eventTriggerProp, err := expandCloudfunctions2functionEventTrigger(d.Get("event_trigger"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("event_trigger"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, eventTriggerProp)) {
		obj["eventTrigger"] = eventTriggerProp
	}
	labelsProp, err := expandCloudfunctions2functionLabels(d.Get("labels"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("labels"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, labelsProp)) {
		obj["labels"] = labelsProp
	}

	url, err := replaceVars(d, config, "{{Cloudfunctions2BasePath}}projects/{{project}}/locations/{{location}}/functions/{{name}}")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Updating function %q: %#v", d.Id(), obj)
	updateMask := []string{}

	if d.HasChange("description") {
		updateMask = append(updateMask, "description")
	}

	if d.HasChange("build_config") {
		updateMask = append(updateMask, "buildConfig")
	}

	if d.HasChange("service_config") {
		updateMask = append(updateMask, "serviceConfig")
	}

	if d.HasChange("event_trigger") {
		updateMask = append(updateMask, "eventTrigger")
	}

	if d.HasChange("labels") {
		updateMask = append(updateMask, "labels")
	}
	// updateMask is a URL parameter but not present in the schema, so replaceVars
	// won't set it
	url, err = addQueryParams(url, map[string]string{"updateMask": strings.Join(updateMask, ",")})
	if err != nil {
		return err
	}

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "PATCH", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutUpdate))

	if err != nil {
		return fmt.Errorf("Error updating function %q: %s", d.Id(), err)
	} else {
		log.Printf("[DEBUG] Finished updating function %q: %#v", d.Id(), res)
	}

	err = cloudfunctions2OperationWaitTime(
		config, res, project, "Updating function", userAgent,
		d.Timeout(schema.TimeoutUpdate))

	if err != nil {
		return err
	}

	return resourceCloudfunctions2functionRead(d, meta)
}

func resourceCloudfunctions2functionDelete(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for function: %s", err)
	}
	billingProject = project

	url, err := replaceVars(d, config, "{{Cloudfunctions2BasePath}}projects/{{project}}/locations/{{location}}/functions/{{name}}")
	if err != nil {
		return err
	}

	var obj map[string]interface{}
	log.Printf("[DEBUG] Deleting function %q", d.Id())

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "DELETE", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutDelete))
	if err != nil {
		return handleNotFoundError(err, d, "function")
	}

	err = cloudfunctions2OperationWaitTime(
		config, res, project, "Deleting function", userAgent,
		d.Timeout(schema.TimeoutDelete))

	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Finished deleting function %q: %#v", d.Id(), res)
	return nil
}

func resourceCloudfunctions2functionImport(d *schema.ResourceData, meta interface{}) ([]*schema.ResourceData, error) {
	config := meta.(*Config)
	if err := parseImportId([]string{
		"projects/(?P<project>[^/]+)/locations/(?P<location>[^/]+)/functions/(?P<name>[^/]+)",
		"(?P<project>[^/]+)/(?P<location>[^/]+)/(?P<name>[^/]+)",
		"(?P<location>[^/]+)/(?P<name>[^/]+)",
	}, d, config); err != nil {
		return nil, err
	}

	// Replace import id for the resource id
	id, err := replaceVars(d, config, "projects/{{project}}/locations/{{location}}/functions/{{name}}")
	if err != nil {
		return nil, fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	return []*schema.ResourceData{d}, nil
}

func flattenCloudfunctions2functionName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	return NameFromSelfLinkStateFunc(v)
}

func flattenCloudfunctions2functionDescription(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionEnvironment(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionState(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionBuildConfig(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["build"] =
		flattenCloudfunctions2functionBuildConfigBuild(original["build"], d, config)
	transformed["runtime"] =
		flattenCloudfunctions2functionBuildConfigRuntime(original["runtime"], d, config)
	transformed["entry_point"] =
		flattenCloudfunctions2functionBuildConfigEntryPoint(original["entryPoint"], d, config)
	transformed["source"] =
		flattenCloudfunctions2functionBuildConfigSource(original["source"], d, config)
	transformed["worker_pool"] =
		flattenCloudfunctions2functionBuildConfigWorkerPool(original["workerPool"], d, config)
	transformed["environment_variables"] =
		flattenCloudfunctions2functionBuildConfigEnvironmentVariables(original["environmentVariables"], d, config)
	transformed["docker_repository"] =
		flattenCloudfunctions2functionBuildConfigDockerRepository(original["dockerRepository"], d, config)
	return []interface{}{transformed}
}
func flattenCloudfunctions2functionBuildConfigBuild(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionBuildConfigRuntime(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionBuildConfigEntryPoint(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionBuildConfigSource(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["storage_source"] =
		flattenCloudfunctions2functionBuildConfigSourceStorageSource(original["storageSource"], d, config)
	transformed["repo_source"] =
		flattenCloudfunctions2functionBuildConfigSourceRepoSource(original["repoSource"], d, config)
	return []interface{}{transformed}
}
func flattenCloudfunctions2functionBuildConfigSourceStorageSource(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["bucket"] =
		flattenCloudfunctions2functionBuildConfigSourceStorageSourceBucket(original["bucket"], d, config)
	transformed["object"] =
		flattenCloudfunctions2functionBuildConfigSourceStorageSourceObject(original["object"], d, config)
	transformed["generation"] =
		flattenCloudfunctions2functionBuildConfigSourceStorageSourceGeneration(original["generation"], d, config)
	return []interface{}{transformed}
}

func flattenCloudfunctions2functionBuildConfigSourceStorageSourceBucket(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return d.Get("build_config.0.source.0.storage_source.0.bucket")
}

func flattenCloudfunctions2functionBuildConfigSourceStorageSourceObject(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return d.Get("build_config.0.source.0.storage_source.0.object")
}

func flattenCloudfunctions2functionBuildConfigSourceStorageSourceGeneration(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenCloudfunctions2functionBuildConfigSourceRepoSource(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["project_id"] =
		flattenCloudfunctions2functionBuildConfigSourceRepoSourceProjectId(original["projectId"], d, config)
	transformed["repo_name"] =
		flattenCloudfunctions2functionBuildConfigSourceRepoSourceRepoName(original["repoName"], d, config)
	transformed["branch_name"] =
		flattenCloudfunctions2functionBuildConfigSourceRepoSourceBranchName(original["branchName"], d, config)
	transformed["tag_name"] =
		flattenCloudfunctions2functionBuildConfigSourceRepoSourceTagName(original["tagName"], d, config)
	transformed["commit_sha"] =
		flattenCloudfunctions2functionBuildConfigSourceRepoSourceCommitSha(original["commitSha"], d, config)
	transformed["dir"] =
		flattenCloudfunctions2functionBuildConfigSourceRepoSourceDir(original["dir"], d, config)
	transformed["invert_regex"] =
		flattenCloudfunctions2functionBuildConfigSourceRepoSourceInvertRegex(original["invertRegex"], d, config)
	return []interface{}{transformed}
}
func flattenCloudfunctions2functionBuildConfigSourceRepoSourceProjectId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionBuildConfigSourceRepoSourceRepoName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionBuildConfigSourceRepoSourceBranchName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionBuildConfigSourceRepoSourceTagName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionBuildConfigSourceRepoSourceCommitSha(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionBuildConfigSourceRepoSourceDir(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionBuildConfigSourceRepoSourceInvertRegex(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionBuildConfigWorkerPool(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionBuildConfigEnvironmentVariables(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionBuildConfigDockerRepository(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionServiceConfig(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["service"] =
		flattenCloudfunctions2functionServiceConfigService(original["service"], d, config)
	transformed["timeout_seconds"] =
		flattenCloudfunctions2functionServiceConfigTimeoutSeconds(original["timeoutSeconds"], d, config)
	transformed["available_memory"] =
		flattenCloudfunctions2functionServiceConfigAvailableMemory(original["availableMemory"], d, config)
	transformed["environment_variables"] =
		flattenCloudfunctions2functionServiceConfigEnvironmentVariables(original["environmentVariables"], d, config)
	transformed["max_instance_count"] =
		flattenCloudfunctions2functionServiceConfigMaxInstanceCount(original["maxInstanceCount"], d, config)
	transformed["min_instance_count"] =
		flattenCloudfunctions2functionServiceConfigMinInstanceCount(original["minInstanceCount"], d, config)
	transformed["vpc_connector"] =
		flattenCloudfunctions2functionServiceConfigVPCConnector(original["vpcConnector"], d, config)
	transformed["vpc_connector_egress_settings"] =
		flattenCloudfunctions2functionServiceConfigVPCConnectorEgressSettings(original["vpcConnectorEgressSettings"], d, config)
	transformed["ingress_settings"] =
		flattenCloudfunctions2functionServiceConfigIngressSettings(original["ingressSettings"], d, config)
	transformed["uri"] =
		flattenCloudfunctions2functionServiceConfigUri(original["uri"], d, config)
	transformed["gcf_uri"] =
		flattenCloudfunctions2functionServiceConfigGcfUri(original["gcfUri"], d, config)
	transformed["service_account_email"] =
		flattenCloudfunctions2functionServiceConfigServiceAccountEmail(original["serviceAccountEmail"], d, config)
	transformed["all_traffic_on_latest_revision"] =
		flattenCloudfunctions2functionServiceConfigAllTrafficOnLatestRevision(original["allTrafficOnLatestRevision"], d, config)
	transformed["secret_environment_variables"] =
		flattenCloudfunctions2functionServiceConfigSecretEnvironmentVariables(original["secretEnvironmentVariables"], d, config)
	transformed["secret_volumes"] =
		flattenCloudfunctions2functionServiceConfigSecretVolumes(original["secretVolumes"], d, config)
	return []interface{}{transformed}
}
func flattenCloudfunctions2functionServiceConfigService(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionServiceConfigTimeoutSeconds(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenCloudfunctions2functionServiceConfigAvailableMemory(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionServiceConfigEnvironmentVariables(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionServiceConfigMaxInstanceCount(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenCloudfunctions2functionServiceConfigMinInstanceCount(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenCloudfunctions2functionServiceConfigVPCConnector(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionServiceConfigVPCConnectorEgressSettings(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionServiceConfigIngressSettings(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionServiceConfigUri(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionServiceConfigGcfUri(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionServiceConfigServiceAccountEmail(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionServiceConfigAllTrafficOnLatestRevision(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionServiceConfigSecretEnvironmentVariables(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"key":        flattenCloudfunctions2functionServiceConfigSecretEnvironmentVariablesKey(original["key"], d, config),
			"project_id": flattenCloudfunctions2functionServiceConfigSecretEnvironmentVariablesProjectId(original["projectId"], d, config),
			"secret":     flattenCloudfunctions2functionServiceConfigSecretEnvironmentVariablesSecret(original["secret"], d, config),
			"version":    flattenCloudfunctions2functionServiceConfigSecretEnvironmentVariablesVersion(original["version"], d, config),
		})
	}
	return transformed
}
func flattenCloudfunctions2functionServiceConfigSecretEnvironmentVariablesKey(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionServiceConfigSecretEnvironmentVariablesProjectId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionServiceConfigSecretEnvironmentVariablesSecret(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionServiceConfigSecretEnvironmentVariablesVersion(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionServiceConfigSecretVolumes(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"mount_path": flattenCloudfunctions2functionServiceConfigSecretVolumesMountPath(original["mountPath"], d, config),
			"project_id": flattenCloudfunctions2functionServiceConfigSecretVolumesProjectId(original["projectId"], d, config),
			"secret":     flattenCloudfunctions2functionServiceConfigSecretVolumesSecret(original["secret"], d, config),
			"versions":   flattenCloudfunctions2functionServiceConfigSecretVolumesVersions(original["versions"], d, config),
		})
	}
	return transformed
}
func flattenCloudfunctions2functionServiceConfigSecretVolumesMountPath(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionServiceConfigSecretVolumesProjectId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionServiceConfigSecretVolumesSecret(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionServiceConfigSecretVolumesVersions(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"version": flattenCloudfunctions2functionServiceConfigSecretVolumesVersionsVersion(original["version"], d, config),
			"path":    flattenCloudfunctions2functionServiceConfigSecretVolumesVersionsPath(original["path"], d, config),
		})
	}
	return transformed
}
func flattenCloudfunctions2functionServiceConfigSecretVolumesVersionsVersion(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionServiceConfigSecretVolumesVersionsPath(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionEventTrigger(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["trigger"] =
		flattenCloudfunctions2functionEventTriggerTrigger(original["trigger"], d, config)
	transformed["trigger_region"] =
		flattenCloudfunctions2functionEventTriggerTriggerRegion(original["triggerRegion"], d, config)
	transformed["event_type"] =
		flattenCloudfunctions2functionEventTriggerEventType(original["eventType"], d, config)
	transformed["event_filters"] =
		flattenCloudfunctions2functionEventTriggerEventFilters(original["eventFilters"], d, config)
	transformed["pubsub_topic"] =
		flattenCloudfunctions2functionEventTriggerPubsubTopic(original["pubsubTopic"], d, config)
	transformed["service_account_email"] =
		flattenCloudfunctions2functionEventTriggerServiceAccountEmail(original["serviceAccountEmail"], d, config)
	transformed["retry_policy"] =
		flattenCloudfunctions2functionEventTriggerRetryPolicy(original["retryPolicy"], d, config)
	return []interface{}{transformed}
}
func flattenCloudfunctions2functionEventTriggerTrigger(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionEventTriggerTriggerRegion(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionEventTriggerEventType(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionEventTriggerEventFilters(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := schema.NewSet(schema.HashResource(cloudfunctions2functionEventTriggerEventFiltersSchema()), []interface{}{})
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed.Add(map[string]interface{}{
			"attribute": flattenCloudfunctions2functionEventTriggerEventFiltersAttribute(original["attribute"], d, config),
			"value":     flattenCloudfunctions2functionEventTriggerEventFiltersValue(original["value"], d, config),
			"operator":  flattenCloudfunctions2functionEventTriggerEventFiltersOperator(original["operator"], d, config),
		})
	}
	return transformed
}
func flattenCloudfunctions2functionEventTriggerEventFiltersAttribute(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionEventTriggerEventFiltersValue(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionEventTriggerEventFiltersOperator(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionEventTriggerPubsubTopic(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionEventTriggerServiceAccountEmail(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionEventTriggerRetryPolicy(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionUpdateTime(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudfunctions2functionLabels(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func expandCloudfunctions2functionName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return replaceVars(d, config, "projects/{{project}}/locations/{{location}}/functions/{{name}}")
}

func expandCloudfunctions2functionDescription(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionBuildConfig(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedBuild, err := expandCloudfunctions2functionBuildConfigBuild(original["build"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedBuild); val.IsValid() && !isEmptyValue(val) {
		transformed["build"] = transformedBuild
	}

	transformedRuntime, err := expandCloudfunctions2functionBuildConfigRuntime(original["runtime"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedRuntime); val.IsValid() && !isEmptyValue(val) {
		transformed["runtime"] = transformedRuntime
	}

	transformedEntryPoint, err := expandCloudfunctions2functionBuildConfigEntryPoint(original["entry_point"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedEntryPoint); val.IsValid() && !isEmptyValue(val) {
		transformed["entryPoint"] = transformedEntryPoint
	}

	transformedSource, err := expandCloudfunctions2functionBuildConfigSource(original["source"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSource); val.IsValid() && !isEmptyValue(val) {
		transformed["source"] = transformedSource
	}

	transformedWorkerPool, err := expandCloudfunctions2functionBuildConfigWorkerPool(original["worker_pool"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedWorkerPool); val.IsValid() && !isEmptyValue(val) {
		transformed["workerPool"] = transformedWorkerPool
	}

	transformedEnvironmentVariables, err := expandCloudfunctions2functionBuildConfigEnvironmentVariables(original["environment_variables"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedEnvironmentVariables); val.IsValid() && !isEmptyValue(val) {
		transformed["environmentVariables"] = transformedEnvironmentVariables
	}

	transformedDockerRepository, err := expandCloudfunctions2functionBuildConfigDockerRepository(original["docker_repository"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDockerRepository); val.IsValid() && !isEmptyValue(val) {
		transformed["dockerRepository"] = transformedDockerRepository
	}

	return transformed, nil
}

func expandCloudfunctions2functionBuildConfigBuild(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionBuildConfigRuntime(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionBuildConfigEntryPoint(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionBuildConfigSource(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedStorageSource, err := expandCloudfunctions2functionBuildConfigSourceStorageSource(original["storage_source"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedStorageSource); val.IsValid() && !isEmptyValue(val) {
		transformed["storageSource"] = transformedStorageSource
	}

	transformedRepoSource, err := expandCloudfunctions2functionBuildConfigSourceRepoSource(original["repo_source"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedRepoSource); val.IsValid() && !isEmptyValue(val) {
		transformed["repoSource"] = transformedRepoSource
	}

	return transformed, nil
}

func expandCloudfunctions2functionBuildConfigSourceStorageSource(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedBucket, err := expandCloudfunctions2functionBuildConfigSourceStorageSourceBucket(original["bucket"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedBucket); val.IsValid() && !isEmptyValue(val) {
		transformed["bucket"] = transformedBucket
	}

	transformedObject, err := expandCloudfunctions2functionBuildConfigSourceStorageSourceObject(original["object"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedObject); val.IsValid() && !isEmptyValue(val) {
		transformed["object"] = transformedObject
	}

	transformedGeneration, err := expandCloudfunctions2functionBuildConfigSourceStorageSourceGeneration(original["generation"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedGeneration); val.IsValid() && !isEmptyValue(val) {
		transformed["generation"] = transformedGeneration
	}

	return transformed, nil
}

func expandCloudfunctions2functionBuildConfigSourceStorageSourceBucket(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionBuildConfigSourceStorageSourceObject(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionBuildConfigSourceStorageSourceGeneration(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionBuildConfigSourceRepoSource(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedProjectId, err := expandCloudfunctions2functionBuildConfigSourceRepoSourceProjectId(original["project_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedProjectId); val.IsValid() && !isEmptyValue(val) {
		transformed["projectId"] = transformedProjectId
	}

	transformedRepoName, err := expandCloudfunctions2functionBuildConfigSourceRepoSourceRepoName(original["repo_name"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedRepoName); val.IsValid() && !isEmptyValue(val) {
		transformed["repoName"] = transformedRepoName
	}

	transformedBranchName, err := expandCloudfunctions2functionBuildConfigSourceRepoSourceBranchName(original["branch_name"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedBranchName); val.IsValid() && !isEmptyValue(val) {
		transformed["branchName"] = transformedBranchName
	}

	transformedTagName, err := expandCloudfunctions2functionBuildConfigSourceRepoSourceTagName(original["tag_name"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTagName); val.IsValid() && !isEmptyValue(val) {
		transformed["tagName"] = transformedTagName
	}

	transformedCommitSha, err := expandCloudfunctions2functionBuildConfigSourceRepoSourceCommitSha(original["commit_sha"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedCommitSha); val.IsValid() && !isEmptyValue(val) {
		transformed["commitSha"] = transformedCommitSha
	}

	transformedDir, err := expandCloudfunctions2functionBuildConfigSourceRepoSourceDir(original["dir"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDir); val.IsValid() && !isEmptyValue(val) {
		transformed["dir"] = transformedDir
	}

	transformedInvertRegex, err := expandCloudfunctions2functionBuildConfigSourceRepoSourceInvertRegex(original["invert_regex"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedInvertRegex); val.IsValid() && !isEmptyValue(val) {
		transformed["invertRegex"] = transformedInvertRegex
	}

	return transformed, nil
}

func expandCloudfunctions2functionBuildConfigSourceRepoSourceProjectId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionBuildConfigSourceRepoSourceRepoName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionBuildConfigSourceRepoSourceBranchName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionBuildConfigSourceRepoSourceTagName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionBuildConfigSourceRepoSourceCommitSha(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionBuildConfigSourceRepoSourceDir(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionBuildConfigSourceRepoSourceInvertRegex(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionBuildConfigWorkerPool(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionBuildConfigEnvironmentVariables(v interface{}, d TerraformResourceData, config *Config) (map[string]string, error) {
	if v == nil {
		return map[string]string{}, nil
	}
	m := make(map[string]string)
	for k, val := range v.(map[string]interface{}) {
		m[k] = val.(string)
	}
	return m, nil
}

func expandCloudfunctions2functionBuildConfigDockerRepository(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionServiceConfig(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedService, err := expandCloudfunctions2functionServiceConfigService(original["service"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedService); val.IsValid() && !isEmptyValue(val) {
		transformed["service"] = transformedService
	}

	transformedTimeoutSeconds, err := expandCloudfunctions2functionServiceConfigTimeoutSeconds(original["timeout_seconds"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTimeoutSeconds); val.IsValid() && !isEmptyValue(val) {
		transformed["timeoutSeconds"] = transformedTimeoutSeconds
	}

	transformedAvailableMemory, err := expandCloudfunctions2functionServiceConfigAvailableMemory(original["available_memory"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAvailableMemory); val.IsValid() && !isEmptyValue(val) {
		transformed["availableMemory"] = transformedAvailableMemory
	}

	transformedEnvironmentVariables, err := expandCloudfunctions2functionServiceConfigEnvironmentVariables(original["environment_variables"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedEnvironmentVariables); val.IsValid() && !isEmptyValue(val) {
		transformed["environmentVariables"] = transformedEnvironmentVariables
	}

	transformedMaxInstanceCount, err := expandCloudfunctions2functionServiceConfigMaxInstanceCount(original["max_instance_count"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedMaxInstanceCount); val.IsValid() && !isEmptyValue(val) {
		transformed["maxInstanceCount"] = transformedMaxInstanceCount
	}

	transformedMinInstanceCount, err := expandCloudfunctions2functionServiceConfigMinInstanceCount(original["min_instance_count"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedMinInstanceCount); val.IsValid() && !isEmptyValue(val) {
		transformed["minInstanceCount"] = transformedMinInstanceCount
	}

	transformedVPCConnector, err := expandCloudfunctions2functionServiceConfigVPCConnector(original["vpc_connector"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedVPCConnector); val.IsValid() && !isEmptyValue(val) {
		transformed["vpcConnector"] = transformedVPCConnector
	}

	transformedVPCConnectorEgressSettings, err := expandCloudfunctions2functionServiceConfigVPCConnectorEgressSettings(original["vpc_connector_egress_settings"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedVPCConnectorEgressSettings); val.IsValid() && !isEmptyValue(val) {
		transformed["vpcConnectorEgressSettings"] = transformedVPCConnectorEgressSettings
	}

	transformedIngressSettings, err := expandCloudfunctions2functionServiceConfigIngressSettings(original["ingress_settings"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedIngressSettings); val.IsValid() && !isEmptyValue(val) {
		transformed["ingressSettings"] = transformedIngressSettings
	}

	transformedUri, err := expandCloudfunctions2functionServiceConfigUri(original["uri"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedUri); val.IsValid() && !isEmptyValue(val) {
		transformed["uri"] = transformedUri
	}

	transformedGcfUri, err := expandCloudfunctions2functionServiceConfigGcfUri(original["gcf_uri"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedGcfUri); val.IsValid() && !isEmptyValue(val) {
		transformed["gcfUri"] = transformedGcfUri
	}

	transformedServiceAccountEmail, err := expandCloudfunctions2functionServiceConfigServiceAccountEmail(original["service_account_email"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedServiceAccountEmail); val.IsValid() && !isEmptyValue(val) {
		transformed["serviceAccountEmail"] = transformedServiceAccountEmail
	}

	transformedAllTrafficOnLatestRevision, err := expandCloudfunctions2functionServiceConfigAllTrafficOnLatestRevision(original["all_traffic_on_latest_revision"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAllTrafficOnLatestRevision); val.IsValid() && !isEmptyValue(val) {
		transformed["allTrafficOnLatestRevision"] = transformedAllTrafficOnLatestRevision
	}

	transformedSecretEnvironmentVariables, err := expandCloudfunctions2functionServiceConfigSecretEnvironmentVariables(original["secret_environment_variables"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSecretEnvironmentVariables); val.IsValid() && !isEmptyValue(val) {
		transformed["secretEnvironmentVariables"] = transformedSecretEnvironmentVariables
	}

	transformedSecretVolumes, err := expandCloudfunctions2functionServiceConfigSecretVolumes(original["secret_volumes"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSecretVolumes); val.IsValid() && !isEmptyValue(val) {
		transformed["secretVolumes"] = transformedSecretVolumes
	}

	return transformed, nil
}

func expandCloudfunctions2functionServiceConfigService(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionServiceConfigTimeoutSeconds(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionServiceConfigAvailableMemory(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionServiceConfigEnvironmentVariables(v interface{}, d TerraformResourceData, config *Config) (map[string]string, error) {
	if v == nil {
		return map[string]string{}, nil
	}
	m := make(map[string]string)
	for k, val := range v.(map[string]interface{}) {
		m[k] = val.(string)
	}
	return m, nil
}

func expandCloudfunctions2functionServiceConfigMaxInstanceCount(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionServiceConfigMinInstanceCount(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionServiceConfigVPCConnector(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionServiceConfigVPCConnectorEgressSettings(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionServiceConfigIngressSettings(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionServiceConfigUri(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionServiceConfigGcfUri(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionServiceConfigServiceAccountEmail(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionServiceConfigAllTrafficOnLatestRevision(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionServiceConfigSecretEnvironmentVariables(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedKey, err := expandCloudfunctions2functionServiceConfigSecretEnvironmentVariablesKey(original["key"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedKey); val.IsValid() && !isEmptyValue(val) {
			transformed["key"] = transformedKey
		}

		transformedProjectId, err := expandCloudfunctions2functionServiceConfigSecretEnvironmentVariablesProjectId(original["project_id"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedProjectId); val.IsValid() && !isEmptyValue(val) {
			transformed["projectId"] = transformedProjectId
		}

		transformedSecret, err := expandCloudfunctions2functionServiceConfigSecretEnvironmentVariablesSecret(original["secret"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedSecret); val.IsValid() && !isEmptyValue(val) {
			transformed["secret"] = transformedSecret
		}

		transformedVersion, err := expandCloudfunctions2functionServiceConfigSecretEnvironmentVariablesVersion(original["version"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedVersion); val.IsValid() && !isEmptyValue(val) {
			transformed["version"] = transformedVersion
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandCloudfunctions2functionServiceConfigSecretEnvironmentVariablesKey(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionServiceConfigSecretEnvironmentVariablesProjectId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionServiceConfigSecretEnvironmentVariablesSecret(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionServiceConfigSecretEnvironmentVariablesVersion(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionServiceConfigSecretVolumes(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedMountPath, err := expandCloudfunctions2functionServiceConfigSecretVolumesMountPath(original["mount_path"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedMountPath); val.IsValid() && !isEmptyValue(val) {
			transformed["mountPath"] = transformedMountPath
		}

		transformedProjectId, err := expandCloudfunctions2functionServiceConfigSecretVolumesProjectId(original["project_id"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedProjectId); val.IsValid() && !isEmptyValue(val) {
			transformed["projectId"] = transformedProjectId
		}

		transformedSecret, err := expandCloudfunctions2functionServiceConfigSecretVolumesSecret(original["secret"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedSecret); val.IsValid() && !isEmptyValue(val) {
			transformed["secret"] = transformedSecret
		}

		transformedVersions, err := expandCloudfunctions2functionServiceConfigSecretVolumesVersions(original["versions"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedVersions); val.IsValid() && !isEmptyValue(val) {
			transformed["versions"] = transformedVersions
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandCloudfunctions2functionServiceConfigSecretVolumesMountPath(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionServiceConfigSecretVolumesProjectId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionServiceConfigSecretVolumesSecret(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionServiceConfigSecretVolumesVersions(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedVersion, err := expandCloudfunctions2functionServiceConfigSecretVolumesVersionsVersion(original["version"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedVersion); val.IsValid() && !isEmptyValue(val) {
			transformed["version"] = transformedVersion
		}

		transformedPath, err := expandCloudfunctions2functionServiceConfigSecretVolumesVersionsPath(original["path"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedPath); val.IsValid() && !isEmptyValue(val) {
			transformed["path"] = transformedPath
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandCloudfunctions2functionServiceConfigSecretVolumesVersionsVersion(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionServiceConfigSecretVolumesVersionsPath(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionEventTrigger(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedTrigger, err := expandCloudfunctions2functionEventTriggerTrigger(original["trigger"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTrigger); val.IsValid() && !isEmptyValue(val) {
		transformed["trigger"] = transformedTrigger
	}

	transformedTriggerRegion, err := expandCloudfunctions2functionEventTriggerTriggerRegion(original["trigger_region"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTriggerRegion); val.IsValid() && !isEmptyValue(val) {
		transformed["triggerRegion"] = transformedTriggerRegion
	}

	transformedEventType, err := expandCloudfunctions2functionEventTriggerEventType(original["event_type"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedEventType); val.IsValid() && !isEmptyValue(val) {
		transformed["eventType"] = transformedEventType
	}

	transformedEventFilters, err := expandCloudfunctions2functionEventTriggerEventFilters(original["event_filters"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedEventFilters); val.IsValid() && !isEmptyValue(val) {
		transformed["eventFilters"] = transformedEventFilters
	}

	transformedPubsubTopic, err := expandCloudfunctions2functionEventTriggerPubsubTopic(original["pubsub_topic"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPubsubTopic); val.IsValid() && !isEmptyValue(val) {
		transformed["pubsubTopic"] = transformedPubsubTopic
	}

	transformedServiceAccountEmail, err := expandCloudfunctions2functionEventTriggerServiceAccountEmail(original["service_account_email"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedServiceAccountEmail); val.IsValid() && !isEmptyValue(val) {
		transformed["serviceAccountEmail"] = transformedServiceAccountEmail
	}

	transformedRetryPolicy, err := expandCloudfunctions2functionEventTriggerRetryPolicy(original["retry_policy"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedRetryPolicy); val.IsValid() && !isEmptyValue(val) {
		transformed["retryPolicy"] = transformedRetryPolicy
	}

	return transformed, nil
}

func expandCloudfunctions2functionEventTriggerTrigger(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionEventTriggerTriggerRegion(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionEventTriggerEventType(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionEventTriggerEventFilters(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	v = v.(*schema.Set).List()
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedAttribute, err := expandCloudfunctions2functionEventTriggerEventFiltersAttribute(original["attribute"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedAttribute); val.IsValid() && !isEmptyValue(val) {
			transformed["attribute"] = transformedAttribute
		}

		transformedValue, err := expandCloudfunctions2functionEventTriggerEventFiltersValue(original["value"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedValue); val.IsValid() && !isEmptyValue(val) {
			transformed["value"] = transformedValue
		}

		transformedOperator, err := expandCloudfunctions2functionEventTriggerEventFiltersOperator(original["operator"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedOperator); val.IsValid() && !isEmptyValue(val) {
			transformed["operator"] = transformedOperator
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandCloudfunctions2functionEventTriggerEventFiltersAttribute(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionEventTriggerEventFiltersValue(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionEventTriggerEventFiltersOperator(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionEventTriggerPubsubTopic(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionEventTriggerServiceAccountEmail(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionEventTriggerRetryPolicy(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudfunctions2functionLabels(v interface{}, d TerraformResourceData, config *Config) (map[string]string, error) {
	if v == nil {
		return map[string]string{}, nil
	}
	m := make(map[string]string)
	for k, val := range v.(map[string]interface{}) {
		m[k] = val.(string)
	}
	return m, nil
}
