#-*- coding:utf-8 -*-


# VM Mngr Exceptions
EXCEPT_DO_NOT_UPDATE_PC = 1 << 25
EXCEPT_NUM_UPDT_EIP = (1<<11)

EXCEPT_CODE_AUTOMOD = (1 << 0)
EXCEPT_SOFT_BP = (1 << 1)
EXCEPT_INT_XX = (1 << 2)
EXCEPT_SPR_ACCESS = (1 << 3)
EXCEPT_SYSCALL = (1 << 4)
EXCEPT_BREAKPOINT_MEMORY = (1 << 10)
# Deprecated
EXCEPT_BREAKPOINT_INTERN = EXCEPT_BREAKPOINT_MEMORY

EXCEPT_ACCESS_VIOL = ((1 << 14) | EXCEPT_DO_NOT_UPDATE_PC)
EXCEPT_DIV_BY_ZERO = ((1 << 16) | EXCEPT_DO_NOT_UPDATE_PC)
EXCEPT_PRIV_INSN = ((1 << 17) | EXCEPT_DO_NOT_UPDATE_PC)
EXCEPT_ILLEGAL_INSN = ((1 << 18) | EXCEPT_DO_NOT_UPDATE_PC)
EXCEPT_UNK_MNEMO = ((1 << 19) | EXCEPT_DO_NOT_UPDATE_PC)
EXCEPT_INT_1 = ((1 << 20) | EXCEPT_DO_NOT_UPDATE_PC)

JitterExceptions = {
    "DO_NOT_UPDATE_PC": EXCEPT_DO_NOT_UPDATE_PC,
    "NUM_UPDT_EIP": EXCEPT_NUM_UPDT_EIP,
    "CODE_AUTOMOD": EXCEPT_CODE_AUTOMOD,
    "SOFT_BP": EXCEPT_SOFT_BP,
    "INT_XX": EXCEPT_INT_XX,
    "SPR_ACCESS": EXCEPT_SPR_ACCESS,
    "SYSCALL": EXCEPT_SYSCALL,
    "BREAKPOINT_MEMORY": EXCEPT_BREAKPOINT_MEMORY,
    "BREAKPOINT_INTERN": EXCEPT_BREAKPOINT_INTERN,
    "ACCESS_VIOL": EXCEPT_ACCESS_VIOL,
    "DIV_BY_ZERO": EXCEPT_DIV_BY_ZERO,
    "PRIV_INSN": EXCEPT_PRIV_INSN,
    "ILLEGAL_INSN": EXCEPT_ILLEGAL_INSN,
    "UNK_MNEMO": EXCEPT_UNK_MNEMO,
    "INT_1": EXCEPT_INT_1,
}

# VM Mngr constants

PAGE_READ = 1
PAGE_WRITE = 2
PAGE_EXEC = 4

BREAKPOINT_READ = 1
BREAKPOINT_WRITE = 2

