'''OpenGL extension EXT.draw_range_elements

This module customises the behaviour of the 
OpenGL.raw.GL.EXT.draw_range_elements to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/draw_range_elements.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.EXT.draw_range_elements import *
from OpenGL.raw.GL.EXT.draw_range_elements import _EXTENSION_NAME

def glInitDrawRangeElementsEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glDrawRangeElementsEXT.indices size not checked against 'count,type'
glDrawRangeElementsEXT=wrapper.wrapper(glDrawRangeElementsEXT).setInputArraySize(
    'indices', None
)
### END AUTOGENERATED SECTION

glDrawRangeElementsEXT = wrapper.wrapper( glDrawRangeElementsEXT ).setPyConverter(
    'indices', arrays.AsArrayOfType( 'indices', 'type' ),
).setReturnValues( 
    wrapper.returnPyArgument( 'indices' ) 
)