"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiHealth", {
  enumerable: true,
  get: function get() {
    return _health.EuiHealth;
  }
});
exports.OuiHealth = exports.TEXT_SIZES = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _common = require("../common");

var _icon = require("../icon");

var _flex = require("../flex");

var _health = require("../../eui_components/health/health");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var sizeToClassNameMap = {
  xs: 'ouiHealth--textSizeXS',
  s: 'ouiHealth--textSizeS',
  m: 'ouiHealth--textSizeM',
  inherit: 'ouiHealth--textSizeInherit'
};
var TEXT_SIZES = (0, _common.keysOf)(sizeToClassNameMap);
exports.TEXT_SIZES = TEXT_SIZES;

var OuiHealth = function OuiHealth(_ref) {
  var children = _ref.children,
      className = _ref.className,
      color = _ref.color,
      _ref$textSize = _ref.textSize,
      textSize = _ref$textSize === void 0 ? 's' : _ref$textSize,
      rest = _objectWithoutProperties(_ref, ["children", "className", "color", "textSize"]);

  var classes = (0, _classnames.default)('ouiHealth', textSize ? sizeToClassNameMap[textSize] : null, className);
  return /*#__PURE__*/_react.default.createElement("div", _extends({
    className: classes
  }, rest), /*#__PURE__*/_react.default.createElement(_flex.OuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_flex.OuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_icon.OuiIcon, {
    type: "dot",
    color: color
  })), /*#__PURE__*/_react.default.createElement(_flex.OuiFlexItem, {
    grow: false
  }, children)));
};
/* OUI -> EUI Aliases: Build-Time */


exports.OuiHealth = OuiHealth;
OuiHealth.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
       * Sets the color of the dot icon.
       * It accepts any `IconColor`: `default`, `primary`, `success`, `accent`, `warning`, `danger`, `text`,
       * `subdued` or `ghost`; or any valid CSS color value as a `string`
       * **`secondary` color is DEPRECATED, use `success` instead**
       */
  color: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.oneOf(["default", "primary", "secondary", "success", "accent", "warning", "danger", "text", "subdued", "ghost", "inherit"]).isRequired]),

  /**
       * Matches the text scales of OuiText.
       * The `inherit` style will get its font size from the parent element
       */
  textSize: _propTypes.default.any
};