/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.BaseDatabaseMeta;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.row.ValueMetaInterface;

public class SQLiteDatabaseMeta
extends BaseDatabaseMeta
implements DatabaseInterface {
    public SQLiteDatabaseMeta(String name, String access, String host, String db, String port, String user, String pass) {
        super(name, access, host, db, port, user, pass);
    }

    public SQLiteDatabaseMeta() {
    }

    public String getDatabaseTypeDesc() {
        return "SQLITE";
    }

    public String getDatabaseTypeDescLong() {
        return "SQLite";
    }

    public int getDatabaseType() {
        return 26;
    }

    public int[] getAccessTypeList() {
        return new int[]{0, 1, 4};
    }

    public int getNotFoundTK(boolean use_autoinc) {
        if (this.supportsAutoInc() && use_autoinc) {
            return 1;
        }
        return super.getNotFoundTK(use_autoinc);
    }

    public String getDriverClass() {
        if (this.getAccessType() == 0) {
            return "org.sqlite.JDBC";
        }
        return "sun.jdbc.odbc.JdbcOdbcDriver";
    }

    public String getURL(String hostname, String port, String databaseName) {
        if (this.getAccessType() == 0) {
            return "jdbc:sqlite:" + databaseName;
        }
        return "jdbc:odbc:" + databaseName;
    }

    public boolean isFetchSizeSupported() {
        return false;
    }

    public String getSchemaTableCombination(String schema_name, String table_part) {
        return "\"" + schema_name + "\".\"" + table_part + "\"";
    }

    public boolean supportsBitmapIndex() {
        return false;
    }

    public boolean supportsRepository() {
        return false;
    }

    public String getTruncateTableStatement(String tableName) {
        return "DELETE FROM " + tableName;
    }

    public String getAddColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ADD " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    public String getModifyColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " MODIFY " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (add_fieldname) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: {
                retval = retval + "DATETIME";
                break;
            }
            case 4: {
                retval = retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    retval = retval + "INTEGER PRIMARY KEY AUTOINCREMENT";
                    break;
                }
                if (precision != 0 || length < 0 || length > 18) {
                    retval = retval + "NUMERIC";
                    break;
                }
                retval = retval + "INTEGER";
                break;
            }
            case 2: {
                if (length >= 9999999) {
                    retval = retval + "BLOB";
                    break;
                }
                retval = retval + "TEXT";
                break;
            }
            case 8: {
                retval = retval + "BLOB";
                break;
            }
            default: {
                retval = retval + "UNKNOWN";
            }
        }
        if (add_cr) {
            retval = retval + Const.CR;
        }
        return retval;
    }

    public String[] getUsedLibraries() {
        return new String[]{"sqlitejdbc-v037-nested.jar"};
    }
}

