/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.solr.api.Command;
import org.apache.solr.api.EndPoint;
import org.apache.solr.api.PayloadObj;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.beans.AddReplicaPayload;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.handler.ClusterAPI;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.security.PermissionNameProvider;

@EndPoint(path={"/c/{collection}/shards", "/collections/{collection}/shards"}, method={SolrRequest.METHOD.POST}, permission=PermissionNameProvider.Name.COLL_EDIT_PERM)
public class AddReplicaAPI {
    private static final String V2_ADD_REPLICA_CMD = "add-replica";
    private final CollectionsHandler collectionsHandler;

    public AddReplicaAPI(CollectionsHandler collectionsHandler) {
        this.collectionsHandler = collectionsHandler;
    }

    @Command(name="add-replica")
    public void addReplica(PayloadObj<AddReplicaPayload> obj) throws Exception {
        AddReplicaPayload v2Body = obj.get();
        Map v1Params = v2Body.toMap(new HashMap());
        v1Params.put("action", CollectionParams.CollectionAction.ADDREPLICA.toLower());
        v1Params.put("collection", obj.getRequest().getPathTemplateValues().get("collection"));
        if (MapUtils.isNotEmpty((Map)v2Body.coreProperties)) {
            V2ApiUtils.flattenMapWithPrefix(v2Body.coreProperties, v1Params, "property.");
        }
        if (CollectionUtils.isNotEmpty((Collection)v2Body.createNodeSet)) {
            v1Params.replace("createNodeSet", String.join((CharSequence)",", v2Body.createNodeSet));
        }
        this.collectionsHandler.handleRequestBody(ClusterAPI.wrapParams(obj.getRequest(), v1Params), obj.getResponse());
    }
}

