/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.util.HashMap;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.PreAnalyzedField;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessorFactory;
import org.apache.solr.update.processor.PreAnalyzedUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;

public class PreAnalyzedUpdateProcessorFactory
extends FieldMutatingUpdateProcessorFactory {
    private PreAnalyzedField parser;
    private String parserImpl;

    @Override
    public void init(NamedList<?> args) {
        this.parserImpl = (String)args.get("parser");
        args.remove("parser");
        super.init(args);
    }

    @Override
    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        return new PreAnalyzedUpdateProcessor(this.getSelector(), next, req.getSchema(), this.parser);
    }

    @Override
    public void inform(SolrCore core) {
        super.inform(core);
        this.parser = new PreAnalyzedField();
        HashMap<String, String> args = new HashMap<String, String>();
        if (this.parserImpl != null) {
            args.put("parserImpl", this.parserImpl);
        }
        this.parser.init(core.getLatestSchema(), args);
    }
}

