/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.protocol.handler.ServerKeyExchangeHandler;
import de.rub.nds.tlsattacker.core.protocol.message.DHEServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.DHEServerKeyExchangeParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.DHEServerKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.DHEServerKeyExchangeSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DHEServerKeyExchangeHandler
extends ServerKeyExchangeHandler<DHEServerKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public DHEServerKeyExchangeHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public DHEServerKeyExchangeParser getParser(byte[] message, int pointer) {
        return new DHEServerKeyExchangeParser(pointer, message, this.tlsContext.getChooser().getLastRecordVersion(), AlgorithmResolver.getKeyExchangeAlgorithm(this.tlsContext.getChooser().getSelectedCipherSuite()), this.tlsContext.getConfig());
    }

    public DHEServerKeyExchangePreparator getPreparator(DHEServerKeyExchangeMessage message) {
        return new DHEServerKeyExchangePreparator<DHEServerKeyExchangeMessage>(this.tlsContext.getChooser(), message);
    }

    public DHEServerKeyExchangeSerializer getSerializer(DHEServerKeyExchangeMessage message) {
        return new DHEServerKeyExchangeSerializer<DHEServerKeyExchangeMessage>(message, this.tlsContext.getChooser().getSelectedProtocolVersion());
    }

    @Override
    public void adjustTLSContext(DHEServerKeyExchangeMessage message) {
        this.adjustDhGenerator(message);
        this.adjustDhModulus(message);
        this.adjustServerPublicKey(message);
        if (message.getComputations() != null && message.getComputations().getPrivateKey() != null) {
            this.adjustServerPrivateKey(message);
        }
    }

    private void adjustDhGenerator(DHEServerKeyExchangeMessage message) {
        this.tlsContext.setServerDhGenerator(new BigInteger(1, (byte[])message.getGenerator().getValue()));
        LOGGER.debug("Dh Generator: " + this.tlsContext.getServerDhGenerator());
    }

    private void adjustDhModulus(DHEServerKeyExchangeMessage message) {
        this.tlsContext.setServerDhModulus(new BigInteger(1, (byte[])message.getModulus().getValue()));
        LOGGER.debug("Dh Modulus: " + this.tlsContext.getServerDhModulus());
    }

    private void adjustServerPublicKey(DHEServerKeyExchangeMessage message) {
        this.tlsContext.setServerDhPublicKey(new BigInteger(1, (byte[])message.getPublicKey().getValue()));
        LOGGER.debug("Server PublicKey: " + this.tlsContext.getServerDhPublicKey());
    }

    private void adjustServerPrivateKey(DHEServerKeyExchangeMessage message) {
        this.tlsContext.setServerDhPrivateKey((BigInteger)message.getComputations().getPrivateKey().getValue());
        LOGGER.debug("Server PrivateKey: " + this.tlsContext.getServerDhPrivateKey());
    }
}

