/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.RenegotiationInfoExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.RenegotiationInfoExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.RenegotiationInfoExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.RenegotiationInfoExtensionSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RenegotiationInfoExtensionHandler
extends ExtensionHandler<RenegotiationInfoExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public RenegotiationInfoExtensionHandler(TlsContext context) {
        super(context);
    }

    @Override
    public RenegotiationInfoExtensionParser getParser(byte[] message, int pointer) {
        return new RenegotiationInfoExtensionParser(pointer, message);
    }

    public RenegotiationInfoExtensionPreparator getPreparator(RenegotiationInfoExtensionMessage message) {
        return new RenegotiationInfoExtensionPreparator(this.context.getChooser(), message, this.getSerializer(message));
    }

    public RenegotiationInfoExtensionSerializer getSerializer(RenegotiationInfoExtensionMessage message) {
        return new RenegotiationInfoExtensionSerializer(message);
    }

    @Override
    public void adjustTLSExtensionContext(RenegotiationInfoExtensionMessage message) {
        if ((Integer)message.getExtensionLength().getValue() > 65535) {
            LOGGER.warn("The RenegotiationInfo length shouldn't exceed 2 bytes as defined in RFC 5246. Length was " + message.getExtensionLength().getValue());
        }
        if (this.context.getTalkingConnectionEndType() != this.context.getChooser().getConnectionEndType()) {
            this.context.setRenegotiationInfo((byte[])message.getRenegotiationInfo().getValue());
            LOGGER.debug("The context RenegotiationInfo was set to " + ArrayConverter.bytesToHexString((ModifiableByteArray)message.getRenegotiationInfo()));
        }
        if (this.context.getTalkingConnectionEndType() == ConnectionEndType.SERVER && ((byte[])message.getRenegotiationInfo().getValue()).length == 1 && ((byte[])message.getRenegotiationInfo().getValue())[0] == 0) {
            this.context.setSecureRenegotiation(true);
        }
    }
}

