/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;

public class LiteralsExtractor {
    private static final int COMMAND_PREFIX_LENGTH = "jx:".length();

    public List<String> extract(String text) {
        ArrayList<String> literalList = new ArrayList<String>();
        String literal = "";
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            String[] lineElems = literal.split("\\n");
            String[] jxLineElem = lineElems.length == 0 ? new String[]{} : lineElems[lineElems.length - 1].split("jx:");
            if (literal.endsWith("jx:") && (jxLineElem.length <= 0 || !jxLineElem[0].contains("//"))) {
                literal = literal.substring(0, literal.length() - COMMAND_PREFIX_LENGTH);
                this.makeCommentLines(literal, literalList);
                String remainingText = text.substring(i - COMMAND_PREFIX_LENGTH, n);
                String cmd = this.makeOperators(remainingText);
                literal = "";
                literalList.add(cmd);
                if ((i += cmd.length() - COMMAND_PREFIX_LENGTH) != n) {
                    literal = String.valueOf(text.charAt(i));
                    continue;
                }
                literal = "";
                continue;
            }
            literal = literal + String.valueOf(text.charAt(i));
        }
        if (!literal.isEmpty()) {
            this.makeCommentLines(literal, literalList);
        }
        return literalList;
    }

    private void makeCommentLines(String literal, List<String> literalList) {
        literalList.addAll(Arrays.stream(literal.split("\n")).filter(line -> !line.replace("\r", "").trim().isEmpty()).collect(Collectors.toList()));
    }

    private String makeOperators(String text) {
        String cmd = "";
        Stack<Character> bracketsStack = new Stack<Character>();
        Stack<Character> quotationsStack = new Stack<Character>();
        for (int i = 0; i < text.length(); ++i) {
            char symbol = text.charAt(i);
            switch (symbol) {
                case '\"': 
                case '\'': {
                    if (!quotationsStack.empty() && ((Character)quotationsStack.peek()).charValue() == symbol) {
                        quotationsStack.pop();
                        break;
                    }
                    quotationsStack.push(Character.valueOf(symbol));
                    break;
                }
                case '(': {
                    if (!quotationsStack.empty()) break;
                    bracketsStack.push(Character.valueOf(symbol));
                    break;
                }
                case ')': {
                    if (!quotationsStack.empty()) break;
                    if (((Character)bracketsStack.peek()).charValue() == '(') {
                        bracketsStack.pop();
                        if (!bracketsStack.empty()) break;
                        return cmd + symbol;
                    }
                    String errorMessage = "Got closing ) but no opening of it. Pos: " + text.substring(0, i);
                    throw new IllegalArgumentException(errorMessage);
                }
            }
            cmd = cmd + symbol;
        }
        return cmd;
    }
}

