/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.forward;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.InvocationCallback;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.forward.PositionData;
import org.traccar.forward.PositionForwarder;
import org.traccar.forward.ResultHandler;
import org.traccar.helper.model.AttributeUtil;
import org.traccar.session.cache.CacheManager;

public class PositionForwarderJson
implements PositionForwarder {
    private final String header;
    private final Client client;
    private final ObjectMapper objectMapper;
    private final CacheManager cacheManager;

    public PositionForwarderJson(Config config, Client client, ObjectMapper objectMapper, CacheManager cacheManager) {
        this.client = client;
        this.objectMapper = objectMapper;
        this.cacheManager = cacheManager;
        this.header = config.getString(Keys.FORWARD_HEADER);
    }

    @Override
    public void forward(PositionData positionData, final ResultHandler resultHandler) {
        String url = AttributeUtil.lookup(this.cacheManager, Keys.FORWARD_URL, positionData.getDevice().getId());
        if (url.isBlank()) {
            resultHandler.onResult(true, null);
            return;
        }
        Invocation.Builder requestBuilder = this.client.target(url).request();
        MediaType mediaType = MediaType.APPLICATION_JSON_TYPE;
        if (this.header != null && !this.header.isEmpty()) {
            for (String line : this.header.split("\\r?\\n")) {
                String[] values = line.split(":", 2);
                String headerName = values[0].trim();
                String headerValue = values[1].trim();
                if (headerName.equals("Content-Type")) {
                    mediaType = MediaType.valueOf((String)headerValue);
                    continue;
                }
                requestBuilder.header(headerName, (Object)headerValue);
            }
        }
        try {
            Entity entity = Entity.entity((Object)this.objectMapper.writeValueAsString((Object)positionData), (MediaType)mediaType);
            requestBuilder.async().post(entity, (InvocationCallback)new InvocationCallback<Response>(){

                public void completed(Response response) {
                    if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                        resultHandler.onResult(true, null);
                    } else {
                        int code = response.getStatusInfo().getStatusCode();
                        resultHandler.onResult(false, new RuntimeException("HTTP code " + code));
                    }
                }

                public void failed(Throwable throwable) {
                    resultHandler.onResult(false, throwable);
                }
            });
        }
        catch (JsonProcessingException e) {
            resultHandler.onResult(false, e);
        }
    }
}

