/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.regionaccess.internal;

import java.util.List;
import java.util.function.BiConsumer;
import org.eclipse.xtext.formatting2.regionaccess.HiddenRegionPartAssociation;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegionPart;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegionPartAssociator;
import org.eclipse.xtext.formatting2.regionaccess.IWhitespace;

public class HiddenRegionPartAssociator
implements IHiddenRegionPartAssociator {
    @Override
    public void associate(IHiddenRegion region, BiConsumer<IHiddenRegionPart, HiddenRegionPartAssociation> handler) {
        List<IHiddenRegionPart> parts = region.getParts();
        if (!region.isMultiline()) {
            for (IHiddenRegionPart p : parts) {
                handler.accept(p, HiddenRegionPartAssociation.CONTAINER);
            }
        } else {
            int i = 0;
            if (region.getPreviousSemanticRegion() != null) {
                while (i < parts.size()) {
                    IHiddenRegionPart part = parts.get(i);
                    if (part.isMultiline()) {
                        if (!part.getText().endsWith("\n")) break;
                        handler.accept(part, HiddenRegionPartAssociation.PREVIOUS);
                        ++i;
                        break;
                    }
                    handler.accept(part, HiddenRegionPartAssociation.PREVIOUS);
                    ++i;
                }
            }
            int j = parts.size() - 1;
            if (region.getNextSemanticRegion() != null) {
                while (j >= i) {
                    IHiddenRegionPart part = parts.get(j);
                    if (part instanceof IWhitespace && part.getLineCount() > 2) break;
                    handler.accept(part, HiddenRegionPartAssociation.NEXT);
                    --j;
                }
            }
            int k = i;
            while (k <= j) {
                IHiddenRegionPart part = parts.get(k);
                handler.accept(part, HiddenRegionPartAssociation.CONTAINER);
                ++k;
            }
        }
    }
}

