/*
 * Decompiled with CFR 0.152.
 */
package tr.view.collect.screen;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.thought.Thought;
import tr.model.util.Manager;
import tr.util.Observable;
import tr.view.collect.dialog.ThoughtDialog;
import tr.view.collect.screen.CollectThoughtsTableModel;
import tr.view.collect.screen.ThoughtNode;
import tr.view.collect.screen.ThoughtNodeProvider;

public class CollectThoughtsPanel
extends JPanel {
    private final Data data;
    private final ThoughtNodeProvider thoughtProvider;
    private final CollectThoughtsTableModel tableModel;
    private JPanel bodyPanel;
    private JScrollPane tableScrollPane;
    private JXTable table;
    private ThoughtDialog createDialog;
    private ThoughtDialog thoughtDialog;

    public CollectThoughtsPanel(ThoughtNodeProvider thoughtProvider) {
        this.thoughtProvider = thoughtProvider;
        this.data = (Data)DataLookup.instance().lookup(Data.class);
        this.tableModel = new CollectThoughtsTableModel(this.data);
        this.initComponents();
    }

    private void initComponents() {
        this.initTable();
        this.initBodyPanel();
        this.initPanel();
    }

    private void initTable() {
        this.table = new JXTable((TableModel)this.tableModel);
        this.table.setColumnControlVisible(true);
        this.table.setSortable(false);
        this.table.setEnabled(true);
        this.table.setFocusable(true);
        this.table.setShowGrid(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setCellSelectionEnabled(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(0);
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    CollectThoughtsPanel.this.modify();
                } else if (e.getKeyCode() == 127) {
                    e.consume();
                    CollectThoughtsPanel.this.delete();
                }
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    CollectThoughtsPanel.this.modify();
                }
            }
        });
        ListSelectionModel rowSM = this.table.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    CollectThoughtsPanel.this.rowSelectionChanged();
                }
            }
        });
        for (int i = 0; i < CollectThoughtsTableModel.CLASSES.length; ++i) {
            TableColumn tc = this.table.getColumnModel().getColumn(i);
            if (this.tableModel.renderers[i] != null) {
                tc.setCellRenderer(this.tableModel.renderers[i]);
            }
            if (CollectThoughtsTableModel.MAX_WIDTHS[i] > -1) {
                tc.setMaxWidth(CollectThoughtsTableModel.MAX_WIDTHS[i]);
            }
            if (CollectThoughtsTableModel.MIN_WIDTHS[i] > -1) {
                tc.setMinWidth(CollectThoughtsTableModel.MIN_WIDTHS[i]);
            }
            if (CollectThoughtsTableModel.PREF_WIDTHS[i] <= -1) continue;
            tc.setPreferredWidth(CollectThoughtsTableModel.PREF_WIDTHS[i]);
        }
        this.tableScrollPane = new JScrollPane((Component)this.table);
        this.tableScrollPane.setBorder(null);
        this.tableScrollPane.getVerticalScrollBar().setUnitIncrement(5);
        this.tableScrollPane.getHorizontalScrollBar().setUnitIncrement(5);
    }

    private void rowSelectionChanged() {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow < 0) {
            this.thoughtProvider.provide(null);
            return;
        }
        Thought thought = this.tableModel.getValueAt(selectedRow);
        if (thought == null) {
            this.thoughtProvider.provide(null);
            return;
        }
        this.thoughtProvider.provide(new ThoughtNode((Manager<Thought>)this.data.getThoughtManager(), thought));
    }

    private void initBodyPanel() {
        this.bodyPanel = new JPanel();
        this.bodyPanel.setLayout(new BorderLayout());
        this.bodyPanel.add((Component)this.tableScrollPane, "Center");
    }

    private void initPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(new Insets(2, 2, 2, 2)));
        this.add((Component)this.bodyPanel, "Center");
    }

    public void create() {
        this.table.clearSelection();
        this.getThoughtDialog().showCreateDialog();
    }

    public void modify() {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow < 0) {
            return;
        }
        Thought thought = this.tableModel.getValueAt(selectedRow);
        if (thought == null) {
            return;
        }
        this.getThoughtDialog().showModifyDialog(thought);
        this.selectRow(selectedRow);
    }

    private ThoughtDialog getThoughtDialog() {
        this.thoughtDialog = new ThoughtDialog(this.data);
        return this.thoughtDialog;
    }

    public void delete() {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow < 0) {
            return;
        }
        Thought thought = this.tableModel.getValueAt(selectedRow);
        if (thought == null) {
            return;
        }
        this.data.getThoughtManager().remove((Observable)thought);
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        int rowCount = this.table.getRowCount();
        if (selectedRow < rowCount) {
            this.selectRow(selectedRow);
        } else if (rowCount > 0) {
            this.selectRow(rowCount - 1);
        }
    }

    private void selectRow(final int row) {
        if (row < 0 || row >= this.table.getRowCount()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CollectThoughtsPanel.this.table.requestFocusInWindow();
                CollectThoughtsPanel.this.table.changeSelection(row, 0, false, false);
            }
        });
    }
}

