/*
 * Decompiled with CFR 0.152.
 */
package jadx.api.plugins.input.data.attributes.types;

import jadx.api.plugins.input.data.annotations.AnnotationVisibility;
import jadx.api.plugins.input.data.annotations.IAnnotation;
import jadx.api.plugins.input.data.attributes.JadxAttrType;
import jadx.api.plugins.input.data.attributes.PinnedAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class AnnotationsAttr
extends PinnedAttribute {
    private final Map<String, IAnnotation> map;

    @Nullable
    public static AnnotationsAttr pack(List<IAnnotation> annotationList) {
        if (annotationList.isEmpty()) {
            return null;
        }
        HashMap<String, IAnnotation> annMap = new HashMap<String, IAnnotation>(annotationList.size());
        for (IAnnotation ann : annotationList) {
            if (ann.getVisibility() == AnnotationVisibility.SYSTEM) continue;
            annMap.put(ann.getAnnotationClass(), ann);
        }
        if (annMap.isEmpty()) {
            return null;
        }
        return new AnnotationsAttr(annMap);
    }

    public AnnotationsAttr(Map<String, IAnnotation> map) {
        this.map = map;
    }

    public IAnnotation get(String className) {
        return this.map.get(className);
    }

    public Collection<IAnnotation> getAll() {
        return this.map.values();
    }

    public List<IAnnotation> getList() {
        return this.map.isEmpty() ? Collections.emptyList() : new ArrayList<IAnnotation>(this.map.values());
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public JadxAttrType<AnnotationsAttr> getAttrType() {
        return JadxAttrType.ANNOTATION_LIST;
    }

    public String toString() {
        return this.map.toString();
    }
}

