/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec4(66u, 72u, 87u, 75u) | 0u) => uvec4(66u, 72u, 87u, 75u)
 * (uvec4(66u, 72u, 87u, 75u) | 6u) => uvec4(70u, 78u, 87u, 79u)
 * (uvec4(66u, 72u, 87u, 75u) | 12u) => uvec4(78u, 76u, 95u, 79u)
 * (uvec4(66u, 72u, 87u, 75u) | 32u) => uvec4(98u, 104u, 119u, 107u)
 * (uvec4(66u, 72u, 87u, 75u) | 74u) => uvec4(74u, 74u, 95u, 75u)
 * (uvec4(24u, 40u, 23u, 74u) | 0u) => uvec4(24u, 40u, 23u, 74u)
 * (uvec4(24u, 40u, 23u, 74u) | 6u) => uvec4(30u, 46u, 23u, 78u)
 * (uvec4(24u, 40u, 23u, 74u) | 12u) => uvec4(28u, 44u, 31u, 78u)
 * (uvec4(24u, 40u, 23u, 74u) | 32u) => uvec4(56u, 40u, 55u, 106u)
 * (uvec4(24u, 40u, 23u, 74u) | 74u) => uvec4(90u, 106u, 95u, 74u)
 */
#version 130

void main()
{
  float[all(equal((uvec4(66u, 72u, 87u, 75u) | 0u), uvec4(66u, 72u, 87u, 75u))) ? 1 : -1] array0;
  float[all(equal((uvec4(66u, 72u, 87u, 75u) | 6u), uvec4(70u, 78u, 87u, 79u))) ? 1 : -1] array1;
  float[all(equal((uvec4(66u, 72u, 87u, 75u) | 12u), uvec4(78u, 76u, 95u, 79u))) ? 1 : -1] array2;
  float[all(equal((uvec4(66u, 72u, 87u, 75u) | 32u), uvec4(98u, 104u, 119u, 107u))) ? 1 : -1] array3;
  float[all(equal((uvec4(66u, 72u, 87u, 75u) | 74u), uvec4(74u, 74u, 95u, 75u))) ? 1 : -1] array4;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) | 0u), uvec4(24u, 40u, 23u, 74u))) ? 1 : -1] array5;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) | 6u), uvec4(30u, 46u, 23u, 78u))) ? 1 : -1] array6;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) | 12u), uvec4(28u, 44u, 31u, 78u))) ? 1 : -1] array7;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) | 32u), uvec4(56u, 40u, 55u, 106u))) ? 1 : -1] array8;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) | 74u), uvec4(90u, 106u, 95u, 74u))) ? 1 : -1] array9;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length());
}
