/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import org.locationtech.jts.geom.Coordinate;

public class CoordinateXYZM
extends Coordinate {
    private static final long serialVersionUID = -8763329985881823442L;
    private double m;

    public CoordinateXYZM() {
        this.m = 0.0;
    }

    public CoordinateXYZM(double x, double y, double z, double m) {
        super(x, y, z);
        this.m = m;
    }

    public CoordinateXYZM(Coordinate coord) {
        super(coord);
        this.m = this.getM();
    }

    public CoordinateXYZM(CoordinateXYZM coord) {
        super(coord);
        this.m = coord.m;
    }

    @Override
    public CoordinateXYZM copy() {
        return new CoordinateXYZM(this);
    }

    @Override
    public Coordinate create() {
        return new CoordinateXYZM();
    }

    @Override
    public double getM() {
        return this.m;
    }

    @Override
    public void setM(double m) {
        this.m = m;
    }

    @Override
    public double getOrdinate(int ordinateIndex) {
        switch (ordinateIndex) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.getZ();
            }
            case 3: {
                return this.getM();
            }
        }
        throw new IllegalArgumentException("Invalid ordinate index: " + ordinateIndex);
    }

    @Override
    public void setCoordinate(Coordinate other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.getZ();
        this.m = other.getM();
    }

    @Override
    public void setOrdinate(int ordinateIndex, double value) {
        switch (ordinateIndex) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
                break;
            }
            case 3: {
                this.m = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid ordinate index: " + ordinateIndex);
            }
        }
    }

    @Override
    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.getZ() + " m=" + this.getM() + ")";
    }
}

