/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.utility;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class BlockingCell<T> {
    private final AtomicReference<T> value = new AtomicReference();
    private final CountDownLatch latch = new CountDownLatch(1);
    private static final long NANOS_IN_MILLI = 1000000L;
    private static final long INFINITY = -1L;

    public T get() throws InterruptedException {
        this.latch.await();
        return this.value.get();
    }

    public T get(long timeout) throws InterruptedException, TimeoutException {
        if (timeout == -1L) {
            return this.get();
        }
        if (timeout < 0L) {
            throw new IllegalArgumentException("Timeout cannot be less than zero");
        }
        boolean done = this.latch.await(timeout, TimeUnit.MILLISECONDS);
        if (!done) {
            throw new TimeoutException();
        }
        return this.value.get();
    }

    public T uninterruptibleGet() {
        boolean wasInterrupted = false;
        while (true) {
            try {
                T t = this.get();
                return t;
            }
            catch (InterruptedException ex) {
                wasInterrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T uninterruptibleGet(int timeout) throws TimeoutException {
        block7: {
            long now = System.nanoTime() / 1000000L;
            long runTime = now + (long)timeout;
            boolean wasInterrupted = false;
            while (true) {
                try {
                    T t = this.get(runTime - now);
                    return t;
                }
                catch (InterruptedException e) {
                    wasInterrupted = true;
                    if ((long)timeout == -1L || (now = System.nanoTime() / 1000000L) < runTime) continue;
                    break block7;
                }
                break;
            }
            finally {
                if (wasInterrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        throw new TimeoutException();
    }

    public void set(T newValue) {
        if (!this.value.compareAndSet(null, newValue)) {
            throw new IllegalStateException("BlockingCell can only be set once");
        }
        this.latch.countDown();
    }

    public boolean setIfUnset(T newValue) {
        if (this.value.compareAndSet(null, newValue)) {
            this.latch.countDown();
            return true;
        }
        return false;
    }
}

