/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.gc;

import java.awt.Font;
import java.time.Duration;
import javax.swing.JLabel;
import org.graalvm.visualvm.jfr.utils.ValuesConverter;
import org.graalvm.visualvm.jfr.views.gc.GcNode;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.McsTimeRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.NumberRenderer;

final class GcRenderers {
    GcRenderers() {
    }

    private static int getMinimumWidth(String valueName) {
        return new JLabel((String)valueName).getPreferredSize().width + 30;
    }

    private static class TimeRenderer
    extends McsTimeRenderer {
        private TimeRenderer() {
        }

        public void setValue(Object value, int row) {
            if (value instanceof Duration) {
                long micros = ValuesConverter.durationToMicros((Duration)value);
                if (micros == 0L) {
                    this.setText("< 0.001 ms");
                } else {
                    super.setValue((Object)micros, row);
                }
            } else {
                this.setText("-");
            }
        }
    }

    static class CountRenderer
    extends NumberRenderer {
        CountRenderer() {
        }

        static String getDisplayName() {
            return "Count";
        }

        static boolean isInitiallyVisible() {
            return false;
        }

        int getPreferredWidth() {
            this.setValue(999999999999L, -1);
            return Math.max(this.getPreferredSize().width, GcRenderers.getMinimumWidth(CountRenderer.getDisplayName()));
        }

        public void setText(String text) {
            if ("-".equals(text)) {
                text = "";
            }
            super.setText(text);
        }
    }

    static class SumOfPausesRenderer
    extends TimeRenderer {
        SumOfPausesRenderer() {
        }

        static String getDisplayName() {
            return "Sum Of Pauses";
        }

        static boolean isInitiallyVisible() {
            return true;
        }

        int getPreferredWidth() {
            this.setValue(Duration.ofMillis(999999999999L), -1);
            return Math.max(this.getPreferredSize().width, GcRenderers.getMinimumWidth(SumOfPausesRenderer.getDisplayName()));
        }
    }

    static class LongestPauseRenderer
    extends TimeRenderer {
        LongestPauseRenderer() {
        }

        static String getDisplayName() {
            return "Longest Pause";
        }

        static boolean isInitiallyVisible() {
            return true;
        }

        int getPreferredWidth() {
            this.setValue(Duration.ofMillis(999999999999L), -1);
            return Math.max(this.getPreferredSize().width, GcRenderers.getMinimumWidth(LongestPauseRenderer.getDisplayName()));
        }
    }

    static class GcIdRenderer
    extends NumberRenderer {
        GcIdRenderer() {
        }

        static String getDisplayName() {
            return "GC ID";
        }

        static boolean isInitiallyVisible() {
            return true;
        }

        int getPreferredWidth() {
            this.setValue(999999999999L, -1);
            return Math.max(this.getPreferredSize().width, GcRenderers.getMinimumWidth(GcIdRenderer.getDisplayName()));
        }

        public void setText(String text) {
            if ("-".equals(text)) {
                text = "";
            }
            super.setText(text);
        }
    }

    static class NameRenderer
    extends LabelRenderer {
        private static Font regular;
        private static Font bold;

        NameRenderer() {
        }

        public void setValue(Object value, int row) {
            if (value instanceof GcNode) {
                GcNode node = (GcNode)((Object)value);
                GcNode parent = node.getParent();
                this.setFont((parent == null || parent.getParent() == null) && !(value instanceof GcNode.Label) ? NameRenderer.bold() : NameRenderer.regular());
                this.setText(node.name);
                this.setIcon(node.icon);
            } else {
                super.setValue(value, row);
            }
        }

        static String getDisplayName() {
            return "Name";
        }

        private static Font regular() {
            if (regular == null) {
                regular = new LabelRenderer().getFont();
            }
            return regular;
        }

        private static Font bold() {
            if (bold == null) {
                bold = new LabelRenderer().getFont().deriveFont(1);
            }
            return bold;
        }
    }
}

