# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx_policy.infra.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class AlbAuthToken(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_auth_token'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbAuthTokenStub)
        self._VAPI_OPERATION_IDS = {}


    def update(self,
               a_lb_auth_token,
               ):
        """
        Passthorugh API calls to Avi controller using the Auth of policy API
        request send to this API will be passthrough to Avi controller and Avi
        controller response will be embedded for this API.

        :type  a_lb_auth_token: :class:`com.vmware.nsx_policy.model_client.ALBAuthToken`
        :param a_lb_auth_token: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ALBAuthToken`
        :return: com.vmware.nsx_policy.model.ALBAuthToken
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'a_lb_auth_token': a_lb_auth_token,
                            })
class AlbOnboardingWorkflow(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.alb_onboarding_workflow'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AlbOnboardingWorkflowStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               managed_by,
               ):
        """
        Delete the EnforcementPoint along with Infra Admin credentials.

        :type  managed_by: :class:`str`
        :param managed_by: On Boarding flow managed by LCM/VCF. (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'managed_by': managed_by,
                            })

    def update(self,
               a_lb_controller_configuration,
               ):
        """
        Set the post deployment cluster configuration for Advanced Load
        Balancer controller cluster.

        :type  a_lb_controller_configuration: :class:`com.vmware.nsx_policy.model_client.ALBControllerConfiguration`
        :param a_lb_controller_configuration: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.EnforcementPoint`
        :return: com.vmware.nsx_policy.model.EnforcementPoint
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'a_lb_controller_configuration': a_lb_controller_configuration,
                            })
class BfdProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.bfd_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _BfdProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               bfd_profile_id,
               override=None,
               ):
        """
        Delete BFD Config and all the entities contained by this BfdProfile.

        :type  bfd_profile_id: :class:`str`
        :param bfd_profile_id: BfdProfile ID (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'bfd_profile_id': bfd_profile_id,
                            'override': override,
                            })

    def get(self,
            bfd_profile_id,
            ):
        """
        Read a BfdProfile.

        :type  bfd_profile_id: :class:`str`
        :param bfd_profile_id: BfdProfile ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.BfdProfile`
        :return: com.vmware.nsx_policy.model.BfdProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'bfd_profile_id': bfd_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all BfdProfiles.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.BfdProfileListResult`
        :return: com.vmware.nsx_policy.model.BfdProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              bfd_profile_id,
              bfd_profile,
              override=None,
              ):
        """
        If a BfdProfile with the bfd-profile-id is not already present, create
        a new BfdProfile. If it already exists, update the BfdProfile. This
        operation will fully replace the object.

        :type  bfd_profile_id: :class:`str`
        :param bfd_profile_id: BfdProfile ID (required)
        :type  bfd_profile: :class:`com.vmware.nsx_policy.model_client.BfdProfile`
        :param bfd_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'bfd_profile_id': bfd_profile_id,
                            'bfd_profile': bfd_profile,
                            'override': override,
                            })

    def update(self,
               bfd_profile_id,
               bfd_profile,
               override=None,
               ):
        """
        If a BfdProfile with the bfd-profile-id is not already present, create
        a new BfdProfile. If it already exists, update the BfdProfile. This
        operation will fully replace the object.

        :type  bfd_profile_id: :class:`str`
        :param bfd_profile_id: BfdProfile ID (required)
        :type  bfd_profile: :class:`com.vmware.nsx_policy.model_client.BfdProfile`
        :param bfd_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.BfdProfile`
        :return: com.vmware.nsx_policy.model.BfdProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'bfd_profile_id': bfd_profile_id,
                            'bfd_profile': bfd_profile,
                            'override': override,
                            })
class Cabundles(VapiInterface):
    """
    
    """
    LIST_TYPE_CLUSTER_API_CERTIFICATE = "cluster_api_certificate"
    """
    Possible value for ``type`` of method :func:`Cabundles.list`.

    """
    LIST_TYPE_API_CERTIFICATE = "api_certificate"
    """
    Possible value for ``type`` of method :func:`Cabundles.list`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.cabundles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _CabundlesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               cabundle_id,
               ):
        """
        Deletes the specified bundle of trusted CA certificates.

        :type  cabundle_id: :class:`str`
        :param cabundle_id: ID of the CA bundle to delete (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'cabundle_id': cabundle_id,
                            })

    def get(self,
            cabundle_id,
            ):
        """
        Returns information about the specified bundle of trusted CA
        certificates.

        :type  cabundle_id: :class:`str`
        :param cabundle_id: ID of the CA bundle to retrieve (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.CaBundle`
        :return: com.vmware.nsx_policy.model.CaBundle
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'cabundle_id': cabundle_id,
                            })

    def list(self,
             cursor=None,
             details=None,
             included_fields=None,
             node_id=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             type=None,
             ):
        """
        Returns information about all the bundles of trusted CA certificates.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  details: :class:`bool` or ``None``
        :param details: whether to expand the pem data and show all its details (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  node_id: :class:`str` or ``None``
        :param node_id: Node ID of certificate to return (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :type  type: :class:`str` or ``None``
        :param type: Type of certificate to return (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.CaBundleListResult`
        :return: com.vmware.nsx_policy.model.CaBundleListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'details': details,
                            'included_fields': included_fields,
                            'node_id': node_id,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            'type': type,
                            })

    def patch(self,
              cabundle_id,
              ca_bundle,
              ):
        """
        Adds or updates a new bundle of trusted CA certificates. The bundle
        must be a concatenation of one or more PEM-encoded certificates. The
        PEM-encoded bundle is replaced with the one provided in the request.

        :type  cabundle_id: :class:`str`
        :param cabundle_id: ID of the CA bundle being updated (required)
        :type  ca_bundle: :class:`com.vmware.nsx_policy.model_client.CaBundle`
        :param ca_bundle: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.CaBundle`
        :return: com.vmware.nsx_policy.model.CaBundle
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'cabundle_id': cabundle_id,
                            'ca_bundle': ca_bundle,
                            })

    def update(self,
               cabundle_id,
               ca_bundle,
               ):
        """
        Adds or replaces a new bundle of trusted CA certificates. The bundle
        must be a concatenation of one or more PEM-encoded certificates.

        :type  cabundle_id: :class:`str`
        :param cabundle_id: ID of the CA bundle being uploaded (required)
        :type  ca_bundle: :class:`com.vmware.nsx_policy.model_client.CaBundle`
        :param ca_bundle: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.CaBundle`
        :return: com.vmware.nsx_policy.model.CaBundle
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'cabundle_id': cabundle_id,
                            'ca_bundle': ca_bundle,
                            })
class Certificates(VapiInterface):
    """
    
    """
    LIST_TYPE_CLUSTER_API_CERTIFICATE = "cluster_api_certificate"
    """
    Possible value for ``type`` of method :func:`Certificates.list`.

    """
    LIST_TYPE_API_CERTIFICATE = "api_certificate"
    """
    Possible value for ``type`` of method :func:`Certificates.list`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.certificates'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _CertificatesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               certificate_id,
               ):
        """
        Removes the specified certificate. The private key associated with the
        certificate is also deleted.

        :type  certificate_id: :class:`str`
        :param certificate_id: ID of certificate to delete (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'certificate_id': certificate_id,
                            })

    def get(self,
            certificate_id,
            details=None,
            ):
        """
        Returns information for the specified certificate ID, including the
        certificate's id; pem_encoded data; and history of the certificate (who
        created or modified it and when). For additional information, include
        the ?details=true modifier at the end of the request URI.

        :type  certificate_id: :class:`str`
        :param certificate_id: ID of certificate to read (required)
        :type  details: :class:`bool` or ``None``
        :param details: whether to expand the pem data and show all its details (optional,
            default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TlsCertificate`
        :return: com.vmware.nsx_policy.model.TlsCertificate
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'certificate_id': certificate_id,
                            'details': details,
                            })

    def list(self,
             cursor=None,
             details=None,
             included_fields=None,
             node_id=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             type=None,
             ):
        """
        Returns all certificate information viewable by the user, including
        each certificate's id; pem_encoded data; and history of the certificate
        (who created or modified it and when). For additional information,
        include the ?details=true modifier at the end of the request URI.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  details: :class:`bool` or ``None``
        :param details: whether to expand the pem data and show all its details (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  node_id: :class:`str` or ``None``
        :param node_id: Node ID of certificate to return (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :type  type: :class:`str` or ``None``
        :param type: Type of certificate to return (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TlsCertificateList`
        :return: com.vmware.nsx_policy.model.TlsCertificateList
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'details': details,
                            'included_fields': included_fields,
                            'node_id': node_id,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            'type': type,
                            })

    def patch(self,
              certificate_id,
              tls_trust_data,
              ):
        """
        Adds a new private-public certificate and, optionally, a private key
        that can be applied to one of the user-facing components (appliance
        management or edge). The certificate and the key should be stored in
        PEM format. If no private key is provided, the certificate is used as a
        client certificate in the trust store. A private key can be uploaded
        for a CA certificate only if the \"purpose\" parameter is set to
        \"signing-ca\". A certificate chain will not be expanded into separate
        certificate instances for reference, but would be pushed to the
        enforcement point as a single certificate. This patch method does not
        modify an existing certificate.

        :type  certificate_id: :class:`str`
        :param certificate_id: (required)
        :type  tls_trust_data: :class:`com.vmware.nsx_policy.model_client.TlsTrustData`
        :param tls_trust_data: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'certificate_id': certificate_id,
                            'tls_trust_data': tls_trust_data,
                            })

    def update(self,
               certificate_id,
               tls_trust_data,
               ):
        """
        Adds a new private-public certificate and, optionally, a private key
        that can be applied to one of the user-facing components (appliance
        management or edge). The certificate and the key should be stored in
        PEM format. If no private key is provided, the certificate is used as a
        client certificate in the trust store. A private key can be uploaded
        for a CA certificate only if the \"purpose\" parameter is set to
        \"signing-ca\". A certificate chain will not be expanded into separate
        certificate instances for reference, but would be pushed to the
        enforcement point as a single certificate. This PUT method does not
        modify an existing certificate.

        :type  certificate_id: :class:`str`
        :param certificate_id: (required)
        :type  tls_trust_data: :class:`com.vmware.nsx_policy.model_client.TlsTrustData`
        :param tls_trust_data: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TlsCertificate`
        :return: com.vmware.nsx_policy.model.TlsCertificate
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'certificate_id': certificate_id,
                            'tls_trust_data': tls_trust_data,
                            })
class CloudNativeServiceGroupAssociations(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.cloud_native_service_group_associations'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _CloudNativeServiceGroupAssociationsStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             cns_external_id,
             cursor=None,
             enforcement_point_path=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Get policy groups for which the given Cloud Native Service Instance is
        a member.

        :type  cns_external_id: :class:`str`
        :param cns_external_id: Cloud Native Service external ID (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyResourceReferenceForEPListResult`
        :return: com.vmware.nsx_policy.model.PolicyResourceReferenceForEPListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cns_external_id': cns_external_id,
                            'cursor': cursor,
                            'enforcement_point_path': enforcement_point_path,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class ConnectivityGlobalConfig(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.connectivity_global_config'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ConnectivityGlobalConfigStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            apply_locally=None,
            ):
        """
        Read the connectivity global configuration

        :type  apply_locally: :class:`bool` or ``None``
        :param apply_locally: Flag to check reaching NSX+ or LM resource (optional, default to
            false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.GlobalConfig`
        :return: com.vmware.nsx_policy.model.GlobalConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'apply_locally': apply_locally,
                            })

    def patch(self,
              global_config,
              apply_locally=None,
              ):
        """
        Update the connectivity global configuration

        :type  global_config: :class:`com.vmware.nsx_policy.model_client.GlobalConfig`
        :param global_config: (required)
        :type  apply_locally: :class:`bool` or ``None``
        :param apply_locally: Flag to check reaching NSX+ or LM resource (optional, default to
            false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'global_config': global_config,
                            'apply_locally': apply_locally,
                            })

    def update(self,
               global_config,
               apply_locally=None,
               ):
        """
        Update the connectivity global configuration

        :type  global_config: :class:`com.vmware.nsx_policy.model_client.GlobalConfig`
        :param global_config: (required)
        :type  apply_locally: :class:`bool` or ``None``
        :param apply_locally: Flag to check reaching NSX+ or LM resource (optional, default to
            false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.GlobalConfig`
        :return: com.vmware.nsx_policy.model.GlobalConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'global_config': global_config,
                            'apply_locally': apply_locally,
                            })
class ConstraintGlobalConfig(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.constraint_global_config'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ConstraintGlobalConfigStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self):
        """
        Read the constraint global configuration


        :rtype: :class:`com.vmware.nsx_policy.model_client.ConstraintGlobalConfig`
        :return: com.vmware.nsx_policy.model.ConstraintGlobalConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get', None)

    def patch(self,
              constraint_global_config,
              ):
        """
        Update the constraint global configuration

        :type  constraint_global_config: :class:`com.vmware.nsx_policy.model_client.ConstraintGlobalConfig`
        :param constraint_global_config: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'constraint_global_config': constraint_global_config,
                            })

    def update(self,
               constraint_global_config,
               ):
        """
        Update the constraint global configuration

        :type  constraint_global_config: :class:`com.vmware.nsx_policy.model_client.ConstraintGlobalConfig`
        :param constraint_global_config: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ConstraintGlobalConfig`
        :return: com.vmware.nsx_policy.model.ConstraintGlobalConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'constraint_global_config': constraint_global_config,
                            })
class Constraints(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.constraints'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ConstraintsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               constraint_id,
               ):
        """
        Delete tenant constraint.

        :type  constraint_id: :class:`str`
        :param constraint_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'constraint_id': constraint_id,
                            })

    def get(self,
            constraint_id,
            ):
        """
        Read tenant constraint.

        :type  constraint_id: :class:`str`
        :param constraint_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Constraint`
        :return: com.vmware.nsx_policy.model.Constraint
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'constraint_id': constraint_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List tenant constraints.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ConstraintListResult`
        :return: com.vmware.nsx_policy.model.ConstraintListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              constraint_id,
              constraint,
              ):
        """
        Create tenant constraint if not exists, otherwise update the existing
        constraint.

        :type  constraint_id: :class:`str`
        :param constraint_id: (required)
        :type  constraint: :class:`com.vmware.nsx_policy.model_client.Constraint`
        :param constraint: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'constraint_id': constraint_id,
                            'constraint': constraint,
                            })

    def update(self,
               constraint_id,
               constraint,
               ):
        """
        Create tenant constraint if it does not exist, otherwise replace the
        existing constraint.

        :type  constraint_id: :class:`str`
        :param constraint_id: (required)
        :type  constraint: :class:`com.vmware.nsx_policy.model_client.Constraint`
        :param constraint: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Constraint`
        :return: com.vmware.nsx_policy.model.Constraint
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'constraint_id': constraint_id,
                            'constraint': constraint,
                            })
class ContextProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.context_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ContextProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               context_profile_id,
               force=None,
               override=None,
               ):
        """
        Deletes the specified Policy Context Profile. If the Policy Context
        Profile is consumed in a firewall rule, it won't get deleted.

        :type  context_profile_id: :class:`str`
        :param context_profile_id: Policy Context Profile Id (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :type  override: :class:`bool` or ``None``
        :param override: Delete the locally overridden global object (optional, default to
            false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'context_profile_id': context_profile_id,
                            'force': force,
                            'override': override,
                            })

    def get(self,
            context_profile_id,
            ):
        """
        Get a single PolicyContextProfile by id

        :type  context_profile_id: :class:`str`
        :param context_profile_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyContextProfile`
        :return: com.vmware.nsx_policy.model.PolicyContextProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'context_profile_id': context_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Get all PolicyContextProfiles

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyContextProfileListResult`
        :return: com.vmware.nsx_policy.model.PolicyContextProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              context_profile_id,
              policy_context_profile,
              override=None,
              ):
        """
        Creates/Updates a PolicyContextProfile, which encapsulates attribute
        and sub-attributes of network services. Rules for using attributes and
        sub-attributes in single PolicyContextProfile 1. One type of attribute
        can't have multiple occurrences. ( Eg. - Attribute type APP_ID can be
        used only once per PolicyContextProfile.) 2. For specifying multiple
        values for an attribute, provide them in an array. 3. If sub-attribtes
        are mentioned for an attribute, then only single value is allowed for
        that attribute. 4. To get a list of supported attributes and
        sub-attributes fire the following REST API GET
        https://<policy-mgr>/policy/api/v1/infra/context-profiles/attributes 5.
        Do not create context profile with \"custom_attributes\" id

        :type  context_profile_id: :class:`str`
        :param context_profile_id: (required)
        :type  policy_context_profile: :class:`com.vmware.nsx_policy.model_client.PolicyContextProfile`
        :param policy_context_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'context_profile_id': context_profile_id,
                            'policy_context_profile': policy_context_profile,
                            'override': override,
                            })

    def update(self,
               context_profile_id,
               policy_context_profile,
               override=None,
               ):
        """
        Creates/Updates a PolicyContextProfile, which encapsulates attribute
        and sub-attributes of network services. Rules for using attributes and
        sub-attributes in single PolicyContextProfile 1. One type of attribute
        can't have multiple occurrences. ( Eg. - Attribute type APP_ID can be
        used only once per PolicyContextProfile.) 2. For specifying multiple
        values for an attribute, provide them in an array. 3. If sub-attribtes
        are mentioned for an attribute, then only single value is allowed for
        that attribute. 4. To get a list of supported attributes and
        sub-attributes fire the following REST API GET
        https://<policy-mgr>/policy/api/v1/infra/context-profiles/attributes 5.
        Do not create context profile with \"custom_attributes\" id

        :type  context_profile_id: :class:`str`
        :param context_profile_id: (required)
        :type  policy_context_profile: :class:`com.vmware.nsx_policy.model_client.PolicyContextProfile`
        :param policy_context_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyContextProfile`
        :return: com.vmware.nsx_policy.model.PolicyContextProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'context_profile_id': context_profile_id,
                            'policy_context_profile': policy_context_profile,
                            'override': override,
                            })
class Crls(VapiInterface):
    """
    
    """
    LIST_TYPE_CLUSTER_API_CERTIFICATE = "cluster_api_certificate"
    """
    Possible value for ``type`` of method :func:`Crls.list`.

    """
    LIST_TYPE_API_CERTIFICATE = "api_certificate"
    """
    Possible value for ``type`` of method :func:`Crls.list`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.crls'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _CrlsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               crl_id,
               ):
        """
        Deletes an existing CRL.

        :type  crl_id: :class:`str`
        :param crl_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'crl_id': crl_id,
                            })

    def get(self,
            crl_id,
            details=None,
            ):
        """
        Returns information about the specified CRL. For additional
        information, include the ?details=true modifier at the end of the
        request URI.

        :type  crl_id: :class:`str`
        :param crl_id: (required)
        :type  details: :class:`bool` or ``None``
        :param details: whether to expand the pem data and show all its details (optional,
            default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TlsCrl`
        :return: com.vmware.nsx_policy.model.TlsCrl
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'crl_id': crl_id,
                            'details': details,
                            })

    def importcrl(self,
                  crl_id,
                  tls_crl,
                  ):
        """
        Adds a new certificate revocation list (CRLs). The CRL is used to
        verify the client certificate status against the revocation lists
        published by the CA. For this reason, the administrator needs to add
        the CRL in certificate repository as well. A CRL can be in the PEM
        X.509 format (crl_type=X509) or JSON OneCRL (crl_type=OneCRL). If
        crl_type is not specified, it is auto-detected based on the presence of
        fields pem_encoded or one_crl. An X.509 CRL can contain a single CRL or
        multiple CRLs depending on the PEM data. - Single CRL: a single CRL is
        created with the given id. - Composite CRL: multiple CRLs are
        generated. Each of the CRL is created with an id generated based on the
        given id. First CRL is created with crl-id, second with crl-id-1, third
        with crl-id-2, etc.

        :type  crl_id: :class:`str`
        :param crl_id: (required)
        :type  tls_crl: :class:`com.vmware.nsx_policy.model_client.TlsCrl`
        :param tls_crl: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TlsCrlListResult`
        :return: com.vmware.nsx_policy.model.TlsCrlListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('importcrl',
                            {
                            'crl_id': crl_id,
                            'tls_crl': tls_crl,
                            })

    def list(self,
             cursor=None,
             details=None,
             included_fields=None,
             node_id=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             type=None,
             ):
        """
        Returns information about all CRLs. For additional information, include
        the ?details=true modifier at the end of the request URI.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  details: :class:`bool` or ``None``
        :param details: whether to expand the pem data and show all its details (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  node_id: :class:`str` or ``None``
        :param node_id: Node ID of certificate to return (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :type  type: :class:`str` or ``None``
        :param type: Type of certificate to return (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TlsCrlListResult`
        :return: com.vmware.nsx_policy.model.TlsCrlListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'details': details,
                            'included_fields': included_fields,
                            'node_id': node_id,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            'type': type,
                            })

    def patch(self,
              crl_id,
              tls_crl,
              ):
        """
        Create or patch a Certificate Revocation List for the given id. The CRL
        is used to verify the client certificate status against the revocation
        lists published by the CA. For this reason, the administrator needs to
        add the CRL in certificate repository as well. The CRL must contain PEM
        data for a single CRL. A CRL can be in the PEM X.509 format
        (crl_type=X509) or JSON OneCRL (crl_type=OneCRL). If crl_type is not
        specified, it is auto-detected based on the presence of fields
        pem_encoded or one_crl.

        :type  crl_id: :class:`str`
        :param crl_id: (required)
        :type  tls_crl: :class:`com.vmware.nsx_policy.model_client.TlsCrl`
        :param tls_crl: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'crl_id': crl_id,
                            'tls_crl': tls_crl,
                            })

    def update(self,
               crl_id,
               tls_crl,
               ):
        """
        Create or replace a Certificate Revocation List for the given id. The
        CRL is used to verify the client certificate status against the
        revocation lists published by the CA. For this reason, the
        administrator needs to add the CRL in certificate repository as well.
        The CRL must contain PEM data for a single CRL. Revision is required. A
        CRL can be in the PEM X.509 format (crl_type=X509) or JSON OneCRL
        (crl_type=OneCRL). If crl_type is not specified, it is auto-detected
        based on the presence of fields pem_encoded or one_crl.

        :type  crl_id: :class:`str`
        :param crl_id: (required)
        :type  tls_crl: :class:`com.vmware.nsx_policy.model_client.TlsCrl`
        :param tls_crl: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TlsCrl`
        :return: com.vmware.nsx_policy.model.TlsCrl
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'crl_id': crl_id,
                            'tls_crl': tls_crl,
                            })
class Csrs(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.csrs'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _CsrsStub)
        self._VAPI_OPERATION_IDS = {}


    def create(self,
               csr_id,
               tls_csr,
               ):
        """
        Creates a new certificate signing request (CSR). A CSR is encrypted
        text that contains information about your organization (organization
        name, country, and so on) and your Web server's public key, which is a
        public certificate the is generated on the server that can be used to
        forward this request to a certificate authority (CA). A private key is
        also usually created at the same time as the CSR.

        :type  csr_id: :class:`str`
        :param csr_id: ID of CSR to create (required)
        :type  tls_csr: :class:`com.vmware.nsx_policy.model_client.TlsCsr`
        :param tls_csr: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TlsCsr`
        :return: com.vmware.nsx_policy.model.TlsCsr
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('create',
                            {
                            'csr_id': csr_id,
                            'tls_csr': tls_csr,
                            })

    def delete(self,
               csr_id,
               ):
        """
        Removes a specified CSR. If a CSR is not used for verification, you can
        delete it. Note that the CSR import and upload POST actions
        automatically delete the associated CSR.

        :type  csr_id: :class:`str`
        :param csr_id: ID of CSR to delete (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'csr_id': csr_id,
                            })

    def get(self,
            csr_id,
            ):
        """
        Returns information about the specified CSR.

        :type  csr_id: :class:`str`
        :param csr_id: ID of CSR to read (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TlsCsr`
        :return: com.vmware.nsx_policy.model.TlsCsr
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'csr_id': csr_id,
                            })

    def importcsr(self,
                  csr_id,
                  tls_trust_data,
                  ):
        """
        Imports a certificate authority (CA)-signed certificate for a CSR. This
        action links the certificate to the private key created by the CSR. The
        pem_encoded string in the request body is the signed certificate
        provided by your CA in response to the CSR that you provide to them.
        The import POST action automatically deletes the associated CSR.

        :type  csr_id: :class:`str`
        :param csr_id: CSR this certificate is associated with (required)
        :type  tls_trust_data: :class:`com.vmware.nsx_policy.model_client.TlsTrustData`
        :param tls_trust_data: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TlsCertificate`
        :return: com.vmware.nsx_policy.model.TlsCertificate
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('importcsr',
                            {
                            'csr_id': csr_id,
                            'tls_trust_data': tls_trust_data,
                            })

    def list(self,
             cursor=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Returns information about all of the CSRs that have been created.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TlsCsrListResult`
        :return: com.vmware.nsx_policy.model.TlsCsrListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def selfsign(self,
                 csr_id,
                 days_valid,
                 ):
        """
        Self-signs the previously generated CSR. This action is similar to the
        import certificate action, but instead of using a public certificate
        signed by a CA, the self_sign POST action uses a certificate that is
        signed with NSX's own private key. For validity of non-CA certificates,
        if a value greater than 825 days is provided, it will be set to 825
        days. No limit is set for CA certificates.

        :type  csr_id: :class:`str`
        :param csr_id: CSR this certificate is associated with (required)
        :type  days_valid: :class:`long`
        :param days_valid: Number of days the certificate will be valid, default 825 days
            (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TlsCertificate`
        :return: com.vmware.nsx_policy.model.TlsCertificate
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('selfsign',
                            {
                            'csr_id': csr_id,
                            'days_valid': days_valid,
                            })

    def selfsign_0(self,
                   tls_csr_with_days_valid,
                   ):
        """
        Creates a new self-signed certificate. A private key is also created at
        the same time. This is convenience call that will generate a CSR and
        then self-sign it. For validity of non-CA certificates, if a value
        greater than 825 days is provided, it will be set to 825 days. No limit
        is set for CA certificates.

        :type  tls_csr_with_days_valid: :class:`com.vmware.nsx_policy.model_client.TlsCsrWithDaysValid`
        :param tls_csr_with_days_valid: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TlsCertificate`
        :return: com.vmware.nsx_policy.model.TlsCertificate
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('selfsign_0',
                            {
                            'tls_csr_with_days_valid': tls_csr_with_days_valid,
                            })
class DeploymentZones(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.deployment_zones'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _DeploymentZonesStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            deployment_zone_id,
            ):
        """
        Read a Deployment Zone. 
        This is a deprecated API. DeploymentZone has been renamed to Site. Use
        GET /infra/sites/site-id.

        .. deprecated:: unknown

        :type  deployment_zone_id: :class:`str`
        :param deployment_zone_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DeploymentZone`
        :return: com.vmware.nsx_policy.model.DeploymentZone
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx_policy.infra.DeploymentZones.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'deployment_zone_id': deployment_zone_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all Deployment zones for infra. 
        This is a deprecated API. DeploymentZone has been renamed to Site. Use
        GET /infra/sites.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DeploymentZoneListResult`
        :return: com.vmware.nsx_policy.model.DeploymentZoneListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx_policy.infra.DeploymentZones.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class DhcpRelayConfigs(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.dhcp_relay_configs'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _DhcpRelayConfigsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               dhcp_relay_config_id,
               ):
        """
        Delete DHCP relay configuration

        :type  dhcp_relay_config_id: :class:`str`
        :param dhcp_relay_config_id: DHCP relay config ID (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'dhcp_relay_config_id': dhcp_relay_config_id,
                            })

    def get(self,
            dhcp_relay_config_id,
            ):
        """
        Read DHCP relay configuration

        :type  dhcp_relay_config_id: :class:`str`
        :param dhcp_relay_config_id: DHCP relay config ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DhcpRelayConfig`
        :return: com.vmware.nsx_policy.model.DhcpRelayConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'dhcp_relay_config_id': dhcp_relay_config_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all DHCP relay config instances

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DhcpRelayConfigListResult`
        :return: com.vmware.nsx_policy.model.DhcpRelayConfigListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              dhcp_relay_config_id,
              dhcp_relay_config,
              ):
        """
        If DHCP relay config with the dhcp-relay-config-id is not already
        present, create a new DHCP relay config instance. If it already exists,
        update the DHCP relay config instance with specified attributes.

        :type  dhcp_relay_config_id: :class:`str`
        :param dhcp_relay_config_id: DHCP relay config ID (required)
        :type  dhcp_relay_config: :class:`com.vmware.nsx_policy.model_client.DhcpRelayConfig`
        :param dhcp_relay_config: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'dhcp_relay_config_id': dhcp_relay_config_id,
                            'dhcp_relay_config': dhcp_relay_config,
                            })

    def update(self,
               dhcp_relay_config_id,
               dhcp_relay_config,
               ):
        """
        If DHCP relay config with the dhcp-relay-config-id is not already
        present, create a new DHCP relay config instance. If it already exists,
        replace the DHCP relay config instance with this object.

        :type  dhcp_relay_config_id: :class:`str`
        :param dhcp_relay_config_id: DHCP relay config ID (required)
        :type  dhcp_relay_config: :class:`com.vmware.nsx_policy.model_client.DhcpRelayConfig`
        :param dhcp_relay_config: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DhcpRelayConfig`
        :return: com.vmware.nsx_policy.model.DhcpRelayConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'dhcp_relay_config_id': dhcp_relay_config_id,
                            'dhcp_relay_config': dhcp_relay_config,
                            })
class DhcpServerConfigs(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.dhcp_server_configs'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _DhcpServerConfigsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               dhcp_server_config_id,
               ):
        """
        Delete DHCP server configuration

        :type  dhcp_server_config_id: :class:`str`
        :param dhcp_server_config_id: DHCP server config ID (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'dhcp_server_config_id': dhcp_server_config_id,
                            })

    def get(self,
            dhcp_server_config_id,
            ):
        """
        Read DHCP server configuration

        :type  dhcp_server_config_id: :class:`str`
        :param dhcp_server_config_id: DHCP server config ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DhcpServerConfig`
        :return: com.vmware.nsx_policy.model.DhcpServerConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'dhcp_server_config_id': dhcp_server_config_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all DHCP server config instances

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DhcpServerConfigListResult`
        :return: com.vmware.nsx_policy.model.DhcpServerConfigListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              dhcp_server_config_id,
              dhcp_server_config,
              ):
        """
        If DHCP server config with the dhcp-server-config-id is not already
        present, create a new DHCP server config instance. If it already
        exists, update the DHCP server config instance with specified
        attributes. Realized entities of this API can be found using the path
        of Tier-0, Tier1, or Segment where this config is applied on.
        Modification of edge_cluster_path in DhcpServerConfig will lose all
        existing DHCP leases. If both the preferred_edge_paths in the
        DhcpServerConfig are changed in a same PATCH API, e.g. change from
        [a,b] to [x,y], the current DHCP server leases will be lost, which
        could cause network connectivity issues. It is recommended to change
        only one member index in an update call, e.g. from [a, b] to [a,y].
        Clearing preferred_edge_paths will not reassign edge nodes from the
        edge cluster. Instead, the previously-allocated edge nodes will be
        retained to avoid loss of leases.

        :type  dhcp_server_config_id: :class:`str`
        :param dhcp_server_config_id: DHCP server config ID (required)
        :type  dhcp_server_config: :class:`com.vmware.nsx_policy.model_client.DhcpServerConfig`
        :param dhcp_server_config: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'dhcp_server_config_id': dhcp_server_config_id,
                            'dhcp_server_config': dhcp_server_config,
                            })

    def update(self,
               dhcp_server_config_id,
               dhcp_server_config,
               ):
        """
        If DHCP server config with the dhcp-server-config-id is not already
        present, create a new DHCP server config instance. If it already
        exists, replace the DHCP server config instance with this object.
        Realized entities of this API can be found using the path of Tier-0,
        Tier1, or Segment where this config is applied on. Modification of
        edge_cluster_path in DhcpServerConfig will lose all existing DHCP
        leases. If both the preferred_edge_paths in the DhcpServerConfig are
        changed in a same PUT API, e.g. change from [a,b] to [x,y], the current
        DHCP server leases will be lost, which could cause network connectivity
        issues. It is recommended to change only one member index in an update
        call, e.g. from [a, b] to [a,y]. Clearing preferred_edge_paths will not
        reassign edge nodes from the edge cluster. Instead, the
        previously-allocated edge nodes will be retained to avoid loss of
        leases.

        :type  dhcp_server_config_id: :class:`str`
        :param dhcp_server_config_id: DHCP server config ID (required)
        :type  dhcp_server_config: :class:`com.vmware.nsx_policy.model_client.DhcpServerConfig`
        :param dhcp_server_config: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DhcpServerConfig`
        :return: com.vmware.nsx_policy.model.DhcpServerConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'dhcp_server_config_id': dhcp_server_config_id,
                            'dhcp_server_config': dhcp_server_config,
                            })
class DnsForwarderZones(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.dns_forwarder_zones'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _DnsForwarderZonesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               dns_forwarder_zone_id,
               ):
        """
        Delete the DNS Forwarder Zone

        :type  dns_forwarder_zone_id: :class:`str`
        :param dns_forwarder_zone_id: DNS Forwarder Zone ID (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'dns_forwarder_zone_id': dns_forwarder_zone_id,
                            })

    def get(self,
            dns_forwarder_zone_id,
            ):
        """
        Read the DNS Forwarder Zone

        :type  dns_forwarder_zone_id: :class:`str`
        :param dns_forwarder_zone_id: DNS Forwarder Zone ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyDnsForwarderZone`
        :return: com.vmware.nsx_policy.model.PolicyDnsForwarderZone
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'dns_forwarder_zone_id': dns_forwarder_zone_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all Dns Forwarder Zones

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyDnsForwarderZoneListResult`
        :return: com.vmware.nsx_policy.model.PolicyDnsForwarderZoneListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              dns_forwarder_zone_id,
              policy_dns_forwarder_zone,
              ):
        """
        Create or update the DNS Forwarder Zone

        :type  dns_forwarder_zone_id: :class:`str`
        :param dns_forwarder_zone_id: DNS Forwarder Zone ID (required)
        :type  policy_dns_forwarder_zone: :class:`com.vmware.nsx_policy.model_client.PolicyDnsForwarderZone`
        :param policy_dns_forwarder_zone: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'dns_forwarder_zone_id': dns_forwarder_zone_id,
                            'policy_dns_forwarder_zone': policy_dns_forwarder_zone,
                            })

    def update(self,
               dns_forwarder_zone_id,
               policy_dns_forwarder_zone,
               ):
        """
        Create or update the DNS Forwarder Zone

        :type  dns_forwarder_zone_id: :class:`str`
        :param dns_forwarder_zone_id: DNS Forwarder Zone ID (required)
        :type  policy_dns_forwarder_zone: :class:`com.vmware.nsx_policy.model_client.PolicyDnsForwarderZone`
        :param policy_dns_forwarder_zone: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyDnsForwarderZone`
        :return: com.vmware.nsx_policy.model.PolicyDnsForwarderZone
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'dns_forwarder_zone_id': dns_forwarder_zone_id,
                            'policy_dns_forwarder_zone': policy_dns_forwarder_zone,
                            })
class DnsSecurityProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.dns_security_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _DnsSecurityProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               profile_id,
               override=None,
               ):
        """
        Delete DNS security profile

        :type  profile_id: :class:`str`
        :param profile_id: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'profile_id': profile_id,
                            'override': override,
                            })

    def get(self,
            profile_id,
            ):
        """
        Read the DNS Forwarder for the given tier-0 instance

        :type  profile_id: :class:`str`
        :param profile_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DnsSecurityProfile`
        :return: com.vmware.nsx_policy.model.DnsSecurityProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'profile_id': profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List all DNS security profiles

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DnsSecurityProfileListResult`
        :return: com.vmware.nsx_policy.model.DnsSecurityProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              profile_id,
              dns_security_profile,
              override=None,
              ):
        """
        Create or update DNS security profile

        :type  profile_id: :class:`str`
        :param profile_id: (required)
        :type  dns_security_profile: :class:`com.vmware.nsx_policy.model_client.DnsSecurityProfile`
        :param dns_security_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'profile_id': profile_id,
                            'dns_security_profile': dns_security_profile,
                            'override': override,
                            })

    def update(self,
               profile_id,
               dns_security_profile,
               override=None,
               ):
        """
        Create or update DNS security profile

        :type  profile_id: :class:`str`
        :param profile_id: (required)
        :type  dns_security_profile: :class:`com.vmware.nsx_policy.model_client.DnsSecurityProfile`
        :param dns_security_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DnsSecurityProfile`
        :return: com.vmware.nsx_policy.model.DnsSecurityProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'profile_id': profile_id,
                            'dns_security_profile': dns_security_profile,
                            'override': override,
                            })
class Domains(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.domains'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _DomainsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               domain_id,
               ):
        """
        Delete the domain along with all the entities contained by this domain.
        The groups that are a part of this domain are also deleted along with
        the domain.

        :type  domain_id: :class:`str`
        :param domain_id: Domain ID (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'domain_id': domain_id,
                            })

    def get(self,
            domain_id,
            ):
        """
        Read a domain.

        :type  domain_id: :class:`str`
        :param domain_id: Domain ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Domain`
        :return: com.vmware.nsx_policy.model.Domain
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'domain_id': domain_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all domains for infra.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DomainListResult`
        :return: com.vmware.nsx_policy.model.DomainListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              domain_id,
              domain,
              ):
        """
        If a domain with the domain-id is not already present, create a new
        domain. If it already exists, patch the domain

        :type  domain_id: :class:`str`
        :param domain_id: Domain ID (required)
        :type  domain: :class:`com.vmware.nsx_policy.model_client.Domain`
        :param domain: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'domain_id': domain_id,
                            'domain': domain,
                            })

    def update(self,
               domain_id,
               domain,
               ):
        """
        If a domain with the domain-id is not already present, create a new
        domain. If it already exists, update the domain including the nested
        groups. This is a full replace

        :type  domain_id: :class:`str`
        :param domain_id: Domain ID (required)
        :type  domain: :class:`com.vmware.nsx_policy.model_client.Domain`
        :param domain: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Domain`
        :return: com.vmware.nsx_policy.model.Domain
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'domain_id': domain_id,
                            'domain': domain,
                            })
class Drafts(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.drafts'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _DraftsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               draft_id,
               ):
        """
        Delete a manual draft.

        :type  draft_id: :class:`str`
        :param draft_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'draft_id': draft_id,
                            })

    def get(self,
            draft_id,
            ):
        """
        Read a draft for a given draft identifier.

        :type  draft_id: :class:`str`
        :param draft_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyDraft`
        :return: com.vmware.nsx_policy.model.PolicyDraft
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'draft_id': draft_id,
                            })

    def list(self,
             auto_drafts=None,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List policy drafts.

        :type  auto_drafts: :class:`bool` or ``None``
        :param auto_drafts: Fetch list of draft based on is_auto_draft flag (optional)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyDraftListResult`
        :return: com.vmware.nsx_policy.model.PolicyDraftListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'auto_drafts': auto_drafts,
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              draft_id,
              policy_draft,
              ):
        """
        Create a new manual draft if the specified draft id does not correspond
        to an existing draft. Update the manual draft otherwise. Auto draft can
        not be updated.

        :type  draft_id: :class:`str`
        :param draft_id: (required)
        :type  policy_draft: :class:`com.vmware.nsx_policy.model_client.PolicyDraft`
        :param policy_draft: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'draft_id': draft_id,
                            'policy_draft': policy_draft,
                            })

    def publish(self,
                draft_id,
                infra,
                ):
        """
        Read a draft and publish it by applying changes onto current
        configuration. If there are additional changes on top of draft
        configuration, pass it as a request body, in form of Infra object.
        Otherwise, if there are no additional changes, then pass empty Infra
        object as a request body.

        :type  draft_id: :class:`str`
        :param draft_id: (required)
        :type  infra: :class:`com.vmware.nsx_policy.model_client.Infra`
        :param infra: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('publish',
                            {
                            'draft_id': draft_id,
                            'infra': infra,
                            })

    def update(self,
               draft_id,
               policy_draft,
               ):
        """
        Create a new manual draft if the specified draft id does not correspond
        to an existing draft. Update the manual draft otherwise. Auto draft can
        not be updated.

        :type  draft_id: :class:`str`
        :param draft_id: (required)
        :type  policy_draft: :class:`com.vmware.nsx_policy.model_client.PolicyDraft`
        :param policy_draft: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyDraft`
        :return: com.vmware.nsx_policy.model.PolicyDraft
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'draft_id': draft_id,
                            'policy_draft': policy_draft,
                            })
class EvpnTenantConfigs(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.evpn_tenant_configs'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _EvpnTenantConfigsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               config_id,
               ):
        """
        Delete evpn tunnel endpoint configuration.

        :type  config_id: :class:`str`
        :param config_id: tier0 id (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'config_id': config_id,
                            })

    def get(self,
            config_id,
            ):
        """
        Read Evpn Tenant Configuration.

        :type  config_id: :class:`str`
        :param config_id: config id (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.EvpnTenantConfig`
        :return: com.vmware.nsx_policy.model.EvpnTenantConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'config_id': config_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List all evpn tunnel endpoint configuration.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.EvpnTenantConfigListResult`
        :return: com.vmware.nsx_policy.model.EvpnTenantConfigListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              config_id,
              evpn_tenant_config,
              ):
        """
        Create a global evpn tenant configuration if it is not already present,
        otherwise update the evpn tenant configuration.

        :type  config_id: :class:`str`
        :param config_id: Evpn Tenant config id (required)
        :type  evpn_tenant_config: :class:`com.vmware.nsx_policy.model_client.EvpnTenantConfig`
        :param evpn_tenant_config: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'config_id': config_id,
                            'evpn_tenant_config': evpn_tenant_config,
                            })

    def update(self,
               config_id,
               evpn_tenant_config,
               ):
        """
        Create or update Evpn Tenant configuration.

        :type  config_id: :class:`str`
        :param config_id: Evpn Tenant config id (required)
        :type  evpn_tenant_config: :class:`com.vmware.nsx_policy.model_client.EvpnTenantConfig`
        :param evpn_tenant_config: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.EvpnTenantConfig`
        :return: com.vmware.nsx_policy.model.EvpnTenantConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'config_id': config_id,
                            'evpn_tenant_config': evpn_tenant_config,
                            })
class Features(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.features'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _FeaturesStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             site_path=None,
             ):
        """
        Paginated list of all Aggregated Feature State

        :type  site_path: :class:`str` or ``None``
        :param site_path: null (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.AggregatedFeatureListResult`
        :return: com.vmware.nsx_policy.model.AggregatedFeatureListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'site_path': site_path,
                            })
class FederationConfig(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.federation_config'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _FederationConfigStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self):
        """
        Read a federation config from Global Manager.


        :rtype: :class:`com.vmware.nsx_policy.model_client.FederationConfig`
        :return: com.vmware.nsx_policy.model.FederationConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get', None)
class FirewallIdentityStoreLdapServer(VapiInterface):
    """
    
    """
    CREATE_ACTION_CONNECTIVITY = "CONNECTIVITY"
    """
    Possible value for ``action`` of method
    :func:`FirewallIdentityStoreLdapServer.create`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.firewall_identity_store_ldap_server'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _FirewallIdentityStoreLdapServerStub)
        self._VAPI_OPERATION_IDS = {}


    def create(self,
               directory_ldap_server,
               action,
               enforcement_point_path=None,
               ):
        """
        This API tests a LDAP server connectivity before the actual domain or
        LDAP server is configured. If the connectivity is good, the response
        will be HTTP status 200. Otherwise the response will be HTTP status 500
        and corresponding error message will be returned.

        :type  directory_ldap_server: :class:`com.vmware.nsx_policy.model_client.DirectoryLdapServer`
        :param directory_ldap_server: (required)
        :type  action: :class:`str`
        :param action: LDAP server test requested (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DirectoryLdapServerStatus`
        :return: com.vmware.nsx_policy.model.DirectoryLdapServerStatus
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('create',
                            {
                            'directory_ldap_server': directory_ldap_server,
                            'action': action,
                            'enforcement_point_path': enforcement_point_path,
                            })
class FirewallIdentityStoreSize(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.firewall_identity_store_size'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _FirewallIdentityStoreSizeStub)
        self._VAPI_OPERATION_IDS = {}


    def create(self,
               directory_domain,
               enforcement_point_path=None,
               ):
        """
        This call scans the size of a directory domain. It may be very |
        expensive to run this call in some AD domain deployments. Please | use
        it with caution.

        :type  directory_domain: :class:`vmware.vapi.struct.VapiStruct`
        :param directory_domain: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.DirectoryDomain`.
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DirectoryDomainSize`
        :return: com.vmware.nsx_policy.model.DirectoryDomainSize
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('create',
                            {
                            'directory_domain': directory_domain,
                            'enforcement_point_path': enforcement_point_path,
                            })
class FirewallIdentityStores(VapiInterface):
    """
    
    """
    CREATE_ACTION_FULL_SYNC = "FULL_SYNC"
    """
    Possible value for ``action`` of method :func:`FirewallIdentityStores.create`.

    """
    CREATE_ACTION_DELTA_SYNC = "DELTA_SYNC"
    """
    Possible value for ``action`` of method :func:`FirewallIdentityStores.create`.

    """
    CREATE_ACTION_STOP_SYNC = "STOP_SYNC"
    """
    Possible value for ``action`` of method :func:`FirewallIdentityStores.create`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.firewall_identity_stores'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _FirewallIdentityStoresStub)
        self._VAPI_OPERATION_IDS = {}


    def create(self,
               firewall_identity_store_id,
               action,
               delay=None,
               enforcement_point_path=None,
               ):
        """
        Invoke full sync or delta sync for a specific domain, with additional
        delay in seconds if needed. Stop sync will try to stop any pending sync
        if any to return to idle state.

        :type  firewall_identity_store_id: :class:`str`
        :param firewall_identity_store_id: Firewall identity store identifier (required)
        :type  action: :class:`str`
        :param action: Sync type requested (required)
        :type  delay: :class:`long` or ``None``
        :param delay: Request to execute the sync with some delay in seconds (optional,
            default to 0)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('create',
                            {
                            'firewall_identity_store_id': firewall_identity_store_id,
                            'action': action,
                            'delay': delay,
                            'enforcement_point_path': enforcement_point_path,
                            })

    def delete(self,
               firewall_identity_store_id,
               enforcement_point_path=None,
               ):
        """
        If the firewall identity store is removed, it will stop the identity
        store synchronization. User will not be able to define new IDFW rules

        :type  firewall_identity_store_id: :class:`str`
        :param firewall_identity_store_id: firewall identity store ID (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'firewall_identity_store_id': firewall_identity_store_id,
                            'enforcement_point_path': enforcement_point_path,
                            })

    def get(self,
            firewall_identity_store_id,
            enforcement_point_path=None,
            ):
        """
        Return a firewall identity store based on the store identifier

        :type  firewall_identity_store_id: :class:`str`
        :param firewall_identity_store_id: firewall identity store ID (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.DirectoryDomain
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.DirectoryDomain`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'firewall_identity_store_id': firewall_identity_store_id,
                            'enforcement_point_path': enforcement_point_path,
                            })

    def list(self,
             cursor=None,
             enforcement_point_path=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List all firewall identity stores

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DirectoryDomainListResults`
        :return: com.vmware.nsx_policy.model.DirectoryDomainListResults
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'enforcement_point_path': enforcement_point_path,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              firewall_identity_store_id,
              directory_domain,
              enforcement_point_path=None,
              ):
        """
        If a firewall identity store with the firewall-identity-store-id is not
        already present, create a new firewall identity store. If it already
        exists, update the firewall identity store with specified attributes.

        :type  firewall_identity_store_id: :class:`str`
        :param firewall_identity_store_id: firewall identity store ID (required)
        :type  directory_domain: :class:`vmware.vapi.struct.VapiStruct`
        :param directory_domain: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.DirectoryDomain`.
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'firewall_identity_store_id': firewall_identity_store_id,
                            'directory_domain': directory_domain,
                            'enforcement_point_path': enforcement_point_path,
                            })

    def update(self,
               firewall_identity_store_id,
               directory_domain,
               enforcement_point_path=None,
               ):
        """
        If a firewall identity store with the firewall-identity-store-id is not
        already present, create a new firewall identity store. If it already
        exists, replace the firewall identity store instance with the new
        object.

        :type  firewall_identity_store_id: :class:`str`
        :param firewall_identity_store_id: firewall identity store ID (required)
        :type  directory_domain: :class:`vmware.vapi.struct.VapiStruct`
        :param directory_domain: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.DirectoryDomain`.
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.DirectoryDomain
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.DirectoryDomain`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'firewall_identity_store_id': firewall_identity_store_id,
                            'directory_domain': directory_domain,
                            'enforcement_point_path': enforcement_point_path,
                            })
class FirewallIdentityStoresOrgUnits(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.firewall_identity_stores_org_units'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _FirewallIdentityStoresOrgUnitsStub)
        self._VAPI_OPERATION_IDS = {}


    def create(self,
               directory_ldap_server,
               enforcement_point_path=None,
               ):
        """
        Fetch all organization units for a LDAP server.

        :type  directory_ldap_server: :class:`com.vmware.nsx_policy.model_client.DirectoryLdapServer`
        :param directory_ldap_server: (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.DirectoryOrgUnitListResults`
        :return: com.vmware.nsx_policy.model.DirectoryOrgUnitListResults
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('create',
                            {
                            'directory_ldap_server': directory_ldap_server,
                            'enforcement_point_path': enforcement_point_path,
                            })
class FirewallIpReputationFeed(VapiInterface):
    """
    
    """
    CREATE_OPERATION_ENABLE_AUTO_DOWNLOAD = "enable_auto_download"
    """
    Possible value for ``operation`` of method
    :func:`FirewallIpReputationFeed.create`.

    """
    CREATE_OPERATION_DISABLE_AUTO_DOWNLOAD = "disable_auto_download"
    """
    Possible value for ``operation`` of method
    :func:`FirewallIpReputationFeed.create`.

    """
    CREATE_OPERATION_DOWNLOAD = "download"
    """
    Possible value for ``operation`` of method
    :func:`FirewallIpReputationFeed.create`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.firewall_ip_reputation_feed'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _FirewallIpReputationFeedStub)
        self._VAPI_OPERATION_IDS = {}


    def create(self,
               operation,
               ):
        """
        This API can be used to activate or deactivate auto-download of IP
        reputation feed, it can also be used to trigger download of IP
        reputation feed when required. Once auto-download is activated, IP
        reputation feed will be downloaded at regular intervals of 720 mins(12
        hrs). Auto-download of IP reputation feed can be activated using the
        action 'enable_auto_download', to deactivate use action
        'disable_auto_download' and to trigger a download use action
        'download'.

        :type  operation: :class:`str`
        :param operation: action (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyFirewallIpReputationConfig`
        :return: com.vmware.nsx_policy.model.PolicyFirewallIpReputationConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('create',
                            {
                            'operation': operation,
                            })

    def get(self):
        """
        API to retrieve the current IP Reputation feed configuration.


        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyFirewallIpReputationConfig`
        :return: com.vmware.nsx_policy.model.PolicyFirewallIpReputationConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get', None)
class FirewallSchedulers(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.firewall_schedulers'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _FirewallSchedulersStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               firewall_scheduler_id,
               force=None,
               ):
        """
        Deletes the specified PolicyFirewallScheduler. If scheduler is consumed
        in a security policy, it won't get deleted.

        :type  firewall_scheduler_id: :class:`str`
        :param firewall_scheduler_id: (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'firewall_scheduler_id': firewall_scheduler_id,
                            'force': force,
                            })

    def get(self,
            firewall_scheduler_id,
            ):
        """
        Get a PolicyFirewallScheduler by id

        :type  firewall_scheduler_id: :class:`str`
        :param firewall_scheduler_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyFirewallScheduler`
        :return: com.vmware.nsx_policy.model.PolicyFirewallScheduler
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'firewall_scheduler_id': firewall_scheduler_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Get all PolicyFirewallSchedulers

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyFirewallSchedulerListResult`
        :return: com.vmware.nsx_policy.model.PolicyFirewallSchedulerListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              firewall_scheduler_id,
              policy_firewall_scheduler,
              ):
        """
        Creates/Updates a PolicyFirewallScheduler, which can be set at security
        policy. Note that at least one property out of \"days\",
        \"start_date\", \"time_interval\", \"end_date\" is required if
        \"recurring\" field is true. Also \"start_time\" and \"end_time\"
        should not be present. And if \"recurring\" field is false then
        \"start_date\" and \"end_date\" is mandatory, \"start_time\" and
        \"end_time\" is optional. Also the fields \"days\" and
        \"time_interval\" should not be present.

        :type  firewall_scheduler_id: :class:`str`
        :param firewall_scheduler_id: (required)
        :type  policy_firewall_scheduler: :class:`com.vmware.nsx_policy.model_client.PolicyFirewallScheduler`
        :param policy_firewall_scheduler: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'firewall_scheduler_id': firewall_scheduler_id,
                            'policy_firewall_scheduler': policy_firewall_scheduler,
                            })

    def update(self,
               firewall_scheduler_id,
               policy_firewall_scheduler,
               ):
        """
        Updates a PolicyFirewallScheduler, which can be set at security policy.
        Note that at least one property out of \"days\", \"start_date\",
        \"time_interval\", \"end_date\" is required if \"recurring\" field is
        true. Also \"start_time\" and \"end_time\" should not be present. And
        if \"recurring\" field is false then \"start_date\" and \"end_date\" is
        mandatory, \"start_time\" and \"end_time\" is optional. Also the fields
        \"days\" and \"time_interval\" should not be present.

        :type  firewall_scheduler_id: :class:`str`
        :param firewall_scheduler_id: (required)
        :type  policy_firewall_scheduler: :class:`com.vmware.nsx_policy.model_client.PolicyFirewallScheduler`
        :param policy_firewall_scheduler: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyFirewallScheduler`
        :return: com.vmware.nsx_policy.model.PolicyFirewallScheduler
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'firewall_scheduler_id': firewall_scheduler_id,
                            'policy_firewall_scheduler': policy_firewall_scheduler,
                            })
class FirewallSessionTimerProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.firewall_session_timer_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _FirewallSessionTimerProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               firewall_session_timer_profile_id,
               override=None,
               ):
        """
        API will delete Firewall Session Timer Profile

        :type  firewall_session_timer_profile_id: :class:`str`
        :param firewall_session_timer_profile_id: Firewall Session Timer Profile ID (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'firewall_session_timer_profile_id': firewall_session_timer_profile_id,
                            'override': override,
                            })

    def get(self,
            firewall_session_timer_profile_id,
            ):
        """
        API will get Firewall Session Timer Profile

        :type  firewall_session_timer_profile_id: :class:`str`
        :param firewall_session_timer_profile_id: Firewall Session Timer Profile ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyFirewallSessionTimerProfile`
        :return: com.vmware.nsx_policy.model.PolicyFirewallSessionTimerProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'firewall_session_timer_profile_id': firewall_session_timer_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        API will list all Firewall Session Timer Profiles

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyFirewallSessionTimerProfileListResult`
        :return: com.vmware.nsx_policy.model.PolicyFirewallSessionTimerProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              firewall_session_timer_profile_id,
              policy_firewall_session_timer_profile,
              override=None,
              ):
        """
        API will create/update Firewall Session Timer Profile

        :type  firewall_session_timer_profile_id: :class:`str`
        :param firewall_session_timer_profile_id: Firewall Session Timer Profile ID (required)
        :type  policy_firewall_session_timer_profile: :class:`com.vmware.nsx_policy.model_client.PolicyFirewallSessionTimerProfile`
        :param policy_firewall_session_timer_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'firewall_session_timer_profile_id': firewall_session_timer_profile_id,
                            'policy_firewall_session_timer_profile': policy_firewall_session_timer_profile,
                            'override': override,
                            })

    def update(self,
               firewall_session_timer_profile_id,
               policy_firewall_session_timer_profile,
               override=None,
               ):
        """
        API will update Firewall Session Timer Profile

        :type  firewall_session_timer_profile_id: :class:`str`
        :param firewall_session_timer_profile_id: Firewall Session Timer Profile ID (required)
        :type  policy_firewall_session_timer_profile: :class:`com.vmware.nsx_policy.model_client.PolicyFirewallSessionTimerProfile`
        :param policy_firewall_session_timer_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyFirewallSessionTimerProfile`
        :return: com.vmware.nsx_policy.model.PolicyFirewallSessionTimerProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'firewall_session_timer_profile_id': firewall_session_timer_profile_id,
                            'policy_firewall_session_timer_profile': policy_firewall_session_timer_profile,
                            'override': override,
                            })
class FloodProtectionProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.flood_protection_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _FloodProtectionProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               flood_protection_profile_id,
               override=None,
               ):
        """
        API will delete Flood Protection Profile

        :type  flood_protection_profile_id: :class:`str`
        :param flood_protection_profile_id: Flood Protection Profile ID (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'flood_protection_profile_id': flood_protection_profile_id,
                            'override': override,
                            })

    def get(self,
            flood_protection_profile_id,
            ):
        """
        API will get Flood Protection Profile

        :type  flood_protection_profile_id: :class:`str`
        :param flood_protection_profile_id: Flood Protection Profile ID (required)
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.FloodProtectionProfile
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.FloodProtectionProfile`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'flood_protection_profile_id': flood_protection_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        API will list all Flood Protection Profiles

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.FloodProtectionProfileListResult`
        :return: com.vmware.nsx_policy.model.FloodProtectionProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              flood_protection_profile_id,
              flood_protection_profile,
              override=None,
              ):
        """
        API will create/update Flood Protection Profile

        :type  flood_protection_profile_id: :class:`str`
        :param flood_protection_profile_id: Firewall Flood Protection Profile ID (required)
        :type  flood_protection_profile: :class:`vmware.vapi.struct.VapiStruct`
        :param flood_protection_profile: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.FloodProtectionProfile`.
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'flood_protection_profile_id': flood_protection_profile_id,
                            'flood_protection_profile': flood_protection_profile,
                            'override': override,
                            })

    def update(self,
               flood_protection_profile_id,
               flood_protection_profile,
               override=None,
               ):
        """
        API will update Firewall Flood Protection Profile

        :type  flood_protection_profile_id: :class:`str`
        :param flood_protection_profile_id: Flood Protection Profile ID (required)
        :type  flood_protection_profile: :class:`vmware.vapi.struct.VapiStruct`
        :param flood_protection_profile: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.FloodProtectionProfile`.
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.FloodProtectionProfile
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.FloodProtectionProfile`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'flood_protection_profile_id': flood_protection_profile_id,
                            'flood_protection_profile': flood_protection_profile,
                            'override': override,
                            })
class FullSyncAction(VapiInterface):
    """
    
    """
    CREATE_ACTION_REQUEST_FULL_SYNC = "request_full_sync"
    """
    Possible value for ``action`` of method :func:`FullSyncAction.create`.

    """
    CREATE_ACTION_REQUEST_NOTIFICATIONS_FULL_SYNC = "request_notifications_full_sync"
    """
    Possible value for ``action`` of method :func:`FullSyncAction.create`.

    """
    CREATE_ACTION_ABORT_CURRENT_SYNC = "abort_current_sync"
    """
    Possible value for ``action`` of method :func:`FullSyncAction.create`.

    """
    CREATE_ACTION_PURGE_HISTORY = "purge_history"
    """
    Possible value for ``action`` of method :func:`FullSyncAction.create`.

    """
    CREATE_SYNC_TYPE_SYNC = "gm_to_lm_full_sync"
    """
    Possible value for ``syncType`` of method :func:`FullSyncAction.create`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.full_sync_action'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _FullSyncActionStub)
        self._VAPI_OPERATION_IDS = {}


    def create(self,
               action,
               site=None,
               sync_type=None,
               ):
        """
        Performs realized object actions specified in the action.

        :type  action: :class:`str`
        :param action: (required)
        :type  site: :class:`str` or ``None``
        :param site: site id (optional)
        :type  sync_type: :class:`str` or ``None``
        :param sync_type: Type of full sync being requested (optional)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('create',
                            {
                            'action': action,
                            'site': site,
                            'sync_type': sync_type,
                            })
class FullSyncStates(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.full_sync_states'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _FullSyncStatesStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            full_sync_id,
            ):
        """
        Get full sync state.

        :type  full_sync_id: :class:`str`
        :param full_sync_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.FullSyncState`
        :return: com.vmware.nsx_policy.model.FullSyncState
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'full_sync_id': full_sync_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List full sync state.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.FullSyncStateListResult`
        :return: com.vmware.nsx_policy.model.FullSyncStateListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class GatewayQosProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.gateway_qos_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _GatewayQosProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               qos_profile_id,
               override=None,
               ):
        """
        Delete QoS profile

        :type  qos_profile_id: :class:`str`
        :param qos_profile_id: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'qos_profile_id': qos_profile_id,
                            'override': override,
                            })

    def get(self,
            qos_profile_id,
            ):
        """
        Read gateway QoS profile

        :type  qos_profile_id: :class:`str`
        :param qos_profile_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.GatewayQosProfile`
        :return: com.vmware.nsx_policy.model.GatewayQosProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'qos_profile_id': qos_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all gateway QoS profle instances

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.GatewayQosProfileListResult`
        :return: com.vmware.nsx_policy.model.GatewayQosProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              qos_profile_id,
              gateway_qos_profile,
              override=None,
              ):
        """
        If profile with the qos-profile-id is not already present, create a new
        gateway QoS profile instance. If it already exists, update the gateway
        QoS profile instance with specified attributes.

        :type  qos_profile_id: :class:`str`
        :param qos_profile_id: (required)
        :type  gateway_qos_profile: :class:`com.vmware.nsx_policy.model_client.GatewayQosProfile`
        :param gateway_qos_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'qos_profile_id': qos_profile_id,
                            'gateway_qos_profile': gateway_qos_profile,
                            'override': override,
                            })

    def update(self,
               qos_profile_id,
               gateway_qos_profile,
               override=None,
               ):
        """
        If profile with the qos-profile-id is not already present, create a new
        gateway QoS profile instance. If it already exists, replace the gateway
        QoS profile instance with this object.

        :type  qos_profile_id: :class:`str`
        :param qos_profile_id: (required)
        :type  gateway_qos_profile: :class:`com.vmware.nsx_policy.model_client.GatewayQosProfile`
        :param gateway_qos_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.GatewayQosProfile`
        :return: com.vmware.nsx_policy.model.GatewayQosProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'qos_profile_id': qos_profile_id,
                            'gateway_qos_profile': gateway_qos_profile,
                            'override': override,
                            })
class GlobalConfig(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.global_config'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _GlobalConfigStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            apply_locally=None,
            ):
        """
        This rest routine is deprecated. Use /infra/connectivity-global-config
        for Connectivity global config and /infra/ops-global-config for
        Operations global config. Read global configuration.

        :type  apply_locally: :class:`bool` or ``None``
        :param apply_locally: Flag to check reaching NSX+ or LM resource (optional, default to
            false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.GlobalConfig`
        :return: com.vmware.nsx_policy.model.GlobalConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'apply_locally': apply_locally,
                            })

    def patch(self,
              global_config,
              apply_locally=None,
              ):
        """
        Update the global configuration. 
        This rest routine is deprecated. Use /infra/connectivity-global-config
        for Connectivity global config and /infra/ops-global-config for
        Operations global config.

        .. deprecated:: unknown

        :type  global_config: :class:`com.vmware.nsx_policy.model_client.GlobalConfig`
        :param global_config: (required)
        :type  apply_locally: :class:`bool` or ``None``
        :param apply_locally: Flag to check reaching NSX+ or LM resource (optional, default to
            false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx_policy.infra.GlobalConfig.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'global_config': global_config,
                            'apply_locally': apply_locally,
                            })

    def update(self,
               global_config,
               apply_locally=None,
               ):
        """
        This rest routine is deprecated. Use /infra/connectivity-global-config
        for Connectivity global config and /infra/ops-global-config for
        Operations global config. Update the global configuration.

        :type  global_config: :class:`com.vmware.nsx_policy.model_client.GlobalConfig`
        :param global_config: (required)
        :type  apply_locally: :class:`bool` or ``None``
        :param apply_locally: Flag to check reaching NSX+ or LM resource (optional, default to
            false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.GlobalConfig`
        :return: com.vmware.nsx_policy.model.GlobalConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'global_config': global_config,
                            'apply_locally': apply_locally,
                            })
class GroupAssociations(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.group_associations'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _GroupAssociationsStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             intent_path,
             cursor=None,
             enforcement_point_path=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Get policy groups for which the given object is a member. In Federation
        environment, if the given object is a global entity (eg: global
        segment) and if the entity is not stretched to the site specified in
        the enforcement_point_path parameter,then the following is returned:-
        1)If the entity is a member of any global group and that group is
        stretched to the enforcement_point_path site,then the API returns an
        empty list. 2)If the entity is not a member of any global group,this
        API returns an 'invalid path' error message. 3)If both the entity and
        its corresponding groups are stretched to the enforcement_point_path
        site , then the API returns the groups list.

        :type  intent_path: :class:`str`
        :param intent_path: String path of the intent object (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyResourceReferenceForEPListResult`
        :return: com.vmware.nsx_policy.model.PolicyResourceReferenceForEPListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'intent_path': intent_path,
                            'cursor': cursor,
                            'enforcement_point_path': enforcement_point_path,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class GroupServiceAssociations(VapiInterface):
    """
    
    """
    LIST_SERVICE_TYPE_FIREWALL = "firewall"
    """
    Possible value for ``serviceType`` of method
    :func:`GroupServiceAssociations.list`.

    """
    LIST_SERVICE_TYPE_IPFIX = "ipfix"
    """
    Possible value for ``serviceType`` of method
    :func:`GroupServiceAssociations.list`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.group_service_associations'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _GroupServiceAssociationsStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             intent_path,
             cursor=None,
             enforcement_point_path=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             service_type=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        The API by default returns all the DFW services associated with the
        given Group. The API returns DFW or IPFIX services based on the
        service_type parameter. It also returns the services associated with
        the parent groups of the given group.

        :type  intent_path: :class:`str`
        :param intent_path: Path of the entity (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  service_type: :class:`str` or ``None``
        :param service_type: (optional)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyResourceReferenceListResult`
        :return: com.vmware.nsx_policy.model.PolicyResourceReferenceListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'intent_path': intent_path,
                            'cursor': cursor,
                            'enforcement_point_path': enforcement_point_path,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'service_type': service_type,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class HostSwitchProfiles(VapiInterface):
    """
    
    """
    LIST_DEPLOYMENT_TYPE_VIRTUAL_MACHINE = "VIRTUAL_MACHINE"
    """
    Possible value for ``deploymentType`` of method
    :func:`HostSwitchProfiles.list`.

    """
    LIST_DEPLOYMENT_TYPE_PHYSICAL_MACHINE = "PHYSICAL_MACHINE"
    """
    Possible value for ``deploymentType`` of method
    :func:`HostSwitchProfiles.list`.

    """
    LIST_DEPLOYMENT_TYPE_UNKNOWN = "UNKNOWN"
    """
    Possible value for ``deploymentType`` of method
    :func:`HostSwitchProfiles.list`.

    """
    LIST_HOSTSWITCH_PROFILE_TYPE_POLICYUPLINKHOSTSWITCHPROFILE = "PolicyUplinkHostSwitchProfile"
    """
    Possible value for ``hostswitchProfileType`` of method
    :func:`HostSwitchProfiles.list`.

    """
    LIST_HOSTSWITCH_PROFILE_TYPE_POLICYLLDPHOSTSWITCHPROFILE = "PolicyLldpHostSwitchProfile"
    """
    Possible value for ``hostswitchProfileType`` of method
    :func:`HostSwitchProfiles.list`.

    """
    LIST_HOSTSWITCH_PROFILE_TYPE_POLICYNIOCPROFILE = "PolicyNiocProfile"
    """
    Possible value for ``hostswitchProfileType`` of method
    :func:`HostSwitchProfiles.list`.

    """
    LIST_HOSTSWITCH_PROFILE_TYPE_POLICYEXTRACONFIGHOSTSWITCHPROFILE = "PolicyExtraConfigHostSwitchProfile"
    """
    Possible value for ``hostswitchProfileType`` of method
    :func:`HostSwitchProfiles.list`.

    """
    LIST_HOSTSWITCH_PROFILE_TYPE_POLICYVTEPHAHOSTSWITCHPROFILE = "PolicyVtepHAHostSwitchProfile"
    """
    Possible value for ``hostswitchProfileType`` of method
    :func:`HostSwitchProfiles.list`.

    """
    LIST_HOSTSWITCH_PROFILE_TYPE_POLICYHIGHPERFORMANCEHOSTSWITCHPROFILE = "PolicyHighPerformanceHostSwitchProfile"
    """
    Possible value for ``hostswitchProfileType`` of method
    :func:`HostSwitchProfiles.list`.

    """
    LIST_NODE_TYPE_EDGENODE = "EdgeNode"
    """
    Possible value for ``nodeType`` of method :func:`HostSwitchProfiles.list`.

    """
    LIST_NODE_TYPE_PUBLICCLOUDGATEWAYNODE = "PublicCloudGatewayNode"
    """
    Possible value for ``nodeType`` of method :func:`HostSwitchProfiles.list`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.host_switch_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _HostSwitchProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               host_switch_profile_id,
               ):
        """
        Deletes a specified hostswitch profile.

        :type  host_switch_profile_id: :class:`str`
        :param host_switch_profile_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'host_switch_profile_id': host_switch_profile_id,
                            })

    def get(self,
            host_switch_profile_id,
            ):
        """
        Returns information about a specified hostswitch profile.

        :type  host_switch_profile_id: :class:`str`
        :param host_switch_profile_id: (required)
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.PolicyBaseHostSwitchProfile
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.PolicyBaseHostSwitchProfile`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'host_switch_profile_id': host_switch_profile_id,
                            })

    def list(self,
             cursor=None,
             deployment_type=None,
             hostswitch_profile_type=None,
             include_mark_for_delete_objects=None,
             include_system_owned=None,
             included_fields=None,
             max_active_uplink_count=None,
             node_type=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             uplink_teaming_policy_name=None,
             ):
        """
        Returns information about the configured hostswitch profiles.
        Hostswitch profiles define networking policies for hostswitches
        (sometimes referred to as bridges in OVS). Currently, following
        profiles are supported. UplinkHostSwitchProfile, LldpHostSwitchProfile,
        NiocProfile & ExtraConfigHostSwitchProfile. Uplink profile - teaming
        defined in this profile allows NSX to load balance traffic across
        different physical NICs (PNICs) on the hypervisor hosts. Multiple
        teaming policies are supported, including LACP active, LACP passive,
        load balancing based on source ID, and failover order. Lldp profile -
        Activate or deactivate sending LLDP packets NiocProfile - Network I/O
        Control settings: defines limits, shares and reservations for various
        host traffic types. ExtraConfig - Vendor specific configuration on
        HostSwitch, logical switch or logical port

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  deployment_type: :class:`str` or ``None``
        :param deployment_type: Supported edge deployment type. (optional)
        :type  hostswitch_profile_type: :class:`str` or ``None``
        :param hostswitch_profile_type: Supported HostSwitch profiles. (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  include_system_owned: :class:`bool` or ``None``
        :param include_system_owned: Whether the list result contains system resources (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  max_active_uplink_count: :class:`long` or ``None``
        :param max_active_uplink_count: Filter uplink profiles by number of active links in teaming policy.
            (optional)
        :type  node_type: :class:`str` or ``None``
        :param node_type: Fabric node type for which uplink profiles are to be listed
            (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :type  uplink_teaming_policy_name: :class:`str` or ``None``
        :param uplink_teaming_policy_name: The host switch profile's uplink teaming policy name (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyHostSwitchProfilesListResult`
        :return: com.vmware.nsx_policy.model.PolicyHostSwitchProfilesListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'deployment_type': deployment_type,
                            'hostswitch_profile_type': hostswitch_profile_type,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'include_system_owned': include_system_owned,
                            'included_fields': included_fields,
                            'max_active_uplink_count': max_active_uplink_count,
                            'node_type': node_type,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            'uplink_teaming_policy_name': uplink_teaming_policy_name,
                            })

    def patch(self,
              host_switch_profile_id,
              policy_base_host_switch_profile,
              ):
        """
        Patch a hostswitch profile. The resource_type is required and needs to
        be one of the following, UplinkHostSwitchProfile,
        LldpHostSwitchProfile, NiocProfile & ExtraConfigHostSwitchProfile.
        Uplink profile - For uplink profiles, the teaming and policy parameters
        are required. By default, the mtu is 1600 and the transport_vlan is 0.
        The supported MTU range is 1280 through (uplink_mtu_threshold).
        uplink_mtu_threshold is 9000 by default. Range can be extended by
        modifying (uplink_mtu_threshold) in SwitchingGlobalConfig to the
        required upper threshold. Teaming defined in this profile allows NSX to
        load balance traffic across different physical NICs (PNICs) on the
        hypervisor hosts. Multiple teaming policies are supported, including
        LACP active, LACP passive, load balancing based on source ID, and
        failover order. Lldp profile - Activate or deactivate sending LLDP
        packets NiocProfile - Network I/O Control settings: defines limits,
        shares and reservations for various host traffic types. ExtraConfig -
        Vendor specific configuration on HostSwitch, logical switch or logical
        port

        :type  host_switch_profile_id: :class:`str`
        :param host_switch_profile_id: (required)
        :type  policy_base_host_switch_profile: :class:`vmware.vapi.struct.VapiStruct`
        :param policy_base_host_switch_profile: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.PolicyBaseHostSwitchProfile`.
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.PolicyBaseHostSwitchProfile
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.PolicyBaseHostSwitchProfile`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'host_switch_profile_id': host_switch_profile_id,
                            'policy_base_host_switch_profile': policy_base_host_switch_profile,
                            })

    def update(self,
               host_switch_profile_id,
               policy_base_host_switch_profile,
               ):
        """
        Create or update a hostswitch profile. The resource_type is required
        and needs to be one of the following, UplinkHostSwitchProfile,
        LldpHostSwitchProfile, NiocProfile & ExtraConfigHostSwitchProfile.
        Uplink profile - For uplink profiles, the teaming and policy parameters
        are required. By default, the mtu is 1600 and the transport_vlan is 0.
        The supported MTU range is 1280 through (uplink_mtu_threshold).
        uplink_mtu_threshold is 9000 by default. Range can be extended by
        modifying (uplink_mtu_threshold) in SwitchingGlobalConfig to the
        required upper threshold. Teaming defined in this profile allows NSX to
        load balance traffic across different physical NICs (PNICs) on the
        hypervisor hosts. Multiple teaming policies are supported, including
        LACP active, LACP passive, load balancing based on source ID, and
        failover order. Lldp profile - Activate or deactivate sending LLDP
        packets NiocProfile - Network I/O Control settings: defines limits,
        shares and reservations for various host traffic types. ExtraConfig -
        Vendor specific configuration on HostSwitch, logical switch or logical
        port

        :type  host_switch_profile_id: :class:`str`
        :param host_switch_profile_id: (required)
        :type  policy_base_host_switch_profile: :class:`vmware.vapi.struct.VapiStruct`
        :param policy_base_host_switch_profile: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.PolicyBaseHostSwitchProfile`.
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.PolicyBaseHostSwitchProfile
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.PolicyBaseHostSwitchProfile`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'host_switch_profile_id': host_switch_profile_id,
                            'policy_base_host_switch_profile': policy_base_host_switch_profile,
                            })
class HostTransportNodeProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.host_transport_node_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _HostTransportNodeProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               transport_node_profile_id,
               ):
        """
        Deletes the specified host transport node profile. A host transport
        node profile can be deleted only when it is not attached to any compute
        collection.

        :type  transport_node_profile_id: :class:`str`
        :param transport_node_profile_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'transport_node_profile_id': transport_node_profile_id,
                            })

    def get(self,
            host_transport_node_profile_id,
            ):
        """
        Returns information about a specified host transport node profile.

        :type  host_transport_node_profile_id: :class:`str`
        :param host_transport_node_profile_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyHostTransportNodeProfile`
        :return: com.vmware.nsx_policy.model.PolicyHostTransportNodeProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'host_transport_node_profile_id': host_transport_node_profile_id,
                            })

    def list(self,
             cursor=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Returns information about all host transport node profiles.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyHostTransportNodeProfileListResult`
        :return: com.vmware.nsx_policy.model.PolicyHostTransportNodeProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def update(self,
               transport_node_profile_id,
               policy_host_transport_node_profile,
               override_nsx_ownership=None,
               ):
        """
        Host transport node profile captures the configuration needed to create
        a host transport node. A host transport node profile can be attached to
        compute collections for automatic host transport node creation of
        member hosts. When configurations of a host transport node profile(TNP)
        are updated, all the host transport nodes in all the compute
        collections to which this TNP is attached are updated to reflect the
        updated configuration.

        :type  transport_node_profile_id: :class:`str`
        :param transport_node_profile_id: (required)
        :type  policy_host_transport_node_profile: :class:`com.vmware.nsx_policy.model_client.PolicyHostTransportNodeProfile`
        :param policy_host_transport_node_profile: (required)
        :type  override_nsx_ownership: :class:`bool` or ``None``
        :param override_nsx_ownership: Override NSX Ownership (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyHostTransportNodeProfile`
        :return: com.vmware.nsx_policy.model.PolicyHostTransportNodeProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'transport_node_profile_id': transport_node_profile_id,
                            'policy_host_transport_node_profile': policy_host_transport_node_profile,
                            'override_nsx_ownership': override_nsx_ownership,
                            })
class IdentityFirewallStores(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.identity_firewall_stores'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _IdentityFirewallStoresStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               identity_firewall_store_id,
               enforcement_point_path=None,
               ):
        """
        If the firewall identity store is removed, it will stop the identity
        store synchronization. User will not be able to define new IDFW rules

        :type  identity_firewall_store_id: :class:`str`
        :param identity_firewall_store_id: firewall identity store ID (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'identity_firewall_store_id': identity_firewall_store_id,
                            'enforcement_point_path': enforcement_point_path,
                            })

    def get(self,
            identity_firewall_store_id,
            enforcement_point_path=None,
            ):
        """
        Return a firewall identity store based on the store identifier

        :type  identity_firewall_store_id: :class:`str`
        :param identity_firewall_store_id: identity firewall store ID (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.IdentityFirewallStore
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.IdentityFirewallStore`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'identity_firewall_store_id': identity_firewall_store_id,
                            'enforcement_point_path': enforcement_point_path,
                            })

    def list(self,
             cursor=None,
             enforcement_point_path=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List all firewall identity stores

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IdentityFirewallStoreListResults`
        :return: com.vmware.nsx_policy.model.IdentityFirewallStoreListResults
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'enforcement_point_path': enforcement_point_path,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              identity_firewall_store_id,
              identity_firewall_store,
              enforcement_point_path=None,
              ):
        """
        If a firewall identity store with the firewall-identity-store-id is not
        already present, create a new firewall identity store. If it already
        exists, update the firewall identity store with specified attributes.

        :type  identity_firewall_store_id: :class:`str`
        :param identity_firewall_store_id: firewall identity store ID (required)
        :type  identity_firewall_store: :class:`vmware.vapi.struct.VapiStruct`
        :param identity_firewall_store: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.IdentityFirewallStore`.
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'identity_firewall_store_id': identity_firewall_store_id,
                            'identity_firewall_store': identity_firewall_store,
                            'enforcement_point_path': enforcement_point_path,
                            })

    def update(self,
               identity_firewall_store_id,
               identity_firewall_store,
               enforcement_point_path=None,
               ):
        """
        If a firewall identity store with the firewall-identity-store-id is not
        already present, create a new firewall identity store. If it already
        exists, replace the firewall identity store instance with the new
        object.

        :type  identity_firewall_store_id: :class:`str`
        :param identity_firewall_store_id: firewall identity store ID (required)
        :type  identity_firewall_store: :class:`vmware.vapi.struct.VapiStruct`
        :param identity_firewall_store: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.IdentityFirewallStore`.
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.IdentityFirewallStore
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.IdentityFirewallStore`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'identity_firewall_store_id': identity_firewall_store_id,
                            'identity_firewall_store': identity_firewall_store,
                            'enforcement_point_path': enforcement_point_path,
                            })
class IdentityGroupAssociations(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.identity_group_associations'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _IdentityGroupAssociationsStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             identity_group_external_id,
             cursor=None,
             enforcement_point_path=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Get policy groups for which the given Identity Group is a member.

        :type  identity_group_external_id: :class:`str`
        :param identity_group_external_id: Identity Group external ID (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyResourceReferenceForEPListResult`
        :return: com.vmware.nsx_policy.model.PolicyResourceReferenceForEPListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'identity_group_external_id': identity_group_external_id,
                            'cursor': cursor,
                            'enforcement_point_path': enforcement_point_path,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class IgmpProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.igmp_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _IgmpProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               igmp_profile_id,
               ):
        """
        Delete Igmp Profile.

        :type  igmp_profile_id: :class:`str`
        :param igmp_profile_id: igmp profile id (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'igmp_profile_id': igmp_profile_id,
                            })

    def get(self,
            igmp_profile_id,
            ):
        """
        Read Igmp Profile.

        :type  igmp_profile_id: :class:`str`
        :param igmp_profile_id: igmp profile id (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyIgmpProfile`
        :return: com.vmware.nsx_policy.model.PolicyIgmpProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'igmp_profile_id': igmp_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List all igmp profile.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyIgmpProfileListResult`
        :return: com.vmware.nsx_policy.model.PolicyIgmpProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              igmp_profile_id,
              policy_igmp_profile,
              ):
        """
        Create a igmp profile with the igmp-profile-id is not already present,
        otherwise update the igmp profile.

        :type  igmp_profile_id: :class:`str`
        :param igmp_profile_id: igmp profile id (required)
        :type  policy_igmp_profile: :class:`com.vmware.nsx_policy.model_client.PolicyIgmpProfile`
        :param policy_igmp_profile: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'igmp_profile_id': igmp_profile_id,
                            'policy_igmp_profile': policy_igmp_profile,
                            })

    def update(self,
               igmp_profile_id,
               policy_igmp_profile,
               ):
        """
        Create or update igmp profile.

        :type  igmp_profile_id: :class:`str`
        :param igmp_profile_id: igmp profile id (required)
        :type  policy_igmp_profile: :class:`com.vmware.nsx_policy.model_client.PolicyIgmpProfile`
        :param policy_igmp_profile: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyIgmpProfile`
        :return: com.vmware.nsx_policy.model.PolicyIgmpProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'igmp_profile_id': igmp_profile_id,
                            'policy_igmp_profile': policy_igmp_profile,
                            })
class IpAddressGroupAssociations(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.ip_address_group_associations'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _IpAddressGroupAssociationsStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             ip_address,
             cursor=None,
             enforcement_point_path=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Get policy groups for which the given IP address is a member.

        :type  ip_address: :class:`str`
        :param ip_address: IPAddress (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyResourceReferenceForEPListResult`
        :return: com.vmware.nsx_policy.model.PolicyResourceReferenceForEPListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'ip_address': ip_address,
                            'cursor': cursor,
                            'enforcement_point_path': enforcement_point_path,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class IpBlocks(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.ip_blocks'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _IpBlocksStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               ip_block_id,
               ):
        """
        Delete the IpAddressBlock with the given id.

        :type  ip_block_id: :class:`str`
        :param ip_block_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'ip_block_id': ip_block_id,
                            })

    def get(self,
            ip_block_id,
            ignore_ipblock_usage=None,
            ):
        """
        Read IpAddressBlock with given Id.

        :type  ip_block_id: :class:`str`
        :param ip_block_id: (required)
        :type  ignore_ipblock_usage: :class:`bool` or ``None``
        :param ignore_ipblock_usage: Flag to specify whether to fetch block usage. (optional, default to
            false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IpAddressBlock`
        :return: com.vmware.nsx_policy.model.IpAddressBlock
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'ip_block_id': ip_block_id,
                            'ignore_ipblock_usage': ignore_ipblock_usage,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of IpAddressBlocks.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IpAddressBlockListResult`
        :return: com.vmware.nsx_policy.model.IpAddressBlockListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              ip_block_id,
              ip_address_block,
              ):
        """
        Creates a new IpAddressBlock with specified ID if not already present.
        If IpAddressBlock of given ID is already present, then the instance is
        updated with specified attributes.

        :type  ip_block_id: :class:`str`
        :param ip_block_id: (required)
        :type  ip_address_block: :class:`com.vmware.nsx_policy.model_client.IpAddressBlock`
        :param ip_address_block: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'ip_block_id': ip_block_id,
                            'ip_address_block': ip_address_block,
                            })

    def update(self,
               ip_block_id,
               ip_address_block,
               ):
        """
        Create a new IpAddressBlock with given ID if it does not exist. If
        IpAddressBlock with given ID already exists, it will update existing
        instance. This is a full replace.

        :type  ip_block_id: :class:`str`
        :param ip_block_id: (required)
        :type  ip_address_block: :class:`com.vmware.nsx_policy.model_client.IpAddressBlock`
        :param ip_address_block: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IpAddressBlock`
        :return: com.vmware.nsx_policy.model.IpAddressBlock
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'ip_block_id': ip_block_id,
                            'ip_address_block': ip_address_block,
                            })
class IpDiscoveryProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.ip_discovery_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _IpDiscoveryProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               ip_discovery_profile_id,
               override=None,
               ):
        """
        API will delete IP Discovery profile.

        :type  ip_discovery_profile_id: :class:`str`
        :param ip_discovery_profile_id: IP Discovery Profile ID (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'ip_discovery_profile_id': ip_discovery_profile_id,
                            'override': override,
                            })

    def get(self,
            ip_discovery_profile_id,
            ):
        """
        API will get IP Discovery profile.

        :type  ip_discovery_profile_id: :class:`str`
        :param ip_discovery_profile_id: IP Discovery Profile ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPDiscoveryProfile`
        :return: com.vmware.nsx_policy.model.IPDiscoveryProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'ip_discovery_profile_id': ip_discovery_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        API will list all IP Discovery Profiles active in current discovery
        profile id.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPDiscoveryProfileListResult`
        :return: com.vmware.nsx_policy.model.IPDiscoveryProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              ip_discovery_profile_id,
              ip_discovery_profile,
              override=None,
              ):
        """
        API will create IP Discovery profile.

        :type  ip_discovery_profile_id: :class:`str`
        :param ip_discovery_profile_id: IP Discovery Profile ID (required)
        :type  ip_discovery_profile: :class:`com.vmware.nsx_policy.model_client.IPDiscoveryProfile`
        :param ip_discovery_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'ip_discovery_profile_id': ip_discovery_profile_id,
                            'ip_discovery_profile': ip_discovery_profile,
                            'override': override,
                            })

    def update(self,
               ip_discovery_profile_id,
               ip_discovery_profile,
               override=None,
               ):
        """
        API will update IP Discovery profile.

        :type  ip_discovery_profile_id: :class:`str`
        :param ip_discovery_profile_id: IP Discovery Profile ID (required)
        :type  ip_discovery_profile: :class:`com.vmware.nsx_policy.model_client.IPDiscoveryProfile`
        :param ip_discovery_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPDiscoveryProfile`
        :return: com.vmware.nsx_policy.model.IPDiscoveryProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'ip_discovery_profile_id': ip_discovery_profile_id,
                            'ip_discovery_profile': ip_discovery_profile,
                            'override': override,
                            })
class IpPools(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.ip_pools'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _IpPoolsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               ip_pool_id,
               ):
        """
        Delete the IpAddressPool with the given id.

        :type  ip_pool_id: :class:`str`
        :param ip_pool_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'ip_pool_id': ip_pool_id,
                            })

    def get(self,
            ip_pool_id,
            ):
        """
        Read IpAddressPool with given Id.

        :type  ip_pool_id: :class:`str`
        :param ip_pool_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IpAddressPool`
        :return: com.vmware.nsx_policy.model.IpAddressPool
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'ip_pool_id': ip_pool_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of IpAddressPools.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IpAddressPoolListResult`
        :return: com.vmware.nsx_policy.model.IpAddressPoolListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              ip_pool_id,
              ip_address_pool,
              ):
        """
        Creates a new IpAddressPool with specified ID if not already present.
        If IpAddressPool of given ID is already present, then the instance is
        updated. This is a full replace.

        :type  ip_pool_id: :class:`str`
        :param ip_pool_id: (required)
        :type  ip_address_pool: :class:`com.vmware.nsx_policy.model_client.IpAddressPool`
        :param ip_address_pool: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'ip_pool_id': ip_pool_id,
                            'ip_address_pool': ip_address_pool,
                            })

    def update(self,
               ip_pool_id,
               ip_address_pool,
               ):
        """
        Create a new IpAddressPool with given ID if it does not exist. If
        IpAddressPool with given ID already exists, it will update existing
        instance. This is a full replace.

        :type  ip_pool_id: :class:`str`
        :param ip_pool_id: (required)
        :type  ip_address_pool: :class:`com.vmware.nsx_policy.model_client.IpAddressPool`
        :param ip_address_pool: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IpAddressPool`
        :return: com.vmware.nsx_policy.model.IpAddressPool
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'ip_pool_id': ip_pool_id,
                            'ip_address_pool': ip_address_pool,
                            })
class IpfixDfwCollectorProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.ipfix_dfw_collector_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _IpfixDfwCollectorProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               ipfix_dfw_collector_profile_id,
               override=None,
               ):
        """
        API deletes IPFIX dfw collector profile. Flow forwarding to collector
        will be stopped.

        :type  ipfix_dfw_collector_profile_id: :class:`str`
        :param ipfix_dfw_collector_profile_id: IPFIX dfw collector Profile id (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'ipfix_dfw_collector_profile_id': ipfix_dfw_collector_profile_id,
                            'override': override,
                            })

    def get(self,
            ipfix_dfw_collector_profile_id,
            ):
        """
        API will return details of IPFIX dfw collector profile. If profile does
        not exist, it will return 404.

        :type  ipfix_dfw_collector_profile_id: :class:`str`
        :param ipfix_dfw_collector_profile_id: IPFIX dfw collector profile id (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPFIXDFWCollectorProfile`
        :return: com.vmware.nsx_policy.model.IPFIXDFWCollectorProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'ipfix_dfw_collector_profile_id': ipfix_dfw_collector_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        API will provide list of all IPFIX dfw collector profiles and their
        details.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPFIXDFWCollectorProfileListResult`
        :return: com.vmware.nsx_policy.model.IPFIXDFWCollectorProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              ipfix_dfw_collector_profile_id,
              i_pfixdfw_collector_profile,
              override=None,
              ):
        """
        Create a new IPFIX dfw collector profile if the IPFIX dfw collector
        profile with given id does not already exist. If the IPFIX dfw
        collector profile with the given id already exists, patch with the
        existing IPFIX dfw collector profile.

        :type  ipfix_dfw_collector_profile_id: :class:`str`
        :param ipfix_dfw_collector_profile_id: (required)
        :type  i_pfixdfw_collector_profile: :class:`com.vmware.nsx_policy.model_client.IPFIXDFWCollectorProfile`
        :param i_pfixdfw_collector_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'ipfix_dfw_collector_profile_id': ipfix_dfw_collector_profile_id,
                            'i_pfixdfw_collector_profile': i_pfixdfw_collector_profile,
                            'override': override,
                            })

    def update(self,
               ipfix_dfw_collector_profile_id,
               i_pfixdfw_collector_profile,
               override=None,
               ):
        """
        Create or Replace IPFIX dfw collector profile. IPFIX data will be sent
        to IPFIX collector port.

        :type  ipfix_dfw_collector_profile_id: :class:`str`
        :param ipfix_dfw_collector_profile_id: IPFIX dfw collector profile id (required)
        :type  i_pfixdfw_collector_profile: :class:`com.vmware.nsx_policy.model_client.IPFIXDFWCollectorProfile`
        :param i_pfixdfw_collector_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPFIXDFWCollectorProfile`
        :return: com.vmware.nsx_policy.model.IPFIXDFWCollectorProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'ipfix_dfw_collector_profile_id': ipfix_dfw_collector_profile_id,
                            'i_pfixdfw_collector_profile': i_pfixdfw_collector_profile,
                            'override': override,
                            })
class IpfixDfwProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.ipfix_dfw_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _IpfixDfwProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               ipfix_dfw_profile_id,
               override=None,
               ):
        """
        API deletes IPFIX DFW Profile. Selected IPFIX Collectors will stop
        receiving flows.

        :type  ipfix_dfw_profile_id: :class:`str`
        :param ipfix_dfw_profile_id: IPFIX DFW Profile ID (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'ipfix_dfw_profile_id': ipfix_dfw_profile_id,
                            'override': override,
                            })

    def get(self,
            ipfix_dfw_profile_id,
            ):
        """
        API will return details of IPFIX DFW profile.

        :type  ipfix_dfw_profile_id: :class:`str`
        :param ipfix_dfw_profile_id: IPFIX DFW collection id (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPFIXDFWProfile`
        :return: com.vmware.nsx_policy.model.IPFIXDFWProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'ipfix_dfw_profile_id': ipfix_dfw_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        API provides list IPFIX DFW profiles available on selected logical DFW.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPFIXDFWProfileListResult`
        :return: com.vmware.nsx_policy.model.IPFIXDFWProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              ipfix_dfw_profile_id,
              i_pfixdfw_profile,
              override=None,
              ):
        """
        Create a new IPFIX DFW profile if the IPFIX DFW profile with given id
        does not already exist. If the IPFIX DFW profile with the given id
        already exists, patch with the existing IPFIX DFW profile.

        :type  ipfix_dfw_profile_id: :class:`str`
        :param ipfix_dfw_profile_id: IPFIX DFW Profile ID (required)
        :type  i_pfixdfw_profile: :class:`com.vmware.nsx_policy.model_client.IPFIXDFWProfile`
        :param i_pfixdfw_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'ipfix_dfw_profile_id': ipfix_dfw_profile_id,
                            'i_pfixdfw_profile': i_pfixdfw_profile,
                            'override': override,
                            })

    def update(self,
               ipfix_dfw_profile_id,
               i_pfixdfw_profile,
               override=None,
               ):
        """
        Create or replace IPFIX DFW profile. Config will start forwarding data
        to provided IPFIX DFW collector.

        :type  ipfix_dfw_profile_id: :class:`str`
        :param ipfix_dfw_profile_id: IPFIX DFW Profile ID (required)
        :type  i_pfixdfw_profile: :class:`com.vmware.nsx_policy.model_client.IPFIXDFWProfile`
        :param i_pfixdfw_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPFIXDFWProfile`
        :return: com.vmware.nsx_policy.model.IPFIXDFWProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'ipfix_dfw_profile_id': ipfix_dfw_profile_id,
                            'i_pfixdfw_profile': i_pfixdfw_profile,
                            'override': override,
                            })
class IpfixL2CollectorProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.ipfix_l2_collector_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _IpfixL2CollectorProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               ipfix_l2_collector_profile_id,
               override=None,
               ):
        """
        API deletes IPFIX collector profile. Flow forwarding to collector will
        be stopped.

        :type  ipfix_l2_collector_profile_id: :class:`str`
        :param ipfix_l2_collector_profile_id: IPFIX collector Profile id (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'ipfix_l2_collector_profile_id': ipfix_l2_collector_profile_id,
                            'override': override,
                            })

    def get(self,
            ipfix_l2_collector_profile_id,
            ):
        """
        API will return details of IPFIX collector profile.

        :type  ipfix_l2_collector_profile_id: :class:`str`
        :param ipfix_l2_collector_profile_id: IPFIX collector profile id (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPFIXL2CollectorProfile`
        :return: com.vmware.nsx_policy.model.IPFIXL2CollectorProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'ipfix_l2_collector_profile_id': ipfix_l2_collector_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        API will provide list of all IPFIX collector profiles and their
        details.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPFIXL2CollectorProfileListResult`
        :return: com.vmware.nsx_policy.model.IPFIXL2CollectorProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              ipfix_l2_collector_profile_id,
              i_pfix_l2_collector_profile,
              override=None,
              ):
        """
        Create a new IPFIX collector profile if the IPFIX collector profile
        with given id does not already exist. If the IPFIX collector profile
        with the given id already exists, patch with the existing IPFIX
        collector profile.

        :type  ipfix_l2_collector_profile_id: :class:`str`
        :param ipfix_l2_collector_profile_id: IPFIX collector profile id (required)
        :type  i_pfix_l2_collector_profile: :class:`com.vmware.nsx_policy.model_client.IPFIXL2CollectorProfile`
        :param i_pfix_l2_collector_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'ipfix_l2_collector_profile_id': ipfix_l2_collector_profile_id,
                            'i_pfix_l2_collector_profile': i_pfix_l2_collector_profile,
                            'override': override,
                            })

    def update(self,
               ipfix_l2_collector_profile_id,
               i_pfix_l2_collector_profile,
               override=None,
               ):
        """
        Create or Replace IPFIX collector profile. IPFIX data will be sent to
        IPFIX collector.

        :type  ipfix_l2_collector_profile_id: :class:`str`
        :param ipfix_l2_collector_profile_id: IPFIX collector profile id (required)
        :type  i_pfix_l2_collector_profile: :class:`com.vmware.nsx_policy.model_client.IPFIXL2CollectorProfile`
        :param i_pfix_l2_collector_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPFIXL2CollectorProfile`
        :return: com.vmware.nsx_policy.model.IPFIXL2CollectorProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'ipfix_l2_collector_profile_id': ipfix_l2_collector_profile_id,
                            'i_pfix_l2_collector_profile': i_pfix_l2_collector_profile,
                            'override': override,
                            })
class IpfixL2Profiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.ipfix_l2_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _IpfixL2ProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               ipfix_l2_profile_id,
               override=None,
               ):
        """
        API deletes IPFIX L2 Profile. Flow forwarding to selected collector
        will be stopped.

        :type  ipfix_l2_profile_id: :class:`str`
        :param ipfix_l2_profile_id: IPFIX L2 Profile ID (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'ipfix_l2_profile_id': ipfix_l2_profile_id,
                            'override': override,
                            })

    def get(self,
            ipfix_l2_profile_id,
            ):
        """
        API will return details of IPFIX L2 profile.

        :type  ipfix_l2_profile_id: :class:`str`
        :param ipfix_l2_profile_id: IPFIX L2 profile id (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPFIXL2Profile`
        :return: com.vmware.nsx_policy.model.IPFIXL2Profile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'ipfix_l2_profile_id': ipfix_l2_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        API provides list IPFIX L2 Profiles available on selected logical l2.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPFIXL2ProfileListResult`
        :return: com.vmware.nsx_policy.model.IPFIXL2ProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              ipfix_l2_profile_id,
              i_pfix_l2_profile,
              override=None,
              ):
        """
        Create a new IPFIX L2 profile if the IPFIX L2 profile with given id
        does not already exist. If the IPFIX L2 profile with the given id
        already exists, patch with the existing IPFIX L2 profile.

        :type  ipfix_l2_profile_id: :class:`str`
        :param ipfix_l2_profile_id: IPFIX L2 Profile ID (required)
        :type  i_pfix_l2_profile: :class:`com.vmware.nsx_policy.model_client.IPFIXL2Profile`
        :param i_pfix_l2_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'ipfix_l2_profile_id': ipfix_l2_profile_id,
                            'i_pfix_l2_profile': i_pfix_l2_profile,
                            'override': override,
                            })

    def update(self,
               ipfix_l2_profile_id,
               i_pfix_l2_profile,
               override=None,
               ):
        """
        Create or replace IPFIX L2 Profile. Profile is reusable entity. Single
        profile can attached multiple bindings e.g group, segment and port.

        :type  ipfix_l2_profile_id: :class:`str`
        :param ipfix_l2_profile_id: IPFIX L2 Profile ID (required)
        :type  i_pfix_l2_profile: :class:`com.vmware.nsx_policy.model_client.IPFIXL2Profile`
        :param i_pfix_l2_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPFIXL2Profile`
        :return: com.vmware.nsx_policy.model.IPFIXL2Profile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'ipfix_l2_profile_id': ipfix_l2_profile_id,
                            'i_pfix_l2_profile': i_pfix_l2_profile,
                            'override': override,
                            })
class IpsecVpnDpdProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.ipsec_vpn_dpd_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _IpsecVpnDpdProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               dpd_profile_id,
               ):
        """
        Delete custom dead peer detection (DPD) profile. Profile can not be
        deleted if profile has references to it.

        :type  dpd_profile_id: :class:`str`
        :param dpd_profile_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'dpd_profile_id': dpd_profile_id,
                            })

    def get(self,
            dpd_profile_id,
            ):
        """
        Get custom dead peer detection (DPD) profile, given the particular id.

        :type  dpd_profile_id: :class:`str`
        :param dpd_profile_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPSecVpnDpdProfile`
        :return: com.vmware.nsx_policy.model.IPSecVpnDpdProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'dpd_profile_id': dpd_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Get paginated list of all DPD Profiles.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPSecVpnDpdProfileListResult`
        :return: com.vmware.nsx_policy.model.IPSecVpnDpdProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              dpd_profile_id,
              ip_sec_vpn_dpd_profile,
              ):
        """
        Create or patch dead peer detection (DPD) profile. Any change in
        profile affects all sessions consuming this profile. System will be
        provisioned with system owned editable default DPD profile. Any change
        in profile affects all sessions consuming this profile.

        :type  dpd_profile_id: :class:`str`
        :param dpd_profile_id: (required)
        :type  ip_sec_vpn_dpd_profile: :class:`com.vmware.nsx_policy.model_client.IPSecVpnDpdProfile`
        :param ip_sec_vpn_dpd_profile: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'dpd_profile_id': dpd_profile_id,
                            'ip_sec_vpn_dpd_profile': ip_sec_vpn_dpd_profile,
                            })

    def update(self,
               dpd_profile_id,
               ip_sec_vpn_dpd_profile,
               ):
        """
        Create or patch dead peer detection (DPD) profile. Any change in
        profile affects all sessions consuming this profile. System will be
        provisioned with system owned editable default DPD profile. Any change
        in profile affects all sessions consuming this profile. Revision is
        optional for creation and required for update.

        :type  dpd_profile_id: :class:`str`
        :param dpd_profile_id: (required)
        :type  ip_sec_vpn_dpd_profile: :class:`com.vmware.nsx_policy.model_client.IPSecVpnDpdProfile`
        :param ip_sec_vpn_dpd_profile: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPSecVpnDpdProfile`
        :return: com.vmware.nsx_policy.model.IPSecVpnDpdProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'dpd_profile_id': dpd_profile_id,
                            'ip_sec_vpn_dpd_profile': ip_sec_vpn_dpd_profile,
                            })
class IpsecVpnIkeProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.ipsec_vpn_ike_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _IpsecVpnIkeProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               ike_profile_id,
               ):
        """
        Delete custom IKE Profile. Profile can not be deleted if profile has
        references to it.

        :type  ike_profile_id: :class:`str`
        :param ike_profile_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'ike_profile_id': ike_profile_id,
                            })

    def get(self,
            ike_profile_id,
            ):
        """
        Get custom IKE Profile, given the particular id.

        :type  ike_profile_id: :class:`str`
        :param ike_profile_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPSecVpnIkeProfile`
        :return: com.vmware.nsx_policy.model.IPSecVpnIkeProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'ike_profile_id': ike_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Get paginated list of all IKE Profiles.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPSecVpnIkeProfileListResult`
        :return: com.vmware.nsx_policy.model.IPSecVpnIkeProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              ike_profile_id,
              ip_sec_vpn_ike_profile,
              ):
        """
        Create or patch custom internet key exchange (IKE) Profile. IKE Profile
        is a reusable profile that captures IKE and phase one negotiation
        parameters. System will be pre provisioned with system owned editable
        default IKE profile and suggested set of profiles that can be used for
        peering with popular remote peers like AWS VPN. User can create custom
        profiles as needed. Any change in profile affects all sessions
        consuming this profile.

        :type  ike_profile_id: :class:`str`
        :param ike_profile_id: (required)
        :type  ip_sec_vpn_ike_profile: :class:`com.vmware.nsx_policy.model_client.IPSecVpnIkeProfile`
        :param ip_sec_vpn_ike_profile: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'ike_profile_id': ike_profile_id,
                            'ip_sec_vpn_ike_profile': ip_sec_vpn_ike_profile,
                            })

    def update(self,
               ike_profile_id,
               ip_sec_vpn_ike_profile,
               ):
        """
        Create or fully replace custom internet key exchange (IKE) Profile. IKE
        Profile is a reusable profile that captures IKE and phase one
        negotiation parameters. System will be pre provisioned with system
        owned editable default IKE profile and suggested set of profiles that
        can be used for peering with popular remote peers like AWS VPN. User
        can create custom profiles as needed. Any change in profile affects all
        sessions consuming this profile. Revision is optional for creation and
        required for update.

        :type  ike_profile_id: :class:`str`
        :param ike_profile_id: (required)
        :type  ip_sec_vpn_ike_profile: :class:`com.vmware.nsx_policy.model_client.IPSecVpnIkeProfile`
        :param ip_sec_vpn_ike_profile: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPSecVpnIkeProfile`
        :return: com.vmware.nsx_policy.model.IPSecVpnIkeProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'ike_profile_id': ike_profile_id,
                            'ip_sec_vpn_ike_profile': ip_sec_vpn_ike_profile,
                            })
class IpsecVpnTunnelProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.ipsec_vpn_tunnel_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _IpsecVpnTunnelProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               tunnel_profile_id,
               ):
        """
        Delete custom IPSec tunnel Profile. Profile can not be deleted if
        profile has references to it.

        :type  tunnel_profile_id: :class:`str`
        :param tunnel_profile_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'tunnel_profile_id': tunnel_profile_id,
                            })

    def get(self,
            tunnel_profile_id,
            ):
        """
        Get custom IPSec tunnel Profile, given the particular id.

        :type  tunnel_profile_id: :class:`str`
        :param tunnel_profile_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPSecVpnTunnelProfile`
        :return: com.vmware.nsx_policy.model.IPSecVpnTunnelProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'tunnel_profile_id': tunnel_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Get paginated list of all IPSec tunnel Profiles.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPSecVpnTunnelProfileListResult`
        :return: com.vmware.nsx_policy.model.IPSecVpnTunnelProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              tunnel_profile_id,
              ip_sec_vpn_tunnel_profile,
              ):
        """
        Create or patch custom IPSec tunnel profile. IPSec tunnel profile is a
        reusable profile that captures phase two negotiation parameters and
        tunnel properties. System will be provisioned with system owned
        editable default IPSec tunnel profile. Any change in profile affects
        all sessions consuming this profile.

        :type  tunnel_profile_id: :class:`str`
        :param tunnel_profile_id: (required)
        :type  ip_sec_vpn_tunnel_profile: :class:`com.vmware.nsx_policy.model_client.IPSecVpnTunnelProfile`
        :param ip_sec_vpn_tunnel_profile: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'tunnel_profile_id': tunnel_profile_id,
                            'ip_sec_vpn_tunnel_profile': ip_sec_vpn_tunnel_profile,
                            })

    def update(self,
               tunnel_profile_id,
               ip_sec_vpn_tunnel_profile,
               ):
        """
        Create or fully replace custom IPSec tunnel profile. IPSec tunnel
        profile is a reusable profile that captures phase two negotiation
        parameters and tunnel properties. System will be provisioned with
        system owned editable default IPSec tunnel profile. Any change in
        profile affects all sessions consuming this profile. Revision is
        optional for creation and required for update.

        :type  tunnel_profile_id: :class:`str`
        :param tunnel_profile_id: (required)
        :type  ip_sec_vpn_tunnel_profile: :class:`com.vmware.nsx_policy.model_client.IPSecVpnTunnelProfile`
        :param ip_sec_vpn_tunnel_profile: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IPSecVpnTunnelProfile`
        :return: com.vmware.nsx_policy.model.IPSecVpnTunnelProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'tunnel_profile_id': tunnel_profile_id,
                            'ip_sec_vpn_tunnel_profile': ip_sec_vpn_tunnel_profile,
                            })
class Ipv6DadProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.ipv6_dad_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _Ipv6DadProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               dad_profile_id,
               override=None,
               ):
        """
        Delete IPv6 DAD profile

        :type  dad_profile_id: :class:`str`
        :param dad_profile_id: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'dad_profile_id': dad_profile_id,
                            'override': override,
                            })

    def get(self,
            dad_profile_id,
            ):
        """
        Read IPv6 DAD profile

        :type  dad_profile_id: :class:`str`
        :param dad_profile_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Ipv6DadProfile`
        :return: com.vmware.nsx_policy.model.Ipv6DadProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'dad_profile_id': dad_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all IPv6 DAD profile instances

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Ipv6DadProfileListResult`
        :return: com.vmware.nsx_policy.model.Ipv6DadProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              dad_profile_id,
              ipv6_dad_profile,
              override=None,
              ):
        """
        If profile with the dad-profile-id is not already present, create a new
        IPv6 DAD profile instance. If it already exists, update the IPv6 DAD
        profile instance with specified attributes.

        :type  dad_profile_id: :class:`str`
        :param dad_profile_id: (required)
        :type  ipv6_dad_profile: :class:`com.vmware.nsx_policy.model_client.Ipv6DadProfile`
        :param ipv6_dad_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'dad_profile_id': dad_profile_id,
                            'ipv6_dad_profile': ipv6_dad_profile,
                            'override': override,
                            })

    def update(self,
               dad_profile_id,
               ipv6_dad_profile,
               override=None,
               ):
        """
        If profile with the dad-profile-id is not already present, create a new
        IPv6 DAD profile instance. If it already exists, replace the IPv6 DAD
        profile instance with this object.

        :type  dad_profile_id: :class:`str`
        :param dad_profile_id: (required)
        :type  ipv6_dad_profile: :class:`com.vmware.nsx_policy.model_client.Ipv6DadProfile`
        :param ipv6_dad_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Ipv6DadProfile`
        :return: com.vmware.nsx_policy.model.Ipv6DadProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'dad_profile_id': dad_profile_id,
                            'ipv6_dad_profile': ipv6_dad_profile,
                            'override': override,
                            })
class Ipv6NdraProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.ipv6_ndra_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _Ipv6NdraProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               ndra_profile_id,
               override=None,
               ):
        """
        Delete IPv6 NDRA profile

        :type  ndra_profile_id: :class:`str`
        :param ndra_profile_id: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'ndra_profile_id': ndra_profile_id,
                            'override': override,
                            })

    def get(self,
            ndra_profile_id,
            ):
        """
        Read IPv6 NDRA profile

        :type  ndra_profile_id: :class:`str`
        :param ndra_profile_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Ipv6NdraProfile`
        :return: com.vmware.nsx_policy.model.Ipv6NdraProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'ndra_profile_id': ndra_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all IPv6 NDRA profile instances

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Ipv6NdraProfileListResult`
        :return: com.vmware.nsx_policy.model.Ipv6NdraProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              ndra_profile_id,
              ipv6_ndra_profile,
              override=None,
              ):
        """
        If profile with the ndra-profile-id is not already present, create a
        new IPv6 NDRA profile instance. If it already exists, update the IPv6
        NDRA profile instance with specified attributes.

        :type  ndra_profile_id: :class:`str`
        :param ndra_profile_id: (required)
        :type  ipv6_ndra_profile: :class:`com.vmware.nsx_policy.model_client.Ipv6NdraProfile`
        :param ipv6_ndra_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'ndra_profile_id': ndra_profile_id,
                            'ipv6_ndra_profile': ipv6_ndra_profile,
                            'override': override,
                            })

    def update(self,
               ndra_profile_id,
               ipv6_ndra_profile,
               override=None,
               ):
        """
        If profile with the ndra-profile-id is not already present, create a
        new IPv6 NDRA profile instance. If it already exists, replace the IPv6
        NDRA profile instance with this object.

        :type  ndra_profile_id: :class:`str`
        :param ndra_profile_id: (required)
        :type  ipv6_ndra_profile: :class:`com.vmware.nsx_policy.model_client.Ipv6NdraProfile`
        :param ipv6_ndra_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Ipv6NdraProfile`
        :return: com.vmware.nsx_policy.model.Ipv6NdraProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'ndra_profile_id': ndra_profile_id,
                            'ipv6_ndra_profile': ipv6_ndra_profile,
                            'override': override,
                            })
class L7AccessProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.l7_access_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _L7AccessProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               l7_access_profile_id,
               override=None,
               ):
        """
        API will delete L7 Access Profile

        :type  l7_access_profile_id: :class:`str`
        :param l7_access_profile_id: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'l7_access_profile_id': l7_access_profile_id,
                            'override': override,
                            })

    def get(self,
            l7_access_profile_id,
            ):
        """
        API will get L7 Access Profile

        :type  l7_access_profile_id: :class:`str`
        :param l7_access_profile_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.L7AccessProfile`
        :return: com.vmware.nsx_policy.model.L7AccessProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'l7_access_profile_id': l7_access_profile_id,
                            })

    def list(self,
             cursor=None,
             include_entry_count=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        API will list all l7 access Profiles

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_entry_count: :class:`bool` or ``None``
        :param include_entry_count: Include the count of entries in L7 Profile (optional, default to
            false)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.L7AccessProfileListResult`
        :return: com.vmware.nsx_policy.model.L7AccessProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_entry_count': include_entry_count,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              l7_access_profile_id,
              l7_access_profile,
              override=None,
              ):
        """
        API will create/update L7 Access Profile

        :type  l7_access_profile_id: :class:`str`
        :param l7_access_profile_id: L7 Access Profile ID (required)
        :type  l7_access_profile: :class:`com.vmware.nsx_policy.model_client.L7AccessProfile`
        :param l7_access_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.L7AccessProfile`
        :return: com.vmware.nsx_policy.model.L7AccessProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'l7_access_profile_id': l7_access_profile_id,
                            'l7_access_profile': l7_access_profile,
                            'override': override,
                            })

    def update(self,
               l7_access_profile_id,
               l7_access_profile,
               override=None,
               ):
        """
        API will update L7 Access Profile

        :type  l7_access_profile_id: :class:`str`
        :param l7_access_profile_id: (required)
        :type  l7_access_profile: :class:`com.vmware.nsx_policy.model_client.L7AccessProfile`
        :param l7_access_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.L7AccessProfile`
        :return: com.vmware.nsx_policy.model.L7AccessProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'l7_access_profile_id': l7_access_profile_id,
                            'l7_access_profile': l7_access_profile,
                            'override': override,
                            })
class Labels(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.labels'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _LabelsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               label_id,
               ):
        """
        Delete PolicyLabel object

        :type  label_id: :class:`str`
        :param label_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'label_id': label_id,
                            })

    def get(self,
            label_id,
            ):
        """
        Read a label.

        :type  label_id: :class:`str`
        :param label_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyLabel`
        :return: com.vmware.nsx_policy.model.PolicyLabel
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'label_id': label_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all labels for infra.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyLabelListResult`
        :return: com.vmware.nsx_policy.model.PolicyLabelListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              label_id,
              policy_label,
              ):
        """
        Create label if not exists, otherwise take the partial updates. Note,
        once the label is created type attribute can not be changed.

        :type  label_id: :class:`str`
        :param label_id: (required)
        :type  policy_label: :class:`com.vmware.nsx_policy.model_client.PolicyLabel`
        :param policy_label: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'label_id': label_id,
                            'policy_label': policy_label,
                            })

    def update(self,
               label_id,
               policy_label,
               ):
        """
        Create label if not exists, otherwise replaces the existing label. If
        label already exists then type attribute cannot be changed.

        :type  label_id: :class:`str`
        :param label_id: (required)
        :type  policy_label: :class:`com.vmware.nsx_policy.model_client.PolicyLabel`
        :param policy_label: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyLabel`
        :return: com.vmware.nsx_policy.model.PolicyLabel
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'label_id': label_id,
                            'policy_label': policy_label,
                            })
class LatencyProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.latency_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _LatencyProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               profile_id,
               ):
        """
        Delete an existing latency profile

        :type  profile_id: :class:`str`
        :param profile_id: Latency profile id (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'profile_id': profile_id,
                            })

    def get(self,
            profile_id,
            ):
        """
        Read latency profile.

        :type  profile_id: :class:`str`
        :param profile_id: Latency profile id (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyLatencyStatProfile`
        :return: com.vmware.nsx_policy.model.PolicyLatencyStatProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'profile_id': profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List latency profiles

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyLatencyStatProfileListResult`
        :return: com.vmware.nsx_policy.model.PolicyLatencyStatProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              profile_id,
              policy_latency_stat_profile,
              ):
        """
        Patch latency profile.

        :type  profile_id: :class:`str`
        :param profile_id: Latency profile id (required)
        :type  policy_latency_stat_profile: :class:`com.vmware.nsx_policy.model_client.PolicyLatencyStatProfile`
        :param policy_latency_stat_profile: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyLatencyStatProfile`
        :return: com.vmware.nsx_policy.model.PolicyLatencyStatProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'profile_id': profile_id,
                            'policy_latency_stat_profile': policy_latency_stat_profile,
                            })

    def update(self,
               profile_id,
               policy_latency_stat_profile,
               ):
        """
        Create or Replace latency profile.

        :type  profile_id: :class:`str`
        :param profile_id: Latency profile id (required)
        :type  policy_latency_stat_profile: :class:`com.vmware.nsx_policy.model_client.PolicyLatencyStatProfile`
        :param policy_latency_stat_profile: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyLatencyStatProfile`
        :return: com.vmware.nsx_policy.model.PolicyLatencyStatProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'profile_id': profile_id,
                            'policy_latency_stat_profile': policy_latency_stat_profile,
                            })
class LbAppProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.lb_app_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _LbAppProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               lb_app_profile_id,
               force=None,
               ):
        """
        Delete the LBAppProfile along with all the entities contained by this
        LBAppProfile. This API is deprecated for the NSX-T Load Balancer, but
        not for the NSX-T Distributed Load Balancer.

        :type  lb_app_profile_id: :class:`str`
        :param lb_app_profile_id: LBAppProfile ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'lb_app_profile_id': lb_app_profile_id,
                            'force': force,
                            })

    def get(self,
            lb_app_profile_id,
            ):
        """
        Read a LBAppProfile. This API is deprecated for the NSX-T Load
        Balancer, but not for the NSX-T Distributed Load Balancer.

        :type  lb_app_profile_id: :class:`str`
        :param lb_app_profile_id: LBAppProfile ID (required)
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.LBAppProfile
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.LBAppProfile`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'lb_app_profile_id': lb_app_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all LBAppProfiles. This API is deprecated for the
        NSX-T Load Balancer, but not for the NSX-T Distributed Load Balancer.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBAppProfileListResult`
        :return: com.vmware.nsx_policy.model.LBAppProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              lb_app_profile_id,
              lb_app_profile,
              ):
        """
        If a LBAppProfile with the lb-app-profile-id is not already present,
        create a new LBAppProfile. If it already exists, update the
        LBAppProfile. This is a full replace. This API is deprecated for the
        NSX-T Load Balancer, but not for the NSX-T Distributed Load Balancer.

        :type  lb_app_profile_id: :class:`str`
        :param lb_app_profile_id: LBAppProfile ID (required)
        :type  lb_app_profile: :class:`vmware.vapi.struct.VapiStruct`
        :param lb_app_profile: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.LBAppProfile`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'lb_app_profile_id': lb_app_profile_id,
                            'lb_app_profile': lb_app_profile,
                            })

    def update(self,
               lb_app_profile_id,
               lb_app_profile,
               ):
        """
        If a LBAppProfile with the lb-app-profile-id is not already present,
        create a new LBAppProfile. If it already exists, update the
        LBAppProfile. This is a full replace. This API is deprecated for the
        NSX-T Load Balancer, but not for the NSX-T Distributed Load Balancer.

        :type  lb_app_profile_id: :class:`str`
        :param lb_app_profile_id: LBAppProfile ID (required)
        :type  lb_app_profile: :class:`vmware.vapi.struct.VapiStruct`
        :param lb_app_profile: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.LBAppProfile`.
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.LBAppProfile
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.LBAppProfile`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'lb_app_profile_id': lb_app_profile_id,
                            'lb_app_profile': lb_app_profile,
                            })
class LbClientSslProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.lb_client_ssl_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _LbClientSslProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               lb_client_ssl_profile_id,
               force=None,
               ):
        """
        Delete the LBClientSslProfile along with all the entities contained by
        this LBClientSslProfile. 
        
        NSX-T Load Balancer is deprecated. 
        Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  lb_client_ssl_profile_id: :class:`str`
        :param lb_client_ssl_profile_id: LBClientSslProfile ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbClientSslProfiles.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'lb_client_ssl_profile_id': lb_client_ssl_profile_id,
                            'force': force,
                            })

    def get(self,
            lb_client_ssl_profile_id,
            ):
        """
        Read a LBClientSslProfile. 
        
        NSX-T Load Balancer is deprecated. 
        Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  lb_client_ssl_profile_id: :class:`str`
        :param lb_client_ssl_profile_id: LBClientSslProfile ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBClientSslProfile`
        :return: com.vmware.nsx_policy.model.LBClientSslProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbClientSslProfiles.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'lb_client_ssl_profile_id': lb_client_ssl_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all LBClientSslProfiles. 
        
        NSX-T Load Balancer is deprecated. 
        Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBClientSslProfileListResult`
        :return: com.vmware.nsx_policy.model.LBClientSslProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbClientSslProfiles.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              lb_client_ssl_profile_id,
              lb_client_ssl_profile,
              ):
        """
        If a LBClientSslProfile with the lb-client-ssl-profile-id is not
        already present, create a new LBClientSslProfile. If it already exists,
        update the LBClientSslProfile. This is a full replace. 
        
        NSX-T Load Balancer is deprecated. 
        Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  lb_client_ssl_profile_id: :class:`str`
        :param lb_client_ssl_profile_id: LBClientSslProfile ID (required)
        :type  lb_client_ssl_profile: :class:`com.vmware.nsx_policy.model_client.LBClientSslProfile`
        :param lb_client_ssl_profile: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbClientSslProfiles.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'lb_client_ssl_profile_id': lb_client_ssl_profile_id,
                            'lb_client_ssl_profile': lb_client_ssl_profile,
                            })

    def update(self,
               lb_client_ssl_profile_id,
               lb_client_ssl_profile,
               ):
        """
        If a LBClientSslProfile with the lb-client-ssl-profile-id is not
        already present, create a new LBClientSslProfile. If it already exists,
        update the LBClientSslProfile. This is a full replace. 
        
        NSX-T Load Balancer is deprecated. 
        Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  lb_client_ssl_profile_id: :class:`str`
        :param lb_client_ssl_profile_id: LBClientSslProfile ID (required)
        :type  lb_client_ssl_profile: :class:`com.vmware.nsx_policy.model_client.LBClientSslProfile`
        :param lb_client_ssl_profile: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBClientSslProfile`
        :return: com.vmware.nsx_policy.model.LBClientSslProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbClientSslProfiles.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'lb_client_ssl_profile_id': lb_client_ssl_profile_id,
                            'lb_client_ssl_profile': lb_client_ssl_profile,
                            })
class LbMonitorProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.lb_monitor_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _LbMonitorProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               lb_monitor_profile_id,
               force=None,
               ):
        """
        Delete the LBMonitorProfile along with all the entities contained by
        this LBMonitorProfile. 
        
        NSX-T Load Balancer is deprecated. 
        Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  lb_monitor_profile_id: :class:`str`
        :param lb_monitor_profile_id: LBMonitorProfile ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbMonitorProfiles.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'lb_monitor_profile_id': lb_monitor_profile_id,
                            'force': force,
                            })

    def get(self,
            lb_monitor_profile_id,
            ):
        """
        Read a LBMonitorProfile. 
        
        NSX-T Load Balancer is deprecated. 
        Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  lb_monitor_profile_id: :class:`str`
        :param lb_monitor_profile_id: LBMonitorProfile ID (required)
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.LBMonitorProfile
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.LBMonitorProfile`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbMonitorProfiles.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'lb_monitor_profile_id': lb_monitor_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all LBMonitorProfiles for infra. 
        
        NSX-T Load Balancer is deprecated. 
        Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBMonitorProfileListResult`
        :return: com.vmware.nsx_policy.model.LBMonitorProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbMonitorProfiles.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              lb_monitor_profile_id,
              lb_monitor_profile,
              ):
        """
        If a LBMonitorProfile with the lb-monitor-profile-id is not already
        present, create a new LBMonitorProfile. If it already exists, update
        the LBMonitorProfile. This is a full replace. 
        
        NSX-T Load Balancer is deprecated. 
        Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  lb_monitor_profile_id: :class:`str`
        :param lb_monitor_profile_id: LBMonitorProfile ID (required)
        :type  lb_monitor_profile: :class:`vmware.vapi.struct.VapiStruct`
        :param lb_monitor_profile: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.LBMonitorProfile`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbMonitorProfiles.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'lb_monitor_profile_id': lb_monitor_profile_id,
                            'lb_monitor_profile': lb_monitor_profile,
                            })

    def update(self,
               lb_monitor_profile_id,
               lb_monitor_profile,
               ):
        """
        If a LBMonitorProfile with the lb-monitor-profile-id is not already
        present, create a new LBMonitorProfile. If it already exists, update
        the LBMonitorProfile. This is a full replace. 
        
        NSX-T Load Balancer is deprecated. 
        Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  lb_monitor_profile_id: :class:`str`
        :param lb_monitor_profile_id: LBMonitorProfile ID (required)
        :type  lb_monitor_profile: :class:`vmware.vapi.struct.VapiStruct`
        :param lb_monitor_profile: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.LBMonitorProfile`.
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.LBMonitorProfile
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.LBMonitorProfile`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbMonitorProfiles.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'lb_monitor_profile_id': lb_monitor_profile_id,
                            'lb_monitor_profile': lb_monitor_profile,
                            })
class LbNodeUsage(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.lb_node_usage'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _LbNodeUsageStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            node_path,
            ):
        """
        API is used to retrieve node usage for load balancer which contains
        basic information, LB entity usages and capacities for the given node.
        Currently only edge node is supported. The parameter
        ?node_path=<node-path> is required. For example, ?node_path=
        /infra/sites/default/enforcement-points/default/edge-clusters/
        85175e0b-4d74-461d-83e1-f3b785adef9c/edge-nodes/
        86e077c0-449f-11e9-87c8-02004eb37029. 
        
        NSX-T Load Balancer is deprecated. 
        Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  node_path: :class:`str`
        :param node_path: The node path for load balancer node usage (required)
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.LBNodeUsage
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.LBNodeUsage`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbNodeUsage.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'node_path': node_path,
                            })
class LbNodeUsageSummary(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.lb_node_usage_summary'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _LbNodeUsageSummaryStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            enforcement_point_path=None,
            include_usages=None,
            ):
        """
        The API is used to retrieve the load balancer node usage summary of all
        nodes for every enforcement point. - If the parameter
        ?include_usages=true exists, the property node_usages are included in
        response. By default, the property node_usages is not included in
        response. - If parameter
        ?enforcement_point_path=<enforcement-point-path> exists, only node
        usage summary from specific enforcement point is included in response.
        If no enforcement point path is specified, information will be
        aggregated from each enforcement point. 
        
        NSX-T Load Balancer is deprecated. 
        Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: enforcement point path (optional)
        :type  include_usages: :class:`bool` or ``None``
        :param include_usages: Whether to include usages (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.AggregateLBNodeUsageSummary`
        :return: com.vmware.nsx_policy.model.AggregateLBNodeUsageSummary
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbNodeUsageSummary.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'enforcement_point_path': enforcement_point_path,
                            'include_usages': include_usages,
                            })
class LbPersistenceProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.lb_persistence_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _LbPersistenceProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               lb_persistence_profile_id,
               force=None,
               ):
        """
        Delete the LBPersistenceProfile along with all the entities contained
        by this LBPersistenceProfile. This API is deprecated for the NSX-T Load
        Balancer, but not for the NSX-T Distributed Load Balancer.

        :type  lb_persistence_profile_id: :class:`str`
        :param lb_persistence_profile_id: LBPersistenceProfile ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'lb_persistence_profile_id': lb_persistence_profile_id,
                            'force': force,
                            })

    def get(self,
            lb_persistence_profile_id,
            ):
        """
        Read a LBPersistenceProfile. This API is deprecated for the NSX-T Load
        Balancer, but not for the NSX-T Distributed Load Balancer.

        :type  lb_persistence_profile_id: :class:`str`
        :param lb_persistence_profile_id: LBPersistenceProfile ID (required)
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.LBPersistenceProfile
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.LBPersistenceProfile`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'lb_persistence_profile_id': lb_persistence_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all LBPersistenceProfiles for infra. This API is
        deprecated for the NSX-T Load Balancer, but not for the NSX-T
        Distributed Load Balancer.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBPersistenceProfileListResult`
        :return: com.vmware.nsx_policy.model.LBPersistenceProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              lb_persistence_profile_id,
              lb_persistence_profile,
              ):
        """
        If a LBPersistenceProfile with the lb-persistence-profile-id is not
        already present, create a new LBPersistenceProfile. If it already
        exists, update the LBPersistenceProfile. This is a full replace. This
        API is deprecated for the NSX-T Load Balancer, but not for the NSX-T
        Distributed Load Balancer.

        :type  lb_persistence_profile_id: :class:`str`
        :param lb_persistence_profile_id: LBPersistenceProfile ID (required)
        :type  lb_persistence_profile: :class:`vmware.vapi.struct.VapiStruct`
        :param lb_persistence_profile: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.LBPersistenceProfile`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'lb_persistence_profile_id': lb_persistence_profile_id,
                            'lb_persistence_profile': lb_persistence_profile,
                            })

    def update(self,
               lb_persistence_profile_id,
               lb_persistence_profile,
               ):
        """
        If a LBPersistenceProfile with the lb-persistence-profile-id is not
        already present, create a new LBPersistenceProfile. If it already
        exists, update the LBPersistenceProfile. This is a full replace. This
        API is deprecated for the NSX-T Load Balancer, but not for the NSX-T
        Distributed Load Balancer.

        :type  lb_persistence_profile_id: :class:`str`
        :param lb_persistence_profile_id: LBPersistenceProfile ID (required)
        :type  lb_persistence_profile: :class:`vmware.vapi.struct.VapiStruct`
        :param lb_persistence_profile: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.LBPersistenceProfile`.
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.LBPersistenceProfile
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.LBPersistenceProfile`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'lb_persistence_profile_id': lb_persistence_profile_id,
                            'lb_persistence_profile': lb_persistence_profile,
                            })
class LbPools(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.lb_pools'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _LbPoolsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               lb_pool_id,
               force=None,
               ):
        """
        Delete the LBPool along with all the entities contained by this LBPool.
        This API is deprecated for the NSX-T Load Balancer, but not for the
        NSX-T Distributed Load Balancer.

        :type  lb_pool_id: :class:`str`
        :param lb_pool_id: LBPool ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'lb_pool_id': lb_pool_id,
                            'force': force,
                            })

    def get(self,
            lb_pool_id,
            ):
        """
        Read a LBPool. This API is deprecated for the NSX-T Load Balancer, but
        not for the NSX-T Distributed Load Balancer.

        :type  lb_pool_id: :class:`str`
        :param lb_pool_id: LBPool ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBPool`
        :return: com.vmware.nsx_policy.model.LBPool
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'lb_pool_id': lb_pool_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all LBPools. This API is deprecated for the NSX-T
        Load Balancer, but not for the NSX-T Distributed Load Balancer.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBPoolListResult`
        :return: com.vmware.nsx_policy.model.LBPoolListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              lb_pool_id,
              lb_pool,
              ):
        """
        If a LBPool with the lb-pool-id is not already present, create a new
        LBPool. If it already exists, update the LBPool. This is a full
        replace. This API is deprecated for the NSX-T Load Balancer, but not
        for the NSX-T Distributed Load Balancer.

        :type  lb_pool_id: :class:`str`
        :param lb_pool_id: LBPool ID (required)
        :type  lb_pool: :class:`com.vmware.nsx_policy.model_client.LBPool`
        :param lb_pool: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'lb_pool_id': lb_pool_id,
                            'lb_pool': lb_pool,
                            })

    def update(self,
               lb_pool_id,
               lb_pool,
               ):
        """
        If a LBPool with the lb-pool-id is not already present, create a new
        LBPool. If it already exists, update the LBPool. This is a full
        replace. This API is deprecated for the NSX-T Load Balancer, but not
        for the NSX-T Distributed Load Balancer.

        :type  lb_pool_id: :class:`str`
        :param lb_pool_id: LBPool ID (required)
        :type  lb_pool: :class:`com.vmware.nsx_policy.model_client.LBPool`
        :param lb_pool: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBPool`
        :return: com.vmware.nsx_policy.model.LBPool
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'lb_pool_id': lb_pool_id,
                            'lb_pool': lb_pool,
                            })
class LbServerSslProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.lb_server_ssl_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _LbServerSslProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               lb_server_ssl_profile_id,
               force=None,
               ):
        """
        Delete the LBServerSslProfile along with all the entities contained by
        this LBServerSslProfile. 
        
        NSX-T Load Balancer is deprecated. 
        Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  lb_server_ssl_profile_id: :class:`str`
        :param lb_server_ssl_profile_id: LBServerSslProfile ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbServerSslProfiles.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'lb_server_ssl_profile_id': lb_server_ssl_profile_id,
                            'force': force,
                            })

    def get(self,
            lb_server_ssl_profile_id,
            ):
        """
        Read a LBServerSslProfile. 
        
        NSX-T Load Balancer is deprecated. 
        Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  lb_server_ssl_profile_id: :class:`str`
        :param lb_server_ssl_profile_id: LBServerSslProfile ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBServerSslProfile`
        :return: com.vmware.nsx_policy.model.LBServerSslProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbServerSslProfiles.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'lb_server_ssl_profile_id': lb_server_ssl_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all LBServerSslProfiles. 
        
        NSX-T Load Balancer is deprecated. 
        Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBServerSslProfileListResult`
        :return: com.vmware.nsx_policy.model.LBServerSslProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbServerSslProfiles.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              lb_server_ssl_profile_id,
              lb_server_ssl_profile,
              ):
        """
        If a LBServerSslProfile with the lb-server-ssl-profile-id is not
        already present, create a new LBServerSslProfile. If it already exists,
        update the LBServerSslProfile. This is a full replace. 
        
        NSX-T Load Balancer is deprecated. 
        Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  lb_server_ssl_profile_id: :class:`str`
        :param lb_server_ssl_profile_id: LBServerSslProfile ID (required)
        :type  lb_server_ssl_profile: :class:`com.vmware.nsx_policy.model_client.LBServerSslProfile`
        :param lb_server_ssl_profile: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbServerSslProfiles.patch is deprecated.', DeprecationWarning)
        return self._invoke('patch',
                            {
                            'lb_server_ssl_profile_id': lb_server_ssl_profile_id,
                            'lb_server_ssl_profile': lb_server_ssl_profile,
                            })

    def update(self,
               lb_server_ssl_profile_id,
               lb_server_ssl_profile,
               ):
        """
        If a LBServerSslProfile with the lb-server-ssl-profile-id is not
        already present, create a new LBServerSslProfile. If it already exists,
        update the LBServerSslProfile. This is a full replace. 
        
        NSX-T Load Balancer is deprecated. 
        Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  lb_server_ssl_profile_id: :class:`str`
        :param lb_server_ssl_profile_id: LBServerSslProfile ID (required)
        :type  lb_server_ssl_profile: :class:`com.vmware.nsx_policy.model_client.LBServerSslProfile`
        :param lb_server_ssl_profile: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBServerSslProfile`
        :return: com.vmware.nsx_policy.model.LBServerSslProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbServerSslProfiles.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'lb_server_ssl_profile_id': lb_server_ssl_profile_id,
                            'lb_server_ssl_profile': lb_server_ssl_profile,
                            })
class LbServiceUsageSummary(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.lb_service_usage_summary'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _LbServiceUsageSummaryStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            include_usages=None,
            ):
        """
        API is used to retrieve the load balancer usage summary for all load
        balancer services. If the parameter ?include_usages=true exists, the
        property service-usages is included in the response. By default,
        service-usages is not included in the response. This API is deprecated
        for the NSX-T Load Balancer, but not for the NSX-T Distributed Load
        Balancer.

        :type  include_usages: :class:`bool` or ``None``
        :param include_usages: Whether to include usages (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBServiceUsageSummary`
        :return: com.vmware.nsx_policy.model.LBServiceUsageSummary
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'include_usages': include_usages,
                            })
class LbServices(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.lb_services'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _LbServicesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               lb_service_id,
               force=None,
               ):
        """
        Delete the LBService along with all the entities contained by this
        LBService. This API is deprecated for the NSX-T Load Balancer, but not
        for the NSX-T Distributed Load Balancer.

        :type  lb_service_id: :class:`str`
        :param lb_service_id: LBService ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'lb_service_id': lb_service_id,
                            'force': force,
                            })

    def get(self,
            lb_service_id,
            ):
        """
        Read an LBService. This API is deprecated for the NSX-T Load Balancer,
        but not for the NSX-T Distributed Load Balancer.

        :type  lb_service_id: :class:`str`
        :param lb_service_id: LBService ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBService`
        :return: com.vmware.nsx_policy.model.LBService
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'lb_service_id': lb_service_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all LBService. This API is deprecated for the NSX-T
        Load Balancer, but not for the NSX-T Distributed Load Balancer.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBServiceListResult`
        :return: com.vmware.nsx_policy.model.LBServiceListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              lb_service_id,
              lb_service,
              ):
        """
        If a LBService with the lb-service-id is not already present, create a
        new LBService. If it already exists, update the LBService. This is a
        full replace. This API is deprecated for the NSX-T Load Balancer, but
        not for the NSX-T Distributed Load Balancer.

        :type  lb_service_id: :class:`str`
        :param lb_service_id: LBService ID (required)
        :type  lb_service: :class:`com.vmware.nsx_policy.model_client.LBService`
        :param lb_service: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'lb_service_id': lb_service_id,
                            'lb_service': lb_service,
                            })

    def update(self,
               lb_service_id,
               lb_service,
               ):
        """
        If a LBService with the lb-service-id is not already present, create a
        new LBService. If it already exists, update the LBService. This is a
        full replace. This API is deprecated for the NSX-T Load Balancer, but
        not for the NSX-T Distributed Load Balancer.

        :type  lb_service_id: :class:`str`
        :param lb_service_id: LBService ID (required)
        :type  lb_service: :class:`com.vmware.nsx_policy.model_client.LBService`
        :param lb_service: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBService`
        :return: com.vmware.nsx_policy.model.LBService
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'lb_service_id': lb_service_id,
                            'lb_service': lb_service,
                            })
class LbSslCiphersAndProtocols(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.lb_ssl_ciphers_and_protocols'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _LbSslCiphersAndProtocolsStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Retrieve a list of supported SSL ciphers and protocols. 
        
        NSX-T Load Balancer is deprecated. 
        Please take advantage of NSX Advanced Load Balancer. 
        Refer to Policy > Networking > Network Services > Advanced Load
        Balancing section of the API guide.

        .. deprecated:: unknown

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LbSslCipherAndProtocolListResult`
        :return: com.vmware.nsx_policy.model.LbSslCipherAndProtocolListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx_policy.infra.LbSslCiphersAndProtocols.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class LbVirtualServers(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.lb_virtual_servers'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _LbVirtualServersStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               lb_virtual_server_id,
               force=None,
               ):
        """
        Delete the LBVirtualServer along with all the entities contained by
        this LBVirtualServer. This API is deprecated for the NSX-T Load
        Balancer, but not for the NSX-T Distributed Load Balancer.

        :type  lb_virtual_server_id: :class:`str`
        :param lb_virtual_server_id: LBVirtualServer ID (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'lb_virtual_server_id': lb_virtual_server_id,
                            'force': force,
                            })

    def get(self,
            lb_virtual_server_id,
            ):
        """
        Read a LBVirtualServer. This API is deprecated for the NSX-T Load
        Balancer, but not for the NSX-T Distributed Load Balancer.

        :type  lb_virtual_server_id: :class:`str`
        :param lb_virtual_server_id: LBVirtualServer ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBVirtualServer`
        :return: com.vmware.nsx_policy.model.LBVirtualServer
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'lb_virtual_server_id': lb_virtual_server_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all LBVirtualServers. This API is deprecated for the
        NSX-T Load Balancer, but not for the NSX-T Distributed Load Balancer.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBVirtualServerListResult`
        :return: com.vmware.nsx_policy.model.LBVirtualServerListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              lb_virtual_server_id,
              lb_virtual_server,
              ):
        """
        If a LBVirtualServer with the lb-virtual-server-id is not already
        present, create a new LBVirtualServer. If it already exists, update the
        LBVirtualServer. This is a full replace. This API is deprecated for the
        NSX-T Load Balancer, but not for the NSX-T Distributed Load Balancer.

        :type  lb_virtual_server_id: :class:`str`
        :param lb_virtual_server_id: LBVirtualServer ID (required)
        :type  lb_virtual_server: :class:`com.vmware.nsx_policy.model_client.LBVirtualServer`
        :param lb_virtual_server: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'lb_virtual_server_id': lb_virtual_server_id,
                            'lb_virtual_server': lb_virtual_server,
                            })

    def update(self,
               lb_virtual_server_id,
               lb_virtual_server,
               ):
        """
        If a LBVirtualServer with the lb-virtual-server-id is not already
        present, create a new LBVirtualServer. If it already exists, update the
        LBVirtualServer. This is a full replace. This API is deprecated for the
        NSX-T Load Balancer, but not for the NSX-T Distributed Load Balancer.

        :type  lb_virtual_server_id: :class:`str`
        :param lb_virtual_server_id: LBVirtualServer ID (required)
        :type  lb_virtual_server: :class:`com.vmware.nsx_policy.model_client.LBVirtualServer`
        :param lb_virtual_server: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LBVirtualServer`
        :return: com.vmware.nsx_policy.model.LBVirtualServer
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'lb_virtual_server_id': lb_virtual_server_id,
                            'lb_virtual_server': lb_virtual_server,
                            })
class Livetraces(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.livetraces'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _LivetracesStub)
        self._VAPI_OPERATION_IDS = {}


    def create(self,
               livetrace_id,
               action=None,
               ):
        """
        Restart a livetrace session with the same set of parameters used in
        creating or updating of a livetrace config.

        :type  livetrace_id: :class:`str`
        :param livetrace_id: (required)
        :type  action: :class:`str` or ``None``
        :param action: Action to be performed (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LiveTraceConfig`
        :return: com.vmware.nsx_policy.model.LiveTraceConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('create',
                            {
                            'livetrace_id': livetrace_id,
                            'action': action,
                            })

    def delete(self,
               livetrace_id,
               ):
        """
        Delete livetrace config with the specified identifier.

        :type  livetrace_id: :class:`str`
        :param livetrace_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'livetrace_id': livetrace_id,
                            })

    def get(self,
            livetrace_id,
            ):
        """
        Read livetrace config with the specified identifier.

        :type  livetrace_id: :class:`str`
        :param livetrace_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LiveTraceConfig`
        :return: com.vmware.nsx_policy.model.LiveTraceConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'livetrace_id': livetrace_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Get a paginated list of all livetrace config entities.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LiveTraceConfigListResult`
        :return: com.vmware.nsx_policy.model.LiveTraceConfigListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              livetrace_id,
              live_trace_config,
              ):
        """
        If a livetrace config with the specified identifier is not present,
        then create a new livetrace config. If it already exists, update the
        livetrace config with a full replacement.

        :type  livetrace_id: :class:`str`
        :param livetrace_id: (required)
        :type  live_trace_config: :class:`com.vmware.nsx_policy.model_client.LiveTraceConfig`
        :param live_trace_config: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'livetrace_id': livetrace_id,
                            'live_trace_config': live_trace_config,
                            })

    def update(self,
               livetrace_id,
               live_trace_config,
               ):
        """
        If a livetrace config with the specified identifier is not present,
        then create a new livetrace config. If it already exists, update the
        livetrace config with a full replacement.

        :type  livetrace_id: :class:`str`
        :param livetrace_id: (required)
        :type  live_trace_config: :class:`com.vmware.nsx_policy.model_client.LiveTraceConfig`
        :param live_trace_config: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.LiveTraceConfig`
        :return: com.vmware.nsx_policy.model.LiveTraceConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'livetrace_id': livetrace_id,
                            'live_trace_config': live_trace_config,
                            })
class MacDiscoveryProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.mac_discovery_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _MacDiscoveryProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               mac_discovery_profile_id,
               override=None,
               ):
        """
        API will delete Mac Discovery profile.

        :type  mac_discovery_profile_id: :class:`str`
        :param mac_discovery_profile_id: Mac Discovery Profile ID (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'mac_discovery_profile_id': mac_discovery_profile_id,
                            'override': override,
                            })

    def get(self,
            mac_discovery_profile_id,
            ):
        """
        API will get Mac Discovery profile.

        :type  mac_discovery_profile_id: :class:`str`
        :param mac_discovery_profile_id: Mac Discovery Profile ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.MacDiscoveryProfile`
        :return: com.vmware.nsx_policy.model.MacDiscoveryProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'mac_discovery_profile_id': mac_discovery_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        API will list all Mac Discovery Profiles active in current discovery
        profile id.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.MacDiscoveryProfileListResult`
        :return: com.vmware.nsx_policy.model.MacDiscoveryProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              mac_discovery_profile_id,
              mac_discovery_profile,
              override=None,
              ):
        """
        API will create Mac Discovery profile.

        :type  mac_discovery_profile_id: :class:`str`
        :param mac_discovery_profile_id: Mac Discovery Profile ID (required)
        :type  mac_discovery_profile: :class:`com.vmware.nsx_policy.model_client.MacDiscoveryProfile`
        :param mac_discovery_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'mac_discovery_profile_id': mac_discovery_profile_id,
                            'mac_discovery_profile': mac_discovery_profile,
                            'override': override,
                            })

    def update(self,
               mac_discovery_profile_id,
               mac_discovery_profile,
               override=None,
               ):
        """
        API will update Mac Discovery profile.

        :type  mac_discovery_profile_id: :class:`str`
        :param mac_discovery_profile_id: Mac Discovery Profile ID (required)
        :type  mac_discovery_profile: :class:`com.vmware.nsx_policy.model_client.MacDiscoveryProfile`
        :param mac_discovery_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.MacDiscoveryProfile`
        :return: com.vmware.nsx_policy.model.MacDiscoveryProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'mac_discovery_profile_id': mac_discovery_profile_id,
                            'mac_discovery_profile': mac_discovery_profile,
                            'override': override,
                            })
class ManagerIpPools(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.manager_ip_pools'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ManagerIpPoolsStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            manager_ip_pool_id,
            ):
        """
        Read Manager Ip Pool with given Id.

        :type  manager_ip_pool_id: :class:`str`
        :param manager_ip_pool_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IpAddressPool`
        :return: com.vmware.nsx_policy.model.IpAddressPool
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'manager_ip_pool_id': manager_ip_pool_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of Manager Ip Pools.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IpAddressPoolListResult`
        :return: com.vmware.nsx_policy.model.IpAddressPoolListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class MetadataProxies(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.metadata_proxies'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _MetadataProxiesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               metadata_proxy_id,
               ):
        """
        API will delete Metadata Proxy Config with ID profile-id

        :type  metadata_proxy_id: :class:`str`
        :param metadata_proxy_id: Metadata Proxy ID (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'metadata_proxy_id': metadata_proxy_id,
                            })

    def get(self,
            metadata_proxy_id,
            ):
        """
        API will read Metadata Proxy Config with ID profile-id

        :type  metadata_proxy_id: :class:`str`
        :param metadata_proxy_id: Metadata Proxy ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.MetadataProxyConfig`
        :return: com.vmware.nsx_policy.model.MetadataProxyConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'metadata_proxy_id': metadata_proxy_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List all L2 Metadata Proxy Configurations

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.MetadataProxyConfigListResult`
        :return: com.vmware.nsx_policy.model.MetadataProxyConfigListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              metadata_proxy_id,
              metadata_proxy_config,
              ):
        """
        API will create or update Metadata Proxy Config with ID profile-id.
        Maximum 10 Metadata Proxy Configurations are supported.

        :type  metadata_proxy_id: :class:`str`
        :param metadata_proxy_id: Metadata Proxy ID (required)
        :type  metadata_proxy_config: :class:`com.vmware.nsx_policy.model_client.MetadataProxyConfig`
        :param metadata_proxy_config: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'metadata_proxy_id': metadata_proxy_id,
                            'metadata_proxy_config': metadata_proxy_config,
                            })

    def update(self,
               metadata_proxy_id,
               metadata_proxy_config,
               ):
        """
        API will create or update Metadata Proxy Config with ID profile-id

        :type  metadata_proxy_id: :class:`str`
        :param metadata_proxy_id: Metadata Proxy ID (required)
        :type  metadata_proxy_config: :class:`com.vmware.nsx_policy.model_client.MetadataProxyConfig`
        :param metadata_proxy_config: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.MetadataProxyConfig`
        :return: com.vmware.nsx_policy.model.MetadataProxyConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'metadata_proxy_id': metadata_proxy_id,
                            'metadata_proxy_config': metadata_proxy_config,
                            })
class NvdsUrt(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.nvds_urt'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _NvdsUrtStub)
        self._VAPI_OPERATION_IDS = {}


    def cleanup(self):
        """
        Clean up all nvds upgrade related configurations 
        NVDS-to-CVDS Upgrade Readiness Tool feature won't be supported

        .. deprecated:: unknown


        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx_policy.infra.NvdsUrt.cleanup is deprecated.', DeprecationWarning)
        return self._invoke('cleanup', None)

    def ignoremigratestatus(self):
        """
        Set the migrate status key of ExtraConfigProfile of all Transport Nodes
        to IGNORE 
        URT feature won't be supported

        .. deprecated:: unknown


        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx_policy.infra.NvdsUrt.ignoremigratestatus is deprecated.', DeprecationWarning)
        return self._invoke('ignoremigratestatus', None)
class OpsGlobalConfig(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.ops_global_config'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _OpsGlobalConfigStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            apply_locally=None,
            ):
        """
        Read global Operations Configuration

        :type  apply_locally: :class:`bool` or ``None``
        :param apply_locally: Flag to check reaching NSX+ or LM resource (optional, default to
            false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.OpsGlobalConfig`
        :return: com.vmware.nsx_policy.model.OpsGlobalConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'apply_locally': apply_locally,
                            })

    def patch(self,
              ops_global_config,
              apply_locally=None,
              ):
        """
        Update the global Operationconfiguration

        :type  ops_global_config: :class:`com.vmware.nsx_policy.model_client.OpsGlobalConfig`
        :param ops_global_config: (required)
        :type  apply_locally: :class:`bool` or ``None``
        :param apply_locally: Flag to check reaching NSX+ or LM resource (optional, default to
            false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'ops_global_config': ops_global_config,
                            'apply_locally': apply_locally,
                            })

    def update(self,
               ops_global_config,
               apply_locally=None,
               ):
        """
        Update the global Operations Configuration

        :type  ops_global_config: :class:`com.vmware.nsx_policy.model_client.OpsGlobalConfig`
        :param ops_global_config: (required)
        :type  apply_locally: :class:`bool` or ``None``
        :param apply_locally: Flag to check reaching NSX+ or LM resource (optional, default to
            false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.OpsGlobalConfig`
        :return: com.vmware.nsx_policy.model.OpsGlobalConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'ops_global_config': ops_global_config,
                            'apply_locally': apply_locally,
                            })
class PartnerServices(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.partner_services'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _PartnerServicesStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            service_name,
            ):
        """
        Read the specific partner service identified by provided name.

        :type  service_name: :class:`str`
        :param service_name: Name of the service (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ServiceDefinition`
        :return: com.vmware.nsx_policy.model.ServiceDefinition
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'service_name': service_name,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Read all the partner services available for service insertion

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ServiceInsertionServiceListResult`
        :return: com.vmware.nsx_policy.model.ServiceInsertionServiceListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class PhysicalServerGroupAssociations(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.physical_server_group_associations'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _PhysicalServerGroupAssociationsStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             physical_server_external_id,
             cursor=None,
             enforcement_point_path=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Get policy groups for which the given Physical Server is a member.

        :type  physical_server_external_id: :class:`str`
        :param physical_server_external_id: Physical external ID (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyResourceReferenceForEPListResult`
        :return: com.vmware.nsx_policy.model.PolicyResourceReferenceForEPListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'physical_server_external_id': physical_server_external_id,
                            'cursor': cursor,
                            'enforcement_point_path': enforcement_point_path,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class PimProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.pim_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _PimProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               pim_profile_id,
               ):
        """
        Delete Pim Profile.

        :type  pim_profile_id: :class:`str`
        :param pim_profile_id: pim profile id (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'pim_profile_id': pim_profile_id,
                            })

    def get(self,
            pim_profile_id,
            ):
        """
        Read Pim Profile.

        :type  pim_profile_id: :class:`str`
        :param pim_profile_id: pim profile id (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyPimProfile`
        :return: com.vmware.nsx_policy.model.PolicyPimProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'pim_profile_id': pim_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List all pim profile.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyPimProfileListResult`
        :return: com.vmware.nsx_policy.model.PolicyPimProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              pim_profile_id,
              policy_pim_profile,
              ):
        """
        Create a pim profile with the pim-profile-id is not already present,
        otherwise update the pim profile.

        :type  pim_profile_id: :class:`str`
        :param pim_profile_id: pim profile id (required)
        :type  policy_pim_profile: :class:`com.vmware.nsx_policy.model_client.PolicyPimProfile`
        :param policy_pim_profile: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'pim_profile_id': pim_profile_id,
                            'policy_pim_profile': policy_pim_profile,
                            })

    def update(self,
               pim_profile_id,
               policy_pim_profile,
               ):
        """
        Create or update pim profile.

        :type  pim_profile_id: :class:`str`
        :param pim_profile_id: pim profile id (required)
        :type  policy_pim_profile: :class:`com.vmware.nsx_policy.model_client.PolicyPimProfile`
        :param policy_pim_profile: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyPimProfile`
        :return: com.vmware.nsx_policy.model.PolicyPimProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'pim_profile_id': pim_profile_id,
                            'policy_pim_profile': policy_pim_profile,
                            })
class PodGroupAssociations(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.pod_group_associations'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _PodGroupAssociationsStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             pod_id,
             cursor=None,
             enforcement_point_path=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Get policy groups for which the given pod is a member.

        :type  pod_id: :class:`str`
        :param pod_id: ContainerApplicationInstance (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyResourceReferenceForEPListResult`
        :return: com.vmware.nsx_policy.model.PolicyResourceReferenceForEPListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'pod_id': pod_id,
                            'cursor': cursor,
                            'enforcement_point_path': enforcement_point_path,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class PortMirroringProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.port_mirroring_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _PortMirroringProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               port_mirroring_profile_id,
               override=None,
               ):
        """
        API will delete port mirroring profile. Mirroring from source to
        destination ports will be stopped.

        :type  port_mirroring_profile_id: :class:`str`
        :param port_mirroring_profile_id: Port Mirroring Profile Id (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'port_mirroring_profile_id': port_mirroring_profile_id,
                            'override': override,
                            })

    def get(self,
            port_mirroring_profile_id,
            ):
        """
        API will return details of port mirroring profile.

        :type  port_mirroring_profile_id: :class:`str`
        :param port_mirroring_profile_id: Port Mirroring Profile Id (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PortMirroringProfile`
        :return: com.vmware.nsx_policy.model.PortMirroringProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'port_mirroring_profile_id': port_mirroring_profile_id,
                            })

    def list(self,
             cursor=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        API will list all port mirroring profiles group.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PortMirroringProfileListResult`
        :return: com.vmware.nsx_policy.model.PortMirroringProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              port_mirroring_profile_id,
              port_mirroring_profile,
              override=None,
              ):
        """
        Create a new Port Mirroring Profile if the Port Mirroring Profile with
        given id does not already exist. If the Port Mirroring Profile with the
        given id already exists, patch with the existing Port Mirroring
        Profile. Realized entities of this API can be found using the path of
        monitoring profile binding map that is used to apply this profile.

        :type  port_mirroring_profile_id: :class:`str`
        :param port_mirroring_profile_id: Port Mirroring Profile Id (required)
        :type  port_mirroring_profile: :class:`com.vmware.nsx_policy.model_client.PortMirroringProfile`
        :param port_mirroring_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'port_mirroring_profile_id': port_mirroring_profile_id,
                            'port_mirroring_profile': port_mirroring_profile,
                            'override': override,
                            })

    def update(self,
               port_mirroring_profile_id,
               port_mirroring_profile,
               override=None,
               ):
        """
        Create or Replace port mirroring profile. Packets will be mirrored from
        source group, segment, port to destination group. Realized entities of
        this API can be found using the path of monitoring profile binding map
        that is used to apply this profile.

        :type  port_mirroring_profile_id: :class:`str`
        :param port_mirroring_profile_id: Port Mirroring Profiles Id (required)
        :type  port_mirroring_profile: :class:`com.vmware.nsx_policy.model_client.PortMirroringProfile`
        :param port_mirroring_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PortMirroringProfile`
        :return: com.vmware.nsx_policy.model.PortMirroringProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'port_mirroring_profile_id': port_mirroring_profile_id,
                            'port_mirroring_profile': port_mirroring_profile,
                            'override': override,
                            })
class QosProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.qos_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _QosProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               qos_profile_id,
               override=None,
               ):
        """
        API will delete QoS profile.

        :type  qos_profile_id: :class:`str`
        :param qos_profile_id: QoS profile Id (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'qos_profile_id': qos_profile_id,
                            'override': override,
                            })

    def get(self,
            qos_profile_id,
            ):
        """
        API will return details of QoS profile.

        :type  qos_profile_id: :class:`str`
        :param qos_profile_id: QoS profile Id (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.QosProfile`
        :return: com.vmware.nsx_policy.model.QoSProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'qos_profile_id': qos_profile_id,
                            })

    def list(self,
             cursor=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        API will list all QoS profiles.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.QosProfileListResult`
        :return: com.vmware.nsx_policy.model.QoSProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              qos_profile_id,
              qos_profile,
              override=None,
              ):
        """
        Create a new QoS profile if the QoS profile with given id does not
        already exist. If the QoS profile with the given id already exists,
        patch with the existing QoS profile.

        :type  qos_profile_id: :class:`str`
        :param qos_profile_id: QoS profile Id (required)
        :type  qos_profile: :class:`com.vmware.nsx_policy.model_client.QosProfile`
        :param qos_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'qos_profile_id': qos_profile_id,
                            'qos_profile': qos_profile,
                            'override': override,
                            })

    def update(self,
               qos_profile_id,
               qos_profile,
               override=None,
               ):
        """
        Create or Replace QoS profile.

        :type  qos_profile_id: :class:`str`
        :param qos_profile_id: QoS profile Id (required)
        :type  qos_profile: :class:`com.vmware.nsx_policy.model_client.QosProfile`
        :param qos_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.QosProfile`
        :return: com.vmware.nsx_policy.model.QoSProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'qos_profile_id': qos_profile_id,
                            'qos_profile': qos_profile,
                            'override': override,
                            })
class Reactions(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.reactions'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ReactionsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               reaction_id,
               ):
        """
        Delete a Reaction under Infra.

        :type  reaction_id: :class:`str`
        :param reaction_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'reaction_id': reaction_id,
                            })

    def get(self,
            reaction_id,
            ):
        """
        Get Reaction under Infra.

        :type  reaction_id: :class:`str`
        :param reaction_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Reaction`
        :return: com.vmware.nsx_policy.model.Reaction
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'reaction_id': reaction_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Get paginated list of all Reactions under Infra.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ReactionListResult`
        :return: com.vmware.nsx_policy.model.ReactionListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              reaction_id,
              reaction,
              ):
        """
        Create or patch a Reaction under Infra.

        :type  reaction_id: :class:`str`
        :param reaction_id: (required)
        :type  reaction: :class:`com.vmware.nsx_policy.model_client.Reaction`
        :param reaction: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'reaction_id': reaction_id,
                            'reaction': reaction,
                            })

    def update(self,
               reaction_id,
               reaction,
               ):
        """
        Create or fully replace a Reaction under Infra. Revision is optional
        for creation and required for update.

        :type  reaction_id: :class:`str`
        :param reaction_id: (required)
        :type  reaction: :class:`com.vmware.nsx_policy.model_client.Reaction`
        :param reaction: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Reaction`
        :return: com.vmware.nsx_policy.model.Reaction
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'reaction_id': reaction_id,
                            'reaction': reaction,
                            })
class SandboxedResources(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.sandboxed_resources'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _SandboxedResourcesStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             intent_path=None,
             site_path=None,
             ):
        """
        Get sandbox resources

        :type  intent_path: :class:`str` or ``None``
        :param intent_path: intent path (optional)
        :type  site_path: :class:`str` or ``None``
        :param site_path: site path (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.SandboxedResourceListResult`
        :return: com.vmware.nsx_policy.model.SandboxedResourceListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'intent_path': intent_path,
                            'site_path': site_path,
                            })
class SecurityGlobalConfig(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.security_global_config'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _SecurityGlobalConfigStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self):
        """
        This reads the security-global-config used for NSX Manager appliance
        certificates. These properties are not sent to the hosts.


        :rtype: :class:`com.vmware.nsx_policy.model_client.InfraSecurityConfig`
        :return: com.vmware.nsx_policy.model.InfraSecurityConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get', None)

    def update(self,
               infra_security_config,
               ):
        """
        This updates the security-global-config used for NSX Manager appliance
        certificates. These properties are not sent to the hosts.

        :type  infra_security_config: :class:`com.vmware.nsx_policy.model_client.InfraSecurityConfig`
        :param infra_security_config: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.InfraSecurityConfig`
        :return: com.vmware.nsx_policy.model.InfraSecurityConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'infra_security_config': infra_security_config,
                            })
class SegmentSecurityProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.segment_security_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _SegmentSecurityProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               segment_security_profile_id,
               override=None,
               ):
        """
        API will delete segment security profile with the given id.

        :type  segment_security_profile_id: :class:`str`
        :param segment_security_profile_id: Segment security profile id (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'segment_security_profile_id': segment_security_profile_id,
                            'override': override,
                            })

    def get(self,
            segment_security_profile_id,
            ):
        """
        API will return details of the segment security profile with given id.
        If the profile does not exist, it will return 404.

        :type  segment_security_profile_id: :class:`str`
        :param segment_security_profile_id: Segment security profile id (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.SegmentSecurityProfile`
        :return: com.vmware.nsx_policy.model.SegmentSecurityProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'segment_security_profile_id': segment_security_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        API will list all segment security profiles.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.SegmentSecurityProfileListResult`
        :return: com.vmware.nsx_policy.model.SegmentSecurityProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              segment_security_profile_id,
              segment_security_profile,
              override=None,
              ):
        """
        Create a new segment security profile if the segment security profile
        with given id does not exist. Otherwise, PATCH the existing segment
        security profile

        :type  segment_security_profile_id: :class:`str`
        :param segment_security_profile_id: Segment security profile id (required)
        :type  segment_security_profile: :class:`com.vmware.nsx_policy.model_client.SegmentSecurityProfile`
        :param segment_security_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'segment_security_profile_id': segment_security_profile_id,
                            'segment_security_profile': segment_security_profile,
                            'override': override,
                            })

    def update(self,
               segment_security_profile_id,
               segment_security_profile,
               override=None,
               ):
        """
        Create or replace a segment security profile

        :type  segment_security_profile_id: :class:`str`
        :param segment_security_profile_id: Segment security profile id (required)
        :type  segment_security_profile: :class:`com.vmware.nsx_policy.model_client.SegmentSecurityProfile`
        :param segment_security_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.SegmentSecurityProfile`
        :return: com.vmware.nsx_policy.model.SegmentSecurityProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'segment_security_profile_id': segment_security_profile_id,
                            'segment_security_profile': segment_security_profile,
                            'override': override,
                            })
class Segments(VapiInterface):
    """
    
    """
    LIST_SEGMENT_TYPE_DVPORTGROUP = "DVPortgroup"
    """
    Possible value for ``segmentType`` of method :func:`Segments.list`.

    """
    LIST_SEGMENT_TYPE_ALL = "ALL"
    """
    Possible value for ``segmentType`` of method :func:`Segments.list`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.segments'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _SegmentsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               segment_id,
               ):
        """
        Delete infra segment

        :type  segment_id: :class:`str`
        :param segment_id: Segment ID (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'segment_id': segment_id,
                            })

    def delete_0(self,
                 segment_id,
                 cascade=None,
                 ):
        """
        Force delete bypasses validations during segment deletion. This may
        result in an inconsistent connectivity.

        :type  segment_id: :class:`str`
        :param segment_id: (required)
        :type  cascade: :class:`bool` or ``None``
        :param cascade: Flag to specify whether to delete related segment ports (optional,
            default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete_0',
                            {
                            'segment_id': segment_id,
                            'cascade': cascade,
                            })

    def deletedhcpleases(self,
                         segment_id,
                         dhcp_delete_leases,
                         enforcement_point_path=None,
                         ):
        """
        Delete one or multiple DHCP lease(s) specified by IP and MAC. If there
        is a DHCP server running upon the given segment, or this segment is
        using a DHCP server running in its connected Tier-0 or Tier-1, the DHCP
        lease(s) which match exactly the IP address and the MAC address will be
        deleted. If no such lease matches, the deletion for this lease will be
        ignored. The DHCP lease to be deleted will be removed by the system
        from both active and standby node. The system will report error if the
        DHCP lease could not be removed from both nodes. If the DHCP lease
        could not be removed on either node, please check the DHCP server
        status. Once the DHCP server status is UP, please invoke the deletion
        API again to ensure the lease gets deleted from both nodes.

        :type  segment_id: :class:`str`
        :param segment_id: (required)
        :type  dhcp_delete_leases: :class:`com.vmware.nsx_policy.model_client.DhcpDeleteLeases`
        :param dhcp_delete_leases: (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: Enforcement point path (optional)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('deletedhcpleases',
                            {
                            'segment_id': segment_id,
                            'dhcp_delete_leases': dhcp_delete_leases,
                            'enforcement_point_path': enforcement_point_path,
                            })

    def get(self,
            segment_id,
            ):
        """
        Read infra segment Note: Extended Segment: Please note that old vpn
        path deprecated. If user specify old l2vpn path in the \"l2_extension\"
        object in the PATCH API payload, the path returned in the GET response
        payload may include the new path instead of the deprecated l2vpn path.
        Both old and new l2vpn path refer to same resource. there is no
        functional impact. Also note that l2vpn path included in the error
        messages returned from validation may include the new VPN path instead
        of the deprecated l2vpn path. Both new path and old vpn path refer to
        same resource.

        :type  segment_id: :class:`str`
        :param segment_id: Segment ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Segment`
        :return: com.vmware.nsx_policy.model.Segment
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'segment_id': segment_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             segment_type=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all segments under infra.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  segment_type: :class:`str` or ``None``
        :param segment_type: Segment type (optional)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.SegmentListResult`
        :return: com.vmware.nsx_policy.model.SegmentListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'segment_type': segment_type,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              segment_id,
              segment,
              ):
        """
        If segment with the segment-id is not already present, create a new
        segment. If it already exists, update the segment with specified
        attributes.

        :type  segment_id: :class:`str`
        :param segment_id: Segment ID (required)
        :type  segment: :class:`com.vmware.nsx_policy.model_client.Segment`
        :param segment: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'segment_id': segment_id,
                            'segment': segment,
                            })

    def patch_0(self,
                segment_id,
                segment,
                ):
        """
        If segment with the segment-id is not already present, create a new
        segment. If it already exists, update the segment with specified
        attributes. Force parameter is required when workload connectivity is
        indirectly impacted with the current update.

        :type  segment_id: :class:`str`
        :param segment_id: Segment ID (required)
        :type  segment: :class:`com.vmware.nsx_policy.model_client.Segment`
        :param segment: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch_0',
                            {
                            'segment_id': segment_id,
                            'segment': segment,
                            })

    def update(self,
               segment_id,
               segment,
               ):
        """
        If segment with the segment-id is not already present, create a new
        segment. If it already exists, replace the segment with this object.
        Note: Extended Segment: Please note that old vpn path deprecated. If
        user specify old l2vpn path in the \"l2_extension\" object in the PATCH
        API payload, the path returned in the GET response payload may include
        the new path instead of the deprecated l2vpn path. Both old and new
        l2vpn path refer to same resource. there is no functional impact. Also
        note that l2vpn path included in the Alarm, GPRR, error messages
        returned from validation may include the new VPN path instead of the
        deprecated l2vpn path. Both new path and old vpn path refer to same
        resource.

        :type  segment_id: :class:`str`
        :param segment_id: Segment ID (required)
        :type  segment: :class:`com.vmware.nsx_policy.model_client.Segment`
        :param segment: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Segment`
        :return: com.vmware.nsx_policy.model.Segment
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'segment_id': segment_id,
                            'segment': segment,
                            })

    def update_0(self,
                 segment_id,
                 segment,
                 ):
        """
        If segment with the segment-id is not already present, create a new
        segment. If it already exists, replace the segment with this object.
        Force parameter is required when workload connectivity is indirectly
        impacted with the current replacement. Note: Extended Segment: Please
        note that old vpn path deprecated. If user specify old l2vpn path in
        the \"l2_extension\" object in the PATCH API payload, the path returned
        in the GET response payload may include the new path instead of the
        deprecated l2vpn path. Both old and new l2vpn path refer to same
        resource. there is no functional impact. Also note that l2vpn path
        included in the Alarm, GPRR, error messages returned from validation
        may include the new VPN path instead of the deprecated l2vpn path. Both
        new path and old vpn path refer to same resource.

        :type  segment_id: :class:`str`
        :param segment_id: Segment ID (required)
        :type  segment: :class:`com.vmware.nsx_policy.model_client.Segment`
        :param segment: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Segment`
        :return: com.vmware.nsx_policy.model.Segment
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update_0',
                            {
                            'segment_id': segment_id,
                            'segment': segment,
                            })
class ServiceChains(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.service_chains'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ServiceChainsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               service_chain_id,
               ):
        """
        This API can be user to delete service chain with given
        service-chain-id.

        :type  service_chain_id: :class:`str`
        :param service_chain_id: Id of Service chain (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'service_chain_id': service_chain_id,
                            })

    def get(self,
            service_chain_id,
            ):
        """
        This API can be used to read service chain with given service-chain-id.

        :type  service_chain_id: :class:`str`
        :param service_chain_id: Id of Service chain (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyServiceChain`
        :return: com.vmware.nsx_policy.model.PolicyServiceChain
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'service_chain_id': service_chain_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List all the service chains available for service insertion

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyServiceChainListResult`
        :return: com.vmware.nsx_policy.model.PolicyServiceChainListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              service_chain_id,
              policy_service_chain,
              ):
        """
        Create Service chain representing the sequence in which 3rd party
        services must be consumed.

        :type  service_chain_id: :class:`str`
        :param service_chain_id: Service chain id (required)
        :type  policy_service_chain: :class:`com.vmware.nsx_policy.model_client.PolicyServiceChain`
        :param policy_service_chain: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'service_chain_id': service_chain_id,
                            'policy_service_chain': policy_service_chain,
                            })

    def update(self,
               service_chain_id,
               policy_service_chain,
               ):
        """
        Create or update Service chain representing the sequence in which 3rd
        party services must be consumed.

        :type  service_chain_id: :class:`str`
        :param service_chain_id: Service chain id (required)
        :type  policy_service_chain: :class:`com.vmware.nsx_policy.model_client.PolicyServiceChain`
        :param policy_service_chain: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyServiceChain`
        :return: com.vmware.nsx_policy.model.PolicyServiceChain
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'service_chain_id': service_chain_id,
                            'policy_service_chain': policy_service_chain,
                            })
class ServiceReferences(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.service_references'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ServiceReferencesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               service_reference_id,
               cascade=None,
               ):
        """
        This API can be used to delete a service reference with the given
        service-reference-id.

        :type  service_reference_id: :class:`str`
        :param service_reference_id: Id of Service Reference (required)
        :type  cascade: :class:`bool` or ``None``
        :param cascade: Flag to cascade delete all children associated with service
            reference (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'service_reference_id': service_reference_id,
                            'cascade': cascade,
                            })

    def get(self,
            service_reference_id,
            ):
        """
        This API can be used to read service reference with the given
        service-reference-id.

        :type  service_reference_id: :class:`str`
        :param service_reference_id: Id of Service Reference (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ServiceReference`
        :return: com.vmware.nsx_policy.model.ServiceReference
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'service_reference_id': service_reference_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List all the partner service references available for service insertion

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ServiceReferenceListResult`
        :return: com.vmware.nsx_policy.model.ServiceReferenceListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              service_reference_id,
              service_reference,
              ):
        """
        Create Service Reference representing the intent to consume a given 3rd
        party service.

        :type  service_reference_id: :class:`str`
        :param service_reference_id: Service reference id (required)
        :type  service_reference: :class:`com.vmware.nsx_policy.model_client.ServiceReference`
        :param service_reference: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'service_reference_id': service_reference_id,
                            'service_reference': service_reference,
                            })

    def update(self,
               service_reference_id,
               service_reference,
               ):
        """
        Create Service Reference representing the intent to consume a given 3rd
        party service.

        :type  service_reference_id: :class:`str`
        :param service_reference_id: Service reference id (required)
        :type  service_reference: :class:`com.vmware.nsx_policy.model_client.ServiceReference`
        :param service_reference: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ServiceReference`
        :return: com.vmware.nsx_policy.model.ServiceReference
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'service_reference_id': service_reference_id,
                            'service_reference': service_reference,
                            })
class Services(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.services'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ServicesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               service_id,
               ):
        """
        Delete Service

        :type  service_id: :class:`str`
        :param service_id: Service ID (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'service_id': service_id,
                            })

    def get(self,
            service_id,
            ):
        """
        Read a service

        :type  service_id: :class:`str`
        :param service_id: Service ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Service`
        :return: com.vmware.nsx_policy.model.Service
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'service_id': service_id,
                            })

    def list(self,
             cursor=None,
             default_service=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of Services for infra.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  default_service: :class:`bool` or ``None``
        :param default_service: Fetch all default services (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ServiceListResult`
        :return: com.vmware.nsx_policy.model.ServiceListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'default_service': default_service,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              service_id,
              service,
              ):
        """
        Create a new service if a service with the given ID does not already
        exist. Creates new service entries if populated in the service. If a
        service with the given ID already exists, patch the service including
        the nested service entries.

        :type  service_id: :class:`str`
        :param service_id: Service ID (required)
        :type  service: :class:`com.vmware.nsx_policy.model_client.Service`
        :param service: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'service_id': service_id,
                            'service': service,
                            })

    def update(self,
               service_id,
               service,
               ):
        """
        Create a new service if a service with the given ID does not already
        exist. Creates new service entries if populated in the service. If a
        service with the given ID already exists, update the service including
        the nested service entries. This is a full replace.

        :type  service_id: :class:`str`
        :param service_id: Service ID (required)
        :type  service: :class:`com.vmware.nsx_policy.model_client.Service`
        :param service: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Service`
        :return: com.vmware.nsx_policy.model.Service
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'service_id': service_id,
                            'service': service,
                            })
class Shares(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.shares'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _SharesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               share_id,
               ):
        """
        Delete a Share.

        :type  share_id: :class:`str`
        :param share_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'share_id': share_id,
                            })

    def get(self,
            share_id,
            ):
        """
        Get single instance of a share

        :type  share_id: :class:`str`
        :param share_id: Share ID (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Share`
        :return: com.vmware.nsx_policy.model.Share
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'share_id': share_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List shares

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ShareListResult`
        :return: com.vmware.nsx_policy.model.ShareListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              share_id,
              share,
              ):
        """
        If a Share with the given ID already exists, update the share entity.

        :type  share_id: :class:`str`
        :param share_id: Share ID (required)
        :type  share: :class:`com.vmware.nsx_policy.model_client.Share`
        :param share: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'share_id': share_id,
                            'share': share,
                            })

    def update(self,
               share_id,
               share,
               ):
        """
        If a Share with the given ID already exists, and the revision is 0,
        throw error

        :type  share_id: :class:`str`
        :param share_id: Share ID (required)
        :type  share: :class:`com.vmware.nsx_policy.model_client.Share`
        :param share: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Share`
        :return: com.vmware.nsx_policy.model.Share
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'share_id': share_id,
                            'share': share,
                            })
class Sites(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.sites'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _SitesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               site_id,
               force=None,
               ):
        """
        Delete a site under Infra.

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  force: :class:`bool` or ``None``
        :param force: (optional)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'site_id': site_id,
                            'force': force,
                            })

    def get(self,
            site_id,
            ):
        """
        Read a site under Infra.

        :type  site_id: :class:`str`
        :param site_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Site`
        :return: com.vmware.nsx_policy.model.Site
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'site_id': site_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List Sites under Infra.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.SiteListResult`
        :return: com.vmware.nsx_policy.model.SiteListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              site_id,
              site,
              ):
        """
        Create or patch Site under Infra.

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  site: :class:`com.vmware.nsx_policy.model_client.Site`
        :param site: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'site_id': site_id,
                            'site': site,
                            })

    def update(self,
               site_id,
               site,
               ):
        """
        Create or fully replace a Site under Infra. Revision is optional for
        creation and required for update.

        :type  site_id: :class:`str`
        :param site_id: (required)
        :type  site: :class:`com.vmware.nsx_policy.model_client.Site`
        :param site: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Site`
        :return: com.vmware.nsx_policy.model.Site
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'site_id': site_id,
                            'site': site,
                            })
class Span(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.span'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _SpanStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            intent_path,
            site_path=None,
            ):
        """
        Get span for an entity with specified path.

        :type  intent_path: :class:`str`
        :param intent_path: String Path of the intent object (required)
        :type  site_path: :class:`str` or ``None``
        :param site_path: Policy Path of the site (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Span`
        :return: com.vmware.nsx_policy.model.Span
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'intent_path': intent_path,
                            'site_path': site_path,
                            })
class SpoofguardProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.spoofguard_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _SpoofguardProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               spoofguard_profile_id,
               override=None,
               ):
        """
        API will delete SpoofGuard profile with the given id.

        :type  spoofguard_profile_id: :class:`str`
        :param spoofguard_profile_id: SpoofGuard profile id (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'spoofguard_profile_id': spoofguard_profile_id,
                            'override': override,
                            })

    def get(self,
            spoofguard_profile_id,
            ):
        """
        API will return details of the SpoofGuard profile with given id. If the
        profile does not exist, it will return 404.

        :type  spoofguard_profile_id: :class:`str`
        :param spoofguard_profile_id: SpoofGuard profile id (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.SpoofGuardProfile`
        :return: com.vmware.nsx_policy.model.SpoofGuardProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'spoofguard_profile_id': spoofguard_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        API will list all SpoofGuard profiles.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.SpoofGuardProfileListResult`
        :return: com.vmware.nsx_policy.model.SpoofGuardProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              spoofguard_profile_id,
              spoof_guard_profile,
              override=None,
              ):
        """
        Create a new SpoofGuard profile if the SpoofGuard profile with the
        given id does not exist. Otherwise, patch with the existing SpoofGuard
        profile.

        :type  spoofguard_profile_id: :class:`str`
        :param spoofguard_profile_id: SpoofGuard profile id (required)
        :type  spoof_guard_profile: :class:`com.vmware.nsx_policy.model_client.SpoofGuardProfile`
        :param spoof_guard_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'spoofguard_profile_id': spoofguard_profile_id,
                            'spoof_guard_profile': spoof_guard_profile,
                            'override': override,
                            })

    def update(self,
               spoofguard_profile_id,
               spoof_guard_profile,
               override=None,
               ):
        """
        API will create or replace SpoofGuard profile.

        :type  spoofguard_profile_id: :class:`str`
        :param spoofguard_profile_id: SpoofGuard profile id (required)
        :type  spoof_guard_profile: :class:`com.vmware.nsx_policy.model_client.SpoofGuardProfile`
        :param spoof_guard_profile: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.SpoofGuardProfile`
        :return: com.vmware.nsx_policy.model.SpoofGuardProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'spoofguard_profile_id': spoofguard_profile_id,
                            'spoof_guard_profile': spoof_guard_profile,
                            'override': override,
                            })
class StaticMimeContents(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.static_mime_contents'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _StaticMimeContentsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               static_mime_content_id,
               override=None,
               ):
        """
        API will delete static mime content

        :type  static_mime_content_id: :class:`str`
        :param static_mime_content_id: Static mime content id (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'static_mime_content_id': static_mime_content_id,
                            'override': override,
                            })

    def get(self,
            static_mime_content_id,
            ):
        """
        API will get static mime content

        :type  static_mime_content_id: :class:`str`
        :param static_mime_content_id: Static mime content id (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.StaticMimeContent`
        :return: com.vmware.nsx_policy.model.StaticMimeContent
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'static_mime_content_id': static_mime_content_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        API will list all static mime contents

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.StaticMimeContentListResult`
        :return: com.vmware.nsx_policy.model.StaticMimeContentListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              static_mime_content_id,
              static_mime_content,
              override=None,
              ):
        """
        API will create/update static mime content id

        :type  static_mime_content_id: :class:`str`
        :param static_mime_content_id: static mime content id (required)
        :type  static_mime_content: :class:`com.vmware.nsx_policy.model_client.StaticMimeContent`
        :param static_mime_content: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.StaticMimeContent`
        :return: com.vmware.nsx_policy.model.StaticMimeContent
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'static_mime_content_id': static_mime_content_id,
                            'static_mime_content': static_mime_content,
                            'override': override,
                            })

    def update(self,
               static_mime_content_id,
               static_mime_content,
               override=None,
               ):
        """
        API will create/update static mime content id

        :type  static_mime_content_id: :class:`str`
        :param static_mime_content_id: static mime content id (required)
        :type  static_mime_content: :class:`com.vmware.nsx_policy.model_client.StaticMimeContent`
        :param static_mime_content: (required)
        :type  override: :class:`bool` or ``None``
        :param override: Locally override the global object (optional, default to false)
        :rtype: :class:`com.vmware.nsx_policy.model_client.StaticMimeContent`
        :return: com.vmware.nsx_policy.model.StaticMimeContent
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'static_mime_content_id': static_mime_content_id,
                            'static_mime_content': static_mime_content,
                            'override': override,
                            })
class Tags(VapiInterface):
    """
    
    """
    LIST_SOURCE_AMAZON = "Amazon"
    """
    Possible value for ``source`` of method :func:`Tags.list`.

    """
    LIST_SOURCE_AZURE = "Azure"
    """
    Possible value for ``source`` of method :func:`Tags.list`.

    """
    LIST_SOURCE_NSX = "NSX"
    """
    Possible value for ``source`` of method :func:`Tags.list`.

    """
    LIST_SOURCE_ANY = "ANY"
    """
    Possible value for ``source`` of method :func:`Tags.list`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.tags'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _TagsStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             cursor=None,
             enforcement_point_path=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             scope=None,
             sort_ascending=None,
             sort_by=None,
             source=None,
             tag=None,
             ):
        """
        Returns paginated list of all unique tags. Supports filtering by scope,
        tag and source from which tags are synced. Supports starts with, ends
        with, equals and contains operators on scope and tag values. To filter
        tags by starts with on scope or tag, use '\*' as suffix after the
        value. To filter tags by ends with on scope or tag, use '\*' as prefix
        before the value. To filter tags by contain on scope or tag, use '\*'
        as prefix and suffix on the value. Below special characters in the
        filter value needs to be escaped with hex values. - Character '&' needs
        to be escaped as '%26' - Character '[' needs to be escaped as '%5B' -
        Character ']' needs to be escaped as '%5D' - Character '+' needs to be
        escaped as '%2B' - Character '#' needs to be escaped as '%23' Sort
        option for list of unique tags is available only on tag and scope
        properties.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  scope: :class:`str` or ``None``
        :param scope: Tag scope (optional)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :type  source: :class:`str` or ``None``
        :param source: Source from which tags are synced. (optional)
        :type  tag: :class:`str` or ``None``
        :param tag: Tag value (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TagInfoListResult`
        :return: com.vmware.nsx_policy.model.TagInfoListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'enforcement_point_path': enforcement_point_path,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'scope': scope,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            'source': source,
                            'tag': tag,
                            })
class Tier0s(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.tier0s'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _Tier0sStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               tier0_id,
               ):
        """
        Delete Tier-0

        :type  tier0_id: :class:`str`
        :param tier0_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'tier0_id': tier0_id,
                            })

    def get(self,
            tier0_id,
            ):
        """
        Read Tier-0

        :type  tier0_id: :class:`str`
        :param tier0_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Tier0`
        :return: com.vmware.nsx_policy.model.Tier0
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'tier0_id': tier0_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all Tier-0s

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Tier0ListResult`
        :return: com.vmware.nsx_policy.model.Tier0ListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              tier0_id,
              tier0,
              ):
        """
        If a Tier-0 with the tier-0-id is not already present, create a new
        Tier-0. If it already exists, update the Tier-0 for specified
        attributes.

        :type  tier0_id: :class:`str`
        :param tier0_id: (required)
        :type  tier0: :class:`com.vmware.nsx_policy.model_client.Tier0`
        :param tier0: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'tier0_id': tier0_id,
                            'tier0': tier0,
                            })

    def reprocess(self,
                  tier0_id,
                  enforcement_point_path=None,
                  ):
        """
        Reprocess Tier0 gateway configuration and configuration of related
        entities like Tier0 interfaces and static routes, etc. Any missing
        Updates are published to NSX controller.

        :type  tier0_id: :class:`str`
        :param tier0_id: (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('reprocess',
                            {
                            'tier0_id': tier0_id,
                            'enforcement_point_path': enforcement_point_path,
                            })

    def sitefailover(self,
                     gateway_site_failover_action_config,
                     ):
        """
        API to recover specified Tier0 gateway and linked tier1 gateway from
        primary site path to new primary site path. This will update intent of
        affected Tier-0 and Tier-1 gateway.

        :type  gateway_site_failover_action_config: :class:`com.vmware.nsx_policy.model_client.GatewaySiteFailoverActionConfig`
        :param gateway_site_failover_action_config: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('sitefailover',
                            {
                            'gateway_site_failover_action_config': gateway_site_failover_action_config,
                            })

    def update(self,
               tier0_id,
               tier0,
               ):
        """
        If a Tier-0 with the tier-0-id is not already present, create a new
        Tier-0. If it already exists, replace the Tier-0 instance with the new
        object.

        :type  tier0_id: :class:`str`
        :param tier0_id: (required)
        :type  tier0: :class:`com.vmware.nsx_policy.model_client.Tier0`
        :param tier0: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Tier0`
        :return: com.vmware.nsx_policy.model.Tier0
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'tier0_id': tier0_id,
                            'tier0': tier0,
                            })
class Tier1s(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.tier1s'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _Tier1sStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               tier1_id,
               ):
        """
        Delete Tier-1 configuration

        :type  tier1_id: :class:`str`
        :param tier1_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'tier1_id': tier1_id,
                            })

    def get(self,
            tier1_id,
            ):
        """
        Read Tier-1 configuration

        :type  tier1_id: :class:`str`
        :param tier1_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Tier1`
        :return: com.vmware.nsx_policy.model.Tier1
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'tier1_id': tier1_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all Tier-1 instances

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Tier1ListResult`
        :return: com.vmware.nsx_policy.model.Tier1ListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              tier1_id,
              tier1,
              ):
        """
        If Tier-1 with the tier-1-id is not already present, create a new
        Tier-1 instance. If it already exists, update the tier-1 instance with
        specified attributes.

        :type  tier1_id: :class:`str`
        :param tier1_id: (required)
        :type  tier1: :class:`com.vmware.nsx_policy.model_client.Tier1`
        :param tier1: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'tier1_id': tier1_id,
                            'tier1': tier1,
                            })

    def reprocess(self,
                  tier1_id,
                  enforcement_point_path=None,
                  ):
        """
        Reprocess Tier1 gateway configuration and configuration of related
        entities like Tier1 interfaces and static routes, etc. Any missing
        Updates are published to NSX controller.

        :type  tier1_id: :class:`str`
        :param tier1_id: (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('reprocess',
                            {
                            'tier1_id': tier1_id,
                            'enforcement_point_path': enforcement_point_path,
                            })

    def update(self,
               tier1_id,
               tier1,
               ):
        """
        If Tier-1 with the tier-1-id is not already present, create a new
        Tier-1 instance. If it already exists, replace the Tier-1 instance with
        this object.

        :type  tier1_id: :class:`str`
        :param tier1_id: (required)
        :type  tier1: :class:`com.vmware.nsx_policy.model_client.Tier1`
        :param tier1: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Tier1`
        :return: com.vmware.nsx_policy.model.Tier1
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'tier1_id': tier1_id,
                            'tier1': tier1,
                            })
class TlsInspectionActionProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.tls_inspection_action_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _TlsInspectionActionProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               action_profile_id,
               ):
        """
        Deletes a Tls profile.

        :type  action_profile_id: :class:`str`
        :param action_profile_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'action_profile_id': action_profile_id,
                            })

    def get(self,
            action_profile_id,
            ):
        """
        Return Tls profile.

        :type  action_profile_id: :class:`str`
        :param action_profile_id: (required)
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.TlsProfile
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.TlsProfile`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'action_profile_id': action_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List all the Tls profiles available by requested resource_type.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TlsProfileListResult`
        :return: com.vmware.nsx_policy.model.TlsProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              action_profile_id,
              tls_profile,
              ):
        """
        

        :type  action_profile_id: :class:`str`
        :param action_profile_id: (required)
        :type  tls_profile: :class:`vmware.vapi.struct.VapiStruct`
        :param tls_profile: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.TlsProfile`.
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.TlsProfile
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.TlsProfile`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'action_profile_id': action_profile_id,
                            'tls_profile': tls_profile,
                            })

    def update(self,
               action_profile_id,
               tls_profile,
               ):
        """
        

        :type  action_profile_id: :class:`str`
        :param action_profile_id: (required)
        :type  tls_profile: :class:`vmware.vapi.struct.VapiStruct`
        :param tls_profile: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.TlsProfile`.
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.TlsProfile
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.TlsProfile`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'action_profile_id': action_profile_id,
                            'tls_profile': tls_profile,
                            })
class TlsInspectionPolicies(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.tls_inspection_policies'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _TlsInspectionPoliciesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               policy_id,
               ):
        """
        Delete TlsPolicy

        :type  policy_id: :class:`str`
        :param policy_id: Firewall TLS inspection poicy id (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'policy_id': policy_id,
                            })

    def get(self,
            policy_id,
            ):
        """
        Read TLS policy.

        :type  policy_id: :class:`str`
        :param policy_id: Firewall TLS inspection poicy id (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TlsPolicy`
        :return: com.vmware.nsx_policy.model.TlsPolicy
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'policy_id': policy_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             include_rule_count=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List all TLS policies.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  include_rule_count: :class:`bool` or ``None``
        :param include_rule_count: Include the count of rules in policy (optional, default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TlsPolicyListResult`
        :return: com.vmware.nsx_policy.model.TlsPolicyListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'include_rule_count': include_rule_count,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              policy_id,
              tls_policy,
              ):
        """
        Update the TLS policy. This is a full replace. All the rules are
        replaced. Performance Note: If you want to edit several rules in a TLS
        policy use this API. It will perform better than several individual
        rule APIs. Just pass all the rules which you wish to edit as embedded
        rules to it.

        :type  policy_id: :class:`str`
        :param policy_id: Firewall TLS inspection poicy id (required)
        :type  tls_policy: :class:`com.vmware.nsx_policy.model_client.TlsPolicy`
        :param tls_policy: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TlsPolicy`
        :return: com.vmware.nsx_policy.model.TlsPolicy
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'policy_id': policy_id,
                            'tls_policy': tls_policy,
                            })

    def update(self,
               policy_id,
               tls_policy,
               ):
        """
        Update the TLS policy. This is a full replace. All the rules are
        replaced. Performance Note: If you want to edit several rules in a TLS
        policy, use this API. It will perform better than several individual
        rule APIs. Just pass all the rules which you wish to edit as embedded
        rules to it.

        :type  policy_id: :class:`str`
        :param policy_id: Firewall TLS inspection poicy id (required)
        :type  tls_policy: :class:`com.vmware.nsx_policy.model_client.TlsPolicy`
        :param tls_policy: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TlsPolicy`
        :return: com.vmware.nsx_policy.model.TlsPolicy
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'policy_id': policy_id,
                            'tls_policy': tls_policy,
                            })
class Traceflows(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.traceflows'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _TraceflowsStub)
        self._VAPI_OPERATION_IDS = {}


    def create(self,
               traceflow_id,
               action=None,
               ):
        """
        This will retrace even if current traceflow has observations. Current
        observations will be lost. Traceflow configuration will be cleaned up
        by the system after two hours of inactivity.

        :type  traceflow_id: :class:`str`
        :param traceflow_id: (required)
        :type  action: :class:`str` or ``None``
        :param action: Action to be performed (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TraceflowConfig`
        :return: com.vmware.nsx_policy.model.TraceflowConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('create',
                            {
                            'traceflow_id': traceflow_id,
                            'action': action,
                            })

    def delete(self,
               traceflow_id,
               ):
        """
        Delete traceflow config with id traceflow-id

        :type  traceflow_id: :class:`str`
        :param traceflow_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'traceflow_id': traceflow_id,
                            })

    def get(self,
            traceflow_id,
            ):
        """
        Read traceflow config with id traceflow-id. This configuration will be
        cleaned up by the system after two hours of inactivity.

        :type  traceflow_id: :class:`str`
        :param traceflow_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TraceflowConfig`
        :return: com.vmware.nsx_policy.model.TraceflowConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'traceflow_id': traceflow_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of all TraceflowConfig for infra.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TraceflowConfigListResult`
        :return: com.vmware.nsx_policy.model.TraceflowConfigListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              traceflow_id,
              traceflow_config,
              enforcement_point_path=None,
              ):
        """
        If a traceflow config with the traceflow-id is not already present,
        create a new traceflow config. If it already exists, update the
        traceflow config. This is a full replace. This configuration will be
        cleaned up by the system after two hours of inactivity. To start
        traceflow on a DHCP port in a custom project, enforcement point path is
        required.

        :type  traceflow_id: :class:`str`
        :param traceflow_id: (required)
        :type  traceflow_config: :class:`com.vmware.nsx_policy.model_client.TraceflowConfig`
        :param traceflow_config: (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: Enforcement point path (optional)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'traceflow_id': traceflow_id,
                            'traceflow_config': traceflow_config,
                            'enforcement_point_path': enforcement_point_path,
                            })

    def update(self,
               traceflow_id,
               traceflow_config,
               enforcement_point_path=None,
               ):
        """
        If a traceflow config with the traceflow-id is not already present,
        create a new traceflow config. If it already exists, update the
        traceflow config. This is a full replace. This configuration will be
        cleaned up by the system after two hours of inactivity. To start
        traceflow on a DHCP port in a custom project, enforcement point path is
        required. User needs to update the in-band network telemetry (INT)
        configuration to specify the DSCP bit/value for traceflow crafted
        packet, if the source port of traceflow is on VLAN logical network. The
        INT configuration is under global operations configuration so please
        refer NSX-T API document Policy > Networking > Networking Profiles >
        Global Gateway Configuration to check how to set the DSCP bit/value via
        global operations configuration related API.

        :type  traceflow_id: :class:`str`
        :param traceflow_id: (required)
        :type  traceflow_config: :class:`com.vmware.nsx_policy.model_client.TraceflowConfig`
        :param traceflow_config: (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: Enforcement point path (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.TraceflowConfig`
        :return: com.vmware.nsx_policy.model.TraceflowConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'traceflow_id': traceflow_id,
                            'traceflow_config': traceflow_config,
                            'enforcement_point_path': enforcement_point_path,
                            })
class TransportZoneProfiles(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.transport_zone_profiles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _TransportZoneProfilesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               tz_profile_id,
               ):
        """
        API will delete Policy Transport Zone Profile.

        :type  tz_profile_id: :class:`str`
        :param tz_profile_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'tz_profile_id': tz_profile_id,
                            })

    def get(self,
            tz_profile_id,
            ):
        """
        API will fetch Policy Transport Zone Profile.

        :type  tz_profile_id: :class:`str`
        :param tz_profile_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyTransportZoneProfile`
        :return: com.vmware.nsx_policy.model.PolicyTransportZoneProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'tz_profile_id': tz_profile_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        API will list all Policy Transport Zone Profiles.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyTransportZoneProfileListResult`
        :return: com.vmware.nsx_policy.model.PolicyTransportZoneProfileListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              tz_profile_id,
              policy_transport_zone_profile,
              ):
        """
        API will create Policy Transport Zone Profile.

        :type  tz_profile_id: :class:`str`
        :param tz_profile_id: (required)
        :type  policy_transport_zone_profile: :class:`com.vmware.nsx_policy.model_client.PolicyTransportZoneProfile`
        :param policy_transport_zone_profile: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyTransportZoneProfile`
        :return: com.vmware.nsx_policy.model.PolicyTransportZoneProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'tz_profile_id': tz_profile_id,
                            'policy_transport_zone_profile': policy_transport_zone_profile,
                            })

    def update(self,
               tz_profile_id,
               policy_transport_zone_profile,
               ):
        """
        API will update Policy Transport Zone Profile.

        :type  tz_profile_id: :class:`str`
        :param tz_profile_id: (required)
        :type  policy_transport_zone_profile: :class:`com.vmware.nsx_policy.model_client.PolicyTransportZoneProfile`
        :param policy_transport_zone_profile: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyTransportZoneProfile`
        :return: com.vmware.nsx_policy.model.PolicyTransportZoneProfile
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'tz_profile_id': tz_profile_id,
                            'policy_transport_zone_profile': policy_transport_zone_profile,
                            })
class UrlCategories(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.url_categories'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _UrlCategoriesStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Gets the list of categories. This will provide all the supported
        categories along with their ids. Few examples of these categories are
        Shopping, Social Networks, Streaming sites, etc.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyUrlCategoryListResult`
        :return: com.vmware.nsx_policy.model.PolicyUrlCategoryListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class UrlReputationSeverities(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.url_reputation_severities'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _UrlReputationSeveritiesStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Gets the list of reputation severities. This will provide all the
        supported severities along with their ids, min and max reputaitons. The
        min_reputation and max_reputation specify the range of the reputations
        which belong to a particular severity. For instance, any reputation
        between 1 to 20 belongs to the severity 'High Risk'. Similary a
        reputation between 81 to 100 belong to the severity 'Trustworthy'.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyUrlReputationSeverityListResult`
        :return: com.vmware.nsx_policy.model.PolicyUrlReputationSeverityListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class VirtualMachineGroupAssociations(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.virtual_machine_group_associations'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _VirtualMachineGroupAssociationsStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             vm_external_id,
             cursor=None,
             enforcement_point_path=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Get policy groups for which the given VM is a member.

        :type  vm_external_id: :class:`str`
        :param vm_external_id: Virtual machine external ID (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyResourceReferenceForEPListResult`
        :return: com.vmware.nsx_policy.model.PolicyResourceReferenceForEPListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'vm_external_id': vm_external_id,
                            'cursor': cursor,
                            'enforcement_point_path': enforcement_point_path,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class VirtualNetworkInterfaceGroupAssociations(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.virtual_network_interface_group_associations'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _VirtualNetworkInterfaceGroupAssociationsStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             vif_external_id,
             cursor=None,
             enforcement_point_path=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Get policy groups for which the given VIF is a member.

        :type  vif_external_id: :class:`str`
        :param vif_external_id: Virtual network interface external ID (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.PolicyResourceReferenceForEPListResult`
        :return: com.vmware.nsx_policy.model.PolicyResourceReferenceForEPListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'vif_external_id': vif_external_id,
                            'cursor': cursor,
                            'enforcement_point_path': enforcement_point_path,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class VniPools(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.vni_pools'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _VniPoolsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               vni_pool_id,
               ):
        """
        Delete Vni Pool Configuration.

        :type  vni_pool_id: :class:`str`
        :param vni_pool_id: vni pool id (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'vni_pool_id': vni_pool_id,
                            })

    def get(self,
            vni_pool_id,
            ):
        """
        Read Vni Pool Configuration.

        :type  vni_pool_id: :class:`str`
        :param vni_pool_id: vni pool id (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.VniPoolConfig`
        :return: com.vmware.nsx_policy.model.VniPoolConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'vni_pool_id': vni_pool_id,
                            })

    def list(self,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List all Vni Pool configuration.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.VniPoolConfigListResult`
        :return: com.vmware.nsx_policy.model.VniPoolConfigListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              vni_pool_id,
              vni_pool_config,
              ):
        """
        Create a Vni Pool config if it is not already present, otherwise update
        the Vni Pool configuration.

        :type  vni_pool_id: :class:`str`
        :param vni_pool_id: vni pool id (required)
        :type  vni_pool_config: :class:`com.vmware.nsx_policy.model_client.VniPoolConfig`
        :param vni_pool_config: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'vni_pool_id': vni_pool_id,
                            'vni_pool_config': vni_pool_config,
                            })

    def update(self,
               vni_pool_id,
               vni_pool_config,
               ):
        """
        Create or update VniPool configuration.

        :type  vni_pool_id: :class:`str`
        :param vni_pool_id: vni pool id (required)
        :type  vni_pool_config: :class:`com.vmware.nsx_policy.model_client.VniPoolConfig`
        :param vni_pool_config: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.VniPoolConfig`
        :return: com.vmware.nsx_policy.model.VniPoolConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'vni_pool_id': vni_pool_id,
                            'vni_pool_config': vni_pool_config,
                            })
class _AlbAuthTokenStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'a_LB_auth_token': type.ReferenceType('com.vmware.nsx_policy.model_client', 'ALBAuthToken'),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
        ]
        update_output_validator_list = [
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/alb-auth-token',
            request_body_parameter='a_LB_auth_token',
            path_variables={
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'ALBAuthToken'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.alb_auth_token',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _AlbOnboardingWorkflowStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'managed_by': type.StringType(),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/infra/alb-onboarding-workflow/{managed-by}',
            path_variables={
                'managed_by': 'managed-by',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'a_LB_controller_configuration': type.ReferenceType('com.vmware.nsx_policy.model_client', 'ALBControllerConfiguration'),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/alb-onboarding-workflow',
            request_body_parameter='a_LB_controller_configuration',
            path_variables={
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'EnforcementPoint'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'delete': delete_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.alb_onboarding_workflow',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _BfdProfilesStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'bfd_profile_id': type.StringType(),
            'override': type.OptionalType(type.BooleanType()),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/infra/bfd-profiles/{bfd-profile-id}',
            path_variables={
                'bfd_profile_id': 'bfd-profile-id',
            },
             header_parameters={
                 },
            query_parameters={
                'override': 'override',
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'bfd_profile_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/bfd-profiles/{bfd-profile-id}',
            path_variables={
                'bfd_profile_id': 'bfd-profile-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'cursor': type.OptionalType(type.StringType()),
            'include_mark_for_delete_objects': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/bfd-profiles',
            path_variables={
            },
             header_parameters={
                         },
            query_parameters={
                'cursor': 'cursor',
                'include_mark_for_delete_objects': 'include_mark_for_delete_objects',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'bfd_profile_id': type.StringType(),
            'bfd_profile': type.ReferenceType('com.vmware.nsx_policy.model_client', 'BfdProfile'),
            'override': type.OptionalType(type.BooleanType()),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/infra/bfd-profiles/{bfd-profile-id}',
            request_body_parameter='bfd_profile',
            path_variables={
                'bfd_profile_id': 'bfd-profile-id',
            },
             header_parameters={
                   },
            query_parameters={
                'override': 'override',
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'bfd_profile_id': type.StringType(),
            'bfd_profile': type.ReferenceType('com.vmware.nsx_policy.model_client', 'BfdProfile'),
            'override': type.OptionalType(type.BooleanType()),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/bfd-profiles/{bfd-profile-id}',
            request_body_parameter='bfd_profile',
            path_variables={
                'bfd_profile_id': 'bfd-profile-id',
            },
             header_parameters={
                   },
            query_parameters={
                'override': 'override',
            },
            content_type='application/json'
        )

        operations = {
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'BfdProfile'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'BfdProfileListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.VoidType(),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'BfdProfile'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'list': list_rest_metadata,
            'patch': patch_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.bfd_profiles',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _CabundlesStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'cabundle_id': type.StringType(),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/infra/cabundles/{cabundle-id}',
            path_variables={
                'cabundle_id': 'cabundle-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'cabundle_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/cabundles/{cabundle-id}',
            path_variables={
                'cabundle_id': 'cabundle-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'cursor': type.OptionalType(type.StringType()),
            'details': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'node_id': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
            'type': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/cabundles',
            path_variables={
            },
             header_parameters={
                             },
            query_parameters={
                'cursor': 'cursor',
                'details': 'details',
                'included_fields': 'included_fields',
                'node_id': 'node_id',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
                'type': 'type',
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'cabundle_id': type.StringType(),
            'ca_bundle': type.ReferenceType('com.vmware.nsx_policy.model_client', 'CaBundle'),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/infra/cabundles/{cabundle-id}',
            request_body_parameter='ca_bundle',
            path_variables={
                'cabundle_id': 'cabundle-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'cabundle_id': type.StringType(),
            'ca_bundle': type.ReferenceType('com.vmware.nsx_policy.model_client', 'CaBundle'),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/cabundles/{cabundle-id}',
            request_body_parameter='ca_bundle',
            path_variables={
                'cabundle_id': 'cabundle-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'CaBundle'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'CaBundleListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'CaBundle'),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'CaBundle'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'list': list_rest_metadata,
            'patch': patch_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.cabundles',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _CertificatesStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'certificate_id': type.StringType(),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/infra/certificates/{certificate-id}',
            path_variables={
                'certificate_id': 'certificate-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'certificate_id': type.StringType(),
            'details': type.OptionalType(type.BooleanType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/certificates/{certificate-id}',
            path_variables={
                'certificate_id': 'certificate-id',
            },
             header_parameters={
                 },
            query_parameters={
                'details': 'details',
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'cursor': type.OptionalType(type.StringType()),
            'details': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'node_id': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
            'type': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/certificates',
            path_variables={
            },
             header_parameters={
                             },
            query_parameters={
                'cursor': 'cursor',
                'details': 'details',
                'included_fields': 'included_fields',
                'node_id': 'node_id',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
                'type': 'type',
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'certificate_id': type.StringType(),
            'tls_trust_data': type.ReferenceType('com.vmware.nsx_policy.model_client', 'TlsTrustData'),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/infra/certificates/{certificate-id}',
            request_body_parameter='tls_trust_data',
            path_variables={
                'certificate_id': 'certificate-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'certificate_id': type.StringType(),
            'tls_trust_data': type.ReferenceType('com.vmware.nsx_policy.model_client', 'TlsTrustData'),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/certificates/{certificate-id}',
            request_body_parameter='tls_trust_data',
            path_variables={
                'certificate_id': 'certificate-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'TlsCertificate'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'TlsCertificateList'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.VoidType(),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'TlsCertificate'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'list': list_rest_metadata,
            'patch': patch_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.certificates',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _CloudNativeServiceGroupAssociationsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'cns_external_id': type.StringType(),
            'cursor': type.OptionalType(type.StringType()),
            'enforcement_point_path': type.OptionalType(type.StringType()),
            'include_mark_for_delete_objects': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/cloud-native-service-group-associations',
            path_variables={
            },
             header_parameters={
                             },
            query_parameters={
                'cns_external_id': 'cns_external_id',
                'cursor': 'cursor',
                'enforcement_point_path': 'enforcement_point_path',
                'include_mark_for_delete_objects': 'include_mark_for_delete_objects',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        operations = {
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyResourceReferenceForEPListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'list': list_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.cloud_native_service_group_associations',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _ConnectivityGlobalConfigStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'apply_locally': type.OptionalType(type.BooleanType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/connectivity-global-config',
            path_variables={
            },
             header_parameters={
               },
            query_parameters={
                'apply_locally': 'apply_locally',
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'global_config': type.ReferenceType('com.vmware.nsx_policy.model_client', 'GlobalConfig'),
            'apply_locally': type.OptionalType(type.BooleanType()),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/infra/connectivity-global-config',
            request_body_parameter='global_config',
            path_variables={
            },
             header_parameters={
                 },
            query_parameters={
                'apply_locally': 'apply_locally',
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'global_config': type.ReferenceType('com.vmware.nsx_policy.model_client', 'GlobalConfig'),
            'apply_locally': type.OptionalType(type.BooleanType()),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/connectivity-global-config',
            request_body_parameter='global_config',
            path_variables={
            },
             header_parameters={
                 },
            query_parameters={
                'apply_locally': 'apply_locally',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'GlobalConfig'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.VoidType(),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'GlobalConfig'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
            'patch': patch_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.connectivity_global_config',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _ConstraintGlobalConfigStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {})
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/constraint-global-config',
            path_variables={
            },
             header_parameters={
             },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'constraint_global_config': type.ReferenceType('com.vmware.nsx_policy.model_client', 'ConstraintGlobalConfig'),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/infra/constraint-global-config',
            request_body_parameter='constraint_global_config',
            path_variables={
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'constraint_global_config': type.ReferenceType('com.vmware.nsx_policy.model_client', 'ConstraintGlobalConfig'),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/constraint-global-config',
            request_body_parameter='constraint_global_config',
            path_variables={
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'ConstraintGlobalConfig'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.VoidType(),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'ConstraintGlobalConfig'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
            'patch': patch_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.constraint_global_config',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _ConstraintsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'constraint_id': type.StringType(),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/infra/constraints/{constraint-id}',
            path_variables={
                'constraint_id': 'constraint-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'constraint_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/constraints/{constraint-id}',
            path_variables={
                'constraint_id': 'constraint-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'cursor': type.OptionalType(type.StringType()),
            'include_mark_for_delete_objects': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/constraints',
            path_variables={
            },
             header_parameters={
                         },
            query_parameters={
                'cursor': 'cursor',
                'include_mark_for_delete_objects': 'include_mark_for_delete_objects',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'constraint_id': type.StringType(),
            'constraint': type.ReferenceType('com.vmware.nsx_policy.model_client', 'Constraint'),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/infra/constraints/{constraint-id}',
            request_body_parameter='constraint',
            path_variables={
                'constraint_id': 'constraint-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'constraint_id': type.StringType(),
            'constraint': type.ReferenceType('com.vmware.nsx_policy.model_client', 'Constraint'),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/constraints/{constraint-id}',
            request_body_parameter='constraint',
            path_variables={
                'constraint_id': 'constraint-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'Constraint'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'ConstraintListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.VoidType(),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'Constraint'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'list': list_rest_metadata,
            'patch': patch_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.constraints',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _ContextProfilesStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'context_profile_id': type.StringType(),
            'force': type.OptionalType(type.BooleanType()),
            'override': type.OptionalType(type.BooleanType()),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/infra/context-profiles/{context-profile-id}',
            path_variables={
                'context_profile_id': 'context-profile-id',
            },
             header_parameters={
                   },
            query_parameters={
                'force': 'force',
                'override': 'override',
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'context_profile_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/context-profiles/{context-profile-id}',
            path_variables={
                'context_profile_id': 'context-profile-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'cursor': type.OptionalType(type.StringType()),
            'include_mark_for_delete_objects': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/context-profiles',
            path_variables={
            },
             header_parameters={
                         },
            query_parameters={
                'cursor': 'cursor',
                'include_mark_for_delete_objects': 'include_mark_for_delete_objects',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'context_profile_id': type.StringType(),
            'policy_context_profile': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyContextProfile'),
            'override': type.OptionalType(type.BooleanType()),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/infra/context-profiles/{context-profile-id}',
            request_body_parameter='policy_context_profile',
            path_variables={
                'context_profile_id': 'context-profile-id',
            },
             header_parameters={
                   },
            query_parameters={
                'override': 'override',
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'context_profile_id': type.StringType(),
            'policy_context_profile': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyContextProfile'),
            'override': type.OptionalType(type.BooleanType()),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/context-profiles/{context-profile-id}',
            request_body_parameter='policy_context_profile',
            path_variables={
                'context_profile_id': 'context-profile-id',
            },
             header_parameters={
                   },
            query_parameters={
                'override': 'override',
            },
            content_type='application/json'
        )

        operations = {
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyContextProfile'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyContextProfileListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.VoidType(),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyContextProfile'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'list': list_rest_metadata,
            'patch': patch_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.context_profiles',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _CrlsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'crl_id': type.StringType(),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/infra/crls/{crl-id}',
            path_variables={
                'crl_id': 'crl-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'crl_id': type.StringType(),
            'details': type.OptionalType(type.BooleanType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/crls/{crl-id}',
            path_variables={
                'crl_id': 'crl-id',
            },
             header_parameters={
                 },
            query_parameters={
                'details': 'details',
            },
            content_type='application/json'
        )

        # properties for importcrl operation
        importcrl_input_type = type.StructType('operation-input', {
            'crl_id': type.StringType(),
            'tls_crl': type.ReferenceType('com.vmware.nsx_policy.model_client', 'TlsCrl'),
        })
        importcrl_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        importcrl_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        importcrl_output_validator_list = [
            HasFieldsOfValidator()
        ]
        importcrl_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/policy/api/v1/infra/crls/{crl-id}?action=import',
            request_body_parameter='tls_crl',
            path_variables={
                'crl_id': 'crl-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'cursor': type.OptionalType(type.StringType()),
            'details': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'node_id': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
            'type': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/crls',
            path_variables={
            },
             header_parameters={
                             },
            query_parameters={
                'cursor': 'cursor',
                'details': 'details',
                'included_fields': 'included_fields',
                'node_id': 'node_id',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
                'type': 'type',
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'crl_id': type.StringType(),
            'tls_crl': type.ReferenceType('com.vmware.nsx_policy.model_client', 'TlsCrl'),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/infra/crls/{crl-id}',
            request_body_parameter='tls_crl',
            path_variables={
                'crl_id': 'crl-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'crl_id': type.StringType(),
            'tls_crl': type.ReferenceType('com.vmware.nsx_policy.model_client', 'TlsCrl'),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/crls/{crl-id}',
            request_body_parameter='tls_crl',
            path_variables={
                'crl_id': 'crl-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'TlsCrl'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'importcrl': {
                'input_type': importcrl_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'TlsCrlListResult'),
                'errors': importcrl_error_dict,
                'input_value_validator_list': importcrl_input_value_validator_list,
                'output_validator_list': importcrl_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'TlsCrlListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.VoidType(),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'TlsCrl'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'importcrl': importcrl_rest_metadata,
            'list': list_rest_metadata,
            'patch': patch_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.crls',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _CsrsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for create operation
        create_input_type = type.StructType('operation-input', {
            'csr_id': type.StringType(),
            'tls_csr': type.ReferenceType('com.vmware.nsx_policy.model_client', 'TlsCsr'),
        })
        create_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        create_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        create_output_validator_list = [
            HasFieldsOfValidator()
        ]
        create_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/policy/api/v1/infra/csrs/{csr-id}?action=create',
            request_body_parameter='tls_csr',
            path_variables={
                'csr_id': 'csr-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'csr_id': type.StringType(),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/infra/csrs/{csr-id}',
            path_variables={
                'csr_id': 'csr-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'csr_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/csrs/{csr-id}',
            path_variables={
                'csr_id': 'csr-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for importcsr operation
        importcsr_input_type = type.StructType('operation-input', {
            'csr_id': type.StringType(),
            'tls_trust_data': type.ReferenceType('com.vmware.nsx_policy.model_client', 'TlsTrustData'),
        })
        importcsr_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        importcsr_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        importcsr_output_validator_list = [
            HasFieldsOfValidator()
        ]
        importcsr_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/policy/api/v1/infra/csrs/{csr-id}?action=import',
            request_body_parameter='tls_trust_data',
            path_variables={
                'csr_id': 'csr-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'cursor': type.OptionalType(type.StringType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/csrs',
            path_variables={
            },
             header_parameters={
                       },
            query_parameters={
                'cursor': 'cursor',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        # properties for selfsign operation
        selfsign_input_type = type.StructType('operation-input', {
            'csr_id': type.StringType(),
            'days_valid': type.IntegerType(),
        })
        selfsign_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        selfsign_input_value_validator_list = [
        ]
        selfsign_output_validator_list = [
            HasFieldsOfValidator()
        ]
        selfsign_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/policy/api/v1/infra/csrs/{csr-id}?action=self_sign',
            path_variables={
                'csr_id': 'csr-id',
            },
             header_parameters={
                 },
            query_parameters={
                'days_valid': 'days_valid',
            },
            content_type='application/json'
        )

        # properties for selfsign_0 operation
        selfsign_0_input_type = type.StructType('operation-input', {
            'tls_csr_with_days_valid': type.ReferenceType('com.vmware.nsx_policy.model_client', 'TlsCsrWithDaysValid'),
        })
        selfsign_0_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        selfsign_0_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        selfsign_0_output_validator_list = [
            HasFieldsOfValidator()
        ]
        selfsign_0_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/policy/api/v1/infra/csrs?action=self_sign',
            request_body_parameter='tls_csr_with_days_valid',
            path_variables={
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'create': {
                'input_type': create_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'TlsCsr'),
                'errors': create_error_dict,
                'input_value_validator_list': create_input_value_validator_list,
                'output_validator_list': create_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'TlsCsr'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'importcsr': {
                'input_type': importcsr_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'TlsCertificate'),
                'errors': importcsr_error_dict,
                'input_value_validator_list': importcsr_input_value_validator_list,
                'output_validator_list': importcsr_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'TlsCsrListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'selfsign': {
                'input_type': selfsign_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'TlsCertificate'),
                'errors': selfsign_error_dict,
                'input_value_validator_list': selfsign_input_value_validator_list,
                'output_validator_list': selfsign_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'selfsign_0': {
                'input_type': selfsign_0_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'TlsCertificate'),
                'errors': selfsign_0_error_dict,
                'input_value_validator_list': selfsign_0_input_value_validator_list,
                'output_validator_list': selfsign_0_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'create': create_rest_metadata,
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'importcsr': importcsr_rest_metadata,
            'list': list_rest_metadata,
            'selfsign': selfsign_rest_metadata,
            'selfsign_0': selfsign_0_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.csrs',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _DeploymentZonesStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'deployment_zone_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/deployment-zones/{deployment-zone-id}',
            path_variables={
                'deployment_zone_id': 'deployment-zone-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'cursor': type.OptionalType(type.StringType()),
            'include_mark_for_delete_objects': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/deployment-zones',
            path_variables={
            },
             header_parameters={
                         },
            query_parameters={
                'cursor': 'cursor',
                'include_mark_for_delete_objects': 'include_mark_for_delete_objects',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'DeploymentZone'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'DeploymentZoneListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
            'list': list_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.deployment_zones',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _DhcpRelayConfigsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'dhcp_relay_config_id': type.StringType(),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/infra/dhcp-relay-configs/{dhcp-relay-config-id}',
            path_variables={
                'dhcp_relay_config_id': 'dhcp-relay-config-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'dhcp_relay_config_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/dhcp-relay-configs/{dhcp-relay-config-id}',
            path_variables={
                'dhcp_relay_config_id': 'dhcp-relay-config-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'cursor': type.OptionalType(type.StringType()),
            'include_mark_for_delete_objects': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/dhcp-relay-configs',
            path_variables={
            },
             header_parameters={
                         },
            query_parameters={
                'cursor': 'cursor',
                'include_mark_for_delete_objects': 'include_mark_for_delete_objects',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'dhcp_relay_config_id': type.StringType(),
            'dhcp_relay_config': type.ReferenceType('com.vmware.nsx_policy.model_client', 'DhcpRelayConfig'),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/infra/dhcp-relay-configs/{dhcp-relay-config-id}',
            request_body_parameter='dhcp_relay_config',
            path_variables={
                'dhcp_relay_config_id': 'dhcp-relay-config-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'dhcp_relay_config_id': type.StringType(),
            'dhcp_relay_config': type.ReferenceType('com.vmware.nsx_policy.model_client', 'DhcpRelayConfig'),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/dhcp-relay-configs/{dhcp-relay-config-id}',
            request_body_parameter='dhcp_relay_config',
            path_variables={
                'dhcp_relay_config_id': 'dhcp-relay-config-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'DhcpRelayConfig'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'DhcpRelayConfigListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.VoidType(),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'DhcpRelayConfig'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'list': list_rest_metadata,
            'patch': patch_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.dhcp_relay_configs',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _DhcpServerConfigsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'dhcp_server_config_id': type.StringType(),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/infra/dhcp-server-configs/{dhcp-server-config-id}',
            path_variables={
                'dhcp_server_config_id': 'dhcp-server-config-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'dhcp_server_config_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/dhcp-server-configs/{dhcp-server-config-id}',
            path_variables={
                'dhcp_server_config_id': 'dhcp-server-config-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'cursor': type.OptionalType(type.StringType()),
            'include_mark_for_delete_objects': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/dhcp-server-configs',
            path_variables={
            },
             header_parameters={
                         },
            query_parameters={
                'cursor': 'cursor',
                'include_mark_for_delete_objects': 'include_mark_for_delete_objects',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'dhcp_server_config_id': type.StringType(),
            'dhcp_server_config': type.ReferenceType('com.vmware.nsx_policy.model_client', 'DhcpServerConfig'),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/infra/dhcp-server-configs/{dhcp-server-config-id}',
            request_body_parameter='dhcp_server_config',
            path_variables={
                'dhcp_server_config_id': 'dhcp-server-config-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'dhcp_server_config_id': type.StringType(),
            'dhcp_server_config': type.ReferenceType('com.vmware.nsx_policy.model_client', 'DhcpServerConfig'),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/dhcp-server-configs/{dhcp-server-config-id}',
            request_body_parameter='dhcp_server_config',
            path_variables={
                'dhcp_server_config_id': 'dhcp-server-config-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'DhcpServerConfig'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'DhcpServerConfigListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.VoidType(),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'DhcpServerConfig'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'list': list_rest_metadata,
            'patch': patch_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.dhcp_server_configs',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _DnsForwarderZonesStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'dns_forwarder_zone_id': type.StringType(),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/infra/dns-forwarder-zones/{dns-forwarder-zone-id}',
            path_variables={
                'dns_forwarder_zone_id': 'dns-forwarder-zone-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'dns_forwarder_zone_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/dns-forwarder-zones/{dns-forwarder-zone-id}',
            path_variables={
                'dns_forwarder_zone_id': 'dns-forwarder-zone-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'cursor': type.OptionalType(type.StringType()),
            'include_mark_for_delete_objects': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/dns-forwarder-zones',
            path_variables={
            },
             header_parameters={
                         },
            query_parameters={
                'cursor': 'cursor',
                'include_mark_for_delete_objects': 'include_mark_for_delete_objects',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'dns_forwarder_zone_id': type.StringType(),
            'policy_dns_forwarder_zone': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyDnsForwarderZone'),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/infra/dns-forwarder-zones/{dns-forwarder-zone-id}',
            request_body_parameter='policy_dns_forwarder_zone',
            path_variables={
                'dns_forwarder_zone_id': 'dns-forwarder-zone-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'dns_forwarder_zone_id': type.StringType(),
            'policy_dns_forwarder_zone': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyDnsForwarderZone'),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/dns-forwarder-zones/{dns-forwarder-zone-id}',
            request_body_parameter='policy_dns_forwarder_zone',
            path_variables={
                'dns_forwarder_zone_id': 'dns-forwarder-zone-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyDnsForwarderZone'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyDnsForwarderZoneListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.VoidType(),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyDnsForwarderZone'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'list': list_rest_metadata,
            'patch': patch_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.dns_forwarder_zones',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _DnsSecurityProfilesStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'profile_id': type.StringType(),
            'override': type.OptionalType(type.BooleanType()),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/infra/dns-security-profiles/{profile-id}',
            path_variables={
                'profile_id': 'profile-id',
            },
             header_parameters={
                 },
            query_parameters={
                'override': 'override',
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'profile_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/dns-security-profiles/{profile-id}',
            path_variables={
                'profile_id': 'profile-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'cursor': type.OptionalType(type.StringType()),
            'include_mark_for_delete_objects': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/dns-security-profiles',
            path_variables={
            },
             header_parameters={
                         },
            query_parameters={
                'cursor': 'cursor',
                'include_mark_for_delete_objects': 'include_mark_for_delete_objects',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'profile_id': type.StringType(),
            'dns_security_profile': type.ReferenceType('com.vmware.nsx_policy.model_client', 'DnsSecurityProfile'),
            'override': type.OptionalType(type.BooleanType()),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/infra/dns-security-profiles/{profile-id}',
            request_body_parameter='dns_security_profile',
            path_variables={
                'profile_id': 'profile-id',
            },
             header_parameters={
                   },
            query_parameters={
                'override': 'override',
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'profile_id': type.StringType(),
            'dns_security_profile': type.ReferenceType('com.vmware.nsx_policy.model_client', 'DnsSecurityProfile'),
            'override': type.OptionalType(type.BooleanType()),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/dns-security-profiles/{profile-id}',
            request_body_parameter='dns_security_profile',
            path_variables={
                'profile_id': 'profile-id',
            },
             header_parameters={
                   },
            query_parameters={
                'override': 'override',
            },
            content_type='application/json'
        )

        operations = {
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'DnsSecurityProfile'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'DnsSecurityProfileListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.VoidType(),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'DnsSecurityProfile'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'list': list_rest_metadata,
            'patch': patch_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.dns_security_profiles',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _DomainsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'domain_id': type.StringType(),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/infra/domains/{domain-id}',
            path_variables={
                'domain_id': 'domain-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'domain_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/domains/{domain-id}',
            path_variables={
                'domain_id': 'domain-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'cursor': type.OptionalType(type.StringType()),
            'include_mark_for_delete_objects': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/domains',
            path_variables={
            },
             header_parameters={
                         },
            query_parameters={
                'cursor': 'cursor',
                'include_mark_for_delete_objects': 'include_mark_for_delete_objects',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'domain_id': type.StringType(),
            'domain': type.ReferenceType('com.vmware.nsx_policy.model_client', 'Domain'),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/infra/domains/{domain-id}',
            request_body_parameter='domain',
            path_variables={
                'domain_id': 'domain-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'domain_id': type.StringType(),
            'domain': type.ReferenceType('com.vmware.nsx_policy.model_client', 'Domain'),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/domains/{domain-id}',
            request_body_parameter='domain',
            path_variables={
                'domain_id': 'domain-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'Domain'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'DomainListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.VoidType(),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'Domain'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'list': list_rest_metadata,
            'patch': patch_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.domains',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _DraftsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'draft_id': type.StringType(),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/infra/drafts/{draft-id}',
            path_variables={
                'draft_id': 'draft-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'draft_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/drafts/{draft-id}',
            path_variables={
                'draft_id': 'draft-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'auto_drafts': type.OptionalType(type.BooleanType()),
            'cursor': type.OptionalType(type.StringType()),
            'include_mark_for_delete_objects': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/drafts',
            path_variables={
            },
             header_parameters={
                           },
            query_parameters={
                'auto_drafts': 'auto_drafts',
                'cursor': 'cursor',
                'include_mark_for_delete_objects': 'include_mark_for_delete_objects',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'draft_id': type.StringType(),
            'policy_draft': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyDraft'),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/infra/drafts/{draft-id}',
            request_body_parameter='policy_draft',
            path_variables={
                'draft_id': 'draft-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for publish operation
        publish_input_type = type.StructType('operation-input', {
            'draft_id': type.StringType(),
            'infra': type.ReferenceType('com.vmware.nsx_policy.model_client', 'Infra'),
        })
        publish_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        publish_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        publish_output_validator_list = [
        ]
        publish_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/policy/api/v1/infra/drafts/{draft-id}?action=publish',
            request_body_parameter='infra',
            path_variables={
                'draft_id': 'draft-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'draft_id': type.StringType(),
            'policy_draft': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyDraft'),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/drafts/{draft-id}',
            request_body_parameter='policy_draft',
            path_variables={
                'draft_id': 'draft-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyDraft'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyDraftListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.VoidType(),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'publish': {
                'input_type': publish_input_type,
                'output_type': type.VoidType(),
                'errors': publish_error_dict,
                'input_value_validator_list': publish_input_value_validator_list,
                'output_validator_list': publish_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyDraft'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'list': list_rest_metadata,
            'patch': patch_rest_metadata,
            'publish': publish_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.drafts',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _EvpnTenantConfigsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'config_id': type.StringType(),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/infra/evpn-tenant-configs/{config-id}',
            path_variables={
                'config_id': 'config-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'config_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/evpn-tenant-configs/{config-id}',
            path_variables={
                'config_id': 'config-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'cursor': type.OptionalType(type.StringType()),
            'include_mark_for_delete_objects': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/evpn-tenant-configs',
            path_variables={
            },
             header_parameters={
                         },
            query_parameters={
                'cursor': 'cursor',
                'include_mark_for_delete_objects': 'include_mark_for_delete_objects',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'config_id': type.StringType(),
            'evpn_tenant_config': type.ReferenceType('com.vmware.nsx_policy.model_client', 'EvpnTenantConfig'),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/infra/evpn-tenant-configs/{config-id}',
            request_body_parameter='evpn_tenant_config',
            path_variables={
                'config_id': 'config-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'config_id': type.StringType(),
            'evpn_tenant_config': type.ReferenceType('com.vmware.nsx_policy.model_client', 'EvpnTenantConfig'),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/evpn-tenant-configs/{config-id}',
            request_body_parameter='evpn_tenant_config',
            path_variables={
                'config_id': 'config-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'EvpnTenantConfig'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'EvpnTenantConfigListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.VoidType(),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'EvpnTenantConfig'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'list': list_rest_metadata,
            'patch': patch_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.evpn_tenant_configs',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _FeaturesStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'site_path': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/features',
            path_variables={
            },
             header_parameters={
               },
            query_parameters={
                'site_path': 'site_path',
            },
            content_type='application/json'
        )

        operations = {
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'AggregatedFeatureListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'list': list_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.features',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _FederationConfigStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {})
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/federation-config',
            path_variables={
            },
             header_parameters={
             },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'FederationConfig'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.federation_config',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _FirewallIdentityStoreLdapServerStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for create operation
        create_input_type = type.StructType('operation-input', {
            'directory_ldap_server': type.ReferenceType('com.vmware.nsx_policy.model_client', 'DirectoryLdapServer'),
            'action': type.StringType(),
            'enforcement_point_path': type.OptionalType(type.StringType()),
        })
        create_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        create_input_value_validator_list = [
        ]
        create_output_validator_list = [
        ]
        create_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/policy/api/v1/infra/firewall-identity-store-ldap-server',
            request_body_parameter='directory_ldap_server',
            path_variables={
            },
             header_parameters={
                   },
            query_parameters={
                'action': 'action',
                'enforcement_point_path': 'enforcement_point_path',
            },
            content_type='application/json'
        )

        operations = {
            'create': {
                'input_type': create_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'DirectoryLdapServerStatus'),
                'errors': create_error_dict,
                'input_value_validator_list': create_input_value_validator_list,
                'output_validator_list': create_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'create': create_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.firewall_identity_store_ldap_server',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _FirewallIdentityStoreSizeStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for create operation
        create_input_type = type.StructType('operation-input', {
            'directory_domain': type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType('com.vmware.nsx_policy.model_client', 'DirectoryDomain')]),
            'enforcement_point_path': type.OptionalType(type.StringType()),
        })
        create_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        create_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        create_output_validator_list = [
        ]
        create_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/policy/api/v1/infra/firewall-identity-store-size',
            request_body_parameter='directory_domain',
            path_variables={
            },
             header_parameters={
                 },
            query_parameters={
                'enforcement_point_path': 'enforcement_point_path',
            },
            content_type='application/json'
        )

        operations = {
            'create': {
                'input_type': create_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'DirectoryDomainSize'),
                'errors': create_error_dict,
                'input_value_validator_list': create_input_value_validator_list,
                'output_validator_list': create_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'create': create_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.firewall_identity_store_size',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _FirewallIdentityStoresStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for create operation
        create_input_type = type.StructType('operation-input', {
            'firewall_identity_store_id': type.StringType(),
            'action': type.StringType(),
            'delay': type.OptionalType(type.IntegerType()),
            'enforcement_point_path': type.OptionalType(type.StringType()),
        })
        create_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        create_input_value_validator_list = [
        ]
        create_output_validator_list = [
        ]
        create_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/policy/api/v1/infra/firewall-identity-stores/{firewall-identity-store-id}',
            path_variables={
                'firewall_identity_store_id': 'firewall-identity-store-id',
            },
             header_parameters={
                     },
            query_parameters={
                'action': 'action',
                'delay': 'delay',
                'enforcement_point_path': 'enforcement_point_path',
            },
            content_type='application/json'
        )

        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'firewall_identity_store_id': type.StringType(),
            'enforcement_point_path': type.OptionalType(type.StringType()),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/infra/firewall-identity-stores/{firewall-identity-store-id}',
            path_variables={
                'firewall_identity_store_id': 'firewall-identity-store-id',
            },
             header_parameters={
                 },
            query_parameters={
                'enforcement_point_path': 'enforcement_point_path',
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'firewall_identity_store_id': type.StringType(),
            'enforcement_point_path': type.OptionalType(type.StringType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/firewall-identity-stores/{firewall-identity-store-id}',
            path_variables={
                'firewall_identity_store_id': 'firewall-identity-store-id',
            },
             header_parameters={
                 },
            query_parameters={
                'enforcement_point_path': 'enforcement_point_path',
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'cursor': type.OptionalType(type.StringType()),
            'enforcement_point_path': type.OptionalType(type.StringType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/firewall-identity-stores',
            path_variables={
            },
             header_parameters={
                         },
            query_parameters={
                'cursor': 'cursor',
                'enforcement_point_path': 'enforcement_point_path',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'firewall_identity_store_id': type.StringType(),
            'directory_domain': type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType('com.vmware.nsx_policy.model_client', 'DirectoryDomain')]),
            'enforcement_point_path': type.OptionalType(type.StringType()),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/infra/firewall-identity-stores/{firewall-identity-store-id}',
            request_body_parameter='directory_domain',
            path_variables={
                'firewall_identity_store_id': 'firewall-identity-store-id',
            },
             header_parameters={
                   },
            query_parameters={
                'enforcement_point_path': 'enforcement_point_path',
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'firewall_identity_store_id': type.StringType(),
            'directory_domain': type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType('com.vmware.nsx_policy.model_client', 'DirectoryDomain')]),
            'enforcement_point_path': type.OptionalType(type.StringType()),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/firewall-identity-stores/{firewall-identity-store-id}',
            request_body_parameter='directory_domain',
            path_variables={
                'firewall_identity_store_id': 'firewall-identity-store-id',
            },
             header_parameters={
                   },
            query_parameters={
                'enforcement_point_path': 'enforcement_point_path',
            },
            content_type='application/json'
        )

        operations = {
            'create': {
                'input_type': create_input_type,
                'output_type': type.VoidType(),
                'errors': create_error_dict,
                'input_value_validator_list': create_input_value_validator_list,
                'output_validator_list': create_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType('com.vmware.nsx_policy.model_client', 'DirectoryDomain')]),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'DirectoryDomainListResults'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.VoidType(),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType('com.vmware.nsx_policy.model_client', 'DirectoryDomain')]),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'create': create_rest_metadata,
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'list': list_rest_metadata,
            'patch': patch_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.firewall_identity_stores',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _FirewallIdentityStoresOrgUnitsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for create operation
        create_input_type = type.StructType('operation-input', {
            'directory_ldap_server': type.ReferenceType('com.vmware.nsx_policy.model_client', 'DirectoryLdapServer'),
            'enforcement_point_path': type.OptionalType(type.StringType()),
        })
        create_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        create_input_value_validator_list = [
        ]
        create_output_validator_list = [
        ]
        create_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/policy/api/v1/infra/firewall-identity-stores-org-units',
            request_body_parameter='directory_ldap_server',
            path_variables={
            },
             header_parameters={
                 },
            query_parameters={
                'enforcement_point_path': 'enforcement_point_path',
            },
            content_type='application/json'
        )

        operations = {
            'create': {
                'input_type': create_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'DirectoryOrgUnitListResults'),
                'errors': create_error_dict,
                'input_value_validator_list': create_input_value_validator_list,
                'output_validator_list': create_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'create': create_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.firewall_identity_stores_org_units',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _FirewallIpReputationFeedStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for create operation
        create_input_type = type.StructType('operation-input', {
            'operation': type.StringType(),
        })
        create_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        create_input_value_validator_list = [
        ]
        create_output_validator_list = [
            HasFieldsOfValidator()
        ]
        create_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/policy/api/v1/infra/firewall-ip-reputation-feed',
            path_variables={
            },
             header_parameters={
               },
            query_parameters={
                'operation': 'operation',
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {})
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/firewall-ip-reputation-feed',
            path_variables={
            },
             header_parameters={
             },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'create': {
                'input_type': create_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyFirewallIpReputationConfig'),
                'errors': create_error_dict,
                'input_value_validator_list': create_input_value_validator_list,
                'output_validator_list': create_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyFirewallIpReputationConfig'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'create': create_rest_metadata,
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.firewall_ip_reputation_feed',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _FirewallSchedulersStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'firewall_scheduler_id': type.StringType(),
            'force': type.OptionalType(type.BooleanType()),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/infra/firewall-schedulers/{firewall-scheduler-id}',
            path_variables={
                'firewall_scheduler_id': 'firewall-scheduler-id',
            },
             header_parameters={
                 },
            query_parameters={
                'force': 'force',
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'firewall_scheduler_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/firewall-schedulers/{firewall-scheduler-id}',
            path_variables={
                'firewall_scheduler_id': 'firewall-scheduler-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'cursor': type.OptionalType(type.StringType()),
            'include_mark_for_delete_objects': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/firewall-schedulers',
            path_variables={
            },
             header_parameters={
                         },
            query_parameters={
                'cursor': 'cursor',
                'include_mark_for_delete_objects': 'include_mark_for_delete_objects',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'firewall_scheduler_id': type.StringType(),
            'policy_firewall_scheduler': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyFirewallScheduler'),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/infra/firewall-schedulers/{firewall-scheduler-id}',
            request_body_parameter='policy_firewall_scheduler',
            path_variables={
                'firewall_scheduler_id': 'firewall-scheduler-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'firewall_scheduler_id': type.StringType(),
            'policy_firewall_scheduler': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyFirewallScheduler'),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/firewall-schedulers/{firewall-scheduler-id}',
            request_body_parameter='policy_firewall_scheduler',
            path_variables={
                'firewall_scheduler_id': 'firewall-scheduler-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyFirewallScheduler'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyFirewallSchedulerListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.VoidType(),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyFirewallScheduler'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'list': list_rest_metadata,
            'patch': patch_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.firewall_schedulers',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _FirewallSessionTimerProfilesStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'firewall_session_timer_profile_id': type.StringType(),
            'override': type.OptionalType(type.BooleanType()),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/infra/firewall-session-timer-profiles/{firewall-session-timer-profile-id}',
            path_variables={
                'firewall_session_timer_profile_id': 'firewall-session-timer-profile-id',
            },
             header_parameters={
                 },
            query_parameters={
                'override': 'override',
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'firewall_session_timer_profile_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/firewall-session-timer-profiles/{firewall-session-timer-profile-id}',
            path_variables={
                'firewall_session_timer_profile_id': 'firewall-session-timer-profile-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'cursor': type.OptionalType(type.StringType()),
            'include_mark_for_delete_objects': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/firewall-session-timer-profiles',
            path_variables={
            },
             header_parameters={
                         },
            query_parameters={
                'cursor': 'cursor',
                'include_mark_for_delete_objects': 'include_mark_for_delete_objects',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'firewall_session_timer_profile_id': type.StringType(),
            'policy_firewall_session_timer_profile': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyFirewallSessionTimerProfile'),
            'override': type.OptionalType(type.BooleanType()),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/infra/firewall-session-timer-profiles/{firewall-session-timer-profile-id}',
            request_body_parameter='policy_firewall_session_timer_profile',
            path_variables={
                'firewall_session_timer_profile_id': 'firewall-session-timer-profile-id',
            },
             header_parameters={
                   },
            query_parameters={
                'override': 'override',
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'firewall_session_timer_profile_id': type.StringType(),
            'policy_firewall_session_timer_profile': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyFirewallSessionTimerProfile'),
            'override': type.OptionalType(type.BooleanType()),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/firewall-session-timer-profiles/{firewall-session-timer-profile-id}',
            request_body_parameter='policy_firewall_session_timer_profile',
            path_variables={
                'firewall_session_timer_profile_id': 'firewall-session-timer-profile-id',
            },
             header_parameters={
                   },
            query_parameters={
                'override': 'override',
            },
            content_type='application/json'
        )

        operations = {
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyFirewallSessionTimerProfile'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyFirewallSessionTimerProfileListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.VoidType(),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'PolicyFirewallSessionTimerProfile'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'list': list_rest_metadata,
            'patch': patch_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.firewall_session_timer_profiles',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _FloodProtectionProfilesStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'flood_protection_profile_id': type.StringType(),
            'override': type.OptionalType(type.BooleanType()),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/infra/flood-protection-profiles/{flood-protection-profile-id}',
            path_variables={
                'flood_protection_profile_id': 'flood-protection-profile-id',
            },
             header_parameters={
                 },
            query_parameters={
                'override': 'override',
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'flood_protection_profile_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/flood-protection-profiles/{flood-protection-profile-id}',
            path_variables={
                'flood_protection_profile_id': 'flood-protection-profile-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'cursor': type.OptionalType(type.StringType()),
            'include_mark_for_delete_objects': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/flood-protection-profiles',
            path_variables={
            },
             header_parameters={
                         },
            query_parameters={
                'cursor': 'cursor',
                'include_mark_for_delete_objects': 'include_mark_for_delete_objects',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'flood_protection_profile_id': type.StringType(),
            'flood_protection_profile': type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType('com.vmware.nsx_policy.model_client', 'FloodProtectionProfile')]),
            'override': type.OptionalType(type.BooleanType()),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/infra/flood-protection-profiles/{flood-protection-profile-id}',
            request_body_parameter='flood_protection_profile',
            path_variables={
                'flood_protection_profile_id': 'flood-protection-profile-id',
            },
             header_parameters={
                   },
            query_parameters={
                'override': 'override',
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'flood_protection_profile_id': type.StringType(),
            'flood_protection_profile': type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType('com.vmware.nsx_policy.model_client', 'FloodProtectionProfile')]),
            'override': type.OptionalType(type.BooleanType()),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/flood-protection-profiles/{flood-protection-profile-id}',
            request_body_parameter='flood_protection_profile',
            path_variables={
                'flood_protection_profile_id': 'flood-protection-profile-id',
            },
             header_parameters={
                   },
            query_parameters={
                'override': 'override',
            },
            content_type='application/json'
        )

        operations = {
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType('com.vmware.nsx_policy.model_client', 'FloodProtectionProfile')]),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'FloodProtectionProfileListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.VoidType(),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType('com.vmware.nsx_policy.model_client', 'FloodProtectionProfile')]),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'list': list_rest_metadata,
            'patch': patch_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.flood_protection_profiles',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _FullSyncActionStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for create operation
        create_input_type = type.StructType('operation-input', {
            'action': type.StringType(),
            'site': type.OptionalType(type.StringType()),
            'sync_type': type.OptionalType(type.StringType()),
        })
        create_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        create_input_value_validator_list = [
        ]
        create_output_validator_list = [
        ]
        create_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/policy/api/v1/infra/full-sync-action',
            path_variables={
            },
             header_parameters={
                   },
            query_parameters={
                'action': 'action',
                'site': 'site',
                'sync_type': 'sync_type',
            },
            content_type='application/json'
        )

        operations = {
            'create': {
                'input_type': create_input_type,
                'output_type': type.VoidType(),
                'errors': create_error_dict,
                'input_value_validator_list': create_input_value_validator_list,
                'output_validator_list': create_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'create': create_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.full_sync_action',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _FullSyncStatesStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'full_sync_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/full-sync-states/{full-sync-id}',
            path_variables={
                'full_sync_id': 'full-sync-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'cursor': type.OptionalType(type.StringType()),
            'include_mark_for_delete_objects': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/full-sync-states',
            path_variables={
            },
             header_parameters={
                         },
            query_parameters={
                'cursor': 'cursor',
                'include_mark_for_delete_objects': 'include_mark_for_delete_objects',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'FullSyncState'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'FullSyncStateListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
            'list': list_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.full_sync_states',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _GatewayQosProfilesStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'qos_profile_id': type.StringType(),
            'override': type.OptionalType(type.BooleanType()),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/infra/gateway-qos-profiles/{qos-profile-id}',
            path_variables={
                'qos_profile_id': 'qos-profile-id',
            },
             header_parameters={
                 },
            query_parameters={
                'override': 'override',
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'qos_profile_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/gateway-qos-profiles/{qos-profile-id}',
            path_variables={
                'qos_profile_id': 'qos-profile-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'cursor': type.OptionalType(type.StringType()),
            'include_mark_for_delete_objects': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/gateway-qos-profiles',
            path_variables={
            },
             header_parameters={
                         },
            query_parameters={
                'cursor': 'cursor',
                'include_mark_for_delete_objects': 'include_mark_for_delete_objects',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'qos_profile_id': type.StringType(),
            'gateway_qos_profile': type.ReferenceType('com.vmware.nsx_policy.model_client', 'GatewayQosProfile'),
            'override': type.OptionalType(type.BooleanType()),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/infra/gateway-qos-profiles/{qos-profile-id}',
            request_body_parameter='gateway_qos_profile',
            path_variables={
                'qos_profile_id': 'qos-profile-id',
            },
             header_parameters={
                   },
            query_parameters={
                'override': 'override',
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'qos_profile_id': type.StringType(),
            'gateway_qos_profile': type.ReferenceType('com.vmware.nsx_policy.model_client', 'GatewayQosProfile'),
            'override': type.OptionalType(type.BooleanType()),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware