/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.enterprise;

import ca.sqlpower.architect.ArchitectSession;
import ca.sqlpower.architect.enterprise.ArchitectClientSideSession;
import ca.sqlpower.architect.enterprise.DomainCategory;
import ca.sqlpower.architect.swingui.ArchitectSwingProject;
import ca.sqlpower.architect.swingui.enterprise.GroupEditorPanel;
import ca.sqlpower.architect.swingui.enterprise.ProjectSecurityPanel;
import ca.sqlpower.architect.swingui.enterprise.UserEditorPanel;
import ca.sqlpower.enterprise.AbstractNetworkConflictResolver;
import ca.sqlpower.enterprise.client.Grant;
import ca.sqlpower.enterprise.client.Group;
import ca.sqlpower.enterprise.client.SPServerInfo;
import ca.sqlpower.enterprise.client.User;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.SPSUtils;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.codec.binary.Hex;

public class SecurityPanel {
    private static final ImageIcon USER_ICON = new ImageIcon(SecurityPanel.class.getResource("icons/user.png"));
    private static final ImageIcon GROUP_ICON = new ImageIcon(SecurityPanel.class.getResource("icons/group.png"));
    private final Action closeAction;
    private final JTree tree;
    private final DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Security");
    private final DefaultMutableTreeNode usersNode = new DefaultMutableTreeNode("Users");
    private final DefaultMutableTreeNode groupsNode = new DefaultMutableTreeNode("Groups");
    private final JPanel panel;
    private final JSplitPane splitpane;
    private final JPanel rightSidePanel;
    private final JScrollPane treePane;
    private final ArchitectSwingProject securityWorkspace;
    private final String username;
    private DataEntryPanel currentGroupOrUserEditPanel;
    private DefaultMutableTreeNode selectionForEditors;
    private final TreeSelectionListener treeListener = new TreeSelectionListener(){

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)SecurityPanel.this.tree.getLastSelectedPathComponent();
            if (dmtn != null && dmtn.isLeaf() && dmtn != SecurityPanel.this.groupsNode && dmtn != SecurityPanel.this.usersNode) {
                if (SecurityPanel.this.promptForUnsavedChanges()) {
                    SecurityPanel.this.createEditPanel((SPObject)dmtn.getUserObject());
                    SecurityPanel.this.panel.revalidate();
                    SecurityPanel.this.selectionForEditors = dmtn;
                } else if (SecurityPanel.this.selectionForEditors != null) {
                    SecurityPanel.this.tree.removeTreeSelectionListener(SecurityPanel.this.treeListener);
                    SecurityPanel.this.tree.setSelectionPath(new TreePath(SecurityPanel.this.selectionForEditors.getPath()));
                    SecurityPanel.this.tree.addTreeSelectionListener(SecurityPanel.this.treeListener);
                }
            }
        }
    };
    private final MouseListener popupListener = new MouseListener(){

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                DefaultMutableTreeNode node;
                TreePath path = SecurityPanel.this.tree.getPathForLocation(e.getX(), e.getY());
                try {
                    node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    SecurityPanel.this.tree.setSelectionPath(path);
                }
                catch (Exception ex) {
                    node = null;
                }
                JPopupMenu popupMenu = new JPopupMenu();
                if (node != null) {
                    SPObject obj;
                    try {
                        obj = (SPObject)node.getUserObject();
                    }
                    catch (Exception ex) {
                        obj = null;
                    }
                    popupMenu.add(new EditAction(path));
                    popupMenu.add(new EditSecuritySettingsAction(path));
                    if (obj != null) {
                        popupMenu.add(new DeleteAction(obj));
                    }
                    popupMenu.addSeparator();
                }
                popupMenu.add(SecurityPanel.this.newUserAction);
                popupMenu.add(SecurityPanel.this.newGroupAction);
                popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    };
    private final Action newUserAction = new AbstractAction("New User..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            User user;
            if (SecurityPanel.this.promptForUnsavedChanges() && (user = SecurityPanel.this.createUserFromPrompter()) != null) {
                try {
                    SecurityPanel.this.securityWorkspace.begin("Creating a new user");
                    SecurityPanel.this.securityWorkspace.addChild((SPObject)user, SecurityPanel.this.securityWorkspace.getChildren(User.class).size());
                    DomainCategory category = new DomainCategory(user.getName() + "'s Domains");
                    user.addGrant(new Grant((SPObject)category, true, true, true, true, true));
                    SecurityPanel.this.securityWorkspace.addChild((SPObject)category, SecurityPanel.this.securityWorkspace.getChildren(DomainCategory.class).size());
                    SecurityPanel.this.securityWorkspace.commit();
                }
                catch (Exception ex) {
                    SecurityPanel.this.securityWorkspace.rollback(ex.getMessage());
                    throw new RuntimeException(ex);
                }
                SecurityPanel.this.refreshTree();
                Enumeration<TreeNode> userNodes = SecurityPanel.this.usersNode.children();
                while (userNodes.hasMoreElements()) {
                    DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)userNodes.nextElement();
                    if (!((User)dmtn.getUserObject()).getUUID().equals(user.getUUID())) continue;
                    SecurityPanel.this.tree.setSelectionPath(new TreePath(dmtn.getPath()));
                }
            }
        }
    };
    private final Action newGroupAction = new AbstractAction("New Group..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            Group group;
            if (SecurityPanel.this.promptForUnsavedChanges() && (group = SecurityPanel.this.createGroupFromPrompter()) != null) {
                SecurityPanel.this.securityWorkspace.addChild((SPObject)group, SecurityPanel.this.securityWorkspace.getChildren(Group.class).size());
                SecurityPanel.this.refreshTree();
                Enumeration<TreeNode> userNodes = SecurityPanel.this.groupsNode.children();
                while (userNodes.hasMoreElements()) {
                    DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)userNodes.nextElement();
                    if (!((Group)dmtn.getUserObject()).getUUID().equals(group.getUUID())) continue;
                    SecurityPanel.this.tree.setSelectionPath(new TreePath(dmtn.getPath()));
                }
            }
        }
    };
    private final MessageDigest digester;
    private final Dialog dialog;
    private final ArchitectSession session;

    public SecurityPanel(SPServerInfo serverInfo, Action closeAction, Dialog d, ArchitectSession session) {
        this.closeAction = closeAction;
        this.splitpane = new JSplitPane();
        this.panel = new JPanel();
        ArchitectClientSideSession clientSideSession = ArchitectClientSideSession.getSecuritySessions().get(serverInfo.getServerAddress());
        if (clientSideSession.getUpdater().getRevision() <= 0) {
            JLabel messageLabel = new JLabel("Opening");
            JProgressBar progressBar = new JProgressBar();
            progressBar.setIndeterminate(true);
            DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("pref:grow, 5dlu, pref"));
            builder.setDefaultDialogBorder();
            builder.append((Component)messageLabel, 3);
            builder.nextLine();
            builder.append((Component)progressBar, 3);
            AbstractNetworkConflictResolver.UpdateListener l = new AbstractNetworkConflictResolver.UpdateListener(){

                public void workspaceDeleted() {
                }

                public boolean updatePerformed(AbstractNetworkConflictResolver resolver) {
                    SecurityPanel.this.panel.removeAll();
                    SecurityPanel.this.panel.add(SecurityPanel.this.splitpane);
                    SecurityPanel.this.dialog.pack();
                    SecurityPanel.this.refreshTree();
                    return true;
                }

                public boolean updateException(AbstractNetworkConflictResolver resolver, Throwable t) {
                    return true;
                }

                public void preUpdatePerformed(AbstractNetworkConflictResolver resolver) {
                }
            };
            clientSideSession.getUpdater().addListener(l);
            this.panel.add(builder.getPanel());
        }
        this.securityWorkspace = clientSideSession.getWorkspace();
        this.username = serverInfo.getUsername();
        this.dialog = d;
        this.session = session;
        try {
            this.digester = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        this.rootNode.add(this.usersNode);
        this.rootNode.add(this.groupsNode);
        this.rightSidePanel = new JPanel();
        this.tree = new JTree(this.rootNode);
        this.tree.addTreeSelectionListener(this.treeListener);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                if (userObject instanceof User) {
                    this.setIcon(USER_ICON);
                } else if (userObject instanceof Group) {
                    this.setIcon(GROUP_ICON);
                }
                return this;
            }
        });
        this.treePane = new JScrollPane(this.tree);
        this.treePane.setPreferredSize(new Dimension(200, this.treePane.getPreferredSize().height));
        this.tree.addMouseListener(this.popupListener);
        this.splitpane.setRightComponent(this.rightSidePanel);
        this.splitpane.setLeftComponent(this.treePane);
        if (clientSideSession.getUpdater().getRevision() > 0) {
            this.panel.removeAll();
            this.panel.add(this.splitpane);
        }
        this.refreshTree();
        try {
            this.tree.setSelectionPath(new TreePath(this.usersNode.getFirstChild()));
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
    }

    private void refreshTree() {
        this.tree.setModel(new DefaultTreeModel(this.rootNode));
        this.usersNode.removeAllChildren();
        for (User user : this.securityWorkspace.getChildren(User.class)) {
            this.usersNode.add(new DefaultMutableTreeNode(user));
        }
        this.groupsNode.removeAllChildren();
        for (Group group : this.securityWorkspace.getChildren(Group.class)) {
            this.groupsNode.add(new DefaultMutableTreeNode(group));
        }
        this.tree.expandPath(new TreePath(this.usersNode.getPath()));
        this.tree.expandPath(new TreePath(this.groupsNode.getPath()));
    }

    private void createEditPanel(SPObject groupOrUser) {
        Object groupOrUserEditPanel;
        if (groupOrUser instanceof Group) {
            groupOrUserEditPanel = new GroupEditorPanel((Group)groupOrUser, this.username, this.closeAction);
        } else if (groupOrUser instanceof User) {
            groupOrUserEditPanel = new UserEditorPanel((User)groupOrUser, this.username, this.closeAction, this.session);
        } else {
            throw new IllegalStateException("Argument must be instance of Group or User");
        }
        this.currentGroupOrUserEditPanel = groupOrUserEditPanel;
        this.rightSidePanel.removeAll();
        this.rightSidePanel.add(groupOrUserEditPanel.getPanel());
        this.panel.revalidate();
        this.dialog.pack();
    }

    private User createUserFromPrompter() {
        JTextField nameField = new JTextField(15);
        JPasswordField passField = new JPasswordField(15);
        JPasswordField confirmField = new JPasswordField(15);
        JPanel namePanel = new JPanel(new BorderLayout());
        namePanel.add((Component)new JLabel("User Name"), "West");
        namePanel.add((Component)nameField, "East");
        JPanel passPanel = new JPanel(new BorderLayout());
        passPanel.add((Component)new JLabel("Password"), "West");
        passPanel.add((Component)passField, "East");
        JPanel confirmPanel = new JPanel(new BorderLayout());
        confirmPanel.add((Component)new JLabel("Confirm Password"), "West");
        confirmPanel.add((Component)confirmField, "East");
        Object[] messages = new Object[]{"Specify the User's Name and Password.", namePanel, passPanel, confirmPanel};
        Object[] options = new String[]{"OK", "Cancel"};
        int option = JOptionPane.showOptionDialog(this.getPanel(), messages, "Specify the User's Name and Password", -1, 1, null, options, options[0]);
        if (nameField.getText().equals("") || nameField.getText() == null || ((JTextComponent)passField).getText().equals("") || ((JTextComponent)passField).getText() == null) {
            return null;
        }
        if (!((JTextComponent)passField).getText().equals(((JTextComponent)confirmField).getText())) {
            JOptionPane.showMessageDialog(this.getPanel(), "The passwords you entered do not match.", "Error", 0);
            return null;
        }
        User user = null;
        if (option == 0) {
            String password;
            try {
                password = new String(Hex.encodeHex((byte[])this.digester.digest(((JTextComponent)passField).getText().getBytes("UTF-8"))));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Unable to encode password", e);
            }
            user = new User(nameField.getText(), password);
        }
        return user;
    }

    private Group createGroupFromPrompter() {
        String input = JOptionPane.showInputDialog(this.getPanel(), "Enter a name for the group.", "Enter the name of the group.", 1);
        if (input != null && !input.equals("")) {
            return new Group(input);
        }
        return null;
    }

    private boolean promptForUnsavedChanges() {
        if (this.currentGroupOrUserEditPanel != null && this.currentGroupOrUserEditPanel.hasUnsavedChanges()) {
            int option = JOptionPane.showConfirmDialog(this.getPanel(), "You have not saved all of your changes,\ndo you want to save them now?", "", 1);
            if (option == 0) {
                this.currentGroupOrUserEditPanel.applyChanges();
                return true;
            }
            if (option == 1) {
                return true;
            }
            if (option == 2) {
                return false;
            }
        }
        return true;
    }

    private boolean promptForDelete(SPObject obj) {
        String typeString = "";
        if (obj instanceof User) {
            typeString = "User";
        }
        if (obj instanceof Group) {
            typeString = "Group";
        }
        Object[] options = new Object[]{"Yes", "No"};
        int option = JOptionPane.showOptionDialog(null, new Object[]{"Are you sure you want to delete the " + typeString + " \"" + obj.getName() + "\"?"}, "", -1, 1, null, options, options[0]);
        return option == 0;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    private class DeleteAction
    extends AbstractAction {
        private final SPObject obj;

        public DeleteAction(SPObject obj) {
            super("Delete");
            this.obj = obj;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SecurityPanel.this.promptForUnsavedChanges() && SecurityPanel.this.promptForDelete(this.obj)) {
                try {
                    if (this.obj instanceof User) {
                        for (Group group : SecurityPanel.this.securityWorkspace.getChildren(Group.class)) {
                            group.removeUser((User)this.obj);
                        }
                    }
                    SecurityPanel.this.securityWorkspace.removeChild(this.obj);
                }
                catch (Exception ex) {
                    throw new RuntimeException("Unable to delete: ", ex);
                }
                SecurityPanel.this.refreshTree();
                SecurityPanel.this.tree.setSelectionPath(new TreePath(SecurityPanel.this.usersNode.getFirstChild()));
            }
        }
    }

    private class EditSecuritySettingsAction
    extends AbstractAction {
        private final TreePath path;

        public EditSecuritySettingsAction(TreePath path) {
            super("Manage Security Settings...");
            this.path = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SPObject object;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.path.getLastPathComponent();
            try {
                object = (SPObject)node.getUserObject();
            }
            catch (Exception ex) {
                object = null;
            }
            Class<Object> objectClass = null;
            if (object != null) {
                objectClass = object.getClass();
            } else if (node == SecurityPanel.this.usersNode) {
                objectClass = User.class;
            } else if (node == SecurityPanel.this.groupsNode) {
                objectClass = Group.class;
            }
            final JDialog d = SPSUtils.makeOwnedDialog((Component)SecurityPanel.this.dialog, (String)"Security Manager");
            AbstractAction closeAction = new AbstractAction("Close"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    d.dispose();
                }
            };
            ProjectSecurityPanel spm = new ProjectSecurityPanel(SecurityPanel.this.securityWorkspace, object, objectClass, SecurityPanel.this.username, d, closeAction);
            d.setDefaultCloseOperation(2);
            d.setContentPane(spm.getPanel());
            SPSUtils.makeJDialogCancellable((Window)d, null);
            d.pack();
            d.setLocationRelativeTo(SecurityPanel.this.panel);
            d.setVisible(true);
        }
    }

    private class EditAction
    extends AbstractAction {
        private final TreePath path;

        public EditAction(TreePath path) {
            super("Edit");
            this.path = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SecurityPanel.this.tree.setSelectionPath(this.path);
        }
    }
}

