/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal.plugins;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.artifacts.DefaultProjectDependencyFactory;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublicationRegistry;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.project.HoldsProjectState;
import org.gradle.internal.build.BuildIncluder;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.resolve.internal.PluginResolution;
import org.gradle.plugin.use.resolve.internal.PluginResolutionResult;
import org.gradle.plugin.use.resolve.internal.PluginResolutionVisitor;
import org.gradle.plugin.use.resolve.internal.PluginResolver;
import org.gradle.plugin.use.resolve.internal.PluginResolverContributor;
import org.gradle.plugin.use.resolve.internal.local.PluginPublication;
import org.gradle.util.Path;

public class CompositeBuildPluginResolverContributor
implements PluginResolverContributor,
HoldsProjectState {
    private static final String SOURCE_DESCRIPTION = "Included Builds";
    private final CompositeBuildPluginResolver resolver;

    @Inject
    public CompositeBuildPluginResolverContributor(BuildIncluder buildIncluder, ProjectPublicationRegistry publicationRegistry, DefaultProjectDependencyFactory projectDependencyFactory) {
        this.resolver = new CompositeBuildPluginResolver(buildIncluder, publicationRegistry, projectDependencyFactory);
    }

    public void discardAll() {
        this.resolver.discardAll();
    }

    public void collectResolversInto(Collection<PluginResolver> resolvers) {
        resolvers.add(this.resolver);
    }

    private static class CompositeBuildPluginResolver
    implements PluginResolver {
        private final BuildIncluder buildIncluder;
        private final ProjectPublicationRegistry publicationRegistry;
        private final DefaultProjectDependencyFactory projectDependencyFactory;
        private final Map<PluginId, PluginResult> results = new ConcurrentHashMap<PluginId, PluginResult>();

        private CompositeBuildPluginResolver(BuildIncluder buildIncluder, ProjectPublicationRegistry publicationRegistry, DefaultProjectDependencyFactory projectDependencyFactory) {
            this.buildIncluder = buildIncluder;
            this.publicationRegistry = publicationRegistry;
            this.projectDependencyFactory = projectDependencyFactory;
        }

        public PluginResolutionResult resolve(PluginRequestInternal pluginRequest) {
            PluginResult resolutionResult = this.results.computeIfAbsent(pluginRequest.getId(), this::doResolve);
            if (resolutionResult == PluginResult.NOT_FOUND_IN_ANY_BUILD) {
                return PluginResolutionResult.notFound((String)CompositeBuildPluginResolverContributor.SOURCE_DESCRIPTION, (String)"None of the included builds contain this plugin");
            }
            if (resolutionResult instanceof ResolvedPlugin) {
                return PluginResolutionResult.found((PluginResolution)((ResolvedPlugin)resolutionResult).resolution);
            }
            return PluginResolutionResult.notFound((String)CompositeBuildPluginResolverContributor.SOURCE_DESCRIPTION, (String)"No included builds contain this plugin");
        }

        private PluginResult doResolve(PluginId pluginId) {
            PluginResolution earlyResolution = this.resolveFromIncludedPluginBuilds(pluginId);
            if (earlyResolution != null) {
                return new ResolvedPlugin(earlyResolution);
            }
            return this.resolvePluginFromIncludedBuilds(pluginId);
        }

        private PluginResult resolvePluginFromIncludedBuilds(PluginId requestedPluginId) {
            Collection includedBuilds = this.buildIncluder.getIncludedBuildsForPluginResolution();
            if (includedBuilds.isEmpty()) {
                return PluginResult.NO_INCLUDED_BUILDS;
            }
            for (IncludedBuildState build : includedBuilds) {
                PluginResolution pluginResolution = this.resolvePlugin(requestedPluginId, build.getBuildIdentifier());
                if (pluginResolution == null) continue;
                return new ResolvedPlugin(pluginResolution);
            }
            return PluginResult.NOT_FOUND_IN_ANY_BUILD;
        }

        private PluginResolution resolveFromIncludedPluginBuilds(PluginId requestedPluginId) {
            for (IncludedBuildState build : this.buildIncluder.getRegisteredPluginBuilds()) {
                this.buildIncluder.prepareForPluginResolution(build);
                PluginResolution pluginResolution = this.resolvePlugin(requestedPluginId, build.getBuildIdentifier());
                if (pluginResolution == null) continue;
                return pluginResolution;
            }
            return null;
        }

        @Nullable
        private PluginResolution resolvePlugin(PluginId requestedPluginId, BuildIdentifier buildIdentity) {
            Collection publicationsForBuild = this.publicationRegistry.getPublicationsForBuild(PluginPublication.class, buildIdentity);
            for (ProjectPublicationRegistry.PublicationForProject publication : publicationsForBuild) {
                PluginId pluginId = ((PluginPublication)publication.getPublication()).getPluginId();
                if (!pluginId.equals(requestedPluginId)) continue;
                return new LocalPluginResolution(pluginId, publication.getProducingProjectId().getBuildTreePath(), this.projectDependencyFactory);
            }
            return null;
        }

        public void discardAll() {
            this.results.clear();
        }
    }

    private static class LocalPluginResolution
    implements PluginResolution {
        private final PluginId pluginId;
        private final Path producingProjectIdentityPath;
        private final DefaultProjectDependencyFactory projectDependencyFactory;

        public LocalPluginResolution(PluginId pluginId, Path producingProjectIdentityPath, DefaultProjectDependencyFactory projectDependencyFactory) {
            this.pluginId = pluginId;
            this.producingProjectIdentityPath = producingProjectIdentityPath;
            this.projectDependencyFactory = projectDependencyFactory;
        }

        public PluginId getPluginId() {
            return this.pluginId;
        }

        public void accept(PluginResolutionVisitor visitor) {
            visitor.visitDependency((Dependency)this.projectDependencyFactory.create(this.producingProjectIdentityPath));
        }

        public void applyTo(PluginManagerInternal pluginManager) {
            pluginManager.apply(this.pluginId.getId());
        }
    }

    private static class ResolvedPlugin
    extends PluginResult {
        final PluginResolution resolution;

        public ResolvedPlugin(PluginResolution resolution) {
            this.resolution = resolution;
        }
    }

    private static abstract class PluginResult {
        static final PluginResult NOT_FOUND_IN_ANY_BUILD = new PluginResult(){};
        static final PluginResult NO_INCLUDED_BUILDS = new PluginResult(){};

        private PluginResult() {
        }
    }
}

