/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.toolkit.url.Uri;
import com.sun.jndi.toolkit.url.UrlUtil;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.util.Locale;
import java.util.StringTokenizer;
import sun.security.action.GetPropertyAction;

public class DnsUrl
extends Uri {
    private static final String PARSE_MODE_PROP = "com.sun.jndi.dnsURLParsing";
    private static final Uri.ParseMode DEFAULT_PARSE_MODE = Uri.ParseMode.COMPAT;
    public static final Uri.ParseMode PARSE_MODE;
    private String domain;

    public static DnsUrl[] fromList(String string) throws MalformedURLException {
        DnsUrl[] dnsUrlArray = new DnsUrl[(string.length() + 1) / 2];
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                dnsUrlArray[n++] = new DnsUrl(DnsUrl.validateURI(stringTokenizer.nextToken()));
            }
            catch (URISyntaxException uRISyntaxException) {
                MalformedURLException malformedURLException = new MalformedURLException(uRISyntaxException.getMessage());
                malformedURLException.initCause(uRISyntaxException);
                throw malformedURLException;
            }
        }
        DnsUrl[] dnsUrlArray2 = new DnsUrl[n];
        System.arraycopy(dnsUrlArray, 0, dnsUrlArray2, 0, n);
        return dnsUrlArray2;
    }

    @Override
    protected Uri.ParseMode parseMode() {
        return PARSE_MODE;
    }

    @Override
    protected final boolean isSchemeOnly(String string) {
        return DnsUrl.isDnsSchemeOnly(string);
    }

    @Override
    protected boolean checkSchemeOnly(String string, String string2) {
        return string.equals(string2 + ":") || string.equals(string2 + "://");
    }

    @Override
    protected final MalformedURLException newInvalidURISchemeException(String string) {
        return new MalformedURLException(string + " is not a valid DNS pseudo-URL");
    }

    private static boolean isDnsSchemeOnly(String string) {
        return "dns:".equals(string) || "dns://".equals(string);
    }

    private static String validateURI(String string) throws URISyntaxException {
        if (PARSE_MODE == Uri.ParseMode.LEGACY) {
            return string;
        }
        if (DnsUrl.isDnsSchemeOnly(string)) {
            return string;
        }
        return new URI(string).toString();
    }

    public DnsUrl(String string) throws MalformedURLException {
        super(string);
        if (!this.scheme.equals("dns")) {
            throw this.newInvalidURISchemeException(string);
        }
        this.domain = this.path.startsWith("/") ? this.path.substring(1) : this.path;
        this.domain = this.domain.equals("") ? "." : UrlUtil.decode(this.domain);
    }

    public String getDomain() {
        return this.domain;
    }

    static {
        GetPropertyAction getPropertyAction = new GetPropertyAction(PARSE_MODE_PROP, DEFAULT_PARSE_MODE.toString());
        Uri.ParseMode parseMode = DEFAULT_PARSE_MODE;
        try {
            String string = AccessController.doPrivileged(getPropertyAction);
            parseMode = Uri.ParseMode.valueOf(string.toUpperCase(Locale.ROOT));
        }
        catch (Throwable throwable) {
            parseMode = DEFAULT_PARSE_MODE;
        }
        finally {
            PARSE_MODE = parseMode;
        }
    }
}

