/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import javax.naming.RefAddr;

public class BinaryRefAddr
extends RefAddr {
    private byte[] buf = null;
    private static final long serialVersionUID = -3415254970957330361L;

    public BinaryRefAddr(String string, byte[] byArray) {
        this(string, byArray, 0, byArray.length);
    }

    public BinaryRefAddr(String string, byte[] byArray, int n, int n2) {
        super(string);
        this.buf = new byte[n2];
        System.arraycopy(byArray, n, this.buf, 0, n2);
    }

    @Override
    public Object getContent() {
        return this.buf;
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object instanceof BinaryRefAddr) {
            BinaryRefAddr binaryRefAddr = (BinaryRefAddr)object;
            if (this.addrType.compareTo(binaryRefAddr.addrType) == 0) {
                if (this.buf == null && binaryRefAddr.buf == null) {
                    return true;
                }
                if (this.buf == null || binaryRefAddr.buf == null || this.buf.length != binaryRefAddr.buf.length) {
                    return false;
                }
                for (int i = 0; i < this.buf.length; ++i) {
                    if (this.buf[i] == binaryRefAddr.buf[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = this.addrType.hashCode();
        for (int i = 0; i < this.buf.length; ++i) {
            n += this.buf[i];
        }
        return n;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Address Type: " + this.addrType + "\n");
        stringBuffer.append("AddressContents: ");
        for (int i = 0; i < this.buf.length && i < 32; ++i) {
            stringBuffer.append(Integer.toHexString(this.buf[i]) + " ");
        }
        if (this.buf.length >= 32) {
            stringBuffer.append(" ...\n");
        }
        return stringBuffer.toString();
    }
}

