/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.exceptions.PreparationException;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ClientEsniInner;
import de.rub.nds.tlsattacker.core.protocol.message.extension.sni.ServerNamePair;
import de.rub.nds.tlsattacker.core.protocol.preparator.Preparator;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ServerNamePairPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ServerNamePairSerializier;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientEsniInnerPreparator
extends Preparator<ClientEsniInner> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ClientEsniInner msg;
    private ByteArrayOutputStream serverNamePairListStream;

    public ClientEsniInnerPreparator(Chooser chooser, ClientEsniInner message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepare() {
        LOGGER.debug("Preparing ClientEsniInner");
        this.prepareNonce(this.msg);
        this.prepareServerPariNameList(this.msg);
        this.prepareServerNameListBytes(this.msg);
        this.prepareServerNameListLength(this.msg);
        this.preparePadding(this.msg);
    }

    private void prepareNonce(ClientEsniInner msg) {
        byte[] nonce = this.chooser.getEsniClientNonce();
        msg.setClientNonce(nonce);
        LOGGER.debug("Nonce: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getClientNonce().getValue())));
    }

    private void prepareServerPariNameList(ClientEsniInner msg) {
        this.serverNamePairListStream = new ByteArrayOutputStream();
        for (ServerNamePair pair : msg.getServerNameList()) {
            ServerNamePairPreparator preparator = new ServerNamePairPreparator(this.chooser, pair);
            preparator.prepare();
            ServerNamePairSerializier serializer = new ServerNamePairSerializier(pair);
            try {
                this.serverNamePairListStream.write(serializer.serialize());
            }
            catch (IOException e) {
                throw new PreparationException("Could not write byte[] from ServerNamePair", e);
            }
        }
    }

    private void prepareServerNameListBytes(ClientEsniInner msg) {
        msg.setServerNameListBytes(this.serverNamePairListStream.toByteArray());
        LOGGER.debug("ServerNameListBytes: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getServerNameListBytes().getValue())));
    }

    private void prepareServerNameListLength(ClientEsniInner msg) {
        msg.setServerNameListLength(((byte[])msg.getServerNameListBytes().getValue()).length);
        LOGGER.debug("ServerNameListLength: " + msg.getServerNameListLength().getValue());
    }

    private void preparePadding(ClientEsniInner msg) {
        int paddedLength = this.chooser.getEsniPaddedLength();
        int paddingLength = paddedLength - ((byte[])msg.getServerNameListBytes().getValue()).length - 2;
        byte[] padding = paddingLength > 0 ? new byte[paddingLength] : new byte[]{};
        msg.setPadding(padding);
        LOGGER.debug("paddedLength: " + paddedLength);
        LOGGER.debug("Padding: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getPadding().getValue())));
    }
}

