untrusted comment: signature from openbsd 5.6 base private key
RWR0EANmo9nqhuWPcQ3w7wo25H7+WEDkRnhCnlQ42+W9WX0UvBuczn9P4kRKw2FGGhjQNYqvPGrCMdhyuhlW5SZVK2vnm4nCwgE=

OpenBSD 5.6 errata 30, Jul 30, 2015:

Substitution commands might contain a newline in the replacement pattern
(escaped with a backslash before it), causing patch's understanding of
the state the ed child process is in to diverge from reality. This can
lead to patch unwillingly feeding '!' (execute shell command) lines to
ed.

Apply by doing:
    signify -Vep /etc/signify/openbsd-56-base.pub -x 030_patch.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install the patch utility:
    cd /usr/src/usr.bin/patch
    make obj
    make
    make install

Index: usr.bin/patch/pch.c
===================================================================
RCS file: /cvs/src/usr.bin/patch/pch.c,v
retrieving revision 1.41.6.1
diff -u -p -u -p -r1.41.6.1 pch.c
--- usr.bin/patch/pch.c	27 Jul 2015 16:08:18 -0000	1.41.6.1
+++ usr.bin/patch/pch.c	31 Jul 2015 00:06:46 -0000
@@ -1393,7 +1393,19 @@ do_ed_script(void)
 		    (*t == 'a' || *t == 'c' || *t == 'd' || *t == 'i' || *t == 's')) {
 			if (pipefp != NULL)
 				fputs(buf, pipefp);
-			if (*t != 'd') {
+			if (*t == 's') {
+				for (;;) {
+					bool continued = false;
+					t = buf + strlen(buf) - 1;
+					while (--t >= buf && *t == '\\')
+						continued = !continued;
+					if (!continued ||
+					    pgets(buf, sizeof buf, pfp) == NULL)
+						break;
+					if (pipefp != NULL)
+						fputs(buf, pipefp);
+				}
+			} else if (*t != 'd') {
 				while (pgets(buf, sizeof buf, pfp) != NULL) {
 					p_input_line++;
 					if (pipefp != NULL)
