untrusted comment: verify with openbsd-72-base.pub
RWQTKNnK3CZZ8OVM77S37bHFGv28ZTSdsqs/6MJ8Dr5+QHIC5EOjdwktfKZqmiTqXw/cEk7TVMglCOuA07m2npWvfF54gsbuyw0=

OpenBSD 7.2 errata 002, October 24, 2022:

Unbreak ASN.1 indefinite length encoding.

Apply by doing:
    signify -Vep /etc/signify/openbsd-72-base.pub -x 002_asn1.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libcrypto and unwind:
    cd /usr/src/lib/libcrypto
    make obj
    make includes
    make
    make install

Index: lib/libcrypto/asn1/tasn_enc.c
===================================================================
RCS file: /cvs/src/lib/libcrypto/asn1/tasn_enc.c,v
retrieving revision 1.25
diff -u -p -r1.25 tasn_enc.c
--- lib/libcrypto/asn1/tasn_enc.c	20 Aug 2022 17:55:08 -0000	1.25
+++ lib/libcrypto/asn1/tasn_enc.c	18 Oct 2022 08:45:03 -0000
@@ -494,7 +494,7 @@ static int
 asn1_i2d_ex_primitive(ASN1_VALUE **pval, unsigned char **out,
     const ASN1_ITEM *it, int tag, int aclass)
 {
-	int len;
+	int olen, len;
 	int utype;
 	int usetag;
 	int ndef = 0;
@@ -505,7 +505,7 @@ asn1_i2d_ex_primitive(ASN1_VALUE **pval,
 	 * out the underlying type.
 	 */
 
-	len = asn1_ex_i2c(pval, NULL, &utype, it);
+	olen = len = asn1_ex_i2c(pval, NULL, &utype, it);
 
 	/* If SEQUENCE, SET or OTHER then header is
 	 * included in pseudo content octets so don't
@@ -541,7 +541,7 @@ asn1_i2d_ex_primitive(ASN1_VALUE **pval,
 	if (out) {
 		if (usetag)
 			ASN1_put_object(out, ndef, len, tag, aclass);
-		if (asn1_ex_i2c(pval, *out, &utype, it) != len)
+		if (asn1_ex_i2c(pval, *out, &utype, it) != olen)
 			return -1;
 		if (ndef)
 			ASN1_put_eoc(out);
