untrusted comment: verify with openbsd-72-base.pub
RWQTKNnK3CZZ8JQ0BBt1FH1BwcLmKysVlCL+YqQzyPJ2Qdxm4k/khLREjXoXNdeQgkCG9ByzGCaM9IKaS6/9pt5vKh/+eb9swgI=

OpenBSD 7.2 errata 017, February 2, 2023:

A double-free in the sshd pre-auth unprivileged process (not believed
to be exploitable).

Apply by doing:
    signify -Vep /etc/signify/openbsd-72-base.pub -x 017_sshd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install sshd:
    cd /usr/src/usr.bin/ssh
    make obj
    make
    make install

Index: usr.bin/ssh/compat.c
===================================================================
RCS file: /cvs/src/usr.bin/ssh/compat.c,v
diff -u -p -u -r1.120 compat.c
--- usr.bin/ssh/compat.c	1 Jul 2022 03:35:45 -0000	1.120
+++ usr.bin/ssh/compat.c	31 Jan 2023 15:43:48 -0000
@@ -188,26 +188,26 @@ compat_pkalg_proposal(struct ssh *ssh, c
 char *
 compat_kex_proposal(struct ssh *ssh, char *p)
 {
-	char *cp = NULL;
+	char *cp = NULL, *cp2 = NULL;
 
 	if ((ssh->compat & (SSH_BUG_CURVE25519PAD|SSH_OLD_DHGEX)) == 0)
 		return xstrdup(p);
 	debug2_f("original KEX proposal: %s", p);
 	if ((ssh->compat & SSH_BUG_CURVE25519PAD) != 0)
-		if ((p = match_filter_denylist(p,
+		if ((cp = match_filter_denylist(p,
 		    "curve25519-sha256@libssh.org")) == NULL)
 			fatal("match_filter_denylist failed");
 	if ((ssh->compat & SSH_OLD_DHGEX) != 0) {
-		cp = p;
-		if ((p = match_filter_denylist(p,
+		if ((cp2 = match_filter_denylist(cp ? cp : p,
 		    "diffie-hellman-group-exchange-sha256,"
 		    "diffie-hellman-group-exchange-sha1")) == NULL)
 			fatal("match_filter_denylist failed");
 		free(cp);
+		cp = cp2;
 	}
-	debug2_f("compat KEX proposal: %s", p);
-	if (*p == '\0')
+	debug2_f("compat KEX proposal: %s", cp);
+	if (*cp == '\0')
 		fatal("No supported key exchange algorithms found");
-	return p;
+	return cp;
 }
 
