untrusted comment: verify with openbsd-72-base.pub
RWQTKNnK3CZZ8Kj2vsByn0oWmmnOo/VjCc2ocaJV7wsuLeWGhNYUEMERaP3FYZhwc5UHZXObu74Ocrcmq5IA7jW2cACSRe4EVw0=

OpenBSD 7.2 errata 018, February 7, 2023:

A malicious certificate revocation list or timestamp response token would
allow an attacker to read arbitrary memory.

Apply by doing:
    signify -Vep /etc/signify/openbsd-72-base.pub -x 018_x509.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libcrypto:
    cd /usr/src/lib/libcrypto
    make obj
    make includes
    make
    make install

Index: lib/libcrypto/x509/x509_genn.c
===================================================================
RCS file: /cvs/src/lib/libcrypto/x509/x509_genn.c,v
diff -u -p -r1.2 x509_genn.c
--- lib/libcrypto/x509/x509_genn.c	8 Dec 2020 15:06:42 -0000	1.2
+++ lib/libcrypto/x509/x509_genn.c	24 Jan 2023 09:43:06 -0000
@@ -366,7 +366,8 @@ GENERAL_NAME_cmp(GENERAL_NAME *a, GENERA
 		return -1;
 	switch (a->type) {
 	case GEN_X400:
-		result = ASN1_TYPE_cmp(a->d.x400Address, b->d.x400Address);
+		result = ASN1_STRING_cmp((ASN1_STRING *)a->d.x400Address,
+		    (ASN1_STRING *)b->d.x400Address);
 		break;
 
 	case GEN_EDIPARTY:
