/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap.action;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPUtil;
import ca.sqlpower.architect.swingui.AbstractPlacer;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.olap.DimensionEditPanel;
import ca.sqlpower.architect.swingui.olap.DimensionPane;
import ca.sqlpower.architect.swingui.olap.OSUtils;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.swingui.DataEntryPanel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class CreateDimensionAction
extends AbstractArchitectAction {
    private final MondrianModel.Schema schema;

    public CreateDimensionAction(ArchitectSwingSession session, MondrianModel.Schema schema, PlayPen pp) {
        super(session, pp, "New Dimension...", "Create a new shared dimension in this schema (d)", (Icon)OSUtils.DIMENSION_ADD_ICON);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke('d'));
        this.schema = schema;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MondrianModel.Dimension dim = new MondrianModel.Dimension();
        dim.setParent((SPObject)this.schema);
        int count = 1;
        while (!OLAPUtil.isNameUnique(this.schema, MondrianModel.Dimension.class, "New Dimension " + count)) {
            ++count;
        }
        dim.setName("New Dimension " + count);
        if (this.getPlaypen().getSelectedContainers().size() >= 1) {
            // empty if block
        }
        DimensionPlacer dp = new DimensionPlacer(new DimensionPane(dim, this.getPlaypen().getContentPane()));
        dp.dirtyup();
    }

    private class DimensionPlacer
    extends AbstractPlacer {
        private final DimensionPane dp;

        DimensionPlacer(DimensionPane cp) {
            super(CreateDimensionAction.this.getPlaypen());
            this.dp = cp;
        }

        @Override
        protected String getEditDialogTitle() {
            return "Dimension Properties";
        }

        @Override
        public DataEntryPanel place(final Point p) throws SQLObjectException {
            DimensionEditPanel editPanel = new DimensionEditPanel((MondrianModel.Dimension)((Object)this.dp.getModel())){

                @Override
                public boolean applyChanges() {
                    if (super.applyChanges()) {
                        try {
                            CreateDimensionAction.this.getSession().getWorkspace().begin("Create a dimension");
                            CreateDimensionAction.this.schema.addDimension((MondrianModel.Dimension)((Object)DimensionPlacer.this.dp.getModel()));
                            DimensionPlacer.this.playpen.selectNone();
                            DimensionPlacer.this.playpen.addPlayPenComponent(DimensionPlacer.this.dp, p);
                            DimensionPlacer.this.dp.setSelected(true, 4);
                            CreateDimensionAction.this.getSession().getWorkspace().commit();
                            return true;
                        }
                        catch (Throwable e) {
                            CreateDimensionAction.this.getSession().getWorkspace().rollback("Error occurred: " + e.toString());
                            throw new RuntimeException(e);
                        }
                    }
                    return false;
                }
            };
            return editPanel;
        }
    }
}

